BeginPackage["BarCharts`"]

If[!ValueQ[BarChart3D::usage], BarChart3D::usage = "\!\(\*RowBox[{\"BarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"21\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"22\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a three-dimensional bar chart using the matrix of heights \!\(\*SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\).\n\!\(\*RowBox[{\"BarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"style\", \"TI\"], StyleBox[\"11\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) uses a specific style for each bar.\n\!\(\*RowBox[{\"BarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"z\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"style\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a bar chart of bars scattered at specific \!\(\*StyleBox[\"x\", \"TI\"]\) and \!\(\*StyleBox[\"y\", \"TI\"]\) coordinates with height \!\(\*StyleBox[\"z\", \"TI\"]\) and a specific \!\(\*StyleBox[\"style\", \"TI\"]\)."];
If[!ValueQ[BarChart::usage], BarChart::usage = "\!\(\*RowBox[{\"BarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a bar chart of the values \!\(\*RowBox[{SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\).\n\!\(\*RowBox[{\"BarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) generates a bar chart of the data in the lists."];
If[!ValueQ[BarEdges::usage], BarEdges::usage = "BarEdges is an option for bar charts that determines whether edges are to be drawn around the bars."];
If[!ValueQ[BarEdgeStyle::usage], BarEdgeStyle::usage = "BarEdgeStyle is an option for bar charts that determines the style for the edges."];
If[!ValueQ[BarGroupSpacing::usage], BarGroupSpacing::usage = "BarGroupSpacing is an option for BarChart that determines the spacing between groups of bars."];
If[!ValueQ[BarLabels::usage], BarLabels::usage = "BarLabels is an option for BarChart, StackedBarChart, and PercentileBarChart, that allows a label to be placed at the tick mark for each bar (or group of bars for multiple data sets). Labels are specified in a list."];
If[!ValueQ[BarOrientation::usage], BarOrientation::usage = "BarOrientation is an option for BarChart that determines whether the bars are oriented vertically or horizontally."];
If[!ValueQ[BarSpacing::usage], BarSpacing::usage = "BarSpacing is an option for bar charts that determines the fraction of the bar width to space the bars in a group of bars."];
If[!ValueQ[BarStyle::usage], BarStyle::usage = "BarStyle is an option for bar charts that determines the default style for the bars. "];
If[!ValueQ[BarValues::usage], BarValues::usage = "BarValues is an option for BarChart and GeneralizedBarChart that allows the length of the bar to be displayed above each bar."];
If[!ValueQ[GeneralizedBarChart3D::usage], GeneralizedBarChart3D::usage = "\!\(\*RowBox[{\"GeneralizedBarChart3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xpos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ypos\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xwidth\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ywidth\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xpos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ypos\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"xwidth\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"ywidth\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) generates a three-dimensional bar chart with the solid bars at the given positions, heights, and widths."];
If[!ValueQ[GeneralizedBarChart::usage], GeneralizedBarChart::usage = "\!\(\*RowBox[{\"GeneralizedBarChart\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"width\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pos\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"height\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"width\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", RowBox[{StyleBox[\"\[Ellipsis]\", \"TR\"], RowBox[{\"}\", \"]\"}]}]}]}]}]\) generates a bar chart with the bars at the given positions, and with given heights and widths.\n\!\(\*RowBox[{\"GeneralizedBarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], StyleBox[\"}\", \"TR\"]}], \"]\"}]\) generates a bar chart from lists of data."];
If[!ValueQ[PercentileBarChart::usage], PercentileBarChart::usage = "\!\(\*RowBox[{\"PercentileBarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a stacked bar chart of the data in the lists. The data for each group of bars is scaled so that the sum of the absolute values in a group of bars is 1."];
If[!ValueQ[StackedBarChart::usage], StackedBarChart::usage = "\!\(\*RowBox[{\"StackedBarChart\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"list\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \"]\"}]\) generates a stacked bar chart of the data in the lists."];


EndPackage[]
