BeginPackage["Histograms`"]



If[!ValueQ[IntervalCenters::usage], IntervalCenters::usage = "IntervalCenters is a possible value for the Ticks option of histogram functions. For example, Histogram[data, Ticks -> IntervalCenters] Automatic}], or Histogram[data, Ticks -> IntervalCenters], places the ticks of the category axis at the interval centers, and sets the ticks of the frequency axis automatically."];
If[!ValueQ[IntervalBoundaries::usage], IntervalBoundaries::usage = "IntervalBoundaries is a possible value for the Ticks option of histogram functions. For example, Histogram[data, Ticks -> {IntervalBoundaries, Automatic}], or Histogram[data, Ticks -> IntervalBoundaries] places the ticks of the category axis at the interval boundaries, and sets the ticks of the frequency axis automatically."];

If[!ValueQ[ApproximateIntervals::usage], ApproximateIntervals::usage = "ApproximateIntervals is an option of histogram functions that specifies whether the HistogramCategories or HistogramRange settings should be adjusted so that the interval boundaries are described by simple numbers."];
If[!ValueQ[FrequencyData::usage], FrequencyData::usage = "FrequencyData is an option of histogram functions that specifies whether the data argument represents the original data or the frequencies with which the original data fall in the respective categories."];
If[!ValueQ[Histogram3D::usage], Histogram3D::usage = "\!\(\*RowBox[{\"Histogram3D\", \"[\", RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) generates a three dimensional bar graph representing a histogram of the bivariate data \!\(\*RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"1\", \"TR\"]]}], \"}\"}], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"y\", \"TI\"], StyleBox[\"2\", \"TR\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}]\).\n\!\(\*RowBox[{\"Histogram3D\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"11\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"12\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[RowBox[{\"1\", \"l\"}], \"TI\"]]}], \"}\"}], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"k1\", \"TI\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"k2\", \"TI\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"kl\", \"TI\"]]}], \"}\"}]}], \"}\"}], \",\", RowBox[{\"FrequencyData\", \"->\", \"True\"}]}], \"]\"}]\) generates a histogram of the bivariate data, where \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"ij\", \"TI\"]]\) is the frequency with which the original data falls in the category \!\(\*RowBox[{\"{\", RowBox[{StyleBox[\"i\", \"TI\"], \",\", StyleBox[\"j\", \"TI\"]}], \"}\"}]\)."];
If[!ValueQ[HistogramCategories::usage], HistogramCategories::usage = "HistogramCategories is an option of histogram functions that specifies the categories in the histogram."];
If[!ValueQ[Histogram::usage], Histogram::usage = "\!\(\*RowBox[{\"Histogram\", \"[\", RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TI\"]}], \"}\"}], \"]\"}]\) generates a histogram of the univariate data \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"x\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\).\n\!\(\*RowBox[{\"Histogram\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", RowBox[{\"FrequencyData\", \"->\", \"True\"}]}], \"]\"}]\) generates a histogram of the univariate frequency data \!\(\*RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}]\), where \!\(\*SubscriptBox[StyleBox[\"f\", \"TI\"], StyleBox[\"i\", \"TI\"]]\) is the frequency with which the original data occurs in category \!\(\*StyleBox[\"i\", \"TI\"]\)."];
If[!ValueQ[HistogramRange::usage], HistogramRange::usage = "HistogramRange is an option of histogram functions that specifies the lower and upper limits of the points to be included in the histogram."];
If[!ValueQ[HistogramScale::usage], HistogramScale::usage = "HistogramScale is an option of histogram functions that specifies the way in which the bar heights are to be scaled."];

EndPackage[]
