(* :Title: Multivariate Statistics *)

(* :Author: Darren Glosemeyer *)

(* :Summary:
This package computes descriptive statistics (location, dispersion, shape,
and association statistics) for a sample represented as a data matrix.
The data matrix is a list of independent identically distributed
vector-valued or multivariate observations.
*)

(* :Context: MultivariateStatistics` *)

(* :Package Version: 1.0 *)

(* :Copyright: Copyright 1993-2007 by Wolfram Research, Inc. *)

(* :History:
	Merged Statistics`MultiDescriptiveStatistics`, Statistics`MultinormalDistribution`,
		and Statistics`MultiDiscreteDistributions` standard add-ons into this file, 2006,
		Darren Glosemeyer. *)

(* :Mathematica Version: 6.0 *)



BeginPackage["MultivariateStatistics`",
	(* needed for Ellipsoid *)
	{"RegressionCommon`",
	(* needed for ConvexHull *)
	"ComputationalGeometry`"}]

Get[ToFileName["MultivariateStatistics","MultiDescriptiveStatistics.m"]]

Get[ToFileName["MultivariateStatistics","MultinormalDistribution.m"]]

Get[ToFileName["MultivariateStatistics","MultiDiscreteDistributions.m"]]

EndPackage[]
