BeginPackage["Splines`"]

If[!ValueQ[Bezier::usage], Bezier::usage = "Bezier is a setting specifying the type of spline generated by Spline and SplineFit."];
If[!ValueQ[CompositeBezier::usage], CompositeBezier::usage = "CompositeBezier is a setting specifying the type of spline generated by Spline and SplineFit."];
If[!ValueQ[Cubic::usage], Cubic::usage = "Cubic is a setting specifying the type of spline generated by Spline and SplineFit."];
If[!ValueQ[RenderSpline::usage], RenderSpline::usage = "\!\(\*RowBox[{\"RenderSpline\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"type\", \"TI\"], \",\", StyleBox[\"splinefunction\", \"TI\"]}], \"]\"}]\) is an alternative rendering method for splines."];
If[!ValueQ[SplineDivision::usage], SplineDivision::usage = "SplineDivision is an option for Spline which specifies the maximum number of subdivisions to be used in attempting to generate a smooth spline."];
If[!ValueQ[SplineDots::usage], SplineDots::usage = "SplineDots is an option for Spline that specifies a style for a point. "];
If[!ValueQ[SplineFit::usage], SplineFit::usage = "\!\(\*RowBox[{\"SplineFit\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) generates a SplineFunction object of the specified \!\(\*StyleBox[\"type\", \"TI\"]\) from the points \!\(\*RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\)."];
If[!ValueQ[SplineFunction::usage], SplineFunction::usage = "\!\(\*RowBox[{\"SplineFunction\", \"[\", RowBox[{StyleBox[\"type\", \"TI\"], \",\", StyleBox[\"domain\", \"TI\"], \",\", StyleBox[\"internal\", \"TI\"]}], \"]\"}]\) represents a spline function created by the SplineFit function parametrizing a curve with the parameter in the specified \!\(\*StyleBox[\"domain\", \"TI\"]\). When given a parameter value as an argument it returns the corresponding point on the curve."];
If[!ValueQ[Spline::usage], Spline::usage = "\!\(\*RowBox[{\"Spline\", \"[\", RowBox[{RowBox[{\"{\", RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", StyleBox[\"\[Ellipsis]\", \"TR\"]}], \"}\"}], \",\", StyleBox[\"type\", \"TI\"]}], \"]\"}]\) is a two-dimensional graphics primitive which represents a spline of type \!\(\*StyleBox[\"type\", \"TI\"]\) through (or controlled by) points \!\(\*RowBox[{SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"1\", \"TR\"]], \",\", \" \", SubscriptBox[StyleBox[\"pt\", \"TI\"], StyleBox[\"2\", \"TR\"]], \",\", \" \", StyleBox[\"\[Ellipsis]\", \"TR\"]}]\). "];
If[!ValueQ[SplinePoints::usage], SplinePoints::usage = "SplinePoints is an option for Spline which determines the number of initial samples for rendering a spline. "];

EndPackage[]
