#! /usr/local/bin/python
# $Id: guifrontend.py,v 1.1 2003/09/26 16:51:40 stevew Exp $

from mathlink import *
from Tkinter import *
import sys, exceptions, time, re, threading


class error(exceptions.Exception):
	def __init__(self,args):
		self.args = args
# End error



class doneiterating(exceptions.Exception):
	def __init__(self,args):
		self.args = args
# End doneiterating

class finished(exceptions.Exception):
	def __init__(self,args):
		self.args = args
# End finished

class guifrontend:

	
	def __init__(self, root, kernel,dashmathlink = 0):
		self.__myclass__ = guifrontend
		self.__root = root
		self.__root.title("Python Mathematica GUI")
		self.__kernel = kernel
	
		self.__buttons = {
			"evaluate" : None,
			"abort" : None,
			"quit" : None
		}
		
		self.__threads = {}
	
		self.__debug = 0
		self.__mynamespace = {}
		self.__mynamespace['debug'] = self.__debug
		self.__mynamespace['kernel'] = self.__kernel
		self.__mynamespace['quit'] = 0
		self.__mode = 0
		self.__mathprompt = ''
		self.__pythonprompt = '>>> '
		self.__outputpromptlength = 0
		self.__function = 0
		self.__gettokenoutput = []
		if(dashmathlink == 0): self.__next = self.__getpacket
		else: self.__next = self.__gettoken
		self.__box = None
		self.__console = None
		self.__firsttime = 1
		self.__initializewindow()
		self.__bindkeys()
		self.__initializeinputprompt()
	
		self.__abort =0
		self.__shutdown = 0
		self.__evaluatestring = None
		self.__evaluateevent = threading.Event()
		self.__evaluatelock = threading.Semaphore()
		self.__threads['evaluator'] = threading.Thread(target=self.__actualevaluator,name="evaluator")
		self.__threads['evaluator'].start()
	
	def __initializewindow(self):
		# Make the top level frame:
		topframe = Frame(self.__root)
		
		# Make the input text box:
		self.__box = Text(topframe, background="white",height=20, width=70,wrap="word", font=(('MS', 'Sans', 'Serif'), '12'))
		scrolla = Scrollbar(topframe,command=self.__box.yview)
		self.__box.configure(yscrollcommand=scrolla.set)
		scrolla.grid(row=0,column=1,sticky='N,S,W')
		self.__box.grid(row=0,column=0)
		
		self.__box.tag_configure('inprompt', foreground='blue')
		self.__box.tag_configure('outprompt', foreground='red')
		self.__box.tag_configure('pythonprompt', foreground='green')
	
		# Make the two buttons:
		buttonframe = Frame(topframe)
		self.__buttons['abort'] = Button(buttonframe, text="Abort")
		self.__buttons['abort'].grid(row=0,column=0)
		self.__buttons['quit'] = Button(buttonframe, text="Quit")
		self.__buttons['quit'].grid(row=0,column=1)
		buttonframe.grid(row=1,column=0)
	
		# Display the whole frame:
		topframe.grid(row=0,column=0)	
	
	def __bindkeys(self):
		self.__root.bind('<Shift-Return>',self.__evaluate)
		self.__buttons['abort'].bind('<Button-1>',self.__abort)
		self.__buttons['quit'].bind('<Button-1>',self.__quit)
	
	def __initializeinputprompt(self):
		try:
			while(1):
				self.__next()
		except doneiterating, e:
			pass
		except finished,e:
			self.__kernel.close()
			self.__root.quit()
	
		self.__box.delete(0.0,END)
		self.__box.insert(END, self.__mathprompt, 'inprompt')
	
		self.__box.yview(END)
	
		end = int(self.__box.index(END).split('.')[0]) - 1
		
		self.__current = str(end) + '.' + str(len(self.__mathprompt))
		
		self.__firsttime = 0
	
	def __getpacket(self):
		if(not self.__kernel.ready()):
			self.__kernel.flush()
			time.sleep(.001)
			return
		if(self.__debug): self.__box.insert(END, "\ngetpacket calling kernel.nextpacket\n")
		packet = self.__kernel.nextpacket()
		if(self.__debug): self.__box.insert(END, "Packet type: %s" % (packetdescriptiondictionary[packet]))
		if(packet == RETURNPKT):
			self.__next = self.__gettoken
		elif(packet == RETURNEXPRPKT):
			self.__next = self.__gettoken
		elif(packet == INPUTNAMEPKT):
			self.__mathprompt = self.__kernel.getstring()
			if(self.__firsttime == 0):
				self.__mathprompt = "\n%s" % (str(self.__mathprompt))
			self.__next = self.__getinput
		elif(packet == OUTPUTNAMEPKT):
			string = self.__kernel.getstring()
			self.__outputpromptlength = len(string)
			self.__box.insert(END, "\n%s" % (str(string)), 'outprompt')
			self.__next = self.__getpacket
		elif(packet == TEXTPKT):
			string = self.__kernel.getstring()
			if(self.__debug): self.__box.insert(END, string)
			string = string.replace("\\012","\n")
			self.__box.insert(END, "\n%s" % (string))
			self.__next = self.__getpacket
		elif(packet == MESSAGEPKT):
			self.__box.insert(END, self.__kernel.getstring())
			self.__next = self.__gettoken
		elif(packet == DISPLAYPKT):
			self.__next = self.__gettoken
		elif(packet == DISPLAYENDPKT):
			self.__next = self.__gettoken
		elif(packet == RESUMEPKT):
			self.__next = self.__getpacket
		elif(packet == RETURNTEXTPKT):
			self.__next = self.__gettoken
		elif(packet == SUSPENDPKT):
			self.__next = self.__gettoken
		elif(packet == MENUPKT):
			self.__next = self.__gettoken
		else:
			self.__box.insert(END,  "\nReceived packet: %d" % (packet))
			self.__next = self.__finish
	
	def __gettoken(self):
		out = None
		if(self.__debug): self.__box.insert(END,"\ngettoken calling kernel.getnext")
		try:
			token = self.__kernel.getnext()
		except LinkError, e: 
			self.__box.insert(END, "\nGot Error token, error: %s" % (e))
			self.__next = self.__finish
			return
	
		if(self.__debug): self.__box.insert(END, "\nToken Type: %s\t" % (tokendictionary[token]))
	
		if((token == MLTKINT) or (token == MLTKREAL)): 
			out = self.__kernel.getnumber()
			if(self.__debug): self.__box.insert(END, "%s" % (str(out)))
			elif(not self.__function): self.__box.insert(END, out)
		elif(token == MLTKSTR): 
			out = self.__kernel.getstring();
			out = out.replace('\\012','\n%s' % (self.__outputpromptlength * ' '))
			if(self.__debug): self.__box.insert(END, "%s" % (str(out)))
			elif(not self.__function): self.__box.insert(END, out)
		elif(token == MLTKSYM): 
			out = self.__kernel.getsymbol(); 
			out = out.replace('\\012','\n')
			if(self.__debug): self.__box.insert(END, "%s" % (str(out)))
			elif(not self.__function): self.__box.insert(END,  out)
		elif(token == MLTKFUNC):
			isetfunction = 0
			(function,arguments) = self.__kernel.getfunction();
			result = []; result.append(function)
			if(not self.__function): self.__function = 1; isetfunction = 1
			for i in range(0,arguments):
				result.append(self.__gettoken())
			if(self.__function and (not isetfunction)):
				if(self.__debug): self.__box.insert(END, "%s" % (self.__printarray(result)))
				return result
			else:
				if(self.__debug): self.__box.insert(END, "%s" % (self.__printarray(result)))
				else: self.__box.insert(END, self.__printarray(result))
				self.__function = 0
		else:
			self.__box.insert(END, "\nUncaught token, ending")
			self.__next = self.__finish
			return None
		self.__next = self.__getpacket
		return out
	
	def __finish(self):
		self.__kernel.putfunction('Quit',0)
		self.__shutdown = 1
		raise finished, "Application done."
	
	def __getinput(self):
		promptlen = 0
		if(self.__mode == 0): # math mode
			self.__box.insert(END, "\n%s" % (str(self.__mathprompt)), 'inprompt')
			promptlen = len(self.__mathprompt) - 1
		else:
			self.__box.insert(END, "\n%s" % (str(self.__pythonprompt)), 'pythonprompt')
			promptlen = len(self.__pythonprompt) - 1
	
		self.__box.yview(END)
	
		send = self.__box.index(END).split('.')[0]
		try:
				end = int(send) - 1
		except ValueError, e:
			print str(e), send
			raise finished, "I'm done"
		
		self.__current = str(end) + '.' + str(promptlen)
		
		raise doneiterating, "Finished last evaluation"
	
	def __printarray(self,array):
		if(len(array) == 0): return None
		s = str(array[0]) + "[";
		for i in range(1,len(array)):
			if(isinstance(array[i],ListType)): s += str(self.__printarray(array[i]))
			else: s += str(array[i])
			if(i < (len(array) - 1)): s += ", "
		s += "]"
		return s
	
	def __evaluate(self,event):
		inputtext = self.__box.get(self.__current, END)
	
		if(re.search(r'\n$', inputtext)):
			inputtext = inputtext.strip()
	
		if(self.__mode == 1):	# interaction with the python interpreter
			eout = None
			try: eout = eval(inputtext,self.__mynamespace,self.__mynamespace)
			except SyntaxError, e: 
				try: exec inputtext in self.__mynamespace, self.__mynamespace
				except Exception, e:
					self.__box.insert(END, "\nException occurred: %s" % (str(e)))
					self.__box.yview(END)
					try: self.__getinput()
					except doneiterating, e:
						pass
					return
			except Exception, e:
				self.__box.insert(END, "\nException occurred: %s" % (str(e)))
				self.__box.yview(END)
				try: self.__getinput()
				except doneiterating, e:
					pass
				return
			if(re.search(r'quit',inputtext)):
				if(self.__mynamespace['debug'] == 1): self.__debug = 1
				elif(self.__mynamespace['debug'] == 0): self.__debug = 0
				self.__box.insert(END, "\nReturning to Mathematica...")
				self.__box.yview(END)
				self.__mode = 0 # switch to math mode.
				try: self.__getinput()
				except doneiterating,e :
					pass
			else: 
				if(eout != None):
					self.__box.insert(END, "\n%s" % (str(eout)))
					self.__box.yview(END)
				try: self.__getinput()
				except doneiterating, e:
					pass
		else: # math mode
			if(re.search(r'^python$', inputtext)):
				self.__mode = 1 # switch to python mode
				self.__box.insert(END,"\nDropping to Python interpreter")
				try: self.__getinput()
				except doneiterating, e:
					pass
				return
	
			if(self.__debug): 
				self.__box.insert(END, "\n%s\n" % (str(62*'=')))
				self.__box.insert(END, "%s\t%s\n" % (str(inputtext),repr(inputtext)))
				self.__box.yview(END)
		
			self.__kernel.putfunction("EnterExpressionPacket",1)
			self.__kernel.putfunction("ToExpression",1)
			self.__kernel.putstring(inputtext)
			self.__next = self.__getpacket
			self.__root.after(100, self.__evaluateevent.set)
	
	def __actualevaluator(self):
		while(self.__shutdown != 1):
			self.__evaluateevent.wait()
			self.__evaluateevent.clear()
			if(self.__shutdown == 1): continue
			try:
				while(1):
					if(self.__debug  > 2): self.__box.insert(END,"\n%s" % (str(self.__next)))
					self.__next()
					if(self.__abort):
						self.__kernel.putmessage(MLAbortMessage)
						self.__abort = 0
					time.sleep(.001)
			except doneiterating, e:
				self.__box.yview(END)
				pass
			except finished,e:
				self.__kernel.close()
				self.__shutdown = 1
				self.__root.quit()
			except LinkError,e:
				self.__box.delete(0.0,END)
				self.__box.insert(END,str(e))
				self.__shutdown = 1
				self.__kernel.close()
				self.__root.quit()
	
			time.sleep(.001)
	
	def __abort(self,event):
		if(self.__debug): self.__box.insert(END,"\nSending MLInterruptMessage\n")
		self.__abort = 1
		if(self.__debug): self.__box.insert(END,"Finished sending MLInterruptMessage\n")
	
	def __quit(self,event):
		self.__kernel.putfunction('Quit',0)
		self.__kernel.close()
		self.__shutdown = 1
		self.__evaluateevent.set()
		while(len(self.__threads) > 0): 
			for thread in self.__threads.keys():
				if(not self.__threads[thread].isAlive()):
					self.__threads[thread].join()
					del self.__threads[thread]
			time.sleep(.5)
		self.__evaluatelock.release()
		self.__root.quit()
	
	def mainloop(self):
		if(self.__root != None): self.__root.mainloop()
	

# End guifrontend

try:
	kernel = link(); kernel.openargv(sys.argv); kernel.connect()
except LinkError, e:
	print "Unable to open and connect Link: %s" % (str(e))
	sys.exit(1)

usingdashmathlink = 0
for arg in sys.argv:
	if(re.search(r'^-mathlink$',arg)):
		usingdashmathlink = 1
		break

application = guifrontend(Tk(),kernel,usingdashmathlink)

application.mainloop()