#! /usr/bin/env python
# $Id: textfrontend.py,v 1.11 2003/05/29 05:49:27 stevew Exp $

from mathlink import *
import exceptions,sys, re, os
from types import ListType

if(re.search(r'win32',sys.platform)):
	os.environ["PATH"] = "C:\\Program Files\\Wolfram Research\\Mathematica\\5.0"
else:
	os.environ["PATH"] = "/usr/local/Wolfram/Mathematica/5.0:/usr/local/bin:/usr/bin:/bin"

sys.argv = ["-linkname","math -mathlink","-linkmode","launch"]

class FrontEndFinished(exceptions.Exception):
  def __init__(self,args=None):
    self.args = args
    
class FrontEnd:
  __name__ = "FrontEnd"
  
  def __init__(self,link = None, debug = 1):
    #if((link != None) and (not isinstance(link,Link))): raise TypeError, "Argument link is not a Link object"
    self.link = link
    self.__myclass__ = FrontEnd
    self.next = self.__start
    self.prompt = "Enter Expression: "
    self.pythonprompt = ">>>"
    self.debug = debug
    self.function = 0
    self.mynamespace = {}
    self.mynamespace['debug'] = debug
    self.mynamespace['link'] = link
    self.mynamespace['quit'] = 0
    self.link.setyieldfunction(self._yieldfunction)
    self.mynamespace['yielded'] = 0
  
  def executenextstep(self):
    self.next()
  
  def _yieldfunction(self,count,sleep):
    self.mynamespace['yielded'] += 1
    self.mynamespace['count'] = count
    
  def __start(self):
    if(self.link.ready() == 1): self.next = self.__getpacket
    
  def __getpacket(self):
    packet = self.link.nextpacket()
    if self.debug: print "Packet type: %s" % (packetdescriptiondictionary[packet])
    if(packet == RETURNPKT):
      self.next = self.__gettoken
    elif(packet == RETURNEXPRPKT):
      self.next = self.__gettoken
    elif(packet == INPUTNAMEPKT):
      print ""
      string = self.link.getstring();
      self.prompt = string
      self.next = self.__getinput
    elif(packet == OUTPUTNAMEPKT):
      print "\n",self.link.getstring()
      self.next = self.__getpacket
    elif(packet == TEXTPKT):
      print self.link.getstring()
      self.next = self.__getpacket
    elif(packet == MESSAGEPKT):
      print self.link.getstring()
      self.next = self.__gettoken
    elif(packet == DISPLAYPKT):
      self.next = self.__gettoken
    elif(packet == DISPLAYENDPKT):
      self.next = self.__gettoken
    elif(packet == RESUMEPKT):
      self.next = self.__getpacket
    elif(packet == RETURNTEXTPKT):
      self.next = self.__gettoken
    elif(packet == SUSPENDPKT):
      self.next = self.__gettoken
    else:
      print "Received packet: %d" % (packet)
      self.next = self.__finish
    
  def __gettoken(self):
    out = None
    try:
      token = self.link.getnext()
    except LinkError, e: 
      print "Got Error token, error: %s" % (e)
      self.next = self.__finish
      return None
      
    if((token == MLTKINT) or (token == MLTKREAL)): 
      out = self.link.getnumber()
      if(self.debug): print "Token Type: %s\t%s" % (tokendictionary[token],str(out))
      elif(not self.function): print out
    elif(token == MLTKSTR): 
      out = self.link.getstring(); 
      if(self.debug): print "Token Type: %s\t%s" % (tokendictionary[token],str(out))
      elif(not self.function): print out
    elif(token == MLTKSYM): 
      out = self.link.getsymbol(); 
      if(self.debug): print "Token Type: %s\t%s" % (tokendictionary[token],str(out))
      elif(not self.function): print out
    elif(token == MLTKFUNC):
      isetfunction = 0
      (function,arguments) = self.link.getfunction();
      result = []; result.append(function)
      if(not self.function): self.function = 1; isetfunction = 1
      for i in range(0,arguments):
        result.append(self.__gettoken())
      if(self.function and (not isetfunction)):
        if(self.debug): print "Token Type: %s\t%s" % (tokendictionary[token],self.__printarray(result))
	return result
      else:
        if(self.debug): print "Token Type: %s\t%s" % (tokendictionary[token],self.__printarray(result))
	else: print self.__printarray(result)
        self.function = 0
    else:
      print "Uncaught token, ending"
      self.next = self.__finish
      return None
    self.next = self.__getpacket
    return out

  def __finish(self):
    self.link.putfunction('Quit',0)
    raise FrontEndFinished, "Finished Executing"
  
  def __getinput(self):
    expr = raw_input(self.prompt)
    if(re.search(r'python',expr)):
      self.next = self.__pythonprompt
      print "Accessing Python interpreter:"
      return
    self.link.putfunction("EnterExpressionPacket",1)
    self.link.putfunction("ToExpression",1)
    self.link.putstring(expr)
    self.next = self.__getpacket
  
  def __pythonprompt(self):
    eout = None
    expr = raw_input(self.pythonprompt)
    try: eout = eval(expr,self.mynamespace,self.mynamespace)
    except SyntaxError, e: 
      try: exec expr in self.mynamespace, self.mynamespace
      except Exception, e:
        print "Exception occured: %s" % (e)
	return
    except Exception, e:
      print "Exception occured: %s" % (e)
      return
    if(re.search(r'quit',expr)):
      self.next = self.__getinput
      if(self.mynamespace['debug'] == 1): self.debug = 1
      elif(self.mynamespace['debug'] == 0): self.debug = 0
      print "Ending Python interaction, returning to Mathematica..."
    else: 
      if(eout != None): print eout
      self.next = self.__pythonprompt
    
  def __printarray(self,array):
    if(len(array) == 0): return None
    s = str(array[0]) + "[";
    for i in range(1,len(array)):
      if(isinstance(array[i],ListType)): s += str(self.__printarray(array[i]))
      else: s += str(array[i])
      if(i < len(array) - 1): s += ", "
    s += "]"
    return s
      
# End FrontEnd
print "Python example text Front End for Mathematica"
try:
  #kernel = link(name="'/usr/local/bin/math -mathlink'",protocol="Pipes",mode=launch)
  kernel = link(); kernel.openargv(sys.argv)
  kernel.connect()
except LinkError, e:
  print "Unable to open and connect Link: %s" % (str(e))
  sys.exit(1)
FE = FrontEnd(kernel,0)
try:
  while(1):
    FE.executenextstep()
except FrontEndFinished, e:
  print "%s" % (str(e))
  sys.exit(0)
except LinkError, e:
  enumb = kernel.error()
  if(enumb == MLECLOSED):
    print "Link to kernel closing: %s" % (str(e))
  else:
    print "Unexepected LinkError: %s" % (str(e))
  kernel.close()
  sys.exit(1)
except KeyboardInterrupt, e:
  print "Keyboard interrupt, closing link"
  kernel.close()
  sys.exit(0)
except EOFError, e:
  print "Received Ctrl-D, quiting..."
  kernel.close()
  sys.exit(0)
