var strBundleService = null;
var regionalBundle = null;


/* 
 * Name: aimRDFSession
 * Arguments: None
 * Description:
 * Returns: the NC:AIM/session resource
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFSession()
{
	var rdf = aimRDF();
	if ( rdf ) {
		return rdf.GetResource("NC:AIM/Session");
	}
	return null;
}

/* 
 * Name: aimRDFSessionState
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the OnlineState resource
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFSessionState()
{
	var rdf = aimRDF();
	if ( rdf ) {
		return rdf.GetResource("http://home.netscape.com/NC-rdf#OnlineState");
	}
	return null;
}

/* 
 * Name: aimRDFWarningStatus
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the nsIRDF service
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFWarningStatus()
{
	var rdf = aimRDF();
	if ( rdf ) {
		return rdf.GetResource("http://home.netscape.com/NC-rdf#Warning");
	}
	return null;
}

/* 
 * Name: aimGetStrBundle(path)
 * Arguments: path
 * Description:
 * Returns: 
 *
*/

function aimGetStrBundle(path)
{
  var strBundle = null;
  if (!strBundleService) {
      try {
          strBundleService =
              Components.classes["@mozilla.org/intl/stringbundle;1"].getService(); 
          strBundleService = 
              strBundleService.QueryInterface(Components.interfaces.nsIStringBundleService);
      } catch (ex) {
          return null;
      }
  }
  strBundle = strBundleService.createBundle(path); 
  if (!strBundle) {
	  return  null;
  }
  return strBundle;
}

function aimRegionString(name)
{
	if (!regionalBundle) {
		regionalBundle = aimGetStrBundle("chrome://aim-region/locale/region.properties");
	}

	if (regionalBundle) {
		try {
			return regionalBundle.GetStringFromName(name);
		} catch (ex) {
			  return null;
		}
	}
	return "";
}

function aimGetArgs(data)
{
	var args = new Object();
	var pairs = data.split(",");
	
	for (var i = pairs.length - 1; i >= 0; i--)
	{
		var pos = pairs[i].indexOf('=');
		if (pos == -1)
			continue;
		var argname = pairs[i].substring(0, pos);
		var argvalue = pairs[i].substring(pos + 1);
		if (argvalue.charAt(0) == "'" && argvalue.charAt(argvalue.length - 1) == "'")
			args[argname] = argvalue.substring(1, argvalue.length - 1);
		else
			try {
			  args[argname] = unescape(argvalue);
			} catch (e) {
			  args[argname] = argvalue;
			}
	}
	return args;
}

function aimString(name)
{

	var myAimSession = aimSession();
	if ( myAimSession ) {
		var pIStringBundle = aimSession().QueryInterface(Components.interfaces.nsIStringBundle);
		if (pIStringBundle) {
      var connection= getCurrentSessionType();
      if (connection == "AIM")
			  return pIStringBundle.GetStringFromName(name);
      if (connection =="ICQ")
        {
          var icqname= name+"_ICQ";
          try {
            if (pIStringBundle.GetStringFromName(icqname)){
              return pIStringBundle.GetStringFromName(icqname);
            }
          }
          catch (e)
          {
            //do nothing when msg_ICQ does not exist - the next return will give the msg and cover that case
          }
          return pIStringBundle.GetStringFromName(name);
        }
      }
	}
	return "";
}

function aimErrorBox(errorText)
{
	top.alert(errorText);
}

/* Global menu commands. Menu commands that might be useful to multiple apps go here */

function aimCmdNewBrowser(url)
{
	var Browser_pref=null;
	try
	{
    Browser_pref = Components.classes["@mozilla.org/preferences-service;1"];
    if (Browser_pref)       Browser_pref = Browser_pref.getService();
    if (Browser_pref)       Browser_pref = Browser_pref.QueryInterface(Components.interfaces.nsIPrefBranch);
	}
	catch (ex)
	{
    Browser_pref = null;
	}

	if (Browser_pref.getBoolPref("network.protocols.useSystemDefaults"))
  {
	  var uri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI); 
		uri.spec=url;
		aimAdminManager().LoadDefaultBrowser(uri);
	}
	else
		window.openDialog( "chrome://navigator/content/navigator.xul", "_blank", "chrome,all,dialog=no", url);
}


function aimCmdNewEmail()
{
	openDialog("chrome://messenger/content/messengercompose/messengercompose.xul", "");
}


//SURESH: This is a hack ;-) it will work fine tgh.
//The backend datasource code shd have the ability to return the #of groups. Add it later on.
//The way it works here is: we checked the first index (0) to see it contains something other than Offline.
function aimCheckForGroupCount()
{
  var tree = getSelectedTreeName();
  var col = getSelectedTabName();
  var view = tree.treeBoxObject.view;
  var firstLevel = view.getLevel(0);
  var firstText = view.getCellText(0, col);
  if ((firstLevel == 0) && (firstText != "Offline"))
    return true;
  else
    return false;
}

/* returns the selected groups*/

function aimGetSelectedBuddyGroups()
{
  var tree = getSelectedTreeName();
  var rangeCount = tree.treeBoxObject.selection.getRangeCount();
  if (rangeCount == 0)
    return null;
  var groups = new Array();
  var count = 0; 
  var col = getSelectedTabName();
  var view = tree.treeBoxObject.view;
  for(var i = 0; i < rangeCount; i++) {
    var startIndex = {};
    var endIndex = {};
    tree.treeBoxObject.selection.getRangeAt(i, startIndex, endIndex);
    for (var j = startIndex.value; j <= endIndex.value; j++) {
      var level = view.getLevel(j);
      if (level == 0) {
        //first see whether the selection is a group by checking the level
        //var colName = view.getCellText(j, col);
        var groupResource = GetBuddyResource(tree, j);
        var colName = GetBuddyAttribute(tree, groupResource, "Name");
        if (colName != "Offline")
          // ignore if Offline group is selected.
          groups[count++] = colName;
      }
    }
  }

  return groups;
}


// this function tries to find where the groups data in the tree starts, 
// and returns the node, else null. 

function aimBuddyTreeFindGroups( tree )
{
	if ( !tree ) {
		return( null);
	}

	else if ( !tree.childNodes )
	{
		return( null );
	}

	for ( var i = 0; i < tree.childNodes.length; i++ ) {
		if ( tree.childNodes[i].nodeName == "treechildren" ) {
			return( tree.childNodes[i].childNodes );
		}
	}
	return( null );
}

function aimGlobalCmdStartupWizard()
{
	var windowManager = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator'].getService();
	var	windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
	var topWindow = windowManagerInterface.getMostRecentWindow("Aim:StartupWizard");
  if(topWindow)
    topWindow.focus();
  else{
    var testingWizard = aimPrefsManager().GetBoolPref("aim.session.testingregistrationwizard", null, true);
	if(testingWizard){
       window.openDialog('chrome://aim/content/migration.xul','CPW','chrome,titlebar,resizable=yes',document);
       }
       else{
          window.openDialog('chrome://aim/content/migrationWizard.xul','CPW','chrome,titlebar,resizable=yes',document);
       }
    }
}

function ClearMenuList( menulist )
{
	if ( menulist ) {
		menulist.selectedItem = null;
		while( menulist.firstChild )
			menulist.removeChild( menulist.firstChild );
	}
}

/* 
 * Name: aimRDFSession
 * Arguments: None
 * Description:
 * Returns: the NC:AIM/session resource
 * Author: syd@netscape.com 5/18/2001
 *
*/
function AppendStringToMenulist(menulist, string)
{
  if (menulist) {
    var menupopup = menulist.firstChild;
    // May not have any popup yet -- so create one
    if (!menupopup) {
      menupopup = document.createElement("menupopup");
      if (menupopup)
        menulist.appendChild(menupopup);
      else {
        return null;
      }
    }
    menuItem = document.createElement("menuitem");
    if (menuItem) {
      menuItem.setAttribute("label", string);
      menupopup.appendChild(menuItem);
      return menuItem;
    }
  }
  return null;
}
