var container = Components.classes['@mozilla.org/rdf/container;1'].createInstance();
container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
container.Init(aimRDFDataSource(), aimRDF().GetResource("NC:AIM/BuddyList"));
var gScreenName = "";
var gGroupArray;
var aimABInfo;
var gGroupInitState = new Array();
var pIAimBuddy = aimManager().QueryInterface(Components.interfaces.nsIAimBuddy);  

function OnLoadABTab()
{
  dump("Calling OnLoadABTab\n");

  // Initialize online state
  var target = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
  var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

  var deck = document.getElementById("AIMDeck");
  if (!(state == "Online" || "OnlineAway" == state))
  {
    deck.setAttribute("selectedIndex", 1);
  }
  else // we're online
  {
    RegisterSaveListener(OnSaveAimABTab);
    deck.setAttribute("selectedIndex", 0);
    // pIIMManager is in Aim.js
    aimABInfo = aimManager().QueryInterface(Components.interfaces.nsIAimABInfo);

    try { 
      var mdbcard = editCard.card.QueryInterface(Components.interfaces.nsIAbMDBCard);
      if (mdbcard)
        gScreenName = mdbcard.getStringAttribute("_AimScreenName");
    }
    catch(ex) { 
      gScreenName = ""; 
    }
     setTimeout('BuildGroupFrame()',50);

     document.getElementById('ScreenName').setAttribute("value", gScreenName);
//   document.getElementById('ScreenName').setAttribute("disabled", true);
//   document.getElementById('BuddyListCheckbox').checked = true;
//   document.getElementById('BuddyListCheckbox').disabled = true;
//   document.getElementById('profile').disabled = true;
  }
}

function OnSaveAimABTab()
{
  var changedScreenName = false;

  try { 
    var screenname = document.getElementById('ScreenName').value;
    var mdbcard = editCard.card.QueryInterface(Components.interfaces.nsIAbMDBCard);
    if (mdbcard) {
      changedScreenName = (screenname != mdbcard.getStringAttribute("_AimScreenName"));     
      if (changedScreenName) {
        mdbcard.setStringAttribute("_AimScreenName", screenname);
      }
    }
  }
  catch(ex) { 
    // this can happen if this isn't a mdb addressbook (example, ldap)
    dump("ex = " + ex + "\n");
  }

  var currentlyChecked;
  for ( var i=0; i < gGroupArray.length; i++ ) {
    currentlyChecked = GetCheckBoxState( gGroupArray, i );

    // if the box is checked AND it was not previously checked (or the user changed the IM screen name, add the buddy to the group
	  if (currentlyChecked && (!gGroupInitState[i] || changedScreenName)) {
	  	try {
		    aimBuddyAddBuddyAfter(gGroupArray[i], screenname, null, null, null);
      }
	  	catch (e) { 
        dump("error adding buddy\n");
	  	}
    }
  	// if it was checked before, but not checked now, remove the buddy unless the user changed im screen names
    else if( !currentlyChecked && gGroupInitState[i] && !changedScreenName) {
      try  { 
		    aimBuddyRemoveBuddy(gGroupArray[i], screenname);
	   	}
      catch (e) { 
        dump("error removing buddy\n");
		  }
    }
  }
}

function BuildGroupFrame()	
{
//  if(gScreenName == "")
//    return;
        if(document.getElementById("AddBuddyGroupList").childNodes.length > 0)
	  return;

	var a = new Array();
	var i = 0;
	gGroupArray = a;

	var enumerator = container.GetElements();
	while (enumerator.hasMoreElements()) 
		{
		var element = enumerator.getNext();
		var resource = element.QueryInterface(Components.interfaces.nsIRDFResource);
		var attr = aimRDFDataSource().GetTarget(resource, 
			aimRDF().GetResource("http://home.netscape.com/NC-rdf#Name"), true);
		if (attr)
			attr = attr.QueryInterface(Components.interfaces.nsIRDFLiteral);
		if (attr) 
		{
			attr = attr.Value;
			a[ i ] = attr;
			i = i + 1;
		}
	}
	CreateGroupList( a );
}
function CreateGroupList( a )
{
  var listDocument = document.getElementById("AddBuddyGroupList")
  listDocument.appendChild(document.createElement("spacer"))
 
  for ( var i=0; i < a.length; i++ ) {
    var chkboxname = "checkBox" + a[i];
    var inBudGroup = false;
		if (gScreenName && (gScreenName != "")) {
      inBudGroup = pIAimBuddy.BuddyIsInGroup(gScreenName, a[i]);
		}

    var outputElement = document.createElement('checkbox')
    outputElement.setAttribute('id',chkboxname)
    outputElement.setAttribute('name',a[i])
    outputElement.setAttribute('label',a[i])
          
    if (inBudGroup) {
			outputElement.setAttribute('checked',true)
    }
    gGroupInitState[i] = inBudGroup;
    
    listDocument.appendChild(outputElement)
  }
  listDocument.appendChild(document.createElement("spacer"))
}       


function GetCheckBoxState( a, i )
{
	chkboxname = "checkBox" + a[i];
	chkbox = document.getElementById(chkboxname);
	return( chkbox.checked );
}

// for later 

function FindSelectedGroup()
{
	// Locate selection in setup list
	// XXX There must be a better way to do this

	var selectedGroup = null;
	var selectedBuddy = null;
	var tree = window.tree;
	dump( "Tree is " + tree + "\n" );
	DumpDOM( tree );
	var groups = tree.childNodes[2].childNodes;

	for (var i = 0; i != groups.length; i++) {
		if (groups[i].getAttribute("selected") == "true") {
			selectedGroup = groups[i].getAttribute("Name");
			break;
		}
	}
	return( selectedGroup );
}

