/*
 * Function:  AimAddGroupWndOnLoad()
 * Arguments: None
 * Return: None
 * Description:  This function is called when the user chooses to add a group and the addgroup window gets loaded.
 * It sets the Ok button to do addgroup function and sets focus to the groupname text box field.
*/

function AimAddGroupWndOnLoad()
{
	doSetOKCancel(AddGroup, 0);
	setTimeout("document.getElementById('fldGroupName').focus()",200);
}

	// build an array of groups
	// generate a list of checkboxes for each

/*
 * Function:  AimAddBuddyWndOnLoad()
 * Arguments: selectedGroups, tree, screenname, (optional) url-argument
 * Return: None
 * Description:  This function is called when the user chooses to add a buddy and the addbuddy window gets loaded.
 * It builds the check box list with all the group names by calling BuildGroupFrame with selectedGroups value.
 * The user can choose which groups the buddy name needs to be added to. It also sets the listSetupTree attribute
 * on the window with the tree name. It sets the Ok button to do addbuddy function and sets focus to the buddyname
 * text box field.
*/

function AimAddBuddyWndOnLoad()	
{
  var gps = window.arguments[0];
  if (window.arguments.length > 3) {
	  if((window.arguments[3] != null) && (window.arguments[0] != null))  {
		gps = gps.split(",");
	  }
  }
  if (isIcq() == true)
  {
    var icqtitle=window.document.getElementById("AimAddBuddyPanel").getAttribute("icqtitle");
    window.document.getElementById("AimAddBuddyPanel").setAttribute("title", icqtitle);
    icqtitle=window.document.getElementById("labelBuddyName").getAttribute("icqvalue");
    window.document.getElementById("labelBuddyName").setAttribute("value", icqtitle);
    window.document.getElementById("labelDisplayName").setAttribute("hidden", "false");
    window.document.getElementById("fldDisplayName").setAttribute("hidden", "false");
    window.document.getElementById("enterContact").setAttribute("hidden", "false");
    window.document.getElementById("enterDisplay").setAttribute("hidden", "false");
    window.document.getElementById("icqSearchButton").setAttribute("hidden", "false");
    var icqval= document.getElementById('AddBuddyLabel').getAttribute('icqmsg', icqval);
    document.getElementById('AddBuddyLabel').setAttribute('value', icqval);
  }
  else
  {
    var imtitle=window.document.getElementById("AimAddBuddyPanel").getAttribute("imtitle");
    window.document.getElementById("AimAddBuddyPanel").setAttribute("title", imtitle);
    imtitle=window.document.getElementById("labelBuddyName").getAttribute("imvalue");
    window.document.getElementById("labelBuddyName").setAttribute("value", imtitle);
    window.document.getElementById("enterDisplay").setAttribute("hidden", "true");
    window.document.getElementById("labelDisplayName").setAttribute("hidden", "true");
    window.document.getElementById("fldDisplayName").setAttribute("hidden", "true");
    window.document.getElementById("enterContact").setAttribute("hidden", "true");
    window.document.getElementById("enterDisplay").setAttribute("hidden", "true");
    window.document.getElementById("icqSearchButton").setAttribute("hidden", "true");
    var imval= document.getElementById('AddBuddyLabel').getAttribute('immsg', imval);
    document.getElementById('AddBuddyLabel').setAttribute('value', imval);
  }
	top.listSetupTree = window.arguments[1];
  if (isIcq())
    doSetOKCancel(IcqAddContact, 0);
  else
	  doSetOKCancel(AimAddBuddies, 0);
	BuildGroupFrame(gps);
	if(window.arguments[2]) {
		document.getElementById("fldBuddyName").value=window.arguments[2]
    return;
  }
  else {
    setTimeout("document.getElementById('fldBuddyName').focus()",200);
  }
  
}


function AimAddBuddies()
{
	var fldBuddy = top.document.getElementById("fldBuddyName");
	var buddy = fldBuddy.value;
	var buddyRelative = null
	var found = false;
	var error = false;
	var error2 = false;
	var a = top.a;

  var pIAimBuddy = aimBuddyManager();
  var aimIBuddy = Components.interfaces.nsIAimBuddy;
  var service= new Object();

  if (!pIAimBuddy || !aimIBuddy){
    aimErrorBox(aimString("msg.BadBuddy"));
    return;
  }

	if ( buddy == "" || !buddy ) {
		aimErrorBox(aimString("msg.EnterBuddy"));
		return;
	}

  var isUnification=getPreaknessFlag();
  var buddies = buddy.split(",");
  for (var j=0; j < buddies.length; j++) {
    var isAllDigits=true;
    buddies[j] = buddies[j].replace(/^\s+|\s+$/g, "");
    if (isUnification)
    {
      isAllDigits=IsIcqServiceUser(buddies[j]);
      if (isAllDigits == true) {
        service[j]=1;
      }
      else
        service[j]=0;
      var isInList = new Object();
      aimBuddyManager().IsInBuddyList(buddies[j], isInList);
      if (isAllDigits == true && isInList.value != true )
      {
        window.openDialog('chrome://aim/content/DisplayName.xul','_blank','modal=yes,chrome,all,centerscreen,dialog=no',j,buddies[j]);
        disp[j]=document.getElementById('storageField').value;
      }
    }
    else
    {
      var fldDisplay = top.document.getElementById("fldDisplayName");
      var display = fldDisplay.value;
      if (display) {
        disp = display.split(",");
        for (var j=0; j < disp.length; j++) {
          // Mini Parser to extract all the display names....
          disp[j] = disp[j].replace(/^\s+|\s+$/g, "");
        }
      } //if display
    }
  }

  
  for ( var i=0; i < a.length; i++ ) {
    if ( GetCheckBoxState( a, i ) == true ) {
      found = true;
      buddyRelative = FindBuddySelected( a[i], top.listSetupTree );
      try {
        //now add each buddies in the each group selected
        for (var j=0; j < buddies.length; j++) {
          if (disp[j] != null) {
            aimBuddyAddBuddyAfter( a[i], buddies[j], buddyRelative, disp[j], service[j]);
          }
          else {
            aimBuddyAddBuddyAfter( a[i], buddies[j], buddyRelative, null, service[j]);
          }
        }
      }
      catch (e) {
        if (pIAimBuddy.GetnResetError() == aimIBuddy.TooManyBuddies){
          aimErrorBox(aimString("msg.BigBuddyList").replace(/%MaxBudNum%/, "" + pIAimBuddy.GetMaxBudNum()));
          return;
        }
        else
          error2 = true;
      } //catch
    } //ifcheckbox 
  } //for 
  
  if (error2 == true) {
    aimErrorBox(aimString("msg.BadBuddy"));
  }
  else
    if ( found == true && error == false ) {
      top.window.close();
    }
    else if ( error == false ) {
		  aimErrorBox(aimString("msg.SelectGroup"));
	}
 

}

function IcqAddContact()
{
  var fldBuddy = top.document.getElementById("fldBuddyName");
  var buddy = fldBuddy.value;
  var buddyRelative = null
  var found = false;
  var error = false;
  var error2 = false;
  var a = top.a;

  var pIAimBuddy = aimBuddyManager();
  var aimIBuddy = Components.interfaces.nsIAimBuddy;
  var service= new Object();
  
  if (!pIAimBuddy || !aimIBuddy) {
    aimErrorBox(aimString("msg.BadBuddy"));
    return;
  }

  if ( buddy == "" || !buddy ) {
    aimErrorBox(aimString("msg.EnterBuddy"));
    return;
  }
  
  var isUnification=getPreaknessFlag();
  var buddies = buddy.split(",");
  for (var j=0; j < buddies.length; j++) {
    var isAllDigits=true;
    buddies[j] = buddies[j].replace(/^\s+|\s+$/g, "");
    if (isUnification)
    {
      isAllDigits=IsIcqServiceUser(buddies[j]);
      if (isAllDigits == true) {
        service[j]=1;
      }
      else
        service[j]=0;
    }
  }

    var fldDisplay = top.document.getElementById("fldDisplayName");
    var display = fldDisplay.value;
    var selectedGroups=0;
    
    for (var i=0; i < a.length; i++) {
      chkboxname = "checkBox" + a[i];
	    chkbox = document.getElementById(chkboxname);
	    if ( chkbox.checked )
         selectedGroups++;
	  }
    if (selectedGroups > 1) {
         // Adding same buddy to more than 1 group 
        aimErrorBox(aimString("msg.MultipleGroups"));
        return;
      }
      
    for (var j=0; j < buddies.length; j++) {
       var isInList = new Object();
       aimBuddyManager().IsInBuddyList(buddies[j], isInList);
       if ( isInList.value == true )  {
        // Adding buddy who is already in contact list
        aimErrorBox(aimString("msg.ExistingContact"));
        return;
      }
    
    var isInAuthList = new Object();
    aimFeedbagManager().IsInAuthList(buddies[j], isInAuthList);
    if ( isInAuthList.value == true )  {
     // Adding buddy who is already in auth await list
      aimErrorBox(aimString("msg.alreadyrequested"));
      return;
    }
        
  } //for loop

    if ( display == "" || !display ) {
      // Display name field is empty!
      aimErrorBox(aimString("msg.EnterDisplay"));
		  return;
	  }
   
    if ((display - 0) > 0) {
      // Display name field should not be a number - enough with icq numbers!
      aimErrorBox(aimString("msg.EnterCharDisplay"));
		  return;
    }

  	
		var disp_buddies = display.split(",");
		for (var j=0; j < disp_buddies.length; j++) {
      // Mini Parser to extract all the display names....
			disp_buddies[j] = disp_buddies[j].replace(/^\s+|\s+$/g, "");
	  }

  if ((buddies.length) != (disp_buddies.length)) {
      // if number of buddies and number of display names do not match.
      aimErrorBox(aimString("msg.MismatchDisplay"));
		  return;
    }

	for ( var i=0; i < a.length; i++ ) {
	  if ( GetCheckBoxState( a, i ) == true ) {
		  found = true;
			buddyRelative = FindBuddySelected( a[i], top.listSetupTree );
			try {
			  //now add each buddies in the each group selected
				for (var j=0; j < buddies.length; j++) {
            aimBuddyAddBuddyAfter( a[i], buddies[j], buddyRelative, disp_buddies[j], service[j] );
            }
				}
      catch (e) {
          if (pIAimBuddy.GetnResetError() == aimIBuddy.TooManyBuddies){
            aimErrorBox(aimString("msg.BigBuddyList").replace(/%MaxBudNum%/, "" + pIAimBuddy.GetMaxBudNum()));
            return;
          }
          else
				    error2 = true;
      } //catch
	 } //ifcheckbox 
	} //for 
  
	if (error2 == true) {
	    aimErrorBox(aimString("msg.BadBuddy"));
	}
  else
    if ( found == true && error == false ) {
		top.window.close();
	}
	else if ( error == false ) {
		aimErrorBox(aimString("msg.SelectGroup"));
	}

}




function AddGroup()
{
	var fldGroup = top.document.getElementById("fldGroupName");
	var group = fldGroup.value;
  if (group && group != "") {
    // trim the spaces before and after the group.
    group = group.replace(/^\s+|\s+$/g, "");
  }
  if (group && group.toLowerCase() == "offline") {
    aimErrorBox(aimString("msg.GroupAlreadyInList"));
    return;
  }
	if ( group && group != "" ) {
		if ( !aimBuddyAddBuddyGroup(group, null) )
			top.window.close();
	}
	else
		aimErrorBox(aimString("msg.EnterGroup"));	
}

function KeyPressAddGroup(event){
	if(event.keyCode== 13){
		AddGroup();
	}
}

function AimDisplayNameWndOnLoad()
{
  cur_val=window.arguments[0];
  cur_name=window.arguments[1];
  doSetOKCancel(SetDisplay, 0);
}

function SetDisplay()
{
  var Name=document.getElementById('dispName');
  var Number=document.getElementById('dispIcq');
  var sel_item=document.getElementById('dispChoices').selectedItem;
  if (sel_item == Name)
    disp[cur_val]=document.getElementById('fldDisplayName').value;
  else
    disp[cur_val]=cur_name;
  top.opener.document.getElementById('storageField').value=disp[cur_val];
  top.window.close();
}

function IsIcqServiceUser(buddy)
{
  var isAllDigits = false;
  var cp = new String(buddy);
  if ((cp.charCodeAt(0) > 47) && (cp.charCodeAt(0) < 58)) 
    // Begins with a number - icq numbers always begin with number whereas aim canNOT begin with number
    isAllDigits=true;
  return isAllDigits;
}


