var processInviteTimer = -1;
var initialState = "Offline";

/*
 * Function: UpdateMenuItemsForApp(isonline)
 * Arguments: 
 *       isonline -- login state (offline/online)
 * Return: None
 * Description: This function is called when the user signs on/off and on load of Standalone.
 * According to the the input parameter, the menu items in the standalone get updated.
*/

function UpdateMenuItemsForApp(isonline)
{
  if ( isonline == "Offline"){
   ClearProcessTimer();
   top.title = aimString("app.title.SignOn");
   top.document.getElementById("miSignOn").setAttribute("label", aimString("miSignOn.SignOn"));
   top.document.getElementById("miSignOn").setAttribute("oncommand", "cmdSignOn();");
   top.document.getElementById("miSignOn").setAttribute("disabled", "false");
   top.document.getElementById("miSignOffClose").setAttribute("disabled", "true");
   top.document.getElementById("miIcqSignOn").setAttribute("label", aimString("miSignOn.SignOn"));
   top.document.getElementById("miIcqSignOn").setAttribute("oncommand", "cmdSignOn();");
   top.document.getElementById("miIcqSignOn").setAttribute("disabled", "false");
   top.document.getElementById("miIcqSignOffClose").setAttribute("disabled", "true");
   top.document.getElementById("change_password").setAttribute("disabled", "true");
   top.document.getElementById("confirm_account").setAttribute("disabled", "true");
   top.document.getElementById("change_email").setAttribute("disabled", "true");
   top.document.getElementById("people_menu").setAttribute("hidden", "true");
   top.document.getElementById("people_menu_icq").setAttribute("hidden", "true");
   top.document.getElementById("menu_PeoplePopup").setAttribute("collapsed", "true");
   top.document.getElementById("menu_PeoplePopup_icq").setAttribute("collapsed", "true");
   top.document.getElementById("menu_Away").setAttribute("hidden", "true");
   top.document.getElementById("away_seperator").setAttribute("hidden", "true");
   top.document.getElementById("menu_Away_icq").setAttribute("hidden", "true");
   top.document.getElementById("away_icq_seperator").setAttribute("hidden", "true");
   top.document.getElementById("cmd_IM").setAttribute("disabled", "true");
   top.document.getElementById("cmd_import").setAttribute("disabled", "true");
   top.document.getElementById("cmd_export").setAttribute("disabled", "true");
  }
 else {
   top.document.getElementById("miSignOn").setAttribute("label", aimString("miSignOn.SignOff"));
   top.document.getElementById("miSignOn").setAttribute("oncommand", "cmdSignOff();");
   top.document.getElementById("miSignOn").setAttribute("disabled", "true");
   top.document.getElementById("miSignOffClose").setAttribute("disabled", "false");
   top.document.getElementById("miIcqSignOn").setAttribute("label", aimString("miSignOn.SignOff"));
   top.document.getElementById("miIcqSignOn").setAttribute("oncommand", "cmdSignOff();");
   top.document.getElementById("miIcqSignOn").setAttribute("disabled", "true");
   top.document.getElementById("miIcqSignOffClose").setAttribute("disabled", "false");
   top.document.getElementById("change_password").setAttribute("disabled", "false");
   top.document.getElementById("confirm_account").setAttribute("disabled", "false");
   top.document.getElementById("change_email").setAttribute("disabled", "false");
   if (isIcq() == true) {
     top.document.getElementById("people_menu_icq").setAttribute("hidden", "false");
     top.document.getElementById("menu_PeoplePopup_icq").setAttribute("collapsed", "false");
     top.document.getElementById("menu_Away_icq").setAttribute("hidden", "false");
     top.document.getElementById("away_icq_seperator").setAttribute("hidden", "false");
     top.document.getElementById("people_menu").setAttribute("hidden", "true");
     top.document.getElementById("menu_PeoplePopup").setAttribute("collapsed", "true");
     top.document.getElementById("menu_Away").setAttribute("hidden", "true");
     top.document.getElementById("away_seperator").setAttribute("hidden", "true");
     }
     else
     {
     top.document.getElementById("people_menu").setAttribute("hidden", "false");
     // top.document.getElementById("menu_Away").setAttribute("hidden", "false");
     top.document.getElementById("menu_PeoplePopup").setAttribute("collapsed", "false");
     top.document.getElementById("menu_Away").setAttribute("hidden", "false");
     top.document.getElementById("away_seperator").setAttribute("hidden", "false");
     top.document.getElementById("people_menu_icq").setAttribute("hidden", "true");
     top.document.getElementById("menu_PeoplePopup_icq").setAttribute("collapsed", "true");
     top.document.getElementById("menu_Away_icq").setAttribute("hidden", "true");
     top.document.getElementById("away_icq_seperator").setAttribute("hidden", "true");
     }
   top.document.getElementById("cmd_IM").setAttribute("disabled", "false");
   top.document.getElementById("cmd_import").setAttribute("disabled", "false");
   top.document.getElementById("cmd_export").setAttribute("disabled", "false");
   // SetupCommandUpdateHandlers() will initialize command observers for Online tree and listsetup tree.
   // timeout is used coz it takes a bit of time for the Online and listsetup tab to show up!
   setTimeout("AimSetupCommandUpdateHandlers()", 500);
   aimMigrateBuddyList( aimSessionCurrentScreenName() );
   SetAwayMenu();
   SetProcessTimer(10000);


 }
}

/****************  Window Management *****************/

function AimSidebarPanelOnWndLoad() {
  //register buddy list observer for sidebar.
  addSidebarBuddyListObserver();
  var todayhide = aimPrefsManager().GetBoolPref("aim.internal.hidetoday", null, false);
  if (todayhide)
  {
    document.getElementById("btnbuddyorgtoday").setAttribute("style", "display: none" );
  }
  var hasState;
  var hideConnection = aimPrefsManager().GetBoolPref("aim.session.hideconnection", null, false);
  if (hideConnection == true) {
    picker = document.getElementById('sessionPicker');
    picker.setAttribute("style", "display: none" );
    picker = document.getElementById('sessionPickerLabel');
    picker.setAttribute("style", "display: none" );
  } 

  enableSignOnButton(false);
	// Read signon prefs. We need to load at least the screen name here,
	// but might as well load the password and autoLogin prefs, too.

	var screenName = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);
	
	//dump("ScreenName is " + screenName);

	var password = aimSessionGetPassword(null);
	var autoLogin = aimPrefsManager().GetBoolPref("aim.session.autologin", null, false);
	var firstTime = aimPrefsManager().GetBoolPref("aim.session.firsttime", null, true); // firsttime is a GLOBAL pref
	var alreadyFinishedWizard = aimPrefsManager().GetBoolPref("aim.session.finishedwizard", null, false);
 
  addSidebarSessionListener();  
  var connectionName = aimPrefsManager().GetCharPref("aim.session.userconnectionname", null, true);
  setMenuPopUp (connectionName);
	top.AIMDocumentPath=window;

  // If this is the first time the user is launching aim, pop open the wizard.
  // If not, ignore and move on.
  if (firstTime) {
    //***** turning off this behavior but we may still need to know if the
    //***** wizard has run yet or not.
    //aimGlobalCmdStartupWizard();
    // Set pref so we don't pop open the wizard again automatically if the user doesn't finish the wizard the first time.
    aimPrefsManager().SetBoolPref("aim.session.firsttime",false, null, true);
  }	

	// Initialize online state

	var state = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
	
	if (state == null){
		state = aimRDF().GetLiteral("Register");	
    hasState = true;	
		}

  if (alreadyFinishedWizard && (hasState || state == aimRDF().GetLiteral("Register")))
    state = aimRDF().GetLiteral("Offline");

   if (screenName && screenName !="" && !alreadyFinishedWizard){
      //we are in that special state of having had another wizard set a screen name
      //but we havent finished up the 'registration'
      aimSessionRegister(screenName);
      aimPrefsManager().SetBoolPref("aim.session.finishedwizard",true, null, true);
      //preset the latestaimscreenname so it will be preserved  if the user
      //switches services before ever signing on it will still remember the
      //aim screenname
      aimPrefsManager().SetCharPref("aim.session.latestaimscreenname",screenName, null, true);
      state = aimRDF().GetLiteral("Offline");   
   }  
  // Check whether the Sidebar buddylist is getting loaded or the Standalone one
  CheckIfApp("Aim:AimApp");
  CheckIfSidebar();

  // If App then initialize the menu items.
  if ((IsApp) && (!IsSidebar)) 
    UpdateMenuItemsForApp("Offline");
  
	
  OnlineObserver.onAssert(aimRDFDataSource(), aimRDFSession(), aimRDFSessionState(), state);
  // Watch future changes to online state
	aimRDFDataSource().AddObserver(OnlineObserver);
	
	
  var firstLogin = aimPrefsManager().GetBoolPref("aim.session.appfirstlogin", null,true);
  // Auto login
	
if (screenName && screenName != '' && password && password != '' && autoLogin && firstLogin != false &&
    connectionName && connectionName !='') {
      if (state.EqualsNode(aimRDF().GetLiteral("Offline"))) {

            if (!IsServiceCorrect(screenName, connectionName)) {
                return;  
            }

            setConnectionInfo (connectionName, "im", screenName);
			aimSessionLogin(screenName, password);
       }
	}
	else
	{
		if (screenName && screenName != '')
		{
			if (!password || password == '')
				document.getElementById('fldPassword').focus();
      else
        enableSignOnButton(true); //ok..we have SN and password. Enable the signon button
		}
		else
			document.getElementById('fldScreenName').focus();
			
	}
}

function resetPopUp()
{
  setMenuPopUp (document.getElementById("sessionTypeListmenu").value);
}


function AimSidebarPanelSetAwayMsgBtn(){
  var menu = window.document.getElementById("btnaway");
  if (isIcq() == true)
  {
    // this is an Icq session
    var sidebar_file = GetRdfFileUrl("default-messages-icq.rdf", "icqdm.rdf"); 
    menu.setAttribute('ref', "NC:ICQ/AwayMessageBag");  
  }
	else
  {
    var sidebar_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf");
    menu.setAttribute('ref', "NC:AIM/AwayMessageBag");  
  }
  var datasource = aimRDF().GetDataSource(sidebar_file);
  var menudb=menu.database.GetDataSources();
  while   (menudb.hasMoreElements()) {
                var curDS= menudb.getNext();
  			curDS=curDS.QueryInterface(Components.interfaces.nsIRDFDataSource);
                menu.database.RemoveDataSource(curDS);
        }
	menu.database.AddDataSource(datasource);
  menu.builder.rebuild();
}


function SetAwayMenu(){
  var menu;
  if (isIcq() == true) {
    menu = top.document.getElementById("menu_Away_icq");
    // this is an Icq session
    var sidebar_file = GetRdfFileUrl("default-messages-icq.rdf", "icqdm.rdf"); 
    menu.setAttribute('ref', "NC:ICQ/AwayMessageBag");  
  }
	else {
    menu = top.document.getElementById("menu_Away");
	  var sidebar_file = GetRdfFileUrl("default-messages.rdf", "dm.rdf");  
  }
  var datasource = aimRDF().GetDataSource(sidebar_file);
	var menudb=menu.database.GetDataSources();
  while   (menudb.hasMoreElements()) {
                var curDS= menudb.getNext();
				curDS=curDS.QueryInterface(Components.interfaces.nsIRDFDataSource);
                menu.database.RemoveDataSource(curDS);
        }
	menu.database.AddDataSource(datasource);
	menu.builder.rebuild();
}

function AimSidebarPanelOnWndUnload() {

	// Save signon fields if offline. If online, we saved during signon.
	var state = aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true);
	if (state == null || state.EqualsNode(aimRDF().GetLiteral("Offline")))
		SaveFieldsToPrefs();
  aimRDFDataSource().RemoveObserver(OnlineObserver);
  ClearProcessTimer();
  removeSidebarSessionListener();
  removeSidebarBuddyListObserver();
}

function InitFieldsFromPrefs( doSNAndPasswd, curScreenName) {


    if (doSNAndPasswd == true) {
		var screenName = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);
		var password = aimSessionGetPassword(null);
		document.getElementById('fldScreenName').value = screenName;
	}
	var savePassword = aimPrefsManager().GetBoolPref("aim.session.storepassword", null, false);
	var autoLogin = aimPrefsManager().GetBoolPref("aim.session.autologin", null, false);
    document.getElementById('chkSavePassword').checked = savePassword;

    // PRASS TODO: This does something wrong. Keeps switching the pulldown incorrectly. Need to look into
    // For now commenting out set menu pop up
	var connectionName;
  connectionName = aimPrefsManager().GetCharPref("aim.session.connectionname", null, false);
  if (curScreenName) {
	    var connectionName;
        if(doSNAndPasswd == true) {
            connectionName = aimPrefsManager().GetCharPref("aim.session.connectionname", null, false);
        }
	    else
	    	connectionName = aimPrefsManager().GetCharPrefEdit("aim.session.connectionname", null, false, 
	    										curScreenName, -1);
  //setMenuPopUp (connectionName);
  }

	if(doSNAndPasswd == true && savePassword)
	    document.getElementById('fldPassword').value = password;
    if (doSNAndPasswd == true && !savePassword)
        document.getElementById('fldPassword').value = '';


	document.getElementById('chkAutoLogin').checked = autoLogin;
	EnableInputs();
}


function setMenuPopUp (pLabel){
  
  dump("starting setMenuPopUp pLabel=" + pLabel + "\n");
    
  if (!pLabel || pLabel == "") {
    pLabel = "AIM";
    }
  var menuPopup = document.getElementById("sessionTypeList");
  if (!menuPopup) {   
    return;
  }
  var menuItems = menuPopup.childNodes;
  var menuItem;
  var defItem;
  for (var i=0; i < menuItems.length; i++)
  {
    menuItem = menuItems.item(i);
    if (menuItem.getAttribute("label") == pLabel )
    {
      document.getElementById('sessionTypeListmenu').selectedItem = menuItem;
      UpdateCurrentWindow(pLabel);
      return;
    }
    if (menuItem.getAttribute("label") == "AIM")  
      defItem = menuItem;
  }   
    //default
  document.getElementById('sessionTypeListmenu').selectedItem = defItem;
  UpdateCurrentWindow(pLabel);
  
}

function SaveFieldsToPrefs() {
  var screenName = document.getElementById('fldScreenName').value;
  var password = document.getElementById('fldPassword').value;
  var autoLogin = document.getElementById('chkAutoLogin').checked;
  var savePassword = document.getElementById('chkSavePassword').checked;
  var connectionNameNode = document.getElementById('sessionTypeListmenu').selectedItem;
  var connectionName = connectionNameNode.getAttribute("label");

  //safety check for trying to save an "empty" screen name. 
  if(screenName != ""){
    aimPrefsManager().SetCharPref("aim.session.screenname", screenName, null, true);
    aimPrefsManager().SetCharPref("aim.session.connectionname", connectionName, null, false);
    //aimPrefsManager().SetCharPref("aim.session.userconnectionname", connectionName, null, true);

    // test screenname to see if there are any non-numeric chars
    // if there are - then it's not a valid ICQ screen name so do not store it.
    // if there are only numeric chars then it's not a valid AIM screen name since 
    // they have to start with a letter at least.
  
    var foundNonNumeric = screenName.match(/[\D]+/g); //matches any alpha chars
  
    switch(connectionName){
       case "ICQ": if(!foundNonNumeric){
                      aimPrefsManager().SetCharPref("aim.session.latesticqscreenname", screenName, null, true);
                      }
                   break;
       case "AIM": if(foundNonNumeric){
                      aimPrefsManager().SetCharPref("aim.session.latestaimscreenname", screenName, null, true);
                      }
                   break;          
  
    }
  }


	if (savePassword)
		aimSessionSavePassword(password);
	else
		aimSessionSavePassword("");

	aimPrefsManager().SetBoolPref("aim.session.storepassword", savePassword, null, false);
	aimPrefsManager().SetBoolPref("aim.session.autologin", autoLogin, null, false);
}


function EnableInputs() {
  var password = document.getElementById("fldPassword").value;
	var savePassword = document.getElementById("chkSavePassword").checked;

	if (password != "") {
    enableSignOnButton(true);
    document.getElementById("chkSavePassword").disabled = false;
		document.getElementById("chkAutoLogin").disabled = !savePassword;

		// XXX This is what the AIM 3.0 client does. Not sure if we should
		//     change it.
		if (!savePassword)
			document.getElementById("chkAutoLogin").checked = false;
	}
	else {
        enableSignOnButton(false);
		document.getElementById("chkSavePassword").disabled = true;
		document.getElementById("chkAutoLogin").disabled = true;

		// XXX This is what the AIM 3.0 client does. Not sure if we should
		//     change it.
		document.getElementById("chkSavePassword").checked = false;
		document.getElementById("chkAutoLogin").checked = false;
	}
}


/*
 * Function: removeAllBuddyGroups()
 *
 * Arguments: none
 * 
 * Return: None
 *
 * Description: This function removes the IM datasource.
 *
 * Author: Suresh 12/13/01
 */

function removeAllBuddyGroups()
{
  var aimbuddy = aimBuddyManager();
  if (aimbuddy) {
    aimbuddy.RemoveAllGroups();
    aimbuddy.RemoveAuthGroup();
  }
}

/****************  RDF Observing ********************/

var OnlineObserver = new Object();

OnlineObserver.onAssert = function(datasource, source, property, target)
{
	if(source.EqualsNode(aimRDFSession()))
	{
		if(property.EqualsNode(aimRDFSessionState()))
		{
			var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

			// flip to the appropriate panel in the deck
      var deck = document.getElementById("PanelDeck");
      var newIndex = deck.getAttribute("selectedIndex");
      switch (state) {
        case "Register":
          setThrobberState(false);
          newIndex = 4; // register panel
          if  ((IsApp) && (!IsSidebar))  {
              top.title = aimString("app.title.Register");
              // top.document.getElementById("navigator-throbber").setAttribute("busy", "true");
              }
          break;
        case "Offline":
          setThrobberState(false);
          var fsttry = aimPrefsManager().GetBoolPref("aim.session.firsttry", null, true);
          if (!fsttry)       
            newIndex = 0;// sign-on panel

          if  ((IsApp) && (!IsSidebar))  {
              top.title = aimString("app.title.SignOn");
              UpdateMenuItemsForApp(state);
              }
          break;
        case "Online":
          if (aimBuddyManager().GetBLLoadingState())
            setThrobberState(true);
          else
            setThrobberState(false);
          newIndex = 3; // online panel
          if  ((IsApp) && (!IsSidebar))  {
            if (isIcq() == true) {
              top.title = aimString("app.title.Online_ICQ").replace(/%UserName%/, aimSessionCurrentScreenName());
            }
            else {
              top.title = aimString("app.title.Online").replace(/%UserName%/, aimSessionCurrentScreenName());
            }
            // top.document.getElementById("navigator-throbber").setAttribute("busy", "false");
            UpdateMenuItemsForApp(state);
            if (initialState == "Offline")
            {
              openAIMToday();
              initialState="Online";
            }
          }
          if (isIcq() == true)
          {
            document.getElementById("ListSetup").setAttribute("context", "icqcontext");
            document.getElementById("OnlineBuddies").setAttribute("context", "icqcontext");
          }
          else
          {
            document.getElementById("ListSetup").setAttribute("context", "context");
            document.getElementById("OnlineBuddies").setAttribute("context", "context");
          }
          break;
        case "OnlineAway":
          setThrobberState(false);
          newIndex = 2; // away panel
          if  ((IsApp) && (!IsSidebar))
            top.title = aimString("app.title.OnlineAway");
          break;
        case "Connecting":
        case "Requesting":
        case "Negotiating":
        case "Validating":
        case "Transferring":
        case "Starting":
          setThrobberState(true);
          newIndex = 1; // connecting panel
          if  ((IsApp) && (!IsSidebar))
            top.title = aimString("app.title.Connecting");
          newIndex = 1;
      }
      deck.setAttribute("selectedIndex", newIndex);
      
			if (state != "Offline" && state != "Online" && state != "Register" && state != "OnlineAway")
			{
        var str = aimString("btnSignOnProgress." + state);
				document.getElementById("btnSignOnProgress").setAttribute("value", str);
				var theProgressBar = document.getElementById("spconnectingprogressbar001");
				theProgressBar.setAttribute("value",parseInt(theProgressBar.getAttribute("value"))+15)
			}
      
			if(state == "Online" || state == "OnlineAway")
			{
					aimMigrateBuddyList( aimSessionCurrentScreenName() );
			}
      
			// If returning to offline state, reinitialize the signon screen fields,
			// which appear to be cleared out when they are hidden. We also do this
			// when the form is loaded.
			if (state == "Offline") {
				progress = window.document.getElementById("spconnectingprogressbar001");
          			if ( progress && progress != undefined )
          				progress.setAttribute("value", "0");
				InitFieldsFromPrefs(true, null);
        initialState="Offline";
        //this call is to delete all our datasources during signoff. Timeout is used coz the Signon panel
        //must be loaded before we call this function. Without timeout, this function is called before the signon panel
        //is loaded and it takes few seconds to see the panel :( 
        setTimeout('removeAllBuddyGroups()', 500);
        
			}
      
			if (state == "Online") { 
			    AimSidebarPanelSetAwayMsgBtn();    
          UpdateUserWarning(null);
          UpdateAuthAwaitGroup();
          setTimeout('SelectIndex(0)', 2000);

          }
      
		}
   
   if(property.EqualsNode(aimRDFWarningStatus())) {
      var st = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
      UpdateUserWarning(st);
   }
    
	}
};

OnlineObserver.onUnassert = function(datasource, source, property, target)
{
	// XXX Do we need to remove the attribute here ???
};
	
OnlineObserver.onChange = function(datasource, source, property, oldTarget, newTarget)
{
	OnlineObserver.onAssert(datasource, source, property, newTarget);
};
	
OnlineObserver.onMove = function(datasource, oldSource, newSource, property, target)
{
	OnlineObserver.onAssert(datasource, newSource, property, target);
};

OnlineObserver.beginUpdateBatch = function(datasource)
{
};

OnlineObserver.endUpdateBatch = function(datasource)
{
};

/**************** Command Handlers ******************/

function cmdPanelSignOn() 
{
	SaveFieldsToPrefs();

	var screenName = document.getElementById('fldScreenName').value;
	var password = document.getElementById('fldPassword').value;

    var curConnName = document.getElementById("sessionTypeListmenu").label;

    if (!IsServiceCorrect(screenName, curConnName)) {
       return;  
    }

  setConnectionInfo (curConnName, "im", screenName);
	aimSessionLogin(screenName, password);
  	
}





/************* key/focus handlers *************/

// function cmdScreenName(event)
// handles key events from screenname field
// id="fldScreenName shift-tabbing goes to id="sessionTypeListmenu"
// id="fldScreenName" tabbing goes to id="fldPassword"

function cmdScreenName(event) {
   var prevTabOrderElement = "sessionTypeListmenu";
   var nextTabOrderElement = "fldPassword";
   
  if ((event.keyCode == 9) && (event.shiftKey)) 
    {
      document.getElementById(prevTabOrderElement).focus();
      document.getElementById(prevTabOrderElement).setAttribute("focus-ring", "true");
      event.preventDefault();
      return;
    }
  
	var screenName = document.getElementById('fldScreenName').value;
  try {
	    var password = "";
      try {
		password = aimSessionGetPassword(screenName);
	    } catch (e) {}
		document.getElementById('fldPassword').value = password; 
		document.getElementById('fldPassword').setAttribute("value",password);
	} catch (e) {dump("exception\n");}
  EnableInputs();
  InitFieldsFromPrefs(false, screenName);

  // if the user types in screenname and if find the password from pref, enable the send button.
  if ((password.length != 0) && (screenName.length != 0))
    enableSignOnButton(true);
  else
    enableSignOnButton(false);
  // ..so.. if the user enters username and password is filled from prefs, then on enter key sign on.
  if ((event.keyCode == 13) && (password.length != 0) && (screenName.length != 0))
    cmdPanelSignOn();

  // if the user presses Enter and password field is empty, put the focus in password field.
  if ((event.keyCode == 13) && (password.length == 0))
    document.getElementById(nextTabOrderElement).focus();
}

function cmdPasswordKeyup(event) {
	// Enabled state of savePassword checkbox depends on
	// empty/non-empty password field
  EnableInputs();
  InitFieldsFromPrefs(false, null);
  var password = document.getElementById('fldPassword').value;
  if (password.length > 0){
    enableSignOnButton(true);
    }
  else{
    enableSignOnButton(false);
    }
if (event.keyCode == 13 && password.length > 0){
   event.preventDefault();
   cmdPanelSignOn();
   }
}


/*
 * Function: setFocusPassLink (event)
 *
 * Arguments: 
 *      event -- key event passed from SpSignOnOrgoverlay
 *
 * Return: None
 *
 * Description: This function intervenes the default focus propagation and sets focus 
 * to the forgot password link to make it accessible. When user hits tab from the Signon button, the focus
 * goes to forgot  password link. Tab from here, goes to screen name field and cycles as before.
 *
 */

function setFocusPassLink(event) {
   var currTabOrderElement = "spsignonSignOn2";
   var nextTabOrderElement = "spsignonpasslink";

  if (event.shiftKey) {
    //go to previous element - either the sign on button or the help button
    document.getElementById(currTabOrderElement).removeAttribute("focus-ring");
    return;
   }
  event.preventDefault();
  document.getElementById(currTabOrderElement).removeAttribute("focus-ring");
  document.getElementById(nextTabOrderElement).focus();
  document.getElementById(nextTabOrderElement).setAttribute("focus-ring", "true");  
  
}

/*
 * Function: unsetFocusPassLink (event)
 *
 * Arguments: 
 *      event -- key event passed from SpSignOnOrgoverlay
 *
 * Return: None
 *
 * Description: This function is called on the onkeypress handler on the password link label.
 * If shift-tab is pressed, it puts focus on the Signon button (provided password field is not empty).
 * If just tab is entered, then focus is put on the Screen name field by rotating focus in clockwise 
 * direction.
 *
 */

function unsetFocusPassLink(event) {
   var prevTabOrderElement = "spsignonSignOn2";
   var currTabOrderElement = "spsignonpasslink";
   var nextTabOrderElement = "spregisterpasslink";

  if (event.shiftKey) {
    // Shift tab should rotate focus in anti clockwise direction. In this case focus to sign on button
    var password = document.getElementById('fldPassword').value;
    if (password.length == 0) 
        // Do not put focus in sign on button is passfield field was empty - since user can use the button
        return;
    event.preventDefault();
    document.getElementById(prevTabOrderElement).focus();
    document.getElementById(prevTabOrderElement).setAttribute("focus-ring", "true");
  }
  document.getElementById(currTabOrderElement).removeAttribute('focus-ring');
}

/*
 * Function: setFocusRegisterLink (event)
 *
 * Arguments: 
 *      event -- key event passed from SpSignOnOrgoverlay
 *
 * Return: None
 *
 * Description: This function intervenes the default focus propagation and sets focus 
 * to the register user link to make it accessible. When user hits tab from the forgot password link, the focus
 * goes to register link. Tab from here, goes to screen name field and cycles as before.
 *
 */

function setFocusRegisterLink(event) {
   var prevTabOrderElement = "spsignonSignOn2";
   var currTabOrderElement = "spsignonpasslink";
   var nextTabOrderElement = "spregisterpasslink";

  if (event.shiftKey) {
    document.getElementById(currTabOrderElement).removeAttribute("focus-ring");
    document.getElementById(currTabOrderElement).blur();
    return;
   }
  event.preventDefault();
  document.getElementById(currTabOrderElement).removeAttribute("focus-ring");
  document.getElementById(currTabOrderElement).blur();
  document.getElementById(nextTabOrderElement).focus();
  document.getElementById(nextTabOrderElement).setAttribute("focus-ring", "true");  
  
}

/*
 * Function: unsetFocusRegisterLink (event)
 *
 * Arguments: 
 *      event -- key event passed from SpSignOnOrgoverlay
 *
 * Return: None
 *
 * Description: This function is called on the onkeypress handler on the register user link label.
 * If shift-tab is pressed, it puts focus on the forgot password link.
 * If just tab is entered, then focus is put on the Screen name field by rotating focus in clockwise 
 * direction.
 *
 */

function unsetFocusRegisterLink(event) {
   var prevTabOrderElement = "spsignonpasslink";
   var currTabOrderElement = "spregisterpasslink";
   //var nextTabOrderElement = "sessionTypeListmenu";
   if (event.shiftKey) {
     event.preventDefault();
     document.getElementById(prevTabOrderElement).focus();
     document.getElementById(prevTabOrderElement).setAttribute("focus-ring", "true");
   }
   document.getElementById(currTabOrderElement).removeAttribute('focus-ring');
   document.getElementById(currTabOrderElement).blur();
}


function setFocusSignOnButton(event){
   var currTabOrderElement = "spsignonHelp2";
   var nextTabOrderElement = "spsignonSignOn2";
   if(event.shiftKey){
      return;
   }
   if(document.getElementById(nextTabOrderElement).getAttribute("disabled") == "true"){
      setFocusPassLink(event);
   }else{
     return;
   }


}



  /*
  * Name: enableSignOnButton
  *
  * Arguments: flag. 
  *
  * Description:
  *
  * This function enables or disables the signon button based on the flag.
  *    true = enables the button
  *    false = disables the button
  *
  * Return Value: none
  *
  * Author: Suresh Kasinathan<suresh@netscape.com> 8/20/01
  *
  */

function enableSignOnButton(flag) {
  var signOnButton = document.getElementById('spsignonSignOn2');
  if (signOnButton) {
    if (flag)
      signOnButton.setAttribute("disabled", "false");
    else
      signOnButton.setAttribute("disabled", "true");
  }
}

function cmdClickSavePassword() {
    if (!document.getElementById('chkSavePassword').checked)
	    aimPrefsManager().SetBoolPref("aim.session.storepassword", false, null, false);
	// Enabled state of autoLogin checkbox depends on
	// state of savePassword checkbox
  EnableInputs();
  // Save fields so that icq/aim switcher will pick up the checkbox pref.
  SaveFieldsToPrefs();
}

function cmdClickAutoLogin() {
}

function cmdRegisterScreenName() {
	var screenName = document.getElementById('fldRegisterName').value;

	if (screenName == '') {
		aimErrorBox(aimString("msg.NoScreenName"));
		return;
	}
  
  // this will call into nsIAimSession, save the screen name in prefs and
  // notify our observers to go from the register panel to the signon panel
  aimSessionRegister(screenName);

	document.getElementById('fldScreenName').value = screenName;
}

function cmdDoubleClick(event)
{
  if (event.button != 0) return;
  var target = event.originalTarget;
  if (event.detail == 2 && target.localName == "treechildren") {
    var row = new Object;
    var colID = new Object;
    var childElt = new Object;

    var tree = getSelectedTreeName();
    var col = getSelectedTabName();
    if (!tree || !col) return;
    tree.boxObject.QueryInterface(Components.interfaces.nsITreeBoxObject).getCellAt(event.clientX, event.clientY, row, colID, childElt);

    if (row.value == -1)
      return;

    var view = tree.treeBoxObject.view;
    var level = view.getLevel(row.value);
    if (level == 0)
      return;
    var colvalue = document.getElementById(colID.value);
    if (colvalue && colvalue.getAttribute("cycler") != "true" && (childElt.value != "twisty"))
      cmdNewIM();
  }
}

function cmdFocus(event)
	{
	dump('focus: ' + event.target.tagName + '\n');
	}
function cmdBlur(event)
	{
	dump('blur: ' + event.target.tagName + '\n');
	}
function cmdGroupKeyUp(event)
	{
	if (event.keyCode == 13)
		{
		var item = event.target.parentNode.parentNode.parentNode;
		var name = item.getAttribute('Name');
		var newName = event.target.value;

		aimBuddyRenameBuddyGroup(name, newName);
		}
	}
function cmdBuddyKeyUp(event)
	{
	if (event.keyCode == 13)
		{
		var item = event.target.parentNode.parentNode.parentNode;
		var screenName = item.getAttribute('ScreenName');
		var newName = event.target.value;

		var groupItem = item.parentNode.parentNode;
		var groupName = groupItem.getAttribute('Name');

		var nextBuddy = null;
		if (item.nextSibling)
			nextBuddy = item.nextSibling.getAttribute('ScreenName');

		// XXX aimBuddyReplaceBuddy(groupName, screenName, newName);
		aimBuddyRemoveBuddy(groupName, screenName);
		aimBuddyAddBuddy(groupName, newName, nextBuddy);
		}
	}
function spInPlaceAddBuddy()
	{
	  spInPlaceAddDelete( "AddBuddy" );
	}
function spAddBuddy()
	{
	val = prompt( "Enter Buddy Name","" );
	}
function spAddGroup()
	{
	val = prompt( "Enter Group Name", "" );
	}
function spInPlaceAddGroup()
	{
		spInPlaceAddDelete( "AddGroup" );
	}
function spInPlaceDelete()
	{
	  spInPlaceAddDelete( "Delete" );
	}

function spInPlaceAddDelete( what )	// "Delete", "AddGroup", "AddBuddy"
	{
	// Locate selection in setup list
	// XXX There must be a better way to do this
	var selectedGroup = null;
	var selectedBuddy = null;
	var tree = document.getElementById("ListSetup");
	var groups = tree.childNodes[2].childNodes;
	for (var i = 0; i != groups.length; i++)
		{
		if (groups[i].getAttribute("selected") == "true")
			{
			selectedGroup = groups[i].getAttribute("Name");
			break;
			}

		var buddies = null;
		for (var j = 0; j != groups[i].childNodes.length; j++)
			{
			if (groups[i].childNodes[j].nodeName == "treechildren")
				{
				buddies = groups[i].childNodes[j].childNodes;
				break;
				}
			}

		if (buddies)
			{
			for (var j = 0; j != buddies.length; j++)
				{
				if (buddies[j].getAttribute("selected") == "true")
					{
					selectedBuddy = buddies[j].getAttribute("ScreenName");
					break;
					}
				}

			if (selectedBuddy)
				{
				selectedGroup = groups[i].getAttribute("Name");
				break;
				}
			}
		}

	if (what == "AddBuddy")
		aimBuddyAddBuddy(selectedGroup, null, selectedBuddy);
	else if (what == "AddGroup")
		aimBuddyAddBuddyGroup(null, selectedGroup);
	else if (what == "Delete")
		{
		if (selectedBuddy)
			aimBuddyRemoveBuddy(selectedGroup, selectedBuddy);
		else if (selectedGroup)
			aimBuddyRemoveBuddyGroup(selectedGroup);
		}
	}

function spFindEmpty( display )	
{
	// Locate selection in setup list
	// XXX There must be a better way to do this
	var selectedGroup = null;
	var selectedBuddy = null;
	var tree = document.getElementById("ListSetup");
	var groups = tree.childNodes[2].childNodes;

	
	for (var i = 0; i != groups.length; i++)
	{
		var buddies = null;
		for (var j = 0; j != groups[i].childNodes.length; j++)
		{
			if (groups[i].childNodes[j].nodeName == "treechildren")
			{
				buddies = groups[i].childNodes[j].childNodes;
				break;
			}
		}

		if (buddies)
		{
			for (var j = 0; j != buddies.length; j++)
			{
				if (buddies[j].getAttribute("ScreenName") == "")
				{
					selectedBuddy = buddies[j];
					if ( display == "none" ) {
						selectedBuddy.setAttribute("style", "visibility: hidden;");
						selectedBuddy.setAttribute("Yabba", "Dabba;");
					}
					else {
						selectedBuddy.setAttribute("style", "visibility: visible;");
					}
				}
				if (buddies[j].getAttribute("type") == "text")
				{
					//dump( "Found an object that has a type of 'text'\n" );
				}
			}
		}
	}

	//dump('  selectedGroup: ' + selectedGroup + '\n');
	//dump('  selectedBuddy: ' + selectedBuddy + '\n');
}
/*
function displayFrontTab(tabObj)
{
	tabOne=document.getElementById('tabOnline');
	tabTwo=document.getElementById('tabSetup');
	tabOne.setAttribute("style","");
	tabTwo.setAttribute("style","");
	tabObj.setAttribute("style","");
}

*/

/*** setup chat callbacks for rendezvous ***/
/** start services **/
var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager);
var ChatManager = pIIMManager.QueryInterface(Components.interfaces.nsIAimChatManager);

/*** setup the chat call backs **/
 var ChatCallback = new Object();

 ChatCallback.OnRequestRoomComplete =  function(roomName,chatRoomObj){
  
  chatRoomObj.SetChatRoomCallback(ChatRoomCallback);

 top.chatRoomObj = chatRoomObj;
  window.setTimeout('top.chatRoomObj.Join()', 5000);
  window.setTimeout('top.chatRoomObj.Invite("vishy26aug", "Join this MAAN")', 10000);
  window.setTimeout('top.chatRoomObj.SendMessage("This is working!!")', 30000);
  window.setTimeout('top.chatRoomObj.SendWhisper("vishy26aug", "Private message for vishy26aug")', 30000);
 }


 ChatCallback.OnRequestRoomError =  function(roomName,errMsg){
 //dump("OnRequestRoomError: there was an error \n");

 }

/** setup the chat Room callbacks **/

 var ChatRoomCallback = new Object();

 ChatRoomCallback.OnJoined = function()
 {
  //dump("Yes I Joined\n");
 }

 ChatRoomCallback.OnUserJoined = function(screenName)
 {
  //dump( screenName + "joined the chat\n");
 }

 ChatRoomCallback.OnInfoUpdate = function()
 {
 }

 ChatRoomCallback.OnMessageReceived = function(screenName, language, message)
 {
  //dump (screenName + " SAYETH " + message + " IN " + language +"\n");
 }



var rendezvousCallback = new Object();

rendezvousCallback.OnProposalReceived = function (screenname, proposal)
{
    //dump ("got a proposal from " + screenname + "\n");

     //proposal.Accept();
     inviteArgsObj = {
     	inviteProposalScreenName: screenname, 
     	inviteProposalObj: proposal,
     	invitedScreenNames: '',
     	inviteToExistingWindow: false,
     	inviteMode: 'incomingchat'
     	}
     //dump('send proposal to dialog! \n;')
	window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj); 
	
     //dump("accepted the proposal");

     //ChatManager.RequestProposedRoom(ChatCallback, proposal);

 }
 
function setupChatRendezvous(){
	//dump("entering setupChatRendezvous 3\n");
	ChatManager.SetChatRendezvousCallback(rendezvousCallback)
	//dump("exiting setupChatRendezvous \n");
}


/***  end setup chat callbacks for rendezvous ***/

function cmdNewChatSidebar(invScreenName,invProposal,invScreenNames,toExistingWindow,invMode){

     inviteArgsObj = {
     	inviteProposalScreenName: invScreenName, 
     	inviteProposalObj: invProposal,
     	invitedScreenNames: getSelectedBuddiesFromList(), //invScreenNames, (getSelectedBuddiesFromList is in App.js)
     	inviteToExistingWindow: toExistingWindow,
     	inviteMode: invMode
     	}
     	
	window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj);
}

// Function to open a new window for password lookup
function openPassLink()
{
  var checkSession=document.getElementById("sessionWatcher").getAttribute('sessionMode'); 
  if (checkSession == "Aim") {
    passLink = aimString("aim.password.url");
    openTopWin(passLink);
    return;
  }
  else {
    passLink = aimString("icq.password.url");
    openTopWin(passLink);  
    }
  
}





/*
 * Function:  UpdateAuthAwaitGroup()
 *
 * Arguments: None
 *
 * Return: None
 *
 * 
 * Author: Prassanna 4/06/2002
 */

function UpdateAuthAwaitGroup()
{
  if (isIcq() == true) {
    // Session is ICQ. Show Auth Await Group.
    document.getElementById('AuthAwait1').setAttribute("hidden", "false");
    document.getElementById('AuthAwait2').setAttribute("hidden", "false");
  }
  else
  {
    // Session is AIM. Hide Auth Await Group.
    document.getElementById('AuthAwait1').setAttribute("hidden", "true");
    document.getElementById('AuthAwait2').setAttribute("hidden", "true");
  }
}

function UpdateUserWarning(warning)
{
  var name = document.getElementById("warnname");
  var warn = document.getElementById("warnamount");
  if (warning != null)
  {
    if (warning > 0)
    {
      warn.setAttribute("value", " " + warning + "%");
      name.setAttribute("class", "warned");
    }
    else
    {
      warn.setAttribute("value", "");
      name.setAttribute("class", "not-warned");
    }
    
    return
  }
  
  var curname=aimSessionCurrentScreenName();
 
  //document.getElementById("warnConnIcon").setAttribute("sessionType", aimPrefsManager().GetIntPref("aim.internal.intconnectiontype", null, true) );

  name.setAttribute("value",curname);
  
  var locateManager = aimLocateManager();
  var LocateCallbackObject = new Object();
  
  LocateCallbackObject.OnRequestUserInfoDefaultComplete = function(screenname, userobj)
  {
    var percent = userobj.GetWarningPercent();
    if (percent > 0 )
    {
      warn.setAttribute("value", " - " + percent + "%");
      name.setAttribute("class", "warned");
    }
    else
    {
      warn.setAttribute("value", "");
      name.setAttribute("class", "not-warned");
    }
  }

  LocateCallbackObject.OnRequestUserInfoDefaultError = function(screenname, error)
  {
    //nothing
  }
  
  if (navigator.platform != "MacPPC")
  {
    locateManager.RequestUserInfoDefault( LocateCallbackObject, curname);
  }
}


/*
 * Function: SetProcessTimer( interval )
 *
 * Arguments: 
 *      interval -- timeout in milliseconds 
 *
 * Return: None
 *
 * Description: This function sets the global (to App.js) timer 
 * processInviteTimer to fire after the specified interval
 *
 * Author: Syd 4/20/2001
 */

function SetProcessTimer( interval )
{
  processInviteTimer = setTimeout('ProcessInviteList()',interval);
}

/*
 * Function: ClearProcessTimer()
 *
 * Arguments: None
 *
 * Return: None
 *
 * Description: if the global processInviteTimer != -1, then
 * clear the timer, otherwise return. This function should 
 * be called by the onunload handler or at anytime the state
 * goes from online to offline
 *
 * Author: Syd 4/20/2001
 */

function ClearProcessTimer()
{
        if ( processInviteTimer != -1 ) {
                window.clearTimeout( processInviteTimer );
                processInviteTimer = -1;
        }
}



/*
 * Function: aimToday ()
 *
 * Arguments: None
 *
 * Return: None
 *
 * Description: This function launches the aimToday window.
 *
 */

function aimToday()
{
  var todayhide = aimPrefsManager().GetBoolPref("aim.internal.hidetoday", null, false);
  if (!todayhide)
  {
    var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
    var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
    var topWindow = windowManagerInterface.getMostRecentWindow( "mini:browser" );
    if ( topWindow )
    {
      topWindow.focus();
    }
    else
    {
      window.open("chrome://aim/content/mini.xul", "_blank", "chrome,extrachrome,menubar,resizable=no,status,toolbar");
    }
  }
}

function setFocusIfSignOnDisabled(event){
  if ((event.keyCode == 9) && (document.getElementById('spsignonSignOn2').getAttribute('disabled') == 'true')) {
    document.getElementById("spsignonHelp2").blur();
    setFocusPassLink(event)
  };
}


/*
 * Function: UpdateSessionImages(sessionType)
 *
 * Arguments: 
 *      sessionType -- "0" is Aim, "1" is TIH and "2" is Icq. Value passed from the Service selection 
 *                      pop-up menu.
 *
 * Return: None
 *
 * Description: This function sets the users choice of sessionType in the global pref. It also notifies all the observers
 * who are watching for the session-Mode changed message about the user's choice of service.
 *
 * Author: Prassanna 4/02/2002
 */

function UpdateSessionImages(sessionType)
{
  var session="";
  var connectionNameNode = document.getElementById('sessionTypeListmenu').selectedItem;
  var connectionName = connectionNameNode.getAttribute("label");
  aimPrefsManager().SetCharPref("aim.session.userconnectionname", connectionName, null, true);
  aimSession().SetAppIcon();
  var latestScreenNameOfType = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);

  switch (sessionType) {
        case "2": session="Icq";
                  latestScreenNameOfType = aimPrefsManager().GetCharPref("aim.session.latesticqscreenname",null, true);
                  //changeTitle("Contact List");
                  break;
        case "0": session="Aim";
                  latestScreenNameOfType = aimPrefsManager().GetCharPref("aim.session.latestaimscreenname",null, true);
                  //changeTitle("Buddy List");
                  break;   
  }

  /** start update sign on fields due to  sessionChange **/
  aimPrefsManager().SetCharPref("aim.session.screenname", latestScreenNameOfType, null, true);
  InitFieldsFromPrefs( true, latestScreenNameOfType)
  /** end update **/
   var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
  observerService.notifyObservers(null, "sessionMode-changed", session);
}



/*
 * Function: UpdateCurrentWindow(sessionName)
 *
 * Arguments: 
 *      sessionName -- "Aim" or "Icq". passed when the current pop label is set
 *
 * Return: None
 *
 * Description: This function is called on load of sidebar buddy list. It basically sets 
 * sessionMode attribute on the broadcaster element when the apropriate seesin label is being set. 
 * This is done so that the current window  and the elements reflect the current sessionName.
 *
 * Author: Prassanna 4/02/2002
 */

function UpdateCurrentWindow(sessionName)
{
  var session;
  var elems = document.getElementById("sessionWatcher");
  switch (sessionName) {
        case "ICQ": session="Icq";
                    elems.setAttribute("sessionMode", "Icq"); 
                    break;
        case "AIM": session="Aim";
                    elems.setAttribute("sessionMode", "Aim"); 
                    break;   
  }
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
  observerService.notifyObservers(null, "sessionMode-changed", session);
}



/*
 * Function: addSidebarSessionListener
 *
 * Arguments: None
 *
 * Return: None
 *
 * Description: This function is called on the load of sidebar buddylist panel. This adds a sessionSidebarObserver 
 * which waits for the sessionMode-changed message.
 *
 * Author: Prassanna 4/02/2002
 */

function addSidebarSessionListener() {
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService();
  observerService = observerService.QueryInterface(Components.interfaces.nsIObserverService);
  if (observerService) {
    observerService.addObserver(sessionSidebarObserver, "sessionMode-changed", false);
  } else {
    dump("failed to get observer service\n");
  }
}

/*
 * Function: removeSidebarSessionListener
 *
 * Arguments: None
 *
 * Return: None
 *
 * Description: This function is called on the Unload of sidebar buddylist panel. This removes the existing sessionSidebarObserver 
 * on the current sidebarpanel.
 *
 * Author: Prassanna 4/02/2002
 */

function removeSidebarSessionListener() {
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService();
  observerService = observerService.QueryInterface(Components.interfaces.nsIObserverService);
  if (observerService)
  {
  observerService.removeObserver(sessionSidebarObserver, "sessionMode-changed");
  }
}

/*
 * Function: UpdateSidebarLabels(sessionName)
 *
 * Arguments: sessionName - Passed from the listener. Aim/Icq
 *
 * Return: None
 *
 * Description: This function is called when the notifier receives sessionMode changed notification. It bruteforces all
 * the UI widgets to have the appropriate display labels and tooltips based on sessionName.
 *
 * Author: Prassanna 4/02/2002
 */


function UpdateSidebarLabels(sessionName)
{
  switch (sessionName) {
        case "Icq": var icqval=  document.getElementById('sessionTypeIcq').getAttribute("label");
                    document.getElementById('sessionTypeListmenu').setAttribute("label",icqval);
                    document.getElementById('sessionTypeListmenu').setAttribute("value","2");
                    icqval=document.getElementById('btnbuddyorgsendim').getAttribute("icqtooltip");
                    document.getElementById('btnbuddyorgsendim').setAttribute("tooltiptext", icqval);
                    //icqval=document.getElementById('tabOnline').getAttribute("icqlabel");
                    //document.getElementById('tabOnline').setAttribute("label", icqval);
                    //icqval=document.getElementById('tabSetup').getAttribute("icqlabel");
                    //document.getElementById('tabSetup').setAttribute("label", icqval);
                    icqval=document.getElementById('btnbuddyorgsignoff').getAttribute("icqlabel");
                    document.getElementById('btnbuddyorgsignoff').setAttribute("label", icqval);
                    icqval=document.getElementById('btnbuddyorgsignoff').getAttribute("icqtooltip");
                    document.getElementById('btnbuddyorgsignoff').setAttribute("tooltiptext", icqval);
                    icqval=document.getElementById('btnSignOnCancel').getAttribute("icqtooltip");
                    document.getElementById('btnSignOnCancel').setAttribute("tooltiptext", icqval); 
                    icqval=document.getElementById('snid').getAttribute("icqlabel");
                    document.getElementById('snid').setAttribute("value", icqval);   
                    icqval=document.getElementById('chkAutoLogin').getAttribute("icqlabel");
                    document.getElementById('chkAutoLogin').setAttribute("label", icqval);   
                    icqval=document.getElementById('spsignonHelp2').getAttribute("icqtooltip");
                    document.getElementById('spsignonHelp2').setAttribute("tooltiptext", icqval);
                    icqval=document.getElementById('spsignonSignOn2').getAttribute("icqlabel");
                    document.getElementById('spsignonSignOn2').setAttribute("label", icqval);   
                    icqval=document.getElementById('spsignonSignOn2').getAttribute("icqtooltip");
                    document.getElementById('spsignonSignOn2').setAttribute("tooltiptext", icqval);
                    icqval=document.getElementById('spregisterpasslink').getAttribute("icqlabel");
                    document.getElementById('spregisterpasslink').setAttribute("value", icqval);   
                    icqval=document.getElementById('spregisterpasslink').getAttribute("icqtooltip");
                    document.getElementById('spregisterpasslink').setAttribute("tooltiptext", icqval);
                    icqval=document.getElementById('btnsetuporgbuddy').getAttribute("icqtooltip");
                    document.getElementById('btnsetuporgbuddy').setAttribute("tooltiptext", icqval);
                    icqval=document.getElementById('btnsetuporgdelete').getAttribute("icqtooltip");
                    document.getElementById('btnsetuporgdelete').setAttribute("tooltiptext", icqval);
                    icqval=document.getElementById('btnImBack').getAttribute("icqlabel");
                    document.getElementById('btnImBack').setAttribute("label", icqval);
                    var sidebarimpanel = top.document.getElementById('urn:sidebar:panel:im-panel');
                    if (sidebarimpanel)
                      sidebarimpanel.setAttribute("label", aimString("icq.sidebarTitle"));
                    break;
        case "Aim": var aimval=  document.getElementById('sessionTypeAim').getAttribute("label");
                    document.getElementById('sessionTypeListmenu').setAttribute("label",aimval);
                    document.getElementById('sessionTypeListmenu').setAttribute("value","0");
                    aimval=document.getElementById('btnbuddyorgsendim').getAttribute("imtooltip");
                    document.getElementById('btnbuddyorgsendim').setAttribute("tooltiptext", aimval);
                    //aimval=document.getElementById('tabOnline').getAttribute("imlabel");
                    //document.getElementById('tabOnline').setAttribute("label", aimval);
                    //aimval=document.getElementById('tabSetup').getAttribute("imlabel");
                    //document.getElementById('tabSetup').setAttribute("label", aimval);
                    aimval=document.getElementById('btnbuddyorgsignoff').getAttribute("imlabel");
                    document.getElementById('btnbuddyorgsignoff').setAttribute("label", aimval);
                    aimval=document.getElementById('btnbuddyorgsignoff').getAttribute("imtooltip");
                    document.getElementById('btnbuddyorgsignoff').setAttribute("tooltiptext", aimval);
                    aimval=document.getElementById('btnSignOnCancel').getAttribute("imtooltip");
                    document.getElementById('btnSignOnCancel').setAttribute("tooltiptext", aimval); 
                    aimval=document.getElementById('snid').getAttribute("imlabel");
                    document.getElementById('snid').setAttribute("value", aimval);   
                    aimval=document.getElementById('chkAutoLogin').getAttribute("imlabel");
                    document.getElementById('chkAutoLogin').setAttribute("label", aimval);   
                    aimval=document.getElementById('spsignonHelp2').getAttribute("imtooltip");
                    document.getElementById('spsignonHelp2').setAttribute("tooltiptext", aimval);
                    aimval=document.getElementById('spsignonSignOn2').getAttribute("imlabel");
                    document.getElementById('spsignonSignOn2').setAttribute("label", aimval);   
                    aimval=document.getElementById('spsignonSignOn2').getAttribute("imtooltip");
                    document.getElementById('spsignonSignOn2').setAttribute("tooltiptext", aimval);
                    aimval=document.getElementById('spregisterpasslink').getAttribute("imlabel");
                    document.getElementById('spregisterpasslink').setAttribute("value", aimval);   
                    aimval=document.getElementById('spregisterpasslink').getAttribute("imtooltip");
                    document.getElementById('spregisterpasslink').setAttribute("tooltiptext", aimval);
                    aimval=document.getElementById('btnsetuporgbuddy').getAttribute("imtooltip");
                    document.getElementById('btnsetuporgbuddy').setAttribute("tooltiptext", aimval);
                    aimval=document.getElementById('btnsetuporgdelete').getAttribute("imtooltip");
                    document.getElementById('btnsetuporgdelete').setAttribute("tooltiptext", aimval);
                    aimval=document.getElementById('btnImBack').getAttribute("imlabel");
                    document.getElementById('btnImBack').setAttribute("label", aimval);
                    var sidebarimpanel = top.document.getElementById('urn:sidebar:panel:im-panel');
                    if (sidebarimpanel)
                      sidebarimpanel.setAttribute("label", aimString("importexport.budlist"));
                    break;   
  }
  
}


/*
 * Function: observe
 *
 * Arguments: message - "sessionMode-changed"
 *              data - "Aim/Icq"
 *              passed by the notifier 
 *
 * Return: None
 *
 * Description: This function updates the sessionWatcher broadcaster with the passes sessionMode. It forces the css
 * to apply the image rules based on sessionMode attribute. It also  calls the UpsideSidebarLabels with the sessionMode
 * so that all the labels and tooltips are updated based on the sessionMode.
 *
 * Author: Prassanna 4/02/2002
 */

var sessionSidebarObserver = {
  observe: function(subject, message, data) {
  if (message == 'sessionMode-changed')  {
     // Update sessionMode attribute which updates all images thru css
     document.getElementById("sessionWatcher").setAttribute("sessionMode", data);
    // Update all strings and labels to workaround un-dynamic dtd:-(
     UpdateSidebarLabels(data);
     }
  }
}


/*
 * Function: getDs()
 *
 * Arguments: None
 *
 * Return: sidebar panel datasource
 *
 * Description: This function is called by the changeTitle function to obtain the sidebar datasource.
 *
 * Author: Prassanna 4/02/2002
 */

function getDs()
{
  var PANELS_RDF_FILE = "UPnls";
  try 
  {
    var locator_service = Components.classes["@mozilla.org/file/directory_service;1"].getService();
    if (locator_service)
      locator_service = locator_service.QueryInterface(Components.interfaces.nsIProperties);
	  var sidebar_file = locator_service.get(PANELS_RDF_FILE, Components.interfaces.nsIFile);
    if (!sidebar_file.exists()) {
      //Sidebar panels file does not exist?
      return;
    }
		var file_url = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIFileURL);
		file_url.file = sidebar_file;
	  return file_url.spec;
  } catch (ex) {
     throw(ex);
  }
}

/*
 * Function:  changeTitle(title)
 *
 * Arguments: title - the title for the instant messenger sidebarpanel  "BuddyList"/"ContactList"
 *
 * Return: None
 *
 * Description: This function is during UpdateSidebarLabels upon notification of session Change. This attempts to
 * change the title of the instant messenger sidebar panel  basedon user's service choice Aim/Icq
 *
 * Author: Prassanna 4/02/2002
 */


function changeTitle(title)
{

  var RDF = aimRDF();
  const NC = "http://home.netscape.com/NC-rdf#";
  var panels = window.parent.document.getElementById("sidebar-panels");
  var datasource = RDF.GetDataSource(getDs());
  //var datasource = panels.database;

  var persistNode = datasource.GetTarget(RDF.GetResource("urn:sidebar:panel:im-panel"),  RDF.GetResource(NC + "title"),true);
  if (persistNode)
  {
    datasource.Change(RDF.GetResource("urn:sidebar:panel:im-panel"),
                                    RDF.GetResource(NC + "title"), 
                                    persistNode,
                                    RDF.GetLiteral(title));
    
/*
    panels.setAttribute('ref', "urn:sidebar:current-panel-list");
    panels.setAttribute('last-selected-panel', "urn:sidebar:panel:im-panel");
    SidebarRebuild();
    for (var ii=2; ii < panels.childNodes.length; ii += 2) {
          var header = panels.childNodes.item(ii);
          var content = this.node.childNodes.item(ii+1);
          if (header.getAttribute('id') == "urn:sidebar:panel:im-panel") {
               header.setAttribute('selected', 'true');
               content.removeAttribute('hidden');
               content.removeAttribute('collapsed');
               header.reload();
         break;
        }
    }

// After setting the current panel disappears from view :-( Have to reload maunally. Commenting for now
  datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
  datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Refresh(true);
*/
  }
	
                   
}


/*
 * Function: addSidebarBuddyListObserver
 *
 * Arguments: None
 *
 * Return: None
 *
 * Description: This function is called on the load of sidebar buddylist panel. This adds a sidebarBuddyListObserver 
 * which get notified when the Buddy List is loaded.
 *
 * Author: Suresh
 */

function addSidebarBuddyListObserver() {
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService();
  observerService = observerService.QueryInterface(Components.interfaces.nsIObserverService);
  if (observerService)
    observerService.addObserver(sidebarBuddyListObserver, "buddyListLoaded", false);
}

/*
 * Function: removeSidebarBuddyListObserver
 *
 * Arguments: None
 *
 * Return: None
 *
 * Description: This function is called on the Unload of sidebar buddylist panel. This removes the existing buddy list observer 
 * on the current sidebarpanel.
 *
 * Author: Suresh
*/

function removeSidebarBuddyListObserver() {
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService();
  observerService = observerService.QueryInterface(Components.interfaces.nsIObserverService);
  if (observerService)
    observerService.removeObserver(sidebarBuddyListObserver, "buddyListLoaded");
}

var sidebarBuddyListObserver = {
  observe: function(subject, message, data) {
    if (message == 'buddyListLoaded')  {
      SelectIndex(0);
      setThrobberState(false);
      //if (!isIcq()) {
        //openAIMToday();
      //}
    }
  }
}

function openAIMToday()
{
  var aimTodaypref = aimPrefsManager().GetBoolPref("aim.general.today", null, false);
  if (aimTodaypref) {
    var navigatorWindow;
    var possibleNavigator = top.document.getElementById("main-window");
    if (possibleNavigator && possibleNavigator.getAttribute("windowtype") == "navigator:browser")
      navigatorWindow = top;

    const WMEDIATOR_CONTRACTID     = "@mozilla.org/appshell/window-mediator;1";
    const nsIWindowMediator        = Components.interfaces.nsIWindowMediator;
    // if not, get the most recently used browser window
    if (!navigatorWindow) {
      var wm = Components.classes[WMEDIATOR_CONTRACTID].getService(nsIWindowMediator);
      navigatorWindow = wm.getMostRecentWindow("navigator:browser");
    }

    // if no browser window available open the mini browser
    if (!navigatorWindow)
      aimToday();

  }  

}


function setThrobberState(state)
{
  if ((IsApp) && (!IsSidebar)) {
    if (state)
      top.document.getElementById("navigator-throbber").setAttribute("busy", "true");
    else
      top.document.getElementById("navigator-throbber").setAttribute("busy", "false");
  }
}

function SwitchView(resource)
{
  if (!resource)
    return;
  var aimsession = aimSession();
  var aimPrefs = aimPrefsManager();
  if (resource == "ScreenNameWithStatus") {
    aimPrefs.SetIntPref("aim.session.buddyview", 0, null, false);
    aimsession.SetSessionBuddyListView(Components.interfaces.nsAimBuddyListViews.ScreenName);
  }
  else { 
    if (resource == "DisplayName") {
      aimPrefs.SetIntPref("aim.session.buddyview", 1, null, false);
      aimsession.SetSessionBuddyListView(Components.interfaces.nsAimBuddyListViews.DisplayName);
    }
  }

  var rdf = aimRDF();
  var res = rdf.GetResource("http://home.netscape.com/NC-rdf#" + resource);
  var aimbuddy = aimBuddyManager();
  aimbuddy.SwitchView(res);
}

function cmdDispName() {
  var ascreenName = getSelectedScreenName();
  if (!ascreenName) {
    aimErrorBox(aimString("msg.selBuddy"));
    return;
  }
  window.openDialog('chrome://aim/content/AimDisplayName.xul','_blank','chrome,titlebar,dialog=yes,centerscreen,modal=yes', ascreenName);
}

