var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager)
var lastRadio = null;
var lastViewRadio = null;
var allEnums = Components.interfaces.nsAimPrivacyModes;
var stateEnums = Components.interfaces.nsAimOnlineStates;
var globalPrivacyObject = pIIMManager.QueryInterface(Components.interfaces.nsIAimPrivacy);
var MozPreferences = Components.classes['@mozilla.org/preferences-service;1'];
MozPreferences = MozPreferences.getService();
MozPreferences = MozPreferences.QueryInterface(Components.interfaces.nsIPrefBranch);


//connection panel
var connLinks = new Object();
connLinks.ConnectionName = "";
connLinks.SessionType    = "";
connLinks.Host           = "";
connLinks.Port           = "";
connLinks.ProxyHost      = "";
connLinks.ProxyPort      = "";
connLinks.ProxyUser      = "";
connLinks.ProxyPassword  = "";
connLinks.ProxyProtocol  = "";
connLinks.IsProxy        = false;
connLinks.ConnectionType = 0;

//end connection panel


function getString(name)
{
	if (aimStringBundle())
                return aimStringBundle().GetStringFromName(name);
        else	
		return "";
}

function EditAwayMessageOnLoad()
{
	var nameItem = document.getElementById("awayMessageName");
	var textItem = document.getElementById("awayMessageText");

	nameItem.value = window.arguments[1];
	textItem.value = window.arguments[2];
	nameItem.focus();


	// set the OK, Cancel callbacks

	if ( nameItem.value == "" ) 
		doSetOKCancel(AddAwayMessageOnOK, 0);
	else	
		doSetOKCancel(EditAwayMessageOnOK, 0);
}

function PrefIcqAwayOnLoad()
{
  if( (false == IsSignedOn()) || (false == isIcq())) {
  	DisableIcqAwayUI();
		aimErrorBox(aimString("icqaway.entermsg"));
    parent.hPrefWindow.registerOKCallbackFunc( DiscardAwayChanges );
  	}
}

function PrefIcqStyleOnload()
{
  var textData = document.getElementById("textColorData");
  var backgroundData = document.getElementById("backgroundColorData");
  var customTextColor = textData.getAttribute("value");
  var customBackgroundColor = backgroundData.getAttribute("value");

  if ( !customBackgroundColor || customBackgroundColor == "")
    customBackgroundColor = "#FFFFFF";
  if ( !customTextColor || customTextColor == "")
    customTextColor = "#000000";
  setColorWell("textCW", customTextColor);
  setColorWell("backgroundCW", customBackgroundColor);

  textData.setAttribute("value", customTextColor); 
  backgroundData.setAttribute("value", customBackgroundColor); 

  SwapSpecialStyles();
}

function SwapSpecialStyles()
{
  if (document.getElementById("textstyles").getAttribute("value") == "1")
  {
    document.getElementById("bold").setAttribute("disabled", "false");
    document.getElementById("italics").setAttribute("disabled", "false");
    document.getElementById("underline").setAttribute("disabled", "false");
  }
  else
  {
    document.getElementById("bold").setAttribute("disabled","true");
    document.getElementById("italics").setAttribute("disabled", "true");
    document.getElementById("underline").setAttribute("disabled", "true");
  }
}

function GetColorAndUpdate(ColorWellID)
{
  var colorObj = new Object;
  var colorWell = document.getElementById(ColorWellID);
  var customTextColor = document.getElementById("textColorData").getAttribute("value"); 
  var customBackgroundColor = document.getElementById("backgroundColorData").getAttribute("value"); 
  if (!colorWell) return;

  colorObj.NoDefault = true;

  switch( ColorWellID )
  {
    case "textCW":
      colorObj.Type = "Text";
      colorObj.TextColor = customTextColor;
      break;
    case "backgroundCW":
      colorObj.Type = "Page";
      colorObj.PageColor = customBackgroundColor;
      break;
  }

  window.openDialog("chrome://editor/content/EdColorPicker.xul", "_blank", "chrome,close,titlebar,modal", "", colorObj);

  if (colorObj.Cancel)
    return;

  var color = "";
  switch( ColorWellID )
  {
    case "textCW":
      color = customTextColor = colorObj.TextColor;
      document.getElementById("textColorData").setAttribute("value", color); 
      break;
    case "backgroundCW":
      color = customBackgroundColor = colorObj.BackgroundColor;
      document.getElementById("backgroundColorData").setAttribute("value", color);
      break;
  }
  setColorWell(ColorWellID, color); 
}


function GetUserAdd()
{
  var fldUserName = top.document.getElementById("fldUserName");
	var pIAimPrivacy = aimPrivacy();
  var name = fldUserName.value;
  if ( name && name != "" ) {
		if ( top.addMode == "Allow" ) {
			pIAimPrivacy.AllowListAdd( name );
		}
		else if ( top.addMode == "Deny" ) {
			pIAimPrivacy.DenyListAdd( name );
		}
		top.opener.updateListBoxSelection(top.addMode);
		top.window.close();
 }
}

function updateListBoxSelection(mode){
   var targetListBox = document.getElementById(mode);
   var targetListBoxSelectedCount = targetListBox.selectedCount
   var targetListBoxRows = targetListBox.listBoxObject.getRowCount();
   if(targetListBoxRows >0 && targetListBoxSelectedCount <1){
      targetListBox.selectedIndex=0;
   }
}



function StandardURL(s) {
    var clazz = Components.classes["@mozilla.org/network/standard-url;1"];
    var iface = Components.interfaces.nsIURL;
    var obj = clazz.createInstance(iface);
    obj.spec = s;
    return obj;
} 


function Sound() {
    var clazz = Components.classes["@mozilla.org/sound;1"];
    var iface = Components.interfaces.nsISound;
    var obj = clazz.createInstance(iface);
    return obj;
}

function PlaySound( myURIPref )
{
	var sound = new Sound();
	var myURI;

	try {
		myURI = aimPrefsManager().GetCharPref( myURIPref , null, false );
	}
	catch(e) {
		try {
			myURI = aimPrefsManager().GetCharPref( myURIPref , null, true); // get the global one if the per screen name doesnt work
  }
		catch(e) {
			return;
		} 		
	}		

	var uri = new StandardURL(myURI);
	if ( sound != undefined && sound != null && uri != undefined && uri != null ) {
		try {
			sound.play( uri );
		}
		catch( e ) {
			// device may not support sound, so ignore
		}
	}	
}

/* away messages */

var datasource = null;
var RDF = null;
var awayMessages = null;

function
GetRDFService()
{
	if ( RDF == null ) {
		RDF=aimRDF();
	}
}

function
RemoveTarget( msgName )
{
	GetRDFService();

	var messages_file = GetRdfFileUrl("default-messages-icq.rdf", "icqdm.rdf");  
	var datasource = RDF.GetDataSource(messages_file);

	var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:ICQ/AwayMessageBag"));

	var elements = container.GetElements();
	var target, node;
	var nameResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName");
	while ( elements.hasMoreElements() ) {
		node = elements.getNext();
		if ( node ) 
			target = datasource.GetTarget( node, nameResource, 
				true );
		if ( target ) 
			target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
		if ( target && target.Value == msgName ) {
			container.RemoveElement( node, true );
			datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
		}
	}
	return null;
}

function
SetAwayMessageTarget( msgName, msgText )
{
	GetRDFService();

	var messages_file = GetRdfFileUrl("default-messages-icq.rdf", "icqdm.rdf");  
	var datasource = RDF.GetDataSource(messages_file);

	var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:ICQ/AwayMessageBag"));

	var elements = container.GetElements();
	var nametarget, texttarget, node;
	var nameResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName");
	var textResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgText");
	while ( elements.hasMoreElements() ) {
		node = elements.getNext();
		if ( node ) 
			nametarget = datasource.GetTarget( node, nameResource, 
				true );
		if ( nametarget ) 
			nametarget = nametarget.QueryInterface(Components.interfaces.nsIRDFLiteral);
		if ( nametarget && nametarget.Value == msgName ) {
			texttarget = datasource.GetTarget( node, textResource, 
				true );
			if ( texttarget ) 
				texttarget = texttarget.QueryInterface(Components.interfaces.nsIRDFLiteral);
			if ( texttarget ) {
				var newText = RDF.GetLiteral(msgText);
				datasource.Change( node, textResource,
					texttarget, newText);
				datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
			}
			break;
		}
	}
}

function modeToRadio(mode)
{

	switch(mode) {
	case allEnums.AllowAll:
	dump ("allEnums.AllowAll\n" );
	    return document.getElementById("icq_privacy_contact_allowallusers"); 
	    break;
	case allEnums.AllowBuddies:
	dump ("allEnums.AllowBuddies\n" );
	    return document.getElementById("icq_privacy_contact_allowbuddylistusers"); 
	    break;
	case allEnums.AllowList:
	dump ("allEnums.AllowOnlyList\n" );
	    return document.getElementById("icq_privacy_contact_allowonlylist"); 
	    break;
	case allEnums.DenyAll:
	dump ("allEnums.DenyAll\n" );
	  
	    return document.getElementById("icq_privacy_contact_blockallusers"); 
	    break;
	case allEnums.DenyList:
	dump ("allEnums.DenyList\n" );
	    return document.getElementById("icq_privacy_contact_blocklistusers"); 
	    break;
	default:
	    dump("Bad privacy mode\n");
	    return document.getElementById("icq_privacy_contact_allowallusers"); 
	    break;
	}
}

function privacyModeRadio(mode)
{
  lastRadio.checked = false;
  lastRadio = modeToRadio(mode);
  lastRadio.checked = true;
  parent.lastPrivacyMode = mode;
}

/*
function viewToRadio(view)
{
	switch(view) {
	case '1':
	    return document.getElementById("nodisclosure"); 
	    break;
	case '2':
	    return document.getElementById("limiteddisclosure"); 
	    break;
	case '3':
	    return document.getElementById("fulldisclosure"); 
	    break;
	default:
	    dump("Bad privacy view\n");
	    return document.getElementById("nodisclosure"); 
	    break;
	}
}

function privacyViewRadio(view)
{
  parent.lastPrivacyView = view;
}
*/
AdminCallback = new Object();
AdminCallback.OnRequestInfoComplete = function(type,info)
{
	switch (type) { 
	case Components.interfaces.nsIAimAdminInfo.RegistrationStatusPreference:
		parent.lastPrivacyView = info;
		lastViewRadio = viewToRadio(parent.lastPrivacyView);
	
		if ( lastViewRadio != undefined && lastViewRadio != null) {
			var privacyViewElement = document.getElementById("privacyView");
			privacyViewElement.selectedItem = lastViewRadio;
		}
		break;
	default:
		break;
	}
}
AdminCallback.OnRequestInfoError = function(pErrMsg)
{
	dump("OnRequestInfoError\n");
}

adminGetterCallback = new Object();

adminGetterCallback.ExecuteIfReady = function()
{
	aimAdminManager().RequestInfoRegistrationStatusPreference(AdminCallback);
}


function DisablePrivacyUI()
{
		var el = document.getElementById("icq_privacy_contact_allowallusers");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("icq_privacy_contact_allowbuddylistusers");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("icq_privacy_contact_allowonlylist");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("icq_privacy_contact_blockallusers");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("icq_privacy_contact_blocklistusers");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("button1");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("button2");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("button3");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("button4");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("authMode");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("onlineStatus");
	if ( el )
			el.setAttribute( "disabled", "true" );
  
		el = document.getElementById("icq_privacy_authorization_required");
		if ( el )
			el.setAttribute( "disabled", "true" );
		el = document.getElementById("icq_privacy_authorization_no");
	if ( el )
			el.setAttribute( "disabled", "true" );
}
 
function DiscardPrivacyChanges()
{
	aimErrorBox(aimString("icqprivacy.exitmsg"));
}

function IsSignedOn()
{
	var state = aimSession().CurrentState;
dump( "state is " + state + " \n" );

	if ( state == stateEnums.Online || state == stateEnums.OnlineAway )
		return true;
	return false;
}

function PrefIcqPrivacyOnLoad()
{
  if( (false == IsSignedOn()) || (isIcq() == false) ) {
  	DisablePrivacyUI();
		aimErrorBox(aimString("icqprivacy.entermsg"));
		parent.hPrefWindow.registerOKCallbackFunc( DiscardPrivacyChanges );
	}
	else {
		parent.hPrefWindow.registerOKCallbackFunc( AssertPrivacyChanges );
    var pAimPrefs =  pIIMManager.QueryInterface(Components.interfaces.nsIPrefsManager);

  	//if (document.documentElement.getAttribute("isIcqPanel") != "true") 
       // return;
//    var tree = document.getElementById("Allow");
//    tree.database.AddDataSource(aimRDF().GetDataSource("rdf:AIM"));
//    tree.setAttribute('ref', tree.getAttribute('ref')); 
    var tree = document.getElementById("Deny");
    tree.database.AddDataSource(aimRDF().GetDataSource("rdf:AIM"));
    tree.setAttribute('ref', tree.getAttribute('ref'));
  }
	var priv = aimPrivacy();
  // do it only the first time!
	if (parent.lastPrivacyMode == undefined)
		parent.lastPrivacyMode = priv.PrivacyMode;

	lastRadio = modeToRadio(parent.lastPrivacyMode);
  if ( lastRadio != undefined && lastRadio != null)
	    lastRadio.setAttribute("selected","true");
  var loggedin = true;

	if (loggedin && (parent.lastPrivacyView == undefined))
	{
		aimAdminManager().ExecuteIfReady(adminGetterCallback);
	}
	updateListBoxSelection("Deny");
}

function PrefIcqPrivacyOnUnload() 
{
	// nothing for now
}

// grab a screenname from the user.

function PostGetUserDlg( which )
{ 
	openDialog("chrome://aim/content/pref-Icq_getuser.xul", "", 
		"modal=yes,chrome", which);
}

function DeleteFromList( which )
{
    var listbox = document.getElementById(which);
    var pIAimPrivacy = aimPrivacy();
    var selectedUser;
    
        
    for (var i = 0; i <= listbox.selectedItems.length; i++) {
      selectedUser = listbox.selectedItems[i].getAttribute("label");
      if ( which == "Allow" ) {
          pIAimPrivacy.AllowListRemove( selectedUser );
          }
      else if ( which == "Deny" ) {
          pIAimPrivacy.DenyListRemove( selectedUser );
          }
      updateListBoxSelection(which);
      break;
    }

    var answer = confirm(getString("confirmICQ.AddUser"));

    if ( answer == true && which == "Deny") 
    {
        openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", "modal=yes,titlebar,chrome", 
               null, null, selectedUser);
    }

}

// onload handler for the dialog used to get a screenname from the user

function GetUserOnLoad()
{
  doSetOKCancel(GetUserAdd, 0);
	top.addMode = window.arguments[0];
	document.getElementById("fldUserName").focus();
}

// called when OK button is pressed in privacy mode preferences panel. Figure
// out what changed, communicate this to AIM Glue backend

function AssertPrivacyChanges()
{
	var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
	var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager)
	var lastRadio = null;
	var allEnums = Components.interfaces.nsAimPrivacyModes;
	var pIAimPrivacy = pIIMManager.QueryInterface(Components.interfaces.nsIAimPrivacy)
	
	if ( pIAimPrivacy == undefined || pIAimPrivacy == null )
		return;

	// This has been simplified and made correct
	pIAimPrivacy.PrivacyMode = parent.lastPrivacyMode;
	var tvalues = false;

	var pAimAdmin = pIIMManager.QueryInterface(Components.interfaces.nsIAimAdminManager);
	
	if ( pAimAdmin == undefined || pAimAdmin == null )
		return;

	adminSetterCallback = new Object();
	adminSetterCallback.ExecuteIfReady = function()
	{
	Components.classes['@netscape.com/aim/IMManager;1'].getService(Components.interfaces.nsIIMManager).QueryInterface(Components.interfaces.nsIAimAdminManager).ChangeRegistrationStatusPreference(null,parent.lastPrivacyView);
	}

	pAimAdmin.ExecuteIfReady(adminSetterCallback);
	return;
}

function
FindAwayMessageTargetByName( msgName )
{
	GetRDFService();

	var messages_file = GetRdfFileUrl("default-messages-icq.rdf", "icqdm.rdf");  
	var datasource = RDF.GetDataSource(messages_file);
  var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  container.Init(datasource, RDF.GetResource("NC:ICQ/AwayMessageBag"));

	var elements = container.GetElements();
	var target, node;
	var nameResource = 
                RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName");
	while ( elements.hasMoreElements() ) {
		node = elements.getNext();
		if ( node ) 
			target = datasource.GetTarget( node, nameResource, 
				true );
	  if ( target ) 
			target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
    if ( target && target.Value == msgName ) 
			return target.Value;
	}
	return null;
}

function
EditAwayMessageOnOK()
{
	var nameItem = document.getElementById("awayMessageName");
	var textItem = document.getElementById("awayMessageText");
	var nameValue = null;
	var textValue = null;

	if ( !nameItem || nameItem == undefined ) 
		return;
	if ( !textItem || textItem == undefined ) 
		return;
	nameValue = nameItem.value;
	textValue = textItem.value;
	if ( nameValue == "" ) {
		aimErrorBox(aimString("away.EnterLabel"));
		return;
	}
	if ( textValue == "" ) {
		aimErrorBox(aimString("away.EnterMessage"));
		return;
	}

	var target = FindAwayMessageTargetByName( nameValue );
	if ( target == null ) {
		retval = confirm(getString("away.DoesNotExist"));
		if ( retval == true ) 
			AssertAwayMessage( nameValue, textValue ); 
		else
			return;
	} else 
		SetAwayMessageTarget( nameValue, textValue )
	top.window.close();
}

function
AddAwayMessageOnOK()
{
	var nameItem = document.getElementById("awayMessageName");
	var textItem = document.getElementById("awayMessageText");
	var nameValue = null;
	var textValue = null;

	if ( !nameItem || nameItem == undefined ) 
		return;
	if ( !textItem || textItem == undefined ) 
		return;
	nameValue = nameItem.value;
	textValue = textItem.value;
	if ( nameValue == "" ) {
		aimErrorBox(aimString("away.EnterLabel"));
		return;
	}
	if ( textValue == "" ) {
		aimErrorBox(aimString("away.EnterMessage"));
		return;
	}

	if ( FindAwayMessageTargetByName( nameValue ) != null ) {

		// ask them if they would like to overwrite (i.e., 
		// turn this into an edit).

		var response = confirm(getString("away.AlreadyExists"));
		if ( response == true ) {
			EditAwayMessageOnOK();
			return;
		} else {
			aimErrorBox(aimString("away.EnterLabel"));
			return;
		}
	}

	AssertAwayMessage( nameValue, textValue ); 
	top.window.close();
}

function
AssertAwayMessage( nameValue, textValue )
{
	GetRDFService();

	var newmsg = RDF.GetAnonymousResource();
	var messages_file = GetRdfFileUrl("default-messages-icq.rdf", "icqdm.rdf");  

	var datasource = 
		RDF.GetDataSource(messages_file);
	datasource.Assert(newmsg, 
		RDF.GetResource("http://home.netscape.com/NC-rdf#MsgName"),
	        RDF.GetLiteral(nameValue), true);
	datasource.Assert(newmsg, 
		RDF.GetResource("http://home.netscape.com/NC-rdf#MsgText"),
		RDF.GetLiteral(textValue), true);

	var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:ICQ/AwayMessageBag"));

	container.AppendElement(newmsg);
	datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
}

function
AddAwayMessage()
{
// title is window.arguments[1];
// content is window.arguments[2];

 	window.openDialog("chrome://aim/content/AddIcqAwayMessage.xul","_blank", "chrome,close,titlebar,modal", "", "", "");
}

function
EditAwayMessage()
{
// title is window.arguments[1];
// content is window.arguments[2];

	var msgName, msgText;
	var response;

	response = FindSelectedAwayMessage();
	if ( response == null ) {
		aimErrorBox(aimString("away.PleaseSelectToEdit"));
		return;
	} else {
		msgName = response.msgName;
		msgText = response.msgText;
	}

 	window.openDialog("chrome://aim/content/AddIcqAwayMessage.xul","_blank", "chrome,close,titlebar, modal", "", msgName, msgText);
}

function
RemoveAwayMessage()
{
	var msgName, msgText;
	var response;

	response = FindSelectedAwayMessage();
	if ( response == null ) {
		aimErrorBox(aimString("away.PleaseSelectToRemove"));
		return;
	} 

	answer = confirm(getString("away.AreYouSure").replace(/%AwayMsg%/,response.msgName));
	if ( answer == true ) 
		RemoveTarget( response.msgName );
}

function
FindSelectedAwayMessage()
{
        var selection;
    var tree = document.getElementById("AwayMessages");

    var response = new Object();

        if ( tree )
                selection = tree.contentView.getItemAtIndex(tree.currentIndex);

        if ( selection) {
            response.msgName = selection.getAttribute("MsgName");
        response.msgText = selection.getAttribute("MsgText");

        return response;
    }
    return null;
}


function getCurrentIcqNumber()
 {
   var myaimSession = aimSession();
   if (myaimSession) {
     return myaimSession.CurrentScreenName;
   }
   else
     return "";
 }

 //XXXVISHY - per screen name stuff
  
function getCurrentScreenName()
{
  var myaimSession = aimSession();
  if (myaimSession) {
    return myaimSession.CurrentScreenName;
  }
  else
    return "";
}


// XXXVISHY - the icqPreferenceOnload function MUST be called in the
// onload handler of every icq preference panel so as to do the
// per screen name munging

/* every element has: prefstring, preftype, preattribute, pref (true/false), prefscope(0,1,2)

preftype, a type of value to retrieve;
preattribute, a type of element attribute to assign


preftype = true, if it is for preference element only
prefscope = 0, PER_SN,
prefscope = 2, SESSION_GLOBAL,
prefscope = 1, GEN_GLOBAL

*/

function icqPreferenceOnload()
{
dump("starting icqPreferenceOnload\n");     
	var aimprefs = document.getElementsByAttribute("pref", "true");
	var sN;
	var qPreference;
	var curDefPref;
	var panelType = 2;
     
    for (var i = 0 ; i < aimprefs.length ; i++) {
 		var preference = aimprefs[i].getAttribute("prefstring");
		var curprefScope = aimprefs[i].getAttribute("prefscope");
dump("curprefScope=" + curprefScope + "\n");		
		if (curprefScope == 2 || curprefScope == 1) {
		
			if (panelType == 0)
				qPreference = preference + ".aim";
			else //panelType == 2
			    qPreference = preference + ".icq";
						
		}
		else { // scope == 0, PER_SN

          if (panelType == aimPrefsManager().GetSessionType()) 
          {
			sN = getCurrentScreenName() + "."; 
			qPreference = sN + preference;

		    if (MozPreferences.getPrefType(qPreference) == Components.interfaces.nsIPrefBranch.PREF_INVALID)
            {
			// first time with this pref, so create a per screen name copy
				if (MozPreferences.getPrefType(preference) == Components.interfaces.nsIPrefBranch.PREF_INVALID)
				 {
				// "preference" is not default name, create default name
					
					if (panelType == 0)
						curDefPref = preference + ".aim";
					else //panelType == 2
					    curDefPref = preference + ".icq";
				}
				else {
					curDefPref = preference;
                }
dump("curDefPref=" + curDefPref + "\n");

				switch (MozPreferences.getPrefType(curDefPref)) {
				case Components.interfaces.nsIPrefBranch.PREF_STRING:
				var sPref = MozPreferences.getCharPref(curDefPref);		
				MozPreferences.setCharPref(qPreference, sPref);
				break;
				case Components.interfaces.nsIPrefBranch.PREF_INT:
				var iPref = MozPreferences.getIntPref(curDefPref);
				MozPreferences.setIntPref(qPreference, iPref);
				break;
				case Components.interfaces.nsIPrefBranch.PREF_BOOL:
				var bPref = MozPreferences.getBoolPref(curDefPref);
				MozPreferences.setBoolPref(qPreference, bPref);
				break;
				default:
				dump("Bad pref type for NIM\n");
				break;
				}


			}

			
          }                  
        else
          {
            qPreference = "__000." + preference;
          
          }
        }

dump("qPreference=" + qPreference + "\n");	
		aimprefs[i].setAttribute("prefstring", qPreference);
	
     }

}



function DisableIcqAwayUI()
{
        var el = document.getElementById("buttonAddMess");
        if ( el )
            el.setAttribute( "disabled", "true" );
        el = document.getElementById("buttonEditMess");
        if ( el )
            el.setAttribute( "disabled", "true" );
        el = document.getElementById("buttonRemoveMess");
        if ( el )
            el.setAttribute( "disabled", "true" );
        el = document.getElementById("AwayMessages");
        if ( el )
            el.setAttribute( "disabled", "true" );
        
}


function DiscardAwayChanges()
{
  aimErrorBox(aimString("icqaway.exitmsg"));
}


function changeContactListDisplay()
{
// Nothing for now
}

/************* Related to the Connection/Proxy Panel ********************/



/*Below all new function for connection panel*/

//OnLoad addconnection.xul
function EditConnectionOnLoad()
{
    // window.arguments[1] is type of ops for title,
    // window.arguments[2] is connection name


    var panelTtl = document.getElementById("panelTitle");

    var connectName = document.getElementById("connectName");

dump("arg1=" + window.arguments[1] + "\narg2=" + window.arguments[2] + "\n");
    if (window.arguments[1] == "Add") {          
        panelTtl.setAttribute('title' , panelTtl.getAttribute('titl1'));
 

        doSetOKCancel(AddConnMessageOnOK, 0);

        connLinks.ConnectionName = "";
        connLinks.SessionType    = 2;
        connLinks.Host           = "";
        connLinks.Port           = "";
        connLinks.ProxyHost      = "";
        connLinks.ProxyPort      = 1080;
        connLinks.ProxyUser      = "";
        connLinks.ProxyPassword  = "";
        connLinks.ProxyProtocol  = 0;
        connLinks.IsProxy        = false;
        connLinks.ConnectionType = 2;
        
    }
    else { /* Edit mode */
        panelTtl.setAttribute('title' , panelTtl.getAttribute('titl2'));
        

        doSetOKCancel(EditConnMessageOnOK, 0);
        
        var curConnName = window.arguments[2];

        setValuesFromRDF (curConnName);

    }
        
    setConnUI();
    
    DoFullEnabling();
    
}

function setValuesFromRDF (connectionName)
{
dump("starting setValuesFromRDF\n");    
    GetRDFService();

	var messages_file = CopynGetUrl("default-connections.rdf", "connections.rdf");  
	var datasource = RDF.GetDataSource(messages_file);
    	
    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:AIM/ConnectionsSeq"));

    var ConnNameLiteral = RDF.GetLiteral(connectionName);

    var ConnName = RDF.GetResource("http://home.netscape.com/NC-rdf#ConnectionName");

    var node = datasource.GetSource (ConnName, ConnNameLiteral, true);

    if (node)
    {
        var curName;
        for (var linkName in connLinks)
        {
            curName = datasource.GetTarget (node, 
                                            RDF.GetResource("http://home.netscape.com/NC-rdf#" + linkName),
                                            true);
            if ( curName ) {
	            curName = curName.QueryInterface(Components.interfaces.nsIRDFLiteral);
                connLinks[linkName] = curName.Value;
            }
        }
    }

}

function DoFullEnabling() {

    var connectName = document.getElementById("connectName");
    var aimHost = document.getElementById("aimHost");
    var aimPort = document.getElementById("aimPort");

    var Name = connectName.value;

    if (Name == "AIM" || Name == "AOL" || Name == "ICQ") {
        connectName.setAttribute( "disabled", "true" );
        aimHost.setAttribute( "disabled", "true" );
    }
    else {
        if (window.arguments[1] == "Add") {
            connectName.setAttribute( "disabled", "false" );
            connectName.removeAttribute( "disabled" );
        }
        else { // Edit
            connectName.setAttribute( "disabled", "true" );        
        }

        aimHost.setAttribute( "disabled", "false" );
        aimHost.removeAttribute( "disabled" );

    }

    // enable proxy protocol fields
    DoEnabling();
}

//OnLoad pref-IM_connection.xul
function PrefIMConnectionOnLoad(){
    // init datasource
dump("starting PrefIMConnectionOnLoad\n");

    GetRDFService();

    // copy file to profile  and return full URL of the file
    var connection_file = CopynGetUrl("default-connections.rdf", "connections.rdf");

    if (!connection_file)
        return;

    datasource = RDF.GetDataSource(connection_file);

    dump( "datasource " + datasource + "\n" );

    var tree = document.getElementById("ConnectionList");
    tree.database.AddDataSource(datasource);
    tree.setAttribute('ref', tree.getAttribute('ref'));

    // disable 2 buttons, no selection here
    document.getElementById("btnEdit").setAttribute("disabled", true);
    document.getElementById("btnRemove").setAttribute("disabled", true);
}


function FindSelectedConnection(connInfo)
{
    var selection;
	var list = document.getElementById("ConnectionList");
dump("starting FindSelectedConnection\n");


    if ( list && list.selectedItem ) {
             connInfo.name          = list.selectedItem.getAttribute("ConnectionName");
        	 connInfo.sessiontype   = list.selectedItem.getAttribute("sessionType");
dump("connInfo.name=" + connInfo.name + " connInfo.sessiontype=" + connInfo.sessiontype + "\n");
            return connInfo;
		
	}
	return null;
}


// 3 buttons
function AddConnMessage()
{
dump("starting AddConnMessage\n");

    window.openDialog("chrome://aim/content/pref-Icq_addconnection.xul","_blank", "chrome,close,titlebar,modal", "", "Add", "");
    
}

function EditConnMessage()
{
dump("starting EditConnMessage\n");

    var ConnectionInfo = new Object();
    ConnectionInfo.name ="";
    ConnectionInfo.sessiontype = "";


    FindSelectedConnection(ConnectionInfo);
    var ConnectionName = ConnectionInfo.name;

dump("ConnectionName=" + ConnectionName + "\n");
    if ( ConnectionName == null ) {
		alert(getString("connection.PleaseSelectToEdit"));
		return;
	}     

    window.openDialog("chrome://aim/content/pref-Icq_addconnection.xul","_blank", "chrome,close,titlebar, modal", "", "Edit", ConnectionName);

}

function RemoveConnMessage()
{
dump("starting RemoveConnMessage\n");

    var ConnectionInfo = new Object();
    ConnectionInfo.name ="";
    ConnectionInfo.sessiontype = "";


    FindSelectedConnection(ConnectionInfo);
    var ConnectionName = ConnectionInfo.name;

    if ( ConnectionName == null ) {
		alert(getString("connection.PleaseSelectToRemove"));
		return;
	}

	var answer = confirm(getString("connection.AreYouSure").replace(/%AwayMsg%/, ConnectionName));

	if ( answer == true ) 
		RemoveConnectionfromDatasrc( ConnectionName );


}


function RemoveConnectionfromDatasrc( ConnectionName )
{
    GetRDFService();

	var messages_file = CopynGetUrl("default-connections.rdf", "connections.rdf");  
	var datasource = RDF.GetDataSource(messages_file);
    	
    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:AIM/ConnectionsSeq"));

    var ConnNameLiteral = RDF.GetLiteral(ConnectionName);

    var ConnName = RDF.GetResource("http://home.netscape.com/NC-rdf#ConnectionName");

    var node = datasource.GetSource (ConnName, ConnNameLiteral, true);

    if (node) {
        // remove from container
        container.RemoveElement( node, true );

        // remove connection info
        var curProp;
        var curTarget;
        for (var curName in connLinks)
        {
          curProp   = RDF.GetResource("http://home.netscape.com/NC-rdf#" + curName);
          curTarget = datasource.GetTarget(node, curProp, true);
            
          datasource.Unassert (node, curProp, curTarget );
        }        

        datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
    }

    return null;

}


//2 callbacks for AddConnection editing window
function AddConnMessageOnOK()
{
    dump("starting AddConnMessageOnOK\n");
    GetRDFService();

	var messages_file = CopynGetUrl("default-connections.rdf", "connections.rdf");  
	var datasource = RDF.GetDataSource(messages_file);

    var connectName = document.getElementById("connectName");
    var connectNameVal = connectName.value;

dump("connectNameVal=" + connectNameVal + "\n");
    if (connectNameVal == "")
    {
        alert(getString("connection.EnterName"));
        return;
    }

    var node = datasource.GetSource (RDF.GetResource("http://home.netscape.com/NC-rdf#ConnectionName"), 
                                     RDF.GetLiteral(connectNameVal), 
                                     true);

    if (node) {
        alert(getString("connection.AlreadyExists"));
        return;
    }
    

    getConnInfoFromUI();

    AddConnectionDatasource ();
    top.window.close();
}

function EditConnMessageOnOK()
{
    GetRDFService();

	var messages_file = CopynGetUrl("default-connections.rdf", "connections.rdf");  
	var datasource = RDF.GetDataSource(messages_file);

    var connectNameVal = document.getElementById("connectName").value;

    var node = datasource.GetSource (RDF.GetResource("http://home.netscape.com/NC-rdf#ConnectionName"), 
                                     RDF.GetLiteral(connectNameVal), 
                                     true);

    if (!node)
        return;

    getConnInfoFromUI();

    EditConnectionDatasource(node);
	top.window.close();
}

function setConnUI()
{

    var panelSessionType = 2;

    var connectName = document.getElementById("connectName");
    var aimHost = document.getElementById("aimHost");
    var aimPort = document.getElementById("aimPort");
    var proxyHost = document.getElementById("proxyHost");
    var proxyPort = document.getElementById("proxyPort");
    var proxyUserName = document.getElementById("proxyUserName");
    var proxyPassword = document.getElementById("proxyPassword");
    var proxyUse = document.getElementById("proxyUse");
    var proxyProtocol = document.getElementById("proxyProtocol");

    if (panelSessionType != 2)
       var IsAol = document.getElementById("IsAol");

    connectName.value = connLinks.ConnectionName;

    aimHost.value = connLinks.Host;    
    aimPort.value = connLinks.Port;    
    proxyHost.value = connLinks.ProxyHost;    
    proxyPort.value = connLinks.ProxyPort;    
    proxyUserName.value = connLinks.ProxyUser;    

    var pIAimSession = aimSession();
   	if ( pIAimSession ) {
   		proxyPassword.value = pIAimSession.UnMungeString(connLinks.ProxyPassword);
dump("UnMungeString connLinks.ProxyPassword=" + connLinks.ProxyPassword + " proxyPassword.value=" + proxyPassword.value + "\n");
   	}

    
    if (connLinks.ProxyProtocol > 0 && connLinks.ProxyProtocol <= 4)
        proxyProtocol.selectedItem = proxyProtocol.childNodes[connLinks.ProxyProtocol - 1];
    else
        proxyProtocol.selectedItem = proxyProtocol.childNodes[0];


    if (connLinks.IsProxy == "true")
      proxyUse.setAttribute ("checked", true);
    else
      proxyUse.setAttribute ("checked", false);

dump("proxyUse.checked=" + proxyUse.checked + "  connLinks.IsProxy=" + connLinks.IsProxy + "\n");

    if (panelSessionType != 2) {
        if (connLinks.ConnectionType == 1)
            proxyUse.setAttribute ("checked", true);
        else
            proxyUse.setAttribute ("checked", false);
        
    }

}

// Remove whitespace from both ends of a string
function TrimString(string)
{
  if (!string) return "";
  return string.replace(/(^\s+)|(\s+$)/g, '')
}

function getConnInfoFromUI()
{
    var panelSessionType = 2;

    var connectName = document.getElementById("connectName");
    var aimHost = document.getElementById("aimHost");
    var aimPort = document.getElementById("aimPort");
    var proxyHost = document.getElementById("proxyHost");
    var proxyPort = document.getElementById("proxyPort");
    var proxyUserName = document.getElementById("proxyUserName");
    var proxyPassword = document.getElementById("proxyPassword");
    var proxyUse = document.getElementById("proxyUse");
    var proxyProtocol = document.getElementById("proxyProtocol");
    var IsAol = document.getElementById("IsAol");

    connLinks.ConnectionName =  TrimString(connectName.value);
    connLinks.SessionType    =  panelSessionType;
dump("getConnInfoFromUI connLinks.SessionType=" + connLinks.SessionType + "\n");
    connLinks.Host           =  TrimString(aimHost.value);    
    connLinks.Port           =  TrimString(aimPort.value);    
    connLinks.ProxyHost      =  TrimString(proxyHost.value);    
    connLinks.ProxyPort      =  TrimString(proxyPort.value);    
    connLinks.ProxyUser      =  TrimString(proxyUserName.value);

    var pIAimSession = aimSession();
    if(pIAimSession) {
        // trim?
       	connLinks.ProxyPassword = pIAimSession.MungeString(proxyPassword.value);
dump("MungeString proxyPassword.value=" + proxyPassword.value + " connLinks.ProxyPassword=" + connLinks.ProxyPassword + "\n");

    }
    
    // trim?
                
    connLinks.ProxyProtocol  =  proxyProtocol.selectedItem.getAttribute("value");
    connLinks.IsProxy        =  proxyUse.checked;

dump("panelSessionType=" + panelSessionType + "\n");
    if (panelSessionType != 2) {
        if (IsAol.checked)
            connLinks.ConnectionType = 1;
        else
            connLinks.ConnectionType = 0;
        
    }
    else
        connLinks.ConnectionType = 2;
}

function AddConnectionDatasource()
{
    GetRDFService();

	var messages_file = CopynGetUrl("default-connections.rdf", "connections.rdf");  
	var datasource = RDF.GetDataSource(messages_file);

    var newConn = RDF.GetAnonymousResource();

    for (var curName in connLinks)     
    {
        datasource.Assert(newConn, RDF.GetResource("http://home.netscape.com/NC-rdf#" + curName),		
	            RDF.GetLiteral(connLinks[curName]), true);
    }

    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:AIM/ConnectionsSeq"));

	container.AppendElement(newConn);
	datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();

}


function EditConnectionDatasource( connectionNode )
{
    GetRDFService();

	var messages_file = CopynGetUrl("default-connections.rdf", "connections.rdf");  
	var datasource = RDF.GetDataSource(messages_file);

    var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
  	container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
  	container.Init(datasource, RDF.GetResource("NC:AIM/ConnectionsSeq"));

    var curLinkRes;
    var oldTarget;
    for(var curName in connLinks) 
    {
        if (curName != "ConnectionName") {// ConnectionName was set already
            curLinkRes = RDF.GetResource("http://home.netscape.com/NC-rdf#" + curName);
            oldTarget  = datasource.GetTarget(connectionNode, curLinkRes, true);
                                                                                          
            datasource.Change( connectionNode, curLinkRes,                               
                               oldTarget, RDF.GetLiteral(connLinks[curName]) );                               
        }
    }

		
	datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();

}
/* keep it for the future for external session UI */
/*
function SetExternalConnection()
{
    var ConnectionInfo = new Object();
    ConnectionInfo.name ="";
    ConnectionInfo.sessiontype = "";


    FindSelectedConnection(ConnectionInfo);
    var ConnectionName = ConnectionInfo.name;

    document.getElementById("mailConn").value = ConnectionName;
    setConnectionInfo (ConnectionName, "mail");

}
*/

function SetHostPortDefault(type)
{

dump("type=" + type + "\n");
    var host = document.getElementById("aimHost"); 
    var port = document.getElementById("aimPort");

        host.setAttribute("value", "login.icq.com");
        port.setAttribute("value", "5190");        
 

}

function EnableConnButtons()
{
    var connInfo = new Object();
    connInfo.name ="";
    connInfo.sessiontype = "";


    FindSelectedConnection(connInfo);
    var ConnectionName = connInfo.name;

    var panelSessionType = 2;
dump("connInfo.name =" + connInfo.name + " connInfo.sessiontype=" + connInfo.sessiontype + 
     "panelSessionType=" + panelSessionType + "\n");

    if(connInfo.sessiontype == panelSessionType) {
        document.getElementById("btnEdit").setAttribute("disabled", false);
        document.getElementById("btnEdit").removeAttribute( "disabled" );    
       
    }
    else {
        document.getElementById("btnEdit").setAttribute("disabled", true);    
    }


    if (connInfo.name == "AIM" || connInfo.name == "AOL" || connInfo.name == "ICQ" ||
        (connInfo.sessiontype != panelSessionType)) {
    
        document.getElementById("btnRemove").setAttribute("disabled", true);
    
    }
    else {
        document.getElementById("btnRemove").setAttribute("disabled", false);
        document.getElementById("btnRemove").removeAttribute( "disabled" ); 
    }


}

// new update

function PrefIMConnectionOnload()
{
   var proxPass = "";
   DoEnabling();
   parent.ConnectionLoadicq = 1;
   parent.connectionSavedicq = 0;
   if ( parent.ConnectionCallbackicq == undefined || 
        parent.ConnectionCallbackicq == null ) {

    // Register the OK callback func once, and unmunge the initial value 

    parent.ConnectionCallbackicq = 1;
       parent.hPrefWindow.registerOKCallbackFunc( AssertProxyChangesIcq );
       var pIAimSession = aimSession();
       if ( pIAimSession ) {
           proxPass = pIAimSession.UnMungeString(document.getElementById("proxyPasswordicq").value);
        parent.proxyPasswordicq = proxPass;
       }
   } else {

    // we switched back from some other panel, so restore the 
    // saved off value from the unload handler

    proxPass = parent.proxyPasswordicq;    
   }
   document.getElementById("proxyPasswordicq").value = proxPass;
}

function
AssertProxyChangesIcq()
{
    // if the connection panel is loaded, base64 the current password

    if ( parent.ConnectionLoadicq == 1 )
        MungeProxyPassword();

    // set this so the unload handler doesn't do anything when called

    parent.connectionSavedicq = 1;
}

function PrefIMConnectionOnunload()
{
    // we already saved (e.g., here because OK was hit), so juswt return

    if ( parent.connectionSavedicq == 1 )
        return;

    // ok, switching to some other panel. Save off the current value
    // to be restored in the onload handler, and remember we are not
    // visible so we deal with the AssertProxyChanges() callback in
    // the correct manner

    parent.proxyPasswordicq = document.getElementById("proxyPasswordicq").value;
    MungeProxyPassword();        // just in case OK is hit while away
    parent.ConnectionLoadicq = 0;    
}

function DoEnabling()
{
  var host = document.getElementById("proxyHosticq");
  var port = document.getElementById("proxyPorticq");
  var protocol = document.getElementById("proxyProtocolicq");
  var userName = document.getElementById("proxyUserNameicq");
  var password = document.getElementById("proxyPasswordicq");
  var radiogroup0 = document.getElementById("proxyProtocolSocks4icq");
  var radiogroup1 = document.getElementById("proxyProtocolSocks5icq");
  var radiogroup2 = document.getElementById("proxyProtocolHttpsicq");
  var radiogroup3 = document.getElementById("proxyProtocolHttpicq");

  // convenience arrays
  var manual = [host, port, protocol, userName, password, radiogroup0, radiogroup1, radiogroup2, radiogroup3];
  
  // checkbox button
  var checkboxitem = document.getElementById("proxyUseicq");
  if ( checkboxitem.checked ) {
      for( var i = 0; i < manual.length; i++ ) {
        manual[i].setAttribute( "disabled", "false" );
        manual[i].removeAttribute( "disabled" );
      }
  } else {
      for( var i = 0; i < manual.length; i++ ) 
        manual[i].setAttribute( "disabled", "true" );
  }
}


function MungeProxyPassword()
{
    //XXXVISHY - you cannot use macros like AimSessionObject in
        // any callback because the javascript context will not remember
        // the included files!!!

        var IMServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
        var pIIMManager  = IMServiceClass.getService(Components.interfaces.nsIIMManager)
        var pIAimSession = pIIMManager.QueryInterface(Components.interfaces.nsIAimSession)
        var proxPass = "";
        if(pIAimSession) {
               proxPass = pIAimSession.MungeString(document.getElementById("proxyPasswordicq").value);
              document.getElementById("proxyPasswordicq").value = proxPass;
        }
}


function resetConnection()
{
dump("Icq reset\n");
    document.getElementById("aimHosticq").value = "login.icq.com"
    document.getElementById("aimPorticq").value = "5190";
}


/*connection panel end*/
