var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService();
prefs = prefs.QueryInterface(Components.interfaces.nsIPrefBranch);

okCallback = null;

//Progress and Status variables
var gSyncButton;
var gStatusText;
var statusFeedback;
var gProgressWindow = null;

function ABSynchStart()
{
	dump("ABSynchStart()\n");

	if (prefs.getBoolPref("mail.absync.firsttime")) {
		var dialog = window.openDialog("chrome://messenger/content/addressbook/ABSynch.xul","","chrome,modal,titlebar,dialog","");
	}
	
	// if this is false, this is not their first time, or it was
	// and they hit ok
	if (!prefs.getBoolPref("mail.absync.firsttime")) {
		AbSync();
	}
}

function ABSynchAccept()
{
  prefs.setBoolPref("mail.absync.firsttime",false);
  return true;
}

function ABSynchOnLoad()
{
  dump("ABSynchOnLoad()\n");
}

//
// Do the sync operation
//
function AbSync()
{
  dump("AbSync()\n");
  var syncDriverContractID = "@mozilla.org/addressbook/services/syncdriver;1";

  // Create windows status feedback
  // set the JS implementation of status feedback before creating the C++ one..
  window.statusFeedback = new nsMsgStatusFeedback();

  // Kill the sync button!
  window.statusFeedback.startMeteors();

  // get the sync driver instance
  var syncDriver = Components.classes[syncDriverContractID].getService();
  if (syncDriver)
  {
    syncDriver = syncDriver.QueryInterface(Components.interfaces.nsIAbSyncDriver);    
  }
  
  syncDriver.KickIt(window.statusFeedback, window);  
}

function nsMsgStatusFeedback()
{
}

function getStringBundle(aURL) 
{
  var stringBundleService = Components.classes["@mozilla.org/intl/stringbundle;1"].getService();
  stringBundleService = stringBundleService.QueryInterface(Components.interfaces.nsIStringBundleService);
  var stringBundle = stringBundleService.createBundle(aURL);
  if (stringBundle)
    return stringBundle.QueryInterface(Components.interfaces.nsIStringBundle);
}

var selectionArray;

nsMsgStatusFeedback.prototype = 
{
  QueryInterface : function(iid) {
    if(iid.equals(Components.interfaces.nsIMsgStatusFeedback))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },
  showStatusString : function(statusText) {
    if (!gStatusText) 
      gStatusText = document.getElementById('statusText');
       
    gStatusText.setAttribute('label', statusText);
  },
  startMeteors : function() {
    // Disable Sync button...
    if (!gSyncButton)
      gSyncButton = document.getElementById('button-absynch');

    if (gSyncButton)
      gSyncButton.setAttribute('disabled', 'true');
  },
  stopMeteors : function() {
    // Enable Sync button...
    if (!gSyncButton)
      gSyncButton = document.getElementById('button-absynch');

    if (gSyncButton)
      gSyncButton.setAttribute('disabled', 'false');
  },
  showProgress : function(percent) {
    if (!gProgressWindow)
      gProgressWindow = window.open(
              "chrome://messenger/content/addressbook/ABSyncProgress.xul",
              "",
              "chrome,centerscreen,titlebar,dialog");

    if (percent==50) {
      var stringBundle = getStringBundle("chrome://messenger/locale/addressbook/absync.properties");
      if (stringBundle) {
        var tMsgObj = gProgressWindow.document.getElementById('progressStatusMsg');
        if (tMsgObj) {
          var tMsg = stringBundle.GetStringFromName("syncInProgress"); 
          tMsgObj.setAttribute('label', tMsg);
        }
      }
    }  
  },
  closeWindow : function() {
    if (gProgressWindow) {
      try {
        gProgressWindow.close();
      }
      catch (ex) {
        dump("failed to find window: ex="+ ex + "\n");
      }

      gProgressWindow = null;
    }
  }
}
