//@line 38 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"

const kXUL_NS            = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
const kIShellService    = Components.interfaces.nsIShellService;
//@line 42 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
const kIMacShellService = Components.interfaces.nsIMacShellService;
//@line 44 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"

var gSetBackground = {
  _position         : kIShellService.BACKGROUND_STRETCH,
  _monitor          : null,
  _image            : null,
  _backgroundColor  : 0,

//@line 73 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"

  get _shell()
  {
    return Components.classes["@mozilla.org/browser/shell-service;1"]
                     .getService(Components.interfaces.nsIShellService);
  },

  load: function ()
  {
    this._monitor = document.getElementById("monitor");
//@line 84 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
    document.documentElement.getButton("accept").hidden = true;
//@line 86 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
    this.init(window.arguments[0]);
  },
        
  init: function (aImage)
  {
    this._image = aImage;
 
//@line 97 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
    // Make sure to reset the button state in case the user has already
    // set an image as their desktop background. 
    var setDesktopBackground = document.getElementById("setDesktopBackground");
    setDesktopBackground.hidden = false;
    var bundle = document.getElementById("backgroundBundle");
    setDesktopBackground.label = bundle.getString("DesktopBackgroundSet");
    setDesktopBackground.disabled = false;
    
    var showDesktopPreferences = document.getElementById("showDesktopPreferences");
    showDesktopPreferences.hidden = true;

    var position = kIShellService.BACKGROUND_STRETCH;
//@line 110 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
    this.updatePosition(position);
  },
        
//@line 130 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"

  observe: function (aSubject, aTopic, aData)
  {
    if (aTopic == "shell:desktop-background-changed") {
      var setDesktopBackground = document.getElementById("setDesktopBackground");
      setDesktopBackground.hidden = true;
      
      var showDesktopPreferences = document.getElementById("showDesktopPreferences");
      showDesktopPreferences.hidden = false;

      var os = Components.classes["@mozilla.org/observer-service;1"]
                         .getService(Components.interfaces.nsIObserverService);
      os.removeObserver(this, "shell:desktop-background-changed");
    }
  },

//@line 147 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
  setDesktopBackground: function()
  {
    var os = Components.classes["@mozilla.org/observer-service;1"]
                       .getService(Components.interfaces.nsIObserverService);
    os.addObserver(this, "shell:desktop-background-changed", false);
    
    var bundle = document.getElementById("backgroundBundle");
    var setDesktopBackground = document.getElementById("setDesktopBackground");
    setDesktopBackground.disabled = true;
    setDesktopBackground.label = bundle.getString("DesktopBackgroundDownloading");

    this._shell.setDesktopBackground(this._image, this._position);
  },
  
  showDesktopPrefs: function()
  {
    this._shell.openApplication(kIMacShellService.APPLICATION_DESKTOP);
  },
//@line 173 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"

  updateColor: function (color)
  {
//@line 182 "/Users/rklein/trunk/mozilla/browser/components/shell/content/setDesktopBackground.js"
  },
  
  updatePosition: function (aPosition)
  {
    if (this._monitor.childNodes.length)
      this._monitor.removeChild(this._monitor.firstChild);
      
    this._position = aPosition;
    if (this._position == kIShellService.BACKGROUND_TILE)
      this._tileImage();
    else if (this._position == kIShellService.BACKGROUND_STRETCH)
      this._stretchImage();
    else
      this._centerImage();
  },

  _createImage: function ()
  {
    const nsIImageLoadingContent = Components.interfaces.nsIImageLoadingContent;
    if (!(this._image instanceof nsIImageLoadingContent))
        return false;

    var request = this._image.QueryInterface(nsIImageLoadingContent)
                             .getRequest(nsIImageLoadingContent.CURRENT_REQUEST);
    if (!request)
      return false;

    var imgURI = this._image.currentURI;
    if (imgURI.schemeIs("javascript"))
      return false;

    var img = document.createElementNS(kXUL_NS, "image");
    img.setAttribute("src", imgURI.spec);
    return img;
  },
        
  _stretchImage: function ()
  {  
    this.updateColor(this._backgroundColor);

    var img = this._createImage();
    img.width = parseInt(this._monitor.style.width);
    img.height = parseInt(this._monitor.style.height);
    this._monitor.appendChild(img);
  },
        
  _tileImage: function ()
  {
    var bundle = document.getElementById("backgroundBundle");

    this._monitor.style.backgroundColor = "white";

    var text = document.createElementNS(kXUL_NS, "label");
    text.setAttribute("id", "noPreviewAvailable");
    text.setAttribute("value", bundle.getString("DesktopBackgroundNoPreview"));
    this._monitor.appendChild(text);
  },
        
  _centerImage: function ()
  {
    this.updateColor(this._backgroundColor);
             
    var img = this._createImage();
    // Use naturalHeight/Width here so we don't scale an image improperly in
    // the preview window if the image is resized in the browser window.
    var width = this._image.naturalWidth * this._monitor.boxObject.width / screen.width;
    var height = this._image.naturalHeight * this._monitor.boxObject.height / screen.height;
    img.width = Math.floor(width);
    img.height = Math.floor(height);
    this._monitor.appendChild(img);
  }
};
