;
;	CRC32.ASM
;	 ᫥ CRC32				     v1.00
;
;	Coded By Alexandr V. Lebedev.
;	CopyRights (C) 1998 Alexandr V. Lebedev
;
;	⥪ ন BP v7.0

LOCALS @@
SMART

CODE	SEGMENT
	ASSUME cs:CODE

	.386

	PUBLIC CRC32Get
	PUBLIC CRC32End

CRC32Seed EQU 0FFFFFFFFh

;=========================================================================

CRC32Table LABEL Dword
INCLUDE CRC32Tab.inc

;=========================================================================
; Function CRC32( Value : Byte; CRC : LongInt ) : LongInt;

CRC32Get	PROC FAR

	ARG CRC : Dword, V : Byte = @@RetSize
	
	push	bp
	mov	bp,sp

	mov	ebx, 0
	mov	bl, [V]

	xor	ebx, [CRC]
	mov	eax, [CRC]
	shr	eax, 8	
	and	eax, 00FFFFFFh

	mov	bh, 0
	mov	ecx, CRC32Table[bx]
	xor	ecx, eax
	xchg	eax, ecx

@@Ret:	pop	bp
	ret	@@RetSize
CRC32Get	ENDP

;=========================================================================
; Function CRC32End ( CRC : LongInt ) : LongInt;

CRC32End	PROC FAR

	ARG CRC : Dword  = @@RetSize
	push	bp
	mov	bp,sp
	
	mov	eax, [CRC]
	xor	eax,CRC32Seed

@@Ret:	pop	bp
	ret	@@RetSize
CRC32End	ENDP

;=========================================================================

CODE	ENDS
	END

    Coded By Alexandr V. Lebedev.

    FidoNet:        None.
    E-Mail:         None.
    Updates:        None.
