/*
 *      ON.CMD - V1.0 C.Langanke 1996
 *
 *      REXX sample for "Animated Mouse Pointer for OS/2"
 *
 *      Syntax: ON [/?]
 *
 *      ON enables all loaded animations. To be animated, an 
 *      animation resource with at least two pointer images 
 *      must be loaded for a given mouse pointer.
 *
 *      /?             displays this help text.
 *
 *      NOTE: "Animated Mouse Pointer for OS/2" must be 
 *            installed before executing this batch program.
 *
 *      Refer to WPAMPTR.INF for more information about how
 *      to use REXX setup strings to configure
 *      "Animated Mouse Pointer for OS/2"
 */
/* First comment is used as online help text. */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 /* OS/2 error codes */
 ERROR.NO_ERROR           =  0;
 ERROR.INVALID_FUNCTION   =  1;
 ERROR.FILE_NOT_FOUND     =  2;
 ERROR.PATH_NOT_FOUND     =  3;
 ERROR.ACCESS_DENIED      =  5;
 ERROR.NOT_ENOUGH_MEMORY  =  8;
 ERROR.INVALID_FORMAT     = 11;
 ERROR.INVALID_DATA       = 13;
 ERROR.NO_MORE_FILES      = 18;
 ERROR.WRITE_FAULT        = 29;
 ERROR.READ_FAULT         = 30;
 ERROR.GEN_FAILURE        = 31;
 ERROR.INVALID_PARAMETER  = 87;

 /* show help */
 ARG Parm .
 IF (POS('?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 /* load RexxUtil */ 
 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;
     
 /* now setup the mouse object */
 setup    = 'ANIMATION=ON;'

 CALL CHAROUT, 'setup mouse object with "'setup'"   ... ';
 rc = SysSetObjectData( '<WP_MOUSE>', setup);
 IF (rc = 1) THEN
    SAY 'Ok.';
 ELSE
    SAY 'ERROR !';

 EXIT(ERROR.NO_ERROR);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Interrupted by user.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE Title

 SAY;
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* close file again */
 rc = LINEOUT(Thisfile);

 RETURN('');

