/*
	DECalc v3.3 program installer
	This will create a WPS program object for DECalc in the directory you specify
*/

/* Load needed REXX function library */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Clear the screen */
call SysCls

/* Get the program version and set variables for install */
Version = SysIni('DECalc.ini', 'DECalc', 'Version')
x = pos('.', Version)
if x > 0 then
	do
		y = substr(Version, 1, x-1)
		z = substr(Version, x+1)
		ExeVersion = y||z
	end
else
	ExeVersion = Version

SourceDir = Directory()
ValidResponse = 'YN'
YesKey = left(ValidResponse, 1)
NoKey = right(ValidResponse, 1)

/* Get installation input from user */
call charout, 'Install from: '
say SourceDir
call charout, 'Install to: '
parse pull InstallDir

if (InstallDir = SourceDir) | (InstallDir = '.') | (InstallDir = '') then
	do
		InstallDir = SourceDir
		SameDir = 1
		signal InstallHere
	end

if left(InstallDir, 1) = '"' then
	InstallDir = strip(InstallDir,'b','"')

if right(InstallDir, 1) = "\" then
	do
		len = length(InstallDir) - 1
		InstallDir = substr(InstallDir, 1, len)
	end

/* See if the destination directory already exists */
call Directory InstallDir

/* If it does not, let's try to create it */
if translate(directory()) <> translate(InstallDir) then
	do
		say 'That directory does not exist.  I will attempt to create it.'
		InstallDir = MakeDir(InstallDir)
	end
else
	do
		if pos(" ", InstallDir) > 0 then
			InstallDir = '"'||InstallDir||'"'
	end

/* Make sure we're in the source directory */
call Directory SourceDir

InstallHere:

/* Prompt user to continue installation */
say 'Installation will copy files to' InstallDir 'and create'
say 'a WPS desktop object for DECalc version' version||'.'
say 'Do you wish to proceed? (Y/N)'

do while (pos(junk, ValidResponse) = 0)
	junk = translate(SysGetKey('NOECHO'))
	if (pos(junk, ValidResponse) = 0) then
		beep(800, 200)
end
say junk

if SameDir <> 1 then
	do
		say 'Copying files...'
		'copy' SourceDir InstallDir
	end

/* Setup WPS program object */
if junk = YesKey then
	do
		ProgTitle = 'DECalc' version
		EXE = 'DECalc.exe'
		ICO = 'DECalc3.ico'

		if left(InstallDir, 1) = '"' then
			InstallDir = strip(InstallDir,'b','"')

		Setup = 'OBJECTID=<DECalc_Prog>;EXENAME='InstallDir'\'EXE';ICONFILE='InstallDir'\'ICO';STARTUPDIR='InstallDir''
		Action = Replace

		say 'Creating Program object'
		call SysCreateObject 'WPProgram',ProgTitle,'<WP_DESKTOP>',Setup,Action
		say 'WPS object created!'
	end
else
	do
		say 'Installation aborted.'
		say ''
	end

call charout, 'Press any key to exit installer.'
rc = SysGetKey('NOECHO')

exit


/* If destination directory does not exist, try to create it */
MakeDir: procedure

	parse arg InstallDir

	if right(InstallDir, 1) <> "\" then
		InstallDir = InstallDir||"\"

	if pos(" ", InstallDir) > 0 then
		InstallDir = '"'||InstallDir||'"'

	loop:
	x = pos(":", InstallDir)
	if x > 1 then
		do
			Drive = left(InstallDir, 2)
			call Directory Drive
			'@cd\'
			Path = substr(InstallDir, x+2)
		end
	else
		do
			InstallDir = directory()||"\"||InstallDir
			signal loop
		end

	Level = 0

	do until y = length(Path)
		y = pos("\", Path)
		if y > 0 then
			do
				Level = Level + 1
				dir.Level = substr(Path, 1, y-1)
				Path = substr(Path, y+1)
			end
		else
			leave
	end

	do z = 1 to Level
		rc = SysMkDir(dir.z)
		call Directory dir.z
	end

	say ''
	say 'Directory successfully created.'
	say ''

return InstallDir

