/* xmouse.h - Preliminary release, subject to changes        20011227 */
/* (c) Copyright 2001, Martin Lafaix.  All Rights reserved            */


/* IMPORTANT:                                                         */
/*                                                                    */
/*  In order to be sure the current mouse driver is an XMouse driver, */
/*  it is recommended to perform a MOU_GETXMOUSEVER ioctl call before */
/*  attempting to perform some other ioctls.                          */
/*                                                                    */
/*  As of this writing, XMOUSEVER.version is 2.                       */


/* MOU_QUERYDETECTEDID                                                */
/*                                                                    */
/* Usage:                                                             */
/*                                                                    */
/*  ULONG ulProductID;                                                */
/*                                                                    */
/*  ulAction = 0;                                                     */
/*  ulLength = sizeof(ulProductID);                                   */
/*  rc = DosDevIOCtl(hf,                                              */
/*                   IOCTL_POINTINGDEVICE,                            */
/*                   MOU_QUERYDETECTEDID,                             */
/*                   0,                                               */
/*                   0,                                               */
/*                   &ulAction,                                       */
/*                   &ulProductID,                                    */
/*                   sizeof(ulProductID),                             */
/*                   &ulLength);                                      */
/*                                                                    */
/* On successful invocation, ulProductID is the detected ID.  A value */
/* of 0 means autodetection has been disabled through the use of the  */
/* PROTOCOL= command line switch.                                     */
/*                                                                    */
/* [The ulProductID returned is of little interest for general use.   */
/*  In particular, there is no guarantee it will remain the same for  */
/*  a given mouse in future XMouse releases.]                         */

/* MOU_QUERYPROTOCOLINFO                                              */
/*                                                                    */
/* Usage:                                                             */
/*                                                                    */
/*  PROTOCOLINFO info;                                                */
/*                                                                    */
/*  ulAction = 0;                                                     */
/*  ulLength = sizeof(info);                                          */
/*  rc = DosDevIOCtl(hf,                                              */
/*                   IOCTL_POINTINGDEVICE,                            */
/*                   MOU_QUERYPROTOCOLINFO,                           */
/*                   0,                                               */
/*                   0,                                               */
/*                   &ulAction,                                       */
/*                   &info,                                           */
/*                   sizeof(info),                                    */
/*                   &ulLength);                                      */
/*                                                                    */
/* On successful invocation, info is filled with the relevant data:   */
/*                                                                    */
/* PROTOCOLINFO.protocol is the protocol # in use (PDIPRO_)           */
/* PROTOCOLINFO.kbd_state is 0 if the mouse driver is not (yet)       */
/*              attached to the keyboard driver, 1 otherwise          */
/* PROTOCOLINFO.capability is a combination of PP_ values             */
/* PROTOCOLINFO.extrabuttons is the number of supported extra buttons */
/*                                                                    */
/* [This describes the _protocol_, not necessarily the mouse]         */

/* MOU_GETLEVEL1ACTIONS                                               */
/* MOU_GETLEVEL2ACTIONS                                               */
/* MOU_GETEXTRABUTTONSACTIONS                                         */
/*                                                                    */
/* Usage:                                                             */
/*                                                                    */
/*  USHORT ausActions[4];                                             */
/*                                                                    */
/*  ulAction = 0;                                                     */
/*  ulLength = sizeof(ausActions);                                    */
/*  rc = DosDevIOCtl(hf,                                              */
/*                   IOCTL_POINTINGDEVICE,                            */
/*                   MOU_GETxxxACTIONS,                               */
/*                   0,                                               */
/*                   0,                                               */
/*                   &ulAction,                                       */
/*                   ausActions,                                      */
/*                   sizeof(ausActions),                              */
/*                   &ulLength);                                      */
/*                                                                    */
/* On successful invocation, ausActions[] contains the four requested */
/* actions (i.e., key codes) at indices XA_.                          */
/*                                                                    */
/* [This queries the _current session_ actions]                       */

/* MOU_SETLEVEL1ACTIONS                                               */
/* MOU_SETLEVEL2ACTIONS                                               */
/* MOU_SETEXTRABUTTONSACTIONS                                         */
/*                                                                    */
/* Usage:                                                             */
/*                                                                    */
/*  USHORT ausActions[4];                                             */
/*                                                                    */
/*  ulAction = 0;                                                     */
/*  ulLength = sizeof(ausActions);                                    */
/*  rc = DosDevIOCtl(hf,                                              */
/*                   IOCTL_POINTINGDEVICE,                            */
/*                   MOU_SETxxxACTIONS,                               */
/*                   0,                                               */
/*                   0,                                               */
/*                   &ulAction,                                       */
/*                   ausActions,                                      */
/*                   sizeof(ausActions),                              */
/*                   &ulLength);                                      */
/*                                                                    */
/* On successful invocation, the four relevant actions are changed to */
/* the ones defined in ausActions at indices XA_.                     */
/*                                                                    */
/* As the actions are changed in block, it is recommended to perform  */
/* a MOU_GETxxxACTIONS beforehand if only one action is to be         */
/* modified.                                                          */
/*                                                                    */
/* [This sets the _current session_ actions]                          */

/* MOU_GETXMOUSEVER                                                   */
/*                                                                    */
/* Usage:                                                             */
/*                                                                    */
/*  XMOUSEVER ver;                                                    */
/*                                                                    */
/*  ulAction = 0;                                                     */
/*  ulLength = sizeof(ver);                                           */
/*  rc = DosDevIOCtl(hf,                                              */
/*                   IOCTL_POINTINGDEVICE,                            */
/*                   MOU_GETXMOUSEVER,                                */
/*                   0,                                               */
/*                   0,                                               */
/*                   &ulAction,                                       */
/*                   &ver,                                            */
/*                   sizeof(ver),                                     */
/*                   &ulLength);                                      */
/*                                                                    */
/* On successful invocation, XMOUSEVER.magic must contain "XMOUSE"    */
/* and XMOUSEVER.version the driver's revision level.                 */


#define MOU_QUERYDETECTEDID            0x73
#define MOU_QUERYPROTOCOLINFO          0x74
#define MOU_GETLEVEL1ACTIONS           0x75
#define MOU_GETLEVEL2ACTIONS           0x76
#define MOU_GETEXTRABUTTONSACTIONS     0x77
#define MOU_SETEXTRABUTTONSACTIONS     0x78
#define MOU_SETLEVEL2ACTIONS           0x79
#define MOU_SETLEVEL1ACTIONS           0x7A
#define MOU_GETXMOUSEVER               0x7B

#pragma pack(1)
/* MOU_QUERYPROTOCOLINFO helpers */
typedef struct
  {
  USHORT protocol;
  USHORT kbd_state;
  ULONG  capability;
  UCHAR  extrabuttons;
  } PROTOCOLINFO;

/* PROTOCOLINFO.protocol supported values */
#define PDIPRO_PS2        0
#define PDIPRO_PS2_3      1
#define PDIPRO_PS2_4      2
#define PDIPRO_CYBERNAV   3
#define PDIPRO_IM         4
#define PDIPRO_IME        5
#define PDIPRO_MMPPS2     6
#define PDIPRO_WMMPPS2    7
#define PDIPRO_MARBLEFX   8
#define PDIPRO_TRACKP_2   9
#define PDIPRO_TRACKP_3  10
#define PDIPRO_PRIMAXS   11
#define PDIPRO_SCRNRDR   12

/* PROTOCOLINFO.capability values (or-ed together as needed) */
#define PP_PLAIN      0x00000000
#define PP_WHEEL1     0x00000001
#define PP_WHEEL2     0x00000002
#define PP_STICK      0x00000004
#define PP_EXTRA      0x00000008
#define PP_READER     0x00000010
#define PP_WHEELS     (PP_WHEEL1|PP_WHEEL2)

/* MOU_GET/SETxxxACTIONS helpers */
#define XA_LEVEL1UP    0
#define XA_LEVEL1DOWN  1
#define XA_LEVEL1LEFT  2
#define XA_LEVEL1RIGHT 3

#define XA_LEVEL2UP    0
#define XA_LEVEL2DOWN  1
#define XA_LEVEL2LEFT  2
#define XA_LEVEL2RIGHT 3

#define XA_BUTTON4     0
#define XA_BUTTON5     1
#define XA_BUTTON6     2
#define XA_BUTTON7     3

/* MOU_GETXMOUSEVER helpers */
typedef struct
  {
  UCHAR  magic[6];
  USHORT version;
  } XMOUSEVER;
#pragma pack()
