/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.entities;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileComparatorProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class AbstractEntity
implements Entity {
    protected String mId;
    protected PolicySource mPolicySource;

    public void setPolicySource(PolicySource policySource) {
        this.mPolicySource = policySource;
    }

    public String getId() {
        return this.mId;
    }

    public abstract Entity getParent();

    public ProfileRepository getProfileRepository() throws SPIException {
        return this.mPolicySource.getProfileProvider().getProfileRepository(this.getId());
    }

    public Iterator getAssignedProfiles() throws SPIException {
        return this.mPolicySource.getAssignmentProvider().getAssignedProfiles(this);
    }

    public void assignProfile(Profile profile) throws SPIException {
        this.mPolicySource.getAssignmentProvider().assignProfile(this, profile);
    }

    public void unassignProfile(Profile profile) throws SPIException {
        this.mPolicySource.getAssignmentProvider().unassignProfile(this, profile);
    }

    public Iterator getAllParents() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Entity entity = this.getParent(); entity != null; entity = entity.getParent()) {
            arrayList.add(0, entity);
        }
        return arrayList.iterator();
    }

    public abstract Iterator getLayeredProfiles() throws SPIException;

    public Iterator getLayeredProfiles(Iterator iterator, Iterator iterator2) throws SPIException {
        Object object;
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Iterator iterator3 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (Entity)iterator.next();
                iterator3 = object.getAssignedProfiles();
                while (iterator3.hasNext()) {
                    arrayList.add((Profile)iterator3.next());
                }
            }
        }
        if (iterator2 != null) {
            Object object2;
            object = ((ProfileComparatorProvider)((Object)this.mPolicySource.getProfileProvider())).getProfileComparator();
            TreeSet treeSet = new TreeSet(object);
            while (iterator2.hasNext()) {
                object2 = (Entity)iterator2.next();
                Iterator iterator4 = object2.getAssignedProfiles();
                while (iterator4.hasNext()) {
                    treeSet.add(iterator4.next());
                }
            }
            object2 = treeSet.iterator();
            while (object2.hasNext()) {
                arrayList.add((Profile)object2.next());
            }
        }
        object = this.getAssignedProfiles();
        while (object.hasNext()) {
            arrayList.add((Profile)object.next());
        }
        return arrayList.iterator();
    }

    public String getPolicySourceName() {
        return this.mPolicySource.getName();
    }
}

