/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.assignments;

import com.sun.apoc.spi.AbstractAssignmentProvider;
import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.IllegalWriteException;
import com.sun.apoc.spi.OpenConnectionException;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.environment.InvalidParameterException;
import com.sun.apoc.spi.environment.MissingParameterException;
import com.sun.apoc.spi.profiles.InvalidProfileException;
import com.sun.apoc.spi.profiles.Profile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class FileAssignmentProvider
extends AbstractAssignmentProvider {
    private static final String DEFAULT_ASSIGN_CONTAINER = "assignments";
    private static final String DEFAULT_EXTENSION = ".dat";
    private URL mLocation;
    private Map mEntitiesAssign;
    private Map mProfilesAssign;
    private boolean mDataIsLoaded;
    private boolean mLoadingData;
    private boolean mReadOnly;
    private boolean mRemote;
    private File mFile;

    public FileAssignmentProvider(PolicySource policySource, String string) throws SPIException {
        if (string == null || string.length() == 0) {
            throw new MissingParameterException("domain PROVIDER_URL");
        }
        this.mPolicySource = policySource;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            stringBuffer.append('/');
        }
        if (!stringBuffer.toString().endsWith("assignments/")) {
            stringBuffer.append(DEFAULT_ASSIGN_CONTAINER).append('/');
        }
        try {
            this.mLocation = new URL(stringBuffer.toString());
            this.mRemote = !this.mLocation.getProtocol().equals("file");
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidParameterException("assignment PROVIDER_URL", stringBuffer.toString());
        }
    }

    public Iterator getEntitiesAssignedToProfile(Profile profile) throws SPIException {
        if (this.mRemote) {
            throw new UnsupportedOperationException();
        }
        LinkedList<Entity> linkedList = new LinkedList<Entity>();
        String[] stringArray = this.mFile.list();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string;
                HashSet hashSet;
                int n = stringArray[i].indexOf(DEFAULT_EXTENSION);
                if (n == -1 || !(hashSet = this.readAssignedProfileIDs(string = stringArray[i].substring(0, n).replace('+', ' '))).contains(profile.getId())) continue;
                linkedList.add(this.getEntity(string));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return linkedList.iterator();
    }

    public void assignProfileToEntity(Entity entity, Profile profile) throws SPIException {
        HashSet<String> hashSet = null;
        try {
            hashSet = this.readAssignedProfileIDs(entity.getId());
        }
        catch (SPIException sPIException) {
            hashSet = new HashSet<String>();
        }
        catch (IOException iOException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", iOException);
        }
        hashSet.add(profile.getId());
        this.writeAssignments(entity.getId(), hashSet);
    }

    public void unassignProfile(Entity entity, Profile profile) throws SPIException {
        HashSet hashSet = null;
        String string = profile.getId();
        try {
            hashSet = this.readAssignedProfileIDs(entity.getId());
        }
        catch (SPIException sPIException) {
            hashSet = new HashSet();
        }
        catch (IOException iOException) {
            throw new InvalidProfileException("error.spi.profile.invalid.noexist", string, (Throwable)iOException);
        }
        if (!hashSet.contains(string)) {
            throw new InvalidProfileException("error.spi.profile.invalid.noexist", string);
        }
        hashSet.remove(string);
        this.writeAssignments(entity.getId(), hashSet);
    }

    public Iterator getProfilesAssignedToEntity(Entity entity) throws SPIException {
        HashSet hashSet;
        try {
            hashSet = this.readAssignedProfileIDs(entity.getId());
        }
        catch (SPIException sPIException) {
            hashSet = new HashSet();
        }
        catch (IOException iOException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", iOException);
        }
        LinkedList<Profile> linkedList = new LinkedList<Profile>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.mPolicySource.getProfileProvider().getProfile((String)iterator.next()));
        }
        return linkedList.iterator();
    }

    public void open() throws SPIException {
        if (this.mRemote) {
            try {
                this.mLocation.openStream();
            }
            catch (IOException iOException) {
                throw new OpenConnectionException(this.mLocation.toString(), iOException);
            }
        }
        try {
            this.mFile = new File(new URI(this.mLocation.toString()));
            if (!this.mFile.exists()) {
                throw new IllegalReadException("error.spi.access.illegal.read.file.name", this.mFile.getAbsolutePath());
            }
            if (!this.mFile.isDirectory()) {
                throw new InvalidParameterException("profile PROVIDER_URL", this.mLocation.toString());
            }
            this.mReadOnly = !this.mFile.canWrite();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidParameterException("assignment PROVIDER_URL", this.mLocation.toString());
        }
    }

    public void close() throws SPIException {
    }

    private HashSet readAssignedProfileIDs(String string) throws MalformedURLException, IOException, SPIException {
        String string2;
        BufferedReader bufferedReader = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            StringBuffer stringBuffer;
            if (this.mRemote) {
                stringBuffer = new StringBuffer(URLEncoder.encode(string, System.getProperty("file.encoding")));
                stringBuffer.append(DEFAULT_EXTENSION);
                URL uRL = new URL(this.mLocation, stringBuffer.toString());
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            } else {
                stringBuffer = new StringBuffer(string.replace(' ', '+'));
                stringBuffer.append(DEFAULT_EXTENSION);
                bufferedReader = new BufferedReader(new FileReader(new File(this.mFile, stringBuffer.toString())));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (IOException iOException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", iOException);
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            hashSet.add(string2);
        }
        bufferedReader.close();
        return hashSet;
    }

    private void writeAssignments(String string, HashSet hashSet) throws SPIException {
        try {
            StringBuffer stringBuffer = new StringBuffer(string.replace(' ', '+'));
            stringBuffer.append(DEFAULT_EXTENSION);
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(this.mFile, stringBuffer.toString())));
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                printWriter.println((String)iterator.next());
            }
            printWriter.close();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.file", malformedURLException);
        }
        catch (IOException iOException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.file", iOException);
        }
    }

    private Entity getEntity(String string) throws SPIException {
        Entity entity = null;
        entity = this.mPolicySource.getEntityProvider().getEntity(string);
        return entity;
    }
}

