/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.OpenConnectionException;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.EntityTreeProvider;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.environment.InvalidParameterException;
import com.sun.apoc.spi.environment.MissingParameterException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class FileEntityProvider
implements EntityTreeProvider {
    protected PolicySource mPolicySource;
    protected boolean mDataIsLoaded;
    protected Node mRootNode;
    protected URL mLocation;

    public FileEntityProvider(PolicySource policySource, String string, String string2) throws SPIException {
        if (string == null || string.length() == 0) {
            throw new MissingParameterException("domain PROVIDER_URL");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            stringBuffer.append('/');
        }
        stringBuffer.append(string2);
        try {
            this.mLocation = new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidParameterException("domain PROVIDER_URL", stringBuffer.toString());
        }
        this.mPolicySource = policySource;
        this.mRootNode = null;
        this.mDataIsLoaded = false;
    }

    public void open() throws SPIException {
        block6: {
            if (this.mLocation.getProtocol().equals("file")) {
                try {
                    File file = new File(new URI(this.mLocation.toString()));
                    if (!file.exists()) {
                        throw new IllegalReadException("error.spi.access.illegal.read.file.name", file.getAbsolutePath());
                    }
                    break block6;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new InvalidParameterException("organization PROVIDER_URL", this.mLocation.toString());
                }
            }
            try {
                this.mLocation.openStream();
            }
            catch (IOException iOException) {
                throw new OpenConnectionException(this.mLocation.toString(), iOException);
            }
        }
    }

    public void close() throws SPIException {
    }

    public Node getRootEntity() throws SPIException {
        if (!this.mDataIsLoaded) {
            this.loadData();
            this.mDataIsLoaded = true;
        }
        return this.mRootNode;
    }

    public Entity getEntity(String string) throws SPIException {
        if (!this.mDataIsLoaded) {
            this.loadData();
        }
        return this.internalGetEntity(string);
    }

    protected Entity internalGetEntity(String string) throws SPIException {
        Entity entity = this.mRootNode;
        if (entity.getId().equals(string)) {
            return entity;
        }
        LinkedList linkedList = new LinkedList();
        this.addChilds(linkedList, (Node)entity);
        while (!linkedList.isEmpty()) {
            entity = (Entity)linkedList.removeFirst();
            if (entity.getId().equals(string)) {
                return entity;
            }
            if (!(entity instanceof Node)) continue;
            this.addChilds(linkedList, (Node)entity);
        }
        return null;
    }

    private void addChilds(LinkedList linkedList, Node node) throws SPIException {
        Iterator iterator = node.getChildren();
        while (iterator.hasNext()) {
            linkedList.add((Entity)iterator.next());
        }
    }

    protected abstract void loadData() throws SPIException;
}

