/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.profiles;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.OpenConnectionException;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.environment.InvalidParameterException;
import com.sun.apoc.spi.environment.MissingParameterException;
import com.sun.apoc.spi.file.entities.FileEntity;
import com.sun.apoc.spi.file.profiles.FileProfileComparator;
import com.sun.apoc.spi.file.profiles.FileProfileRepository;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileComparatorProvider;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FileProfileProvider
implements ProfileProvider,
ProfileComparatorProvider {
    private static final String DEFAULT_REP_CONTAINER = "profiles";
    private PolicySource mPolicySource;
    private boolean mRemoteRepository;
    private URL mLocation;

    public FileProfileProvider(PolicySource policySource, String string) throws SPIException {
        if (string == null || string.length() == 0) {
            throw new MissingParameterException("domain PROVIDER_URL");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            stringBuffer.append('/');
        }
        if (!stringBuffer.toString().endsWith("profiles/")) {
            stringBuffer.append(DEFAULT_REP_CONTAINER).append('/');
        }
        try {
            this.mLocation = new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidParameterException("domain PROVIDER_URL", stringBuffer.toString());
        }
        this.mPolicySource = policySource;
    }

    public ProfileRepository getDefaultProfileRepository() throws SPIException {
        return this.getProfileRepository("default");
    }

    public ProfileRepository getProfileRepository(String string) throws SPIException {
        URL uRL;
        FileProfileRepository fileProfileRepository = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("PROFILE_REPOSITORY_");
            stringBuffer.append(string.replace(' ', '+'));
            stringBuffer.append("/");
            uRL = new URL(this.mLocation, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", malformedURLException);
        }
        fileProfileRepository = new FileProfileRepository(this.mPolicySource, string, uRL);
        return fileProfileRepository;
    }

    public Profile getProfile(String string) throws SPIException {
        Profile profile = null;
        String[] stringArray = string.split("-");
        ProfileRepository profileRepository = this.getProfileRepository(stringArray[0]);
        profile = profileRepository.getProfile(string);
        return profile;
    }

    public void open() throws SPIException {
        block7: {
            if (this.mLocation.getProtocol().equals("file")) {
                this.mRemoteRepository = false;
                try {
                    File file = new File(new URI(this.mLocation.toString()));
                    if (!file.exists()) {
                        throw new IllegalReadException("error.spi.access.illegal.read.file.name", file.getAbsolutePath());
                    }
                    if (!file.isDirectory()) {
                        throw new InvalidParameterException("profile PROVIDER_URL", this.mLocation.toString());
                    }
                    break block7;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new InvalidParameterException("profile PROVIDER_URL", this.mLocation.toString());
                }
            }
            this.mRemoteRepository = true;
            try {
                this.mLocation.openStream();
            }
            catch (IOException iOException) {
                throw new OpenConnectionException(this.mLocation.toString(), iOException);
            }
        }
    }

    public void close() throws SPIException {
    }

    public Iterator getAllProfiles() throws SPIException {
        if (this.mRemoteRepository) {
            throw new UnsupportedOperationException();
        }
        LinkedList linkedList = new LinkedList();
        try {
            File file = new File(new URI(this.mLocation.toString()));
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                if (!fileArray[i].isDirectory() || (string = FileProfileProvider.getRepIdFromFile(fileArray[i])) == null) continue;
                ProfileRepository profileRepository = this.getProfileRepository(string);
                Iterator iterator = profileRepository.getProfiles(Applicability.getApplicability(this.mPolicySource.getName()));
                FileProfileProvider.addProfiles(linkedList, iterator);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", uRISyntaxException);
        }
        return linkedList.iterator();
    }

    public Iterator getAllProfiles(Entity entity) throws SPIException {
        List list = new LinkedList();
        if (this.mRemoteRepository) {
            throw new UnsupportedOperationException();
        }
        if (entity instanceof LdapEntity && entity.equals(this.mPolicySource.getRoot())) {
            FileProfileProvider.addProfiles(list, entity.getProfileRepository().getProfiles(Applicability.getApplicability(this.mPolicySource.getName())));
            Iterator iterator = ((Node)entity).getChildren();
            while (iterator.hasNext()) {
                Entity entity2 = (Entity)iterator.next();
                list.addAll(this.getAllProfilesInSubEntity(entity2));
            }
        } else {
            list = this.getAllProfilesInSubEntity(entity);
        }
        return list.iterator();
    }

    private List getAllProfilesInSubEntity(Entity entity) throws SPIException {
        LinkedList linkedList = new LinkedList();
        try {
            File file = new File(new URI(this.mLocation.toString()));
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                if (!fileArray[i].isDirectory() || (string = FileProfileProvider.getRepIdFromFile(fileArray[i])) == null || !FileProfileProvider.isRepIdInSubEntity(string, entity)) continue;
                ProfileRepository profileRepository = this.getProfileRepository(string);
                Iterator iterator = profileRepository.getProfiles(Applicability.getApplicability(this.mPolicySource.getName()));
                FileProfileProvider.addProfiles(linkedList, iterator);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", uRISyntaxException);
        }
        return linkedList;
    }

    public Comparator getProfileComparator() {
        return new FileProfileComparator();
    }

    private static void addProfiles(List list, Iterator iterator) {
        while (iterator.hasNext()) {
            list.add((Profile)iterator.next());
        }
    }

    private static String getRepIdFromFile(File file) throws SPIException {
        String string = null;
        String string2 = file.getName();
        if (string2.startsWith("PROFILE_REPOSITORY_")) {
            try {
                string = URLDecoder.decode(string2.substring("PROFILE_REPOSITORY_".length()), System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalReadException("error.spi.access.illegal.read.file", unsupportedEncodingException);
            }
        }
        return string;
    }

    private static boolean isRepIdInSubEntity(String string, Entity entity) throws SPIException {
        boolean bl = false;
        String string2 = entity.getProfileRepository().getId();
        if (entity instanceof LdapEntity) {
            bl = string.endsWith(string2);
        } else if (entity instanceof FileEntity) {
            bl = string.startsWith(string2 + "_") || string.equals(string2);
        }
        return bl;
    }
}

