/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import netscape.ldap.LDAPConnection;

public class LdapConnectionPool {
    private Set mUsedConnections = new HashSet();
    private Stack mFreeConnections = new Stack();
    private String mServer = null;
    private int mPort = 389;
    private static final int MAX_CONN = 50;

    public LdapConnectionPool(String string, int n) {
        this.mServer = string;
        this.mPort = n;
    }

    public synchronized LDAPConnection getConnection() {
        LDAPConnection lDAPConnection = null;
        if (!this.mFreeConnections.empty()) {
            lDAPConnection = (LDAPConnection)this.mFreeConnections.pop();
            if (lDAPConnection.isConnected()) {
                this.mUsedConnections.add(lDAPConnection);
            } else {
                lDAPConnection = null;
            }
        }
        return lDAPConnection;
    }

    public synchronized void addConnection(LDAPConnection lDAPConnection) {
        if (this.mUsedConnections.size() + this.mFreeConnections.size() < 50) {
            this.mUsedConnections.add(lDAPConnection);
        }
    }

    public synchronized boolean closeConnection(LDAPConnection lDAPConnection) {
        if (this.mUsedConnections.contains(lDAPConnection)) {
            this.mUsedConnections.remove(lDAPConnection);
            this.mFreeConnections.push(lDAPConnection);
            return true;
        }
        return false;
    }
}

