/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.AbstractEntity;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.OrganizationTreeProvider;
import com.sun.apoc.spi.ldap.LdapConnectionHandler;
import com.sun.apoc.spi.ldap.entities.LdapEntityProvider;

public class LdapOrganizationProvider
extends LdapEntityProvider
implements OrganizationTreeProvider {
    public LdapOrganizationProvider(PolicySource policySource, String string) throws SPIException {
        super(policySource, string);
    }

    public void open() throws SPIException {
        if (this.mConnection == null && this.mEnvironmentMgr != null) {
            this.mConnection = new LdapConnectionHandler();
            this.mConnection.connect(this.mURL, this.mEnvironmentMgr.getOrganizationTimeout(), this.mEnvironmentMgr.getOrganizationAuthUser(), this.mEnvironmentMgr.getOrganizationAuthPassword(), this.mEnvironmentMgr);
            if (this.isGSSAPIAuthentication()) {
                Object object = this.mEnvironmentMgr.getOrganizationCallbackHandler();
                this.mConnection.authenticate(object);
            } else {
                this.mConnection.authenticate(this.mEnvironmentMgr.getOrganizationUser(this.mURL), this.mEnvironmentMgr.getOrganizationCredentials());
            }
            this.mConnection.closeAuthorizedContext();
            this.mPolicySource.setConnectionHandler(this.mURL, this.mConnection);
        }
        this.mDataStore = this.mConnection.getDataStore();
        this.mRootNode = this.mDataStore.getRootOrganization();
        ((AbstractEntity)((Object)this.mRootNode)).setPolicySource(this.mPolicySource);
    }

    protected boolean isGSSAPIAuthentication() {
        return this.mEnvironmentMgr.getOrganizationAuthType().equals("GSSAPI");
    }

    public Organization getRootOrganization() throws SPIException {
        return (Organization)super.getRootEntity();
    }
}

