/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities.mapping;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.environment.InvalidParameterException;
import com.sun.apoc.spi.environment.MissingParameterException;
import com.sun.apoc.spi.util.MetaConfiguration;
import java.util.StringTokenizer;

public class LdapEntityMapping {
    public static final String VALUE_SEPARATOR = ",";
    public static final String NAME_SEPARATOR = "/";
    private static final String ORG_KEY = "Organization/";
    private static final String DOMAIN_KEY = "Domain/";
    private static final String USER_KEY = "User/";
    private static final String HOST_KEY = "Host/";
    private static final String ROLE_KEY = "Role/";
    public static final String OBJCLASS = "ObjectClass";
    public static final String NAMING_ATTR = "NamingAttribute";
    public static final String CONTAINER = "Container";
    public static final String UNIQUE_ATTR = "UniqueIdAttribute";
    public static final String MEMBER_ATTR = "MemberAttribute";
    public static final String LISTING_ATTR = "VirtualMemberAttribute";
    public static final String DISPLAY = "DisplayNameFormat";
    public ContainerMapping mOrganizationMapping = null;
    public ContainerMapping mDomainMapping = null;
    public ListMapping mRoleMapping = null;
    public UserMapping mUserMapping = null;
    public ItemMapping mHostMapping = null;

    public LdapEntityMapping(MetaConfiguration metaConfiguration) throws SPIException {
        this.mOrganizationMapping = new ContainerMapping(ORG_KEY, metaConfiguration);
        this.mDomainMapping = new ContainerMapping(DOMAIN_KEY, metaConfiguration);
        this.mRoleMapping = new ListMapping(ROLE_KEY, metaConfiguration);
        this.mUserMapping = new UserMapping(USER_KEY, metaConfiguration);
        this.mHostMapping = new ItemMapping(HOST_KEY, metaConfiguration);
    }

    public static class UserMapping
    extends ItemMapping {
        String mDisplayFormat = null;
        String[] mDisplayAttributes = null;
        String[] mSearchAttributes = null;
        static final String DEFAULT_DISPLAY_FORMAT = "sn, givenname";

        UserMapping(String string, MetaConfiguration metaConfiguration) throws SPIException {
            super(string, metaConfiguration);
            this.mDisplayFormat = metaConfiguration.getString(string + LdapEntityMapping.DISPLAY);
            if (this.mDisplayFormat == null || this.mDisplayFormat.length() == 0) {
                this.mDisplayFormat = DEFAULT_DISPLAY_FORMAT;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.mDisplayFormat, LdapEntityMapping.VALUE_SEPARATOR);
            int n = 0;
            this.mDisplayAttributes = new String[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                this.mDisplayAttributes[n++] = stringTokenizer.nextToken().trim();
            }
        }

        public String getDisplayFormat() {
            return this.mDisplayFormat;
        }

        public String[] getDisplayAttributes() {
            return this.mDisplayAttributes;
        }

        public String[] getSearchAttributes() {
            if (this.mSearchAttributes == null) {
                this.mSearchAttributes = new String[1];
                this.mSearchAttributes[0] = this.mUniqueAttribute;
            }
            return this.mSearchAttributes;
        }
    }

    public static class ItemMapping {
        String mObjectClass = null;
        String mUniqueAttribute = null;
        String mContainerEntry = null;

        ItemMapping(String string, MetaConfiguration metaConfiguration) throws SPIException {
            this.mObjectClass = metaConfiguration.getString(string + LdapEntityMapping.OBJCLASS);
            this.mUniqueAttribute = metaConfiguration.getString(string + LdapEntityMapping.UNIQUE_ATTR);
            if (this.mObjectClass == null) {
                throw new MissingParameterException(string + LdapEntityMapping.OBJCLASS);
            }
            if (this.mUniqueAttribute == null) {
                throw new MissingParameterException(string + LdapEntityMapping.UNIQUE_ATTR);
            }
            this.mContainerEntry = metaConfiguration.getString(string + LdapEntityMapping.CONTAINER);
            if (this.mContainerEntry != null && this.mContainerEntry.length() == 0) {
                this.mContainerEntry = null;
            }
        }

        public String getObjectClass() {
            return this.mObjectClass;
        }

        public String getUniqueAttribute() {
            return this.mUniqueAttribute;
        }

        public String getContainerEntry() {
            return this.mContainerEntry;
        }
    }

    public static class ListMapping
    extends ContainerMapping {
        String mMemberAttribute;
        String mListingAttribute;
        String mContainerEntry;

        ListMapping(String string, MetaConfiguration metaConfiguration) throws SPIException {
            super(string, metaConfiguration);
            this.mMemberAttribute = metaConfiguration.getString(string + LdapEntityMapping.MEMBER_ATTR);
            this.mListingAttribute = metaConfiguration.getString(string + LdapEntityMapping.LISTING_ATTR);
            if (this.mMemberAttribute == null) {
                throw new MissingParameterException(string + LdapEntityMapping.MEMBER_ATTR);
            }
            if (this.mListingAttribute == null) {
                throw new MissingParameterException(string + LdapEntityMapping.LISTING_ATTR);
            }
            this.mContainerEntry = metaConfiguration.getString(string + LdapEntityMapping.CONTAINER);
            if (this.mContainerEntry != null && this.mContainerEntry.length() == 0) {
                this.mContainerEntry = null;
            }
        }

        public String getContainerEntry() {
            return this.mContainerEntry;
        }

        public String getMemberAttribute() {
            return this.mMemberAttribute;
        }

        public String getListingAttribute() {
            return this.mListingAttribute;
        }
    }

    public static class ContainerMapping {
        String[] mObjectClasses;
        String[] mNamingAttributes;

        ContainerMapping(String string, MetaConfiguration metaConfiguration) throws SPIException {
            this.mObjectClasses = metaConfiguration.getStrings(string + LdapEntityMapping.OBJCLASS);
            this.mNamingAttributes = metaConfiguration.getStrings(string + LdapEntityMapping.NAMING_ATTR);
            if (this.mObjectClasses == null) {
                throw new MissingParameterException(string + LdapEntityMapping.OBJCLASS);
            }
            if (this.mNamingAttributes == null) {
                throw new MissingParameterException(string + LdapEntityMapping.NAMING_ATTR);
            }
            if (this.mObjectClasses.length != this.mNamingAttributes.length) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.mNamingAttributes.length; ++i) {
                    stringBuffer.append(this.mNamingAttributes[i]);
                }
                throw new InvalidParameterException(string + LdapEntityMapping.NAMING_ATTR, stringBuffer.toString());
            }
        }

        public String[] getObjectClasses() {
            return this.mObjectClasses;
        }

        public String[] getNamingAttributes() {
            return this.mNamingAttributes;
        }
    }
}

