/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.profiles;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.ldap.LdapConnectionHandler;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import com.sun.apoc.spi.ldap.profiles.LdapProfileComparator;
import com.sun.apoc.spi.ldap.profiles.LdapProfileRepository;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileComparatorProvider;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.Comparator;
import java.util.Iterator;

public class LdapProfileProvider
implements ProfileProvider,
ProfileComparatorProvider {
    protected PolicySource mPolicySource;
    protected LdapConnectionHandler mConnection;
    protected LdapDataStore mDataStore;
    protected LdapEnvironmentMgr mEnvironmentMgr;
    protected String mURL;

    public LdapProfileProvider(PolicySource policySource, String string) throws SPIException {
        this.mPolicySource = policySource;
        this.mEnvironmentMgr = new LdapEnvironmentMgr(this.mPolicySource.getEnvironment());
        String string2 = string;
        this.mConnection = (LdapConnectionHandler)this.mPolicySource.getConnectionHandler(string2);
        if (this.mConnection == null) {
            this.mEnvironmentMgr.checkEnvironment();
        }
    }

    public Comparator getProfileComparator() {
        return new LdapProfileComparator();
    }

    public void open() throws SPIException {
        if (this.mConnection == null && this.mEnvironmentMgr != null) {
            this.mConnection = new LdapConnectionHandler();
            this.mConnection.connect(this.mURL, this.mEnvironmentMgr.getProfileTimeout(), this.mEnvironmentMgr.getProfileAuthUser(), this.mEnvironmentMgr.getProfileAuthPassword(), this.mEnvironmentMgr);
            if (this.isGSSAPIAuthentication()) {
                Object object = this.mEnvironmentMgr.getProfileCallbackHandler();
                this.mConnection.authenticate(object);
            } else {
                this.mConnection.authenticate(this.mEnvironmentMgr.getProfileUser(this.mURL), this.mEnvironmentMgr.getProfileCredentials());
            }
            this.mConnection.closeAuthorizedContext();
            this.mPolicySource.setConnectionHandler(this.mURL, this.mConnection);
        }
        this.mDataStore = this.mConnection.getDataStore();
    }

    public void close() throws SPIException {
        if (this.mPolicySource.getConnectionHandler(this.mURL) != null) {
            this.mPolicySource.setConnectionHandler(this.mURL, null);
        }
        this.mConnection.disconnect();
    }

    protected boolean isGSSAPIAuthentication() {
        return this.mEnvironmentMgr.getProfileAuthType().equals("GSSAPI");
    }

    public ProfileRepository getDefaultProfileRepository() throws SPIException {
        Entity entity = this.mPolicySource.getRoot();
        if (entity != null) {
            return this.getProfileRepository(entity.getId());
        }
        return null;
    }

    public ProfileRepository getProfileRepository(String string) throws SPIException {
        return new LdapProfileRepository(string, this.mPolicySource);
    }

    public Profile getProfile(String string) throws SPIException {
        return this.mDataStore.getProfile(string);
    }

    public Iterator getAllProfiles() throws SPIException {
        return this.mDataStore.getAllProfiles(this.mPolicySource, (LdapEntity)this.mPolicySource.getRoot(), Applicability.getApplicability(this.mPolicySource.getName()));
    }

    public Iterator getAllProfiles(Entity entity) throws SPIException {
        return this.mDataStore.getAllProfiles(this.mPolicySource, (LdapEntity)entity, Applicability.getApplicability(this.mPolicySource.getName()));
    }

    public LdapDataStore getDataStore() {
        return this.mDataStore;
    }
}

