/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.memory;

import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.profiles.Profile;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class AssignmentProviderImpl
implements AssignmentProvider {
    private Hashtable m_assignments = new Hashtable();
    private PolicySource m_mgr = null;

    public AssignmentProviderImpl(PolicySource policySource) {
        this.m_mgr = policySource;
    }

    public void open() {
    }

    public void close() {
        this.m_mgr = null;
        this.m_assignments.clear();
    }

    public void assignProfile(Entity entity, Profile profile) {
        HashSet<Profile> hashSet = (HashSet<Profile>)this.m_assignments.get(entity);
        if (hashSet == null) {
            hashSet = new HashSet<Profile>();
            this.m_assignments.put(entity, hashSet);
        }
        hashSet.add(profile);
    }

    public void unassignProfile(Entity entity, Profile profile) {
        HashSet hashSet = (HashSet)this.m_assignments.get(entity);
        if (hashSet != null) {
            hashSet.remove(profile);
        }
    }

    public Iterator getAssignedProfiles(Entity entity) {
        HashSet hashSet = (HashSet)this.m_assignments.get(entity);
        if (hashSet != null) {
            return hashSet.iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public Iterator getAssignedEntities(Profile profile) {
        HashSet<Entity> hashSet = new HashSet<Entity>();
        Iterator iterator = this.m_assignments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Entity entity = (Entity)entry.getKey();
            HashSet hashSet2 = (HashSet)entry.getValue();
            if (!hashSet2.contains(profile)) continue;
            hashSet.add(entity);
        }
        return hashSet.iterator();
    }
}

