/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.memory.entities;

import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;

public class EntityImpl
implements Entity {
    private String m_displayName = "";
    private String m_id = "";
    private Entity m_parent = null;
    private PolicySource m_mgr = null;

    public EntityImpl(PolicySource policySource, Entity entity, String string, String string2) {
        this.m_mgr = policySource;
        this.m_parent = entity;
        this.m_displayName = string2;
        this.m_id = string;
    }

    public String getDisplayName(Locale locale) {
        return this.m_displayName;
    }

    public Iterator getAncestorNames(Locale locale) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Entity entity = this.getParent(); entity != null; entity = entity.getParent()) {
            linkedList.add(0, entity.getDisplayName(locale));
        }
        return linkedList.iterator();
    }

    public String getId() {
        return this.m_id;
    }

    public Entity getParent() {
        return this.m_parent;
    }

    public Iterator getAssignedProfiles() throws SPIException {
        return this.m_mgr.getAssignmentProvider().getAssignedProfiles(this);
    }

    public void assignProfile(Profile profile) throws SPIException {
        this.m_mgr.getAssignmentProvider().assignProfile(this, profile);
    }

    public void unassignProfile(Profile profile) throws SPIException {
        this.m_mgr.getAssignmentProvider().unassignProfile(this, profile);
    }

    public Iterator getLayeredProfiles() throws SPIException {
        return null;
    }

    public ProfileRepository getProfileRepository() throws SPIException {
        if (this.getParent() != null) {
            return this.m_mgr.getProfileProvider().getProfileRepository(this.getId());
        }
        return this.m_mgr.getProfileProvider().getDefaultProfileRepository();
    }

    public String getPolicySourceName() {
        return this.m_mgr.getName();
    }
}

