/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.profiles;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipProfileReadWrite {
    public static final String PRODUCT_VERSION = "2.0";
    public static final String APOC_VERSION = "ApocVersion";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String COMMENT = "Comment";
    public static final String APPLICABILITY = "Applicability";
    public static final String PRIORITY = "Priority";
    public static final String AUTHOR = "Author";
    public static final String LAST_MODIFIED = "LastModified";
    public static final String META_INF_ENTRY = "META-INF/general.properties";
    public static final String ENTRY_SUFFIX = ".xml";
    public static final String ENTRY_ENCODING = "UTF-8";
    public static final char COMPONENT_SEPARATOR = '.';
    public static final char ENTRY_SEPARATOR = '/';
    public static final String OLD_ENTRY_SUFFIX = ".xcu";

    public static void writeMetaData(Profile profile, ZipOutputStream zipOutputStream) throws IOException, SPIException {
        Properties properties = new Properties();
        properties.put(APOC_VERSION, PRODUCT_VERSION);
        properties.put(DISPLAY_NAME, profile.getDisplayName());
        properties.put(COMMENT, profile.getComment());
        properties.put(AUTHOR, profile.getAuthor());
        properties.put(PRIORITY, new Integer(profile.getPriority()).toString());
        properties.put(APPLICABILITY, profile.getApplicability().getStringValue());
        properties.put(LAST_MODIFIED, Long.toString(profile.getLastModified()));
        ZipEntry zipEntry = new ZipEntry(META_INF_ENTRY);
        zipOutputStream.putNextEntry(zipEntry);
        properties.store(zipOutputStream, null);
        zipOutputStream.closeEntry();
    }

    public static void writePolicies(Profile profile, ZipOutputStream zipOutputStream) throws IOException, SPIException {
        Iterator iterator = profile.getPolicies();
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(policy.getId());
            stringBuffer.append(ENTRY_SUFFIX);
            ZipEntry zipEntry = new ZipEntry(stringBuffer.toString());
            zipEntry.setTime(policy.getLastModified());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = policy.getData().getBytes(ENTRY_ENCODING);
            zipOutputStream.write(byArray, 0, byArray.length);
            zipOutputStream.closeEntry();
        }
    }

    public static Properties readMetaData(ZipInputStream zipInputStream) throws IOException {
        Properties properties = null;
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null && zipEntry.getName().equals(META_INF_ENTRY)) {
            properties = new Properties();
            properties.load(zipInputStream);
            zipInputStream.closeEntry();
        }
        return properties;
    }

    public static Iterator readPolicies(ZipInputStream zipInputStream) throws IOException {
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string = zipEntry.getName();
            int n = string.indexOf(ENTRY_SUFFIX);
            if (n > 0) {
                string = string.substring(0, n);
                byte[] byArray = new byte[1024];
                StringBuffer stringBuffer = new StringBuffer();
                while (zipInputStream.available() != 0) {
                    int n2 = zipInputStream.read(byArray, 0, byArray.length);
                    if (n2 <= 0) continue;
                    stringBuffer.append(new String(byArray, 0, n2, ENTRY_ENCODING));
                }
                Policy policy = new Policy(string, stringBuffer.toString(), zipEntry.getTime());
                arrayList.add(policy);
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        return arrayList.iterator();
    }

    public static Iterator readOldPoliciesFormat(ZipInputStream zipInputStream) throws IOException {
        ArrayList<Policy> arrayList = new ArrayList<Policy>();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string;
            int n;
            if (!zipEntry.isDirectory() && (n = (string = zipEntry.getName()).length() - OLD_ENTRY_SUFFIX.length()) > 0 && string.substring(n).equals(OLD_ENTRY_SUFFIX)) {
                string = string.substring(0, n).replace('/', '.');
                byte[] byArray = new byte[1024];
                StringBuffer stringBuffer = new StringBuffer();
                while (zipInputStream.available() != 0) {
                    int n2 = zipInputStream.read(byArray, 0, byArray.length);
                    if (n2 <= 0) continue;
                    stringBuffer.append(new String(byArray, 0, n2, ENTRY_ENCODING));
                }
                Policy policy = new Policy(string, stringBuffer.toString());
                arrayList.add(policy);
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        return arrayList.iterator();
    }
}

