/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModDNContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class LDAPModify
extends LDAPTool {
    private static boolean m_continuous = false;
    private static boolean m_force = false;
    private static boolean m_add = false;
    private static boolean m_binaryFiles = false;
    private static String m_rejectsFile = null;
    private static LDIF m_ldif = null;
    private static String m_file = null;

    private static LDAPAttribute checkFiles(LDAPAttribute attr) {
        LDAPAttribute newAttr = new LDAPAttribute(attr.getName());
        Enumeration e = attr.getStringValues();
        if (e != null) {
            while (e.hasMoreElements()) {
                String val = (String)e.nextElement();
                if (val != null && val.length() > 1) {
                    try {
                        File file = new File(val);
                        FileInputStream fi = new FileInputStream(file);
                        byte[] bval = new byte[(int)file.length()];
                        fi.read(bval, 0, (int)file.length());
                        newAttr.addValue(bval);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        newAttr.addValue(val);
                    }
                    catch (IOException iOException) {
                        System.err.println("Unable to read value from file " + val);
                        if (!m_continuous) {
                            System.exit(1);
                        }
                        newAttr = null;
                    }
                    continue;
                }
                newAttr.addValue(val);
            }
        } else {
            System.err.println("Failed to do string conversion for " + attr.getName());
        }
        return newAttr;
    }

    private static void doModify() throws IOException {
        PrintWriter reject = null;
        LDAPConstraints baseCons = null;
        if (!LDAPTool.m_justShow) {
            baseCons = LDAPTool.m_client.getConstraints();
            Vector<LDAPControl> controlVector = new Vector<LDAPControl>();
            if (LDAPTool.m_proxyControl != null) {
                controlVector.addElement(LDAPTool.m_proxyControl);
            }
            if (LDAPTool.m_ordinary) {
                controlVector.addElement(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
            }
            if (controlVector.size() > 0) {
                Object[] controls = new LDAPControl[controlVector.size()];
                controlVector.copyInto(controls);
                baseCons.setServerControls((LDAPControl[])controls);
            }
            baseCons.setReferrals(LDAPTool.m_referrals);
            if (LDAPTool.m_referrals) {
                LDAPTool.setDefaultReferralCredentials(baseCons);
            }
            baseCons.setHopLimit(LDAPTool.m_hopLimit);
        }
        LDIFRecord rec = m_ldif.nextRecord();
        while (rec != null) {
            LDAPControl[] newControls;
            LDAPConstraints cons = baseCons;
            if (!LDAPTool.m_justShow && (newControls = rec.getControls()) != null) {
                LDAPControl[] controls = newControls;
                LDAPControl[] oldControls = baseCons.getServerControls();
                if (oldControls != null) {
                    controls = new LDAPControl[oldControls.length + newControls.length];
                    int i = 0;
                    while (i < oldControls.length) {
                        controls[i] = oldControls[i];
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < newControls.length) {
                        controls[i2 + oldControls.length] = newControls[i2];
                        ++i2;
                    }
                }
                cons = (LDAPSearchConstraints)baseCons.clone();
                cons.setServerControls(controls);
            }
            LDIFContent content = rec.getContent();
            LDAPModification[] mods = null;
            LDAPAttribute[] addAttrs = null;
            boolean doDelete = false;
            boolean doModDN = false;
            LDAPEntry newEntry = null;
            if (content instanceof LDIFModifyContent) {
                mods = ((LDIFModifyContent)content).getModifications();
            } else if (content instanceof LDIFAddContent) {
                addAttrs = ((LDIFAddContent)content).getAttributes();
            } else if (content instanceof LDIFAttributeContent) {
                if (m_add) {
                    addAttrs = ((LDIFAttributeContent)content).getAttributes();
                } else {
                    LDAPAttribute[] tmpAttrs = ((LDIFAttributeContent)content).getAttributes();
                    mods = new LDAPModification[tmpAttrs.length];
                    int ta = 0;
                    while (ta < tmpAttrs.length) {
                        mods[ta] = new LDAPModification(2, tmpAttrs[ta]);
                        ++ta;
                    }
                }
            } else if (content instanceof LDIFDeleteContent) {
                doDelete = true;
            } else if (content instanceof LDIFModDNContent) {
                doModDN = true;
            }
            if (addAttrs != null) {
                LDAPAttributeSet newAttrSet = new LDAPAttributeSet();
                int a = 0;
                while (a < addAttrs.length) {
                    newAttrSet.add(addAttrs[a]);
                    ++a;
                }
                newEntry = new LDAPEntry(rec.getDN(), newAttrSet);
            }
            boolean skip = false;
            if (m_binaryFiles) {
                LDAPAttribute newAttr;
                if (mods != null) {
                    int m = 0;
                    while (m < mods.length) {
                        LDAPModification mod = mods[m];
                        LDAPAttribute attr = mods[m].getAttribute();
                        newAttr = LDAPModify.checkFiles(attr);
                        if (newAttr == null) {
                            skip = true;
                        } else {
                            mods[m] = new LDAPModification(mod.getOp(), newAttr);
                        }
                        ++m;
                    }
                } else if (addAttrs != null) {
                    LDAPAttributeSet newAttrSet = new LDAPAttributeSet();
                    int a = 0;
                    while (a < addAttrs.length) {
                        LDAPAttribute attr = addAttrs[a];
                        newAttr = LDAPModify.checkFiles(attr);
                        if (newAttr == null) {
                            skip = true;
                            break;
                        }
                        newAttrSet.add(newAttr);
                        ++a;
                    }
                    if (!skip) {
                        newEntry = new LDAPEntry(rec.getDN(), newAttrSet);
                    }
                }
            }
            int errCode = 0;
            if (!skip) {
                try {
                    if (mods != null) {
                        LDAPModificationSet modSet = new LDAPModificationSet();
                        System.out.println("\nmodifying entry " + rec.getDN());
                        int m = 0;
                        while (m < mods.length) {
                            if (LDAPTool.m_verbose) {
                                System.out.println("\t" + mods[m]);
                            }
                            modSet.add(mods[m].getOp(), mods[m].getAttribute());
                            ++m;
                        }
                        if (!LDAPTool.m_justShow) {
                            LDAPTool.m_client.modify(rec.getDN(), modSet, cons);
                        }
                    } else if (newEntry != null) {
                        System.out.println("\nadding new entry " + newEntry.getDN());
                        if (LDAPTool.m_verbose) {
                            LDAPAttributeSet set = newEntry.getAttributeSet();
                            int a = 0;
                            while (a < set.size()) {
                                System.out.println("\t" + set.elementAt(a));
                                ++a;
                            }
                        }
                        if (!LDAPTool.m_justShow) {
                            LDAPTool.m_client.add(newEntry, cons);
                        }
                    } else if (doDelete) {
                        System.out.println("\ndeleting entry " + rec.getDN());
                        if (!LDAPTool.m_justShow) {
                            LDAPTool.m_client.delete(rec.getDN(), cons);
                        }
                    } else if (doModDN) {
                        System.out.println("\nmodifying RDN of entry " + rec.getDN() + " and/or moving it beneath a new parent");
                        if (LDAPTool.m_verbose) {
                            System.out.println("\t" + content.toString());
                        }
                        if (!LDAPTool.m_justShow) {
                            LDIFModDNContent moddnContent = (LDIFModDNContent)content;
                            LDAPTool.m_client.rename(rec.getDN(), moddnContent.getRDN(), moddnContent.getNewParent(), moddnContent.getDeleteOldRDN(), cons);
                            System.out.println("rename completed");
                        }
                    }
                }
                catch (LDAPException e) {
                    System.err.println(String.valueOf(rec.getDN()) + ": " + e.errorCodeToString());
                    if (e.getLDAPErrorMessage() != null) {
                        System.err.println("additional info: " + e.getLDAPErrorMessage());
                    }
                    if (!m_continuous) {
                        System.exit(1);
                    }
                    skip = true;
                    errCode = e.getLDAPResultCode();
                }
            }
            if (skip && m_rejectsFile != null) {
                try {
                    if (reject == null) {
                        reject = new PrintWriter(new FileOutputStream(m_rejectsFile));
                    }
                }
                catch (Exception exception) {}
                if (reject != null) {
                    reject.println("dn: " + rec.getDN() + " # Error: " + errCode);
                    if (mods != null) {
                        int m = 0;
                        while (m < mods.length) {
                            reject.println(mods[m].toString());
                            ++m;
                        }
                    } else if (newEntry != null) {
                        reject.println("Add " + newEntry.toString());
                    } else if (doDelete) {
                        reject.println("Delete " + rec.getDN());
                    } else if (doModDN) {
                        reject.println("ModDN " + ((LDIFModDNContent)content).toString());
                    }
                    reject.flush();
                }
            }
            rec = m_ldif.nextRecord();
        }
        System.exit(0);
    }

    private static void doUsage() {
        System.err.println("usage: LDAPModify [options]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -c            continuous mode (do not stop on errors)");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -f file       read modifications from file instead of standard input");
        System.err.println("  -a            add entries");
        System.err.println("  -b            read values that start with / from files (for bin attrs)");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -r            replace existing values by default");
        System.err.println("  -e rejectfile save rejected entries in 'rejfile'");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    protected static void extractParameters(String[] args) {
        String privateOpts = "abcHFre:f:";
        GetOpt options = LDAPTool.extractParameters(privateOpts, args);
        if (options.hasOption('H')) {
            LDAPModify.doUsage();
            System.exit(0);
        }
        if (options.hasOption('F')) {
            m_force = true;
        }
        if (options.hasOption('a')) {
            m_add = true;
        }
        if (options.hasOption('c')) {
            m_continuous = true;
        }
        if (options.hasOption('r')) {
            m_add = false;
        }
        if (options.hasOption('b')) {
            m_binaryFiles = true;
        }
        if (options.hasOption('f')) {
            m_file = options.getOptionParam('f');
        }
        if (options.hasOption('e')) {
            m_rejectsFile = options.getOptionParam('e');
        }
    }

    public static void main(String[] args) {
        LDAPModify.extractParameters(args);
        try {
            if (!LDAPTool.m_justShow) {
                LDAPTool.m_client = new LDAPConnection();
                LDAPTool.m_client.connect(LDAPTool.m_ldaphost, LDAPTool.m_ldapport);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: client connection failed!");
            System.exit(0);
        }
        try {
            if (!LDAPTool.m_justShow) {
                LDAPTool.m_client.authenticate(LDAPTool.m_version, LDAPTool.m_binddn, LDAPTool.m_passwd);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(0);
        }
        try {
            m_ldif = m_file != null ? new LDIF(m_file) : new LDIF();
        }
        catch (Exception e) {
            if (m_file == null) {
                m_file = "stdin";
            }
            System.err.println("Failed to read LDIF file " + m_file + ", " + e.toString());
            System.exit(0);
        }
        try {
            LDAPModify.doModify();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        try {
            if (!LDAPTool.m_justShow) {
                LDAPTool.m_client.disconnect();
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        System.exit(0);
    }
}

