/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;

public class LDAPCompareAttrNames
implements LDAPEntryComparator,
Serializable {
    static final long serialVersionUID = -2567450425231175944L;
    private String[] m_attrs;
    private boolean[] m_ascending;
    private Locale m_locale = null;
    private Collator m_collator = null;
    private boolean m_sensitive = true;

    public LDAPCompareAttrNames(String attribute) {
        this.m_attrs = new String[1];
        this.m_attrs[0] = attribute;
        this.m_ascending = new boolean[1];
        this.m_ascending[0] = true;
    }

    public LDAPCompareAttrNames(String attribute, boolean ascendingFlag) {
        this.m_attrs = new String[1];
        this.m_attrs[0] = attribute;
        this.m_ascending = new boolean[1];
        this.m_ascending[0] = ascendingFlag;
    }

    public LDAPCompareAttrNames(String[] attributes) {
        this.m_attrs = attributes;
        this.m_ascending = new boolean[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            this.m_ascending[i] = true;
            ++i;
        }
    }

    public LDAPCompareAttrNames(String[] attributes, boolean[] ascendingFlags) {
        this.m_attrs = attributes;
        this.m_ascending = ascendingFlags;
        if (this.m_ascending == null) {
            this.m_ascending = new boolean[attributes.length];
            int i = 0;
            while (i < attributes.length) {
                this.m_ascending[i] = true;
                ++i;
            }
        }
    }

    boolean attrGreater(LDAPEntry greater, LDAPEntry less, int attrPos) {
        Enumeration greaterAttrSet = greater.getAttributeSet().getAttributes();
        Enumeration lessAttrSet = less.getAttributeSet().getAttributes();
        String greaterValue = null;
        String lessValue = null;
        String attrName = this.m_attrs[attrPos];
        boolean ascending = this.m_ascending[attrPos];
        try {
            LDAPAttribute currAttr;
            while (lessAttrSet.hasMoreElements()) {
                currAttr = (LDAPAttribute)lessAttrSet.nextElement();
                if (!attrName.equalsIgnoreCase(currAttr.getName())) continue;
                lessValue = (String)currAttr.getStringValues().nextElement();
                break;
            }
            while (greaterAttrSet.hasMoreElements()) {
                currAttr = (LDAPAttribute)greaterAttrSet.nextElement();
                if (!attrName.equalsIgnoreCase(currAttr.getName())) continue;
                greaterValue = (String)currAttr.getStringValues().nextElement();
                break;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        if (lessValue == null ^ greaterValue == null) {
            return greaterValue != null;
        }
        if (lessValue == null || this.m_collator != null && this.m_collator.compare(greaterValue, lessValue) == 0 || this.m_collator == null && this.m_sensitive && lessValue.equals(greaterValue) || this.m_collator == null && !this.m_sensitive && lessValue.equalsIgnoreCase(greaterValue)) {
            if (attrPos == this.m_attrs.length - 1) {
                return false;
            }
            return this.attrGreater(greater, less, attrPos + 1);
        }
        if (ascending) {
            if (this.m_collator != null) {
                return this.m_collator.compare(greaterValue, lessValue) > 0;
            }
            if (this.m_sensitive) {
                return greaterValue.compareTo(lessValue) > 0;
            }
            return greaterValue.toLowerCase().compareTo(lessValue.toLowerCase()) > 0;
        }
        if (this.m_collator != null) {
            return this.m_collator.compare(greaterValue, lessValue) < 0;
        }
        if (this.m_sensitive) {
            return greaterValue.compareTo(lessValue) < 0;
        }
        return greaterValue.toLowerCase().compareTo(lessValue.toLowerCase()) < 0;
    }

    public boolean getCaseSensitive() {
        return this.m_sensitive;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public boolean isGreater(LDAPEntry greater, LDAPEntry less) {
        if (greater.equals(less)) {
            return false;
        }
        return this.attrGreater(greater, less, 0);
    }

    public void setCaseSensitive(boolean sensitive) {
        this.m_sensitive = sensitive;
    }

    public void setLocale(Locale locale) {
        if (this.m_sensitive) {
            this.setLocale(locale, 3);
        } else {
            this.setLocale(locale, 0);
        }
    }

    public void setLocale(Locale locale, int strength) {
        this.m_locale = locale;
        if (this.m_locale == null) {
            this.m_collator = null;
        } else {
            this.m_collator = Collator.getInstance(this.m_locale);
            this.m_collator.setStrength(strength);
        }
    }
}

