/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAsynchronousConnection;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseControl;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import netscape.ldap.LDAPSaslBind;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.client.opers.JDAPSearchResultReference;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPConnection
implements LDAPv3,
LDAPAsynchronousConnection,
Cloneable,
Serializable {
    static final long serialVersionUID = -8698420087475771144L;
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    public static final String TRACE_PROPERTY = "com.netscape.ldap.trace";
    public static final int NODELAY_SERIAL = -1;
    public static final int NODELAY_PARALLEL = 0;
    private static final String defaultFilter = "(objectClass=*)";
    private static final LDAPConstraints readConstraints = new LDAPSearchConstraints();
    private LDAPSearchConstraints m_defaultConstraints = new LDAPSearchConstraints();
    private LDAPConstraints m_rebindConstraints;
    private Vector m_responseListeners;
    private Vector m_searchListeners;
    private boolean m_bound;
    private String m_prevBoundDN;
    private String m_prevBoundPasswd;
    private String m_boundDN;
    private String m_boundPasswd;
    private int m_protocolVersion = 2;
    private LDAPConnSetupMgr m_connMgr;
    private int m_connSetupDelay = -1;
    private int m_connectTimeout = 0;
    private LDAPSocketFactory m_factory = null;
    private transient LDAPConnThread m_thread = null;
    private Vector m_attachedList = new Vector();
    private Hashtable m_responseControlTable = new Hashtable();
    private LDAPCache m_cache = null;
    static Hashtable m_threadConnTable = new Hashtable();
    private boolean m_anonymousBound = false;
    private Object m_security = null;
    private LDAPSaslBind m_saslBinder = null;
    private Properties m_securityProperties;
    private Hashtable m_properties = new Hashtable();
    private LDAPConnection m_referralConnection;
    private String m_authMethod = "none";
    private static final Float SdkVersion = new Float(4.15f);
    private static final Float ProtocolVersion = new Float(3.0f);
    private static final String SecurityVersion = new String("none,simple,sasl");
    private static final Float MajorVersion = new Float(4.0f);
    private static final Float MinorVersion = new Float(0.15f);
    private static final String DELIM = "#";
    private static final String PersistSearchPackageName = "netscape.ldap.controls.LDAPPersistSearchControl";
    static final String EXTERNAL_MECHANISM = "external";
    private static final String EXTERNAL_MECHANISM_PACKAGE = "com.netscape.sasl";
    static final String DEFAULT_SASL_PACKAGE = "com.netscape.sasl";
    static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    static final String SASL_PACKAGE_PROPERTY = "com.netscape.ldap.saslpackage";
    public static final int MAXBACKLOG = 30;
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static boolean debug = false;

    public LDAPConnection() {
        this.m_properties.put(LDAP_PROPERTY_SDK, SdkVersion);
        this.m_properties.put(LDAP_PROPERTY_PROTOCOL, ProtocolVersion);
        this.m_properties.put(LDAP_PROPERTY_SECURITY, SecurityVersion);
        this.m_properties.put("version.major", MajorVersion);
        this.m_properties.put("version.minor", MinorVersion);
    }

    public LDAPConnection(LDAPSocketFactory factory) {
        this();
        this.m_factory = factory;
    }

    public void abandon(int id) throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        int i = 0;
        while (i < 3) {
            try {
                this.m_thread.abandon(id);
                this.m_thread.sendRequest(null, new JDAPAbandonRequest(id), null, this.m_defaultConstraints);
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++i;
            }
        }
        if (this.m_thread == null) {
            throw new LDAPException("Failed to send abandon request to the server.", 80);
        }
    }

    public void abandon(LDAPSearchListener searchlistener) throws LDAPException {
        int[] ids = searchlistener.getMessageIDs();
        int i = 0;
        while (i < ids.length) {
            searchlistener.removeRequest(ids[i]);
            this.abandon(ids[i]);
            ++i;
        }
    }

    public void abandon(LDAPSearchResults searchResults) throws LDAPException {
        if (!this.isConnected() || searchResults == null) {
            return;
        }
        int id = searchResults.getMessageID();
        if (id != -1) {
            this.abandon(id);
        }
    }

    public void add(LDAPEntry entry) throws LDAPException {
        this.add(entry, this.m_defaultConstraints);
    }

    public void add(LDAPEntry entry, LDAPConstraints cons) throws LDAPException {
        this.internalBind(cons);
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPAttributeSet attrs = entry.getAttributeSet();
        LDAPAttribute[] attrList = new LDAPAttribute[attrs.size()];
        int i = 0;
        while (i < attrs.size()) {
            attrList[i] = attrs.elementAt(i);
            ++i;
        }
        boolean attrPosition = false;
        try {
            try {
                this.sendRequest(new JDAPAddRequest(entry.getDN(), attrList), myListener, cons);
                LDAPResponse response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 8, null, 0, null, null, false, null, entry, null, null);
            }
            Object var10_10 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public LDAPResponseListener add(LDAPEntry entry, LDAPResponseListener listener) throws LDAPException {
        return this.add(entry, listener, this.m_defaultConstraints);
    }

    public LDAPResponseListener add(LDAPEntry entry, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        LDAPAttributeSet attrs = entry.getAttributeSet();
        LDAPAttribute[] attrList = new LDAPAttribute[attrs.size()];
        int i = 0;
        while (i < attrs.size()) {
            attrList[i] = attrs.elementAt(i);
            ++i;
        }
        boolean attrPosition = false;
        this.sendRequest(new JDAPAddRequest(entry.getDN(), attrList), listener, cons);
        return listener;
    }

    public void add(LDAPEntry entry, LDAPSearchConstraints cons) throws LDAPException {
        this.add(entry, (LDAPConstraints)cons);
    }

    public void authenticate(int version, String dn, String passwd) throws LDAPException {
        this.authenticate(version, dn, passwd, this.m_defaultConstraints);
    }

    public void authenticate(int version, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.m_prevBoundDN = this.m_boundDN;
        this.m_prevBoundPasswd = this.m_boundPasswd;
        this.m_boundDN = dn;
        this.m_boundPasswd = passwd;
        this.m_anonymousBound = this.m_prevBoundDN == null || this.m_prevBoundPasswd == null;
        this.internalBind(version, true, cons);
    }

    public LDAPResponseListener authenticate(int version, String dn, String passwd, LDAPResponseListener listener) throws LDAPException {
        return this.authenticate(version, dn, passwd, listener, this.m_defaultConstraints);
    }

    public LDAPResponseListener authenticate(int version, String dn, String passwd, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.m_prevBoundDN = this.m_boundDN;
        this.m_prevBoundPasswd = this.m_boundPasswd;
        this.m_boundDN = dn;
        this.m_boundPasswd = passwd;
        this.m_protocolVersion = version;
        if (this.m_thread == null) {
            this.connect();
        } else if (this.m_thread.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPBindRequest(version, this.m_boundDN, this.m_boundPasswd), listener, cons);
        return listener;
    }

    public void authenticate(int version, String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.authenticate(version, dn, passwd, (LDAPConstraints)cons);
    }

    public void authenticate(String dn, String passwd) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, this.m_defaultConstraints);
    }

    public void authenticate(String dn, String mechanism, String packageName, Hashtable props, Object cbh) throws LDAPException {
        this.authenticate(dn, new String[]{mechanism}, packageName, props, cbh);
    }

    public void authenticate(String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, cons);
    }

    public void authenticate(String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.authenticate(dn, passwd, (LDAPConstraints)cons);
    }

    public void authenticate(String dn, Hashtable props, Object cbh) throws LDAPException {
        String[] attrs;
        LDAPEntry entry;
        LDAPAttribute attr;
        if (!this.isConnected()) {
            this.connect();
        }
        if ((attr = (entry = this.read("", attrs = new String[]{"supportedSaslMechanisms"})).getAttribute(attrs[0])) == null) {
            throw new LDAPException("Not found in root DSE: " + attrs[0], 16);
        }
        this.authenticate(dn, attr.getStringValueArray(), props, cbh);
    }

    public void authenticate(String dn, String[] mechanisms, String packageName, Hashtable props, Object cbh) throws LDAPException {
        if (!this.isConnected()) {
            this.connect();
        } else if (this.m_thread.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        this.m_boundDN = null;
        this.m_protocolVersion = 3;
        if (props == null) {
            props = new Hashtable();
        }
        this.m_saslBinder = new LDAPSaslBind(dn, mechanisms, packageName, props, cbh);
        this.m_saslBinder.bind(this);
        this.m_authMethod = "sasl";
        this.m_boundDN = dn;
    }

    public void authenticate(String dn, String[] mechanisms, Hashtable props, Object cbh) throws LDAPException {
        this.authenticate(dn, mechanisms, "com.netscape.sasl", props, cbh);
    }

    private void authenticateSSLConnection() throws LDAPException {
        if (this.m_factory != null && this.m_factory instanceof LDAPSSLSocketFactoryExt && ((LDAPSSLSocketFactoryExt)this.m_factory).isClientAuth()) {
            this.authenticate(null, EXTERNAL_MECHANISM, "com.netscape.sasl", null, null);
        }
    }

    public void bind(int version, String dn, String passwd) throws LDAPException {
        this.authenticate(version, dn, passwd, this.m_defaultConstraints);
    }

    public void bind(int version, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.authenticate(version, dn, passwd, cons);
    }

    public LDAPResponseListener bind(int version, String dn, String passwd, LDAPResponseListener listener) throws LDAPException {
        return this.bind(version, dn, passwd, listener, this.m_defaultConstraints);
    }

    public LDAPResponseListener bind(int version, String dn, String passwd, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        return this.authenticate(version, dn, passwd, listener, cons);
    }

    public void bind(String dn, String passwd) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, this.m_defaultConstraints);
    }

    public void bind(String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, cons);
    }

    public LDAPResponseListener bind(String dn, String passwd, LDAPResponseListener listener) throws LDAPException {
        return this.bind(this.m_protocolVersion, dn, passwd, listener, this.m_defaultConstraints);
    }

    public LDAPResponseListener bind(String dn, String passwd, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        return this.bind(this.m_protocolVersion, dn, passwd, listener, cons);
    }

    public void bind(String dn, Hashtable props, Object cbh) throws LDAPException {
        this.authenticate(dn, props, cbh);
    }

    public void bind(String dn, String[] mechanisms, Hashtable props, Object cbh) throws LDAPException {
        this.authenticate(dn, mechanisms, props, cbh);
    }

    private static boolean checkCommunicator() {
        try {
            Method m = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (m == null) {
                LDAPConnection.printDebug("Method is null");
                return false;
            }
            Object[] args = new Object[]{new String("UniversalConnect")};
            m.invoke(null, args);
            LDAPConnection.printDebug("UniversalConnect enabled");
            args[0] = new String("UniversalPropertyRead");
            m.invoke(null, args);
            LDAPConnection.printDebug("UniversalPropertyRead enabled");
            return true;
        }
        catch (LDAPException e) {
            LDAPConnection.printDebug("Exception: " + e.toString());
        }
        catch (Exception ie) {
            LDAPConnection.printDebug("Exception on invoking enablePrivilege: " + ie.toString());
        }
        return false;
    }

    void checkMsg(LDAPMessage m) throws LDAPException {
        if (m.getProtocolOp() instanceof JDAPResult) {
            JDAPResult response = (JDAPResult)((Object)m.getProtocolOp());
            int resultCode = response.getResultCode();
            if (resultCode == 0) {
                return;
            }
            if (resultCode == 10) {
                throw new LDAPReferralException("referral", resultCode, response.getReferrals());
            }
            if (resultCode == 9) {
                throw new LDAPReferralException("referral", resultCode, response.getErrorMessage());
            }
            throw new LDAPException("error result", resultCode, response.getErrorMessage(), response.getMatchedDN());
        }
        if (m.getProtocolOp() instanceof JDAPSearchResultReference) {
            String[] referrals = ((JDAPSearchResultReference)m.getProtocolOp()).getUrls();
            throw new LDAPReferralException("referral", 0, referrals);
        }
    }

    /*
     * Unable to fully structure code
     */
    void checkSearchMsg(LDAPSearchResults value, LDAPMessage msg, LDAPSearchConstraints cons, String dn, int scope, String filter, String[] attrs, boolean attrsOnly) throws LDAPException {
        block9: {
            value.setMsgID(msg.getMessageID());
            try {
                this.checkMsg(msg);
                if (msg.getProtocolOp().getType() != 5) {
                    value.add(msg);
                }
            }
            catch (LDAPReferralException e) {
                res = new Vector<E>();
                try {
                    this.performReferrals(e, (LDAPConstraints)cons, 3, dn, scope, filter, attrs, attrsOnly, null, null, null, res);
                }
                catch (LDAPException ex) {
                    if (msg.getProtocolOp() instanceof JDAPSearchResultReference) {
                        System.err.println("LDAPConnection.checkSearchMsg: ignoring bad referral");
                        return;
                    }
                    throw ex;
                }
                i = 0;
                ** while (i < res.size())
            }
lbl-1000:
            // 1 sources

            {
                value.addReferralEntries((LDAPSearchResults)res.elementAt(i));
                ++i;
                continue;
            }
lbl22:
            // 1 sources

            res = null;
            break block9;
            catch (LDAPException e) {
                if (e.getLDAPResultCode() == 11 || e.getLDAPResultCode() == 3 || e.getLDAPResultCode() == 4) {
                    value.add(e);
                }
                throw e;
            }
        }
    }

    public synchronized Object clone() {
        try {
            LDAPConnection c = (LDAPConnection)super.clone();
            if (!this.isConnected()) {
                this.internalBind(this.m_defaultConstraints);
            }
            c.m_defaultConstraints = (LDAPSearchConstraints)this.m_defaultConstraints.clone();
            c.m_responseListeners = null;
            c.m_searchListeners = null;
            c.m_bound = this.m_bound;
            c.m_connMgr = this.m_connMgr;
            c.m_connSetupDelay = this.m_connSetupDelay;
            c.m_boundDN = this.m_boundDN;
            c.m_boundPasswd = this.m_boundPasswd;
            c.m_prevBoundDN = this.m_prevBoundDN;
            c.m_prevBoundPasswd = this.m_prevBoundPasswd;
            c.m_anonymousBound = this.m_anonymousBound;
            c.setCache(this.m_cache);
            c.m_factory = this.m_factory;
            c.m_thread = this.m_thread;
            Hashtable hashtable = m_threadConnTable;
            synchronized (hashtable) {
                Vector v = (Vector)m_threadConnTable.get(this.m_thread);
                if (v == null) {
                    LDAPConnection.printDebug("Failed to clone");
                    Object var2_4 = null;
                    Object var4_5 = null;
                    return var2_4;
                }
                v.addElement(c);
            }
            c.m_thread.register(c);
            return c;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean compare(String DN2, LDAPAttribute attr) throws LDAPException {
        return this.compare(DN2, attr, this.m_defaultConstraints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compare(String DN2, LDAPAttribute attr, LDAPConstraints cons) throws LDAPException {
        LDAPResponseListener myListener;
        block8: {
            boolean bl;
            block7: {
                this.internalBind(cons);
                myListener = this.getResponseListener();
                Enumeration en = attr.getStringValues();
                String val = (String)en.nextElement();
                JDAPAVA ass = new JDAPAVA(attr.getName(), val);
                try {
                    try {
                        this.sendRequest(new JDAPCompareRequest(DN2, ass), myListener, cons);
                        LDAPResponse response = myListener.getResponse();
                        int resultCode = ((JDAPResult)((Object)response.getProtocolOp())).getResultCode();
                        if (resultCode == 5) {
                            boolean bl2 = false;
                            Object var11_14 = null;
                            this.releaseResponseListener(myListener);
                            return bl2;
                        }
                        if (resultCode == 6) {
                            bl = true;
                            break block7;
                        }
                        this.checkMsg(response);
                        break block8;
                    }
                    catch (LDAPReferralException e) {
                        Vector res = new Vector();
                        this.performReferrals(e, cons, 14, DN2, 0, null, null, false, null, null, attr, res);
                        boolean bool = false;
                        if (res.size() > 0) {
                            bool = (Boolean)res.elementAt(0);
                        }
                        boolean bl3 = bool;
                        Object var11_16 = null;
                        this.releaseResponseListener(myListener);
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    this.releaseResponseListener(myListener);
                    throw throwable;
                }
            }
            Object var11_15 = null;
            this.releaseResponseListener(myListener);
            return bl;
        }
        Object var11_17 = null;
        this.releaseResponseListener(myListener);
        return false;
    }

    public LDAPResponseListener compare(String dn, LDAPAttribute attr, LDAPResponseListener listener) throws LDAPException {
        return this.compare(dn, attr, listener, this.m_defaultConstraints);
    }

    public LDAPResponseListener compare(String dn, LDAPAttribute attr, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        Enumeration en = attr.getStringValues();
        String val = (String)en.nextElement();
        JDAPAVA ava = new JDAPAVA(attr.getName(), val);
        this.sendRequest(new JDAPCompareRequest(dn, ava), listener, cons);
        return listener;
    }

    public boolean compare(String DN2, LDAPAttribute attr, LDAPSearchConstraints cons) throws LDAPException {
        return this.compare(DN2, attr, (LDAPConstraints)cons);
    }

    private synchronized void connect() throws LDAPException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connMgr == null) {
            throw new LDAPException("no connection parameters", 89);
        }
        this.m_connMgr.openConnection();
        this.m_thread = this.getNewThread(this.m_connMgr, this.m_cache);
        this.authenticateSSLConnection();
    }

    public void connect(int version, String host, int port, String dn, String passwd) throws LDAPException {
        this.connect(version, host, port, dn, passwd, this.m_defaultConstraints);
    }

    public void connect(int version, String host, int port, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.setProtocolVersion(version);
        this.connect(host, port, dn, passwd, cons);
    }

    public void connect(int version, String host, int port, String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.connect(version, host, port, dn, passwd, (LDAPConstraints)cons);
    }

    public void connect(String host, int port) throws LDAPException {
        this.connect(host, port, null, null, this.m_defaultConstraints, false);
    }

    public void connect(String host, int port, String dn, String passwd) throws LDAPException {
        this.connect(host, port, dn, passwd, this.m_defaultConstraints, true);
    }

    public void connect(String host, int port, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.connect(host, port, dn, passwd, cons, true);
    }

    private void connect(String host, int port, String dn, String passwd, LDAPConstraints cons, boolean doAuthenticate) throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (host == null || host.equals("")) {
            throw new LDAPException("no host for connection", 89);
        }
        int defaultPort = port;
        StringTokenizer st = new StringTokenizer(host);
        String[] hostList = new String[st.countTokens()];
        int[] portList = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int colon = s.indexOf(58);
            if (colon > 0) {
                hostList[i] = s.substring(0, colon);
                portList[i] = Integer.parseInt(s.substring(colon + 1));
            } else {
                hostList[i] = s;
                portList[i] = defaultPort;
            }
            ++i;
        }
        this.m_connMgr = new LDAPConnSetupMgr(hostList, portList, this.m_factory);
        this.m_connMgr.setConnSetupDelay(this.m_connSetupDelay);
        this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        this.connect();
        if (doAuthenticate) {
            this.authenticate(dn, passwd, cons);
        }
    }

    public void connect(String host, int port, String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.connect(host, port, dn, passwd, (LDAPConstraints)cons);
    }

    private String createReferralConnectList(LDAPUrl[] urls) {
        String connectList = "";
        String host = null;
        int port = 0;
        int i = 0;
        while (urls != null && i < urls.length) {
            host = urls[i].getHost();
            port = urls[i].getPort();
            if (host == null || host.length() < 1) {
                host = this.getHost();
                port = this.getPort();
            }
            connectList = String.valueOf(connectList) + (i == 0 ? "" : " ") + host + ":" + port;
            ++i;
        }
        return connectList.length() == 0 ? null : connectList;
    }

    LDAPConnection createReferralConnection(LDAPReferralException e, LDAPConstraints cons) throws LDAPException {
        if (cons.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            throw e;
        }
        String connectList = this.createReferralConnectList(e.getURLs());
        if (connectList == null) {
            throw new LDAPException("No target URL in referral", 94);
        }
        LDAPConnection connection = null;
        connection = this.prepareReferral(connectList, cons);
        try {
            connection.authenticate(this.m_protocolVersion, this.m_boundDN, this.m_boundPasswd);
        }
        catch (LDAPException authEx) {
            try {
                connection.disconnect();
            }
            catch (LDAPException lDAPException) {}
            throw authEx;
        }
        return connection;
    }

    Object createTraceOutput(Object out) throws LDAPException {
        if (out instanceof String) {
            FilterOutputStream os = null;
            String file = (String)out;
            if (file.length() == 0) {
                os = System.err;
            } else {
                try {
                    boolean appendMode;
                    boolean bl = appendMode = file.charAt(0) == '+';
                    if (appendMode) {
                        file = file.substring(1);
                    }
                    FileOutputStream fos = new FileOutputStream(file, appendMode);
                    os = new BufferedOutputStream(fos);
                }
                catch (IOException e) {
                    throw new LDAPException("Can not open output trace file " + file + " " + e);
                }
            }
            return os;
        }
        if (out instanceof OutputStream) {
            return out;
        }
        if (out instanceof LDAPTraceWriter) {
            return out;
        }
        throw new LDAPException("com.netscape.ldap.trace must be an OutputStream, a file name or an instance of LDAPTraceWriter");
    }

    public void delete(String DN2) throws LDAPException {
        this.delete(DN2, this.m_defaultConstraints);
    }

    public void delete(String DN2, LDAPConstraints cons) throws LDAPException {
        this.internalBind(cons);
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            try {
                this.sendRequest(new JDAPDeleteRequest(DN2), myListener, cons);
                LDAPResponse response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 10, DN2, 0, null, null, false, null, null, null, null);
            }
            Object var6_6 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public LDAPResponseListener delete(String dn, LDAPResponseListener listener) throws LDAPException {
        return this.delete(dn, listener, this.m_defaultConstraints);
    }

    public LDAPResponseListener delete(String dn, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPDeleteRequest(dn), listener, cons);
        return listener;
    }

    public void delete(String DN2, LDAPSearchConstraints cons) throws LDAPException {
        this.delete(DN2, (LDAPConstraints)cons);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteThreadConnEntry() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            LDAPConnection c;
            Vector connVector = (Vector)m_threadConnTable.get(this.m_thread);
            if (connVector == null) {
                LDAPConnection.printDebug("Thread table does not contain the thread of this object");
                return;
            }
            Enumeration enumv = connVector.elements();
            do {
                if (enumv.hasMoreElements()) continue;
                return;
            } while (!(c = (LDAPConnection)enumv.nextElement()).equals(this));
            connVector.removeElement(c);
            if (connVector.size() != 0) return;
            m_threadConnTable.remove(this.m_thread);
            return;
        }
    }

    synchronized void deregisterConnection() {
        if (this.m_thread != null) {
            this.deleteThreadConnEntry();
            if (this.m_thread.isRunning()) {
                this.m_thread.deregister(this);
            }
        }
        this.m_thread = null;
        this.m_bound = false;
    }

    public synchronized void disconnect() throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        if (this.m_thread.isRunning() && this.m_thread.getClientCount() > 1) {
            this.m_connMgr = (LDAPConnSetupMgr)this.m_connMgr.clone();
            this.m_connMgr.disconnect();
        }
        if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
            this.m_referralConnection.disconnect();
        }
        this.m_referralConnection = null;
        if (this.m_cache != null) {
            this.m_cache.removeReference();
            this.m_cache = null;
        }
        this.deregisterConnection();
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op) throws LDAPException {
        return this.extendedOperation(op, this.m_defaultConstraints);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op, LDAPConstraints cons) throws LDAPException {
        String resultID;
        this.internalBind(cons);
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPResponse response = null;
        byte[] results = null;
        try {
            try {
                this.sendRequest(new JDAPExtendedRequest(op.getID(), op.getValue()), myListener, cons);
                response = myListener.getResponse();
                this.checkMsg(response);
                JDAPExtendedResponse res = (JDAPExtendedResponse)response.getProtocolOp();
                results = res.getValue();
                resultID = res.getID();
            }
            catch (LDAPReferralException e) {
                LDAPExtendedOperation lDAPExtendedOperation = this.performExtendedReferrals(e, cons, op);
                Object var9_10 = null;
                this.releaseResponseListener(myListener);
                return lDAPExtendedOperation;
            }
            Object var9_11 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
        return new LDAPExtendedOperation(resultID, results);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op, LDAPSearchConstraints cons) throws LDAPException {
        return this.extendedOperation(op, (LDAPConstraints)cons);
    }

    public void finalize() throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
    }

    private LDAPUrl findReferralURL(LDAPConnection ldc, LDAPUrl[] urls) {
        String connHost = ldc.getHost();
        int connPort = ldc.getPort();
        int i = 0;
        while (i < urls.length) {
            if (urls[i].getHost() == null || urls[i].getHost().length() < 1 ? connHost.equals(this.getHost()) && connPort == this.getPort() : connHost.equals(urls[i].getHost()) && connPort == urls[i].getPort()) {
                return urls[i];
            }
            ++i;
        }
        return null;
    }

    public String getAuthenticationDN() {
        return this.m_boundDN;
    }

    public String getAuthenticationMethod() {
        return this.isConnected() ? this.m_authMethod : "none";
    }

    public String getAuthenticationPassword() {
        return this.m_boundPasswd;
    }

    public LDAPCache getCache() {
        return this.m_cache;
    }

    public int getConnSetupDelay() {
        return this.m_connSetupDelay;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public LDAPConstraints getConstraints() {
        return this.getSearchConstraints();
    }

    public String getHost() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getHost();
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.m_thread != null ? this.m_thread.getInputStream() : null;
    }

    private synchronized LDAPConnThread getNewThread(LDAPConnSetupMgr connMgr, LDAPCache cache) throws LDAPException {
        LDAPConnThread newThread = null;
        Vector v = null;
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            Enumeration keys = m_threadConnTable.keys();
            boolean connExists = false;
            while (keys.hasMoreElements()) {
                LDAPConnThread connThread = (LDAPConnThread)keys.nextElement();
                Vector connVector = (Vector)m_threadConnTable.get(connThread);
                Enumeration enumv = connVector.elements();
                while (enumv.hasMoreElements()) {
                    LDAPConnection conn = (LDAPConnection)enumv.nextElement();
                    if (!conn.equals(this)) continue;
                    connExists = true;
                    if (connThread.isRunning()) break;
                    try {
                        newThread = new LDAPConnThread(connMgr, cache, this.getTraceOutput());
                        v = (Vector)m_threadConnTable.remove(connThread);
                        break;
                    }
                    catch (Exception exception) {
                        throw new LDAPException("unable to establish connection", 52);
                    }
                }
                if (connExists) break;
            }
            if (!connExists) {
                try {
                    newThread = new LDAPConnThread(connMgr, cache, this.getTraceOutput());
                    v = new Vector();
                    v.addElement(this);
                }
                catch (Exception exception) {
                    throw new LDAPException("unable to establish connection", 52);
                }
            }
            if (newThread != null) {
                m_threadConnTable.put(newThread, v);
                int i = 0;
                int n = v.size();
                while (i < n) {
                    LDAPConnection c = (LDAPConnection)v.elementAt(i);
                    newThread.register(c);
                    c.m_thread = newThread;
                    ++i;
                }
            }
        }
        return newThread;
    }

    public Object getOption(int option) throws LDAPException {
        if (option == 17) {
            return new Integer(this.m_protocolVersion);
        }
        return LDAPConnection.getOption(option, this.m_defaultConstraints);
    }

    private static Object getOption(int option, LDAPSearchConstraints cons) throws LDAPException {
        switch (option) {
            case 2: {
                return new Integer(cons.getDereference());
            }
            case 3: {
                return new Integer(cons.getMaxResults());
            }
            case 4: {
                return new Integer(cons.getServerTimeLimit());
            }
            case 8: {
                return new Boolean(cons.getReferrals());
            }
            case 9: {
                return cons.getRebindProc();
            }
            case 13: {
                return cons.getBindProc();
            }
            case 10: {
                return new Integer(cons.getHopLimit());
            }
            case 20: {
                return new Integer(cons.getBatchSize());
            }
            case 11: {
                return cons.getClientControls();
            }
            case 12: {
                return cons.getServerControls();
            }
            case 30: {
                return new Integer(cons.getMaxBacklog());
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    public OutputStream getOutputStream() {
        return this.m_thread != null ? this.m_thread.getOutputStream() : null;
    }

    public int getPort() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getPort();
        }
        return -1;
    }

    public Object getProperty(String name) throws LDAPException {
        return this.m_properties.get(name);
    }

    public LDAPControl[] getResponseControls() {
        LDAPControl[] controls = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Vector responses = (Vector)this.m_responseControlTable.get(this.m_thread);
            if (responses != null) {
                int i = 0;
                int size = responses.size();
                while (i < size) {
                    LDAPResponseControl responseObj = (LDAPResponseControl)responses.elementAt(i);
                    if (responseObj.getConnection().equals(this)) {
                        controls = responseObj.getControls();
                        responses.removeElementAt(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return controls;
    }

    LDAPControl[] getResponseControls(int msgID) {
        LDAPControl[] controls = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Vector responses = (Vector)this.m_responseControlTable.get(this.m_thread);
            if (responses != null) {
                int i = 0;
                int size = responses.size();
                while (i < size) {
                    LDAPResponseControl responseObj = (LDAPResponseControl)responses.elementAt(i);
                    if (responseObj.getMsgID() == msgID) {
                        controls = responseObj.getControls();
                        responses.removeElementAt(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return controls;
    }

    synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener l;
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        if (this.m_responseListeners.size() < 1) {
            l = new LDAPResponseListener(false);
        } else {
            l = (LDAPResponseListener)this.m_responseListeners.elementAt(0);
            this.m_responseListeners.removeElementAt(0);
        }
        return l;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return (LDAPSearchConstraints)this.m_defaultConstraints.clone();
    }

    private synchronized LDAPSearchListener getSearchListener(LDAPSearchConstraints cons) {
        LDAPSearchListener l;
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        if (this.m_searchListeners.size() < 1) {
            l = new LDAPSearchListener(false, cons);
        } else {
            l = (LDAPSearchListener)this.m_searchListeners.elementAt(0);
            this.m_searchListeners.removeElementAt(0);
            l.setSearchConstraints(cons);
        }
        return l;
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.m_factory;
    }

    Object getTraceOutput() throws LDAPException {
        Object traceOut = this.m_properties.get(TRACE_PROPERTY);
        if (traceOut != null) {
            return this.createTraceOutput(traceOut);
        }
        try {
            traceOut = System.getProperty(TRACE_PROPERTY);
            if (traceOut != null) {
                return this.createTraceOutput(traceOut);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void internalBind(int version, boolean rebind, LDAPConstraints cons) throws LDAPException {
        this.m_saslBinder = null;
        if (!this.isConnected()) {
            this.m_bound = false;
            this.m_authMethod = "none";
            this.connect();
        } else if (!this.m_bound && rebind && this.m_thread.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (this.m_bound && !rebind) {
            return;
        }
        if (!(this.m_anonymousBound || this.m_boundDN != null && this.m_boundPasswd != null || rebind)) {
            return;
        }
        if (this.m_bound && rebind) {
            if (this.m_protocolVersion == version) {
                if (this.m_anonymousBound && (this.m_boundDN == null || this.m_boundPasswd == null)) {
                    return;
                }
                if (!this.m_anonymousBound && this.m_boundDN != null && this.m_boundPasswd != null && this.m_boundDN.equals(this.m_prevBoundDN) && this.m_boundPasswd.equals(this.m_prevBoundPasswd)) {
                    return;
                }
            }
            if (this.m_thread.getClientCount() > 1) {
                this.disconnect();
                this.connect();
            }
        }
        this.m_protocolVersion = version;
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            try {
                if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
                    this.m_referralConnection.disconnect();
                }
                this.m_referralConnection = null;
                this.m_bound = false;
                this.sendRequest(new JDAPBindRequest(this.m_protocolVersion, this.m_boundDN, this.m_boundPasswd), myListener, cons);
                this.checkMsg(myListener.getResponse());
                this.markConnAsBound();
                this.m_rebindConstraints = (LDAPConstraints)cons.clone();
                this.m_authMethod = "simple";
            }
            catch (LDAPReferralException e) {
                this.m_referralConnection = this.createReferralConnection(e, cons);
            }
            Object var6_6 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    private void internalBind(LDAPConstraints cons) throws LDAPException {
        if (this.m_connMgr != null && this.m_connMgr.isUserDisconnected()) {
            throw new LDAPException("not connected", 80);
        }
        if (this.m_saslBinder != null) {
            if (!this.isConnected()) {
                this.connect();
            }
            this.m_saslBinder.bind(this, false);
            this.m_authMethod = "sasl";
        } else {
            if (this.m_rebindConstraints == null) {
                this.m_rebindConstraints = this.m_defaultConstraints;
            }
            this.internalBind(this.m_protocolVersion, false, this.m_rebindConstraints);
        }
    }

    public boolean isAuthenticated() {
        if (this.m_bound && (this.m_boundDN == null || this.m_boundDN.equals("") || this.m_boundPasswd == null || this.m_boundPasswd.equals(""))) {
            return false;
        }
        return this.m_bound;
    }

    public boolean isConnected() {
        LDAPConnection lDAPConnection = this;
        synchronized (lDAPConnection) {
            if (this.m_thread != null && this.m_thread.isRunning()) {
                boolean bl = true;
                Object var3_3 = null;
                return bl;
            }
        }
        if (this.m_thread != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            Thread.yield();
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    public static void main(String[] args) {
        System.out.println("LDAP SDK Version is " + SdkVersion);
        System.out.println("LDAP Protocol Version is " + ProtocolVersion);
    }

    void markConnAsBound() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            if (m_threadConnTable.containsKey(this.m_thread)) {
                Vector v = (Vector)m_threadConnTable.get(this.m_thread);
                int i = 0;
                int n = v.size();
                while (i < n) {
                    LDAPConnection conn = (LDAPConnection)v.elementAt(i);
                    conn.m_bound = true;
                    ++i;
                }
            } else {
                LDAPConnection.printDebug("Thread table does not contain the thread of this object");
            }
        }
    }

    public void modify(String DN2, LDAPModification mod) throws LDAPException {
        this.modify(DN2, mod, this.m_defaultConstraints);
    }

    public void modify(String DN2, LDAPModification mod, LDAPConstraints cons) throws LDAPException {
        LDAPModification[] mods = new LDAPModification[]{mod};
        this.modify(DN2, mods, cons);
    }

    public LDAPResponseListener modify(String dn, LDAPModification mod, LDAPResponseListener listener) throws LDAPException {
        return this.modify(dn, mod, listener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener modify(String dn, LDAPModification mod, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        LDAPModification[] modList = new LDAPModification[]{mod};
        this.sendRequest(new JDAPModifyRequest(dn, modList), listener, cons);
        return listener;
    }

    public void modify(String DN2, LDAPModification mod, LDAPSearchConstraints cons) throws LDAPException {
        this.modify(DN2, mod, (LDAPConstraints)cons);
    }

    public void modify(String DN2, LDAPModificationSet mods) throws LDAPException {
        this.modify(DN2, mods, this.m_defaultConstraints);
    }

    public void modify(String DN2, LDAPModificationSet mods, LDAPConstraints cons) throws LDAPException {
        LDAPModification[] modList = new LDAPModification[mods.size()];
        int i = 0;
        while (i < mods.size()) {
            modList[i] = mods.elementAt(i);
            ++i;
        }
        this.modify(DN2, modList, cons);
    }

    public LDAPResponseListener modify(String dn, LDAPModificationSet mods, LDAPResponseListener listener) throws LDAPException {
        return this.modify(dn, mods, listener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener modify(String dn, LDAPModificationSet mods, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        LDAPModification[] modList = new LDAPModification[mods.size()];
        int i = 0;
        while (i < mods.size()) {
            modList[i] = mods.elementAt(i);
            ++i;
        }
        this.sendRequest(new JDAPModifyRequest(dn, modList), listener, cons);
        return listener;
    }

    public void modify(String DN2, LDAPModificationSet mods, LDAPSearchConstraints cons) throws LDAPException {
        this.modify(DN2, mods, (LDAPConstraints)cons);
    }

    public void modify(String DN2, LDAPModification[] mods) throws LDAPException {
        this.modify(DN2, mods, this.m_defaultConstraints);
    }

    public void modify(String DN2, LDAPModification[] mods, LDAPConstraints cons) throws LDAPException {
        this.internalBind(cons);
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPResponse response = null;
        try {
            try {
                this.sendRequest(new JDAPModifyRequest(DN2, mods), myListener, cons);
                response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 6, DN2, 0, null, null, false, mods, null, null, null);
            }
            Object var7_7 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public void modify(String DN2, LDAPModification[] mods, LDAPSearchConstraints cons) throws LDAPException {
        this.modify(DN2, mods, (LDAPConstraints)cons);
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException e, LDAPConstraints cons, LDAPExtendedOperation op) throws LDAPException {
        if (cons.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            throw e;
        }
        LDAPUrl[] u = e.getURLs();
        if (u == null || u.length == 0) {
            return null;
        }
        String connectList = this.createReferralConnectList(u);
        LDAPConnection connection = this.prepareReferral(connectList, cons);
        this.referralRebind(connection, cons);
        LDAPExtendedOperation results = connection.extendedOperation(op);
        connection.disconnect();
        return results;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performReferrals(LDAPConnection connection, LDAPConstraints cons, int ops, String dn, int scope, String filter, String[] types, boolean attrsOnly, LDAPModification[] mods, LDAPEntry entry, LDAPAttribute attr, Vector results) throws LDAPException {
        LDAPSearchResults res = null;
        try {
            switch (ops) {
                case 3: {
                    res = connection.search(dn, scope, filter, types, attrsOnly, (LDAPSearchConstraints)cons);
                    if (res != null) {
                        res.closeOnCompletion(connection);
                        results.addElement(res);
                        return;
                    }
                    if (this.m_referralConnection != null) {
                        if (connection.equals(this.m_referralConnection)) return;
                    }
                    connection.disconnect();
                    return;
                }
                case 6: {
                    connection.modify(dn, mods, cons);
                    return;
                }
                case 8: {
                    if (dn != null && !dn.equals("")) {
                        entry.setDN(dn);
                    }
                    connection.add(entry, cons);
                    return;
                }
                case 10: {
                    connection.delete(dn, cons);
                    return;
                }
                case 12: {
                    connection.rename(dn, filter, attrsOnly, cons);
                    return;
                }
                case 14: {
                    boolean bool = connection.compare(dn, attr, cons);
                    results.addElement(new Boolean(bool));
                    return;
                }
                default: {
                    return;
                }
            }
        }
        finally {
            Object var15_16 = null;
            if (!(connection == null || ops == 3 && res != null || this.m_referralConnection != null && connection.equals(this.m_referralConnection))) {
                connection.disconnect();
            }
        }
    }

    void performReferrals(LDAPReferralException e, LDAPConstraints cons, int ops, String dn, int scope, String filter, String[] types, boolean attrsOnly, LDAPModification[] mods, LDAPEntry entry, LDAPAttribute attr, Vector results) throws LDAPException {
        if (cons.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            if (ops == 3) {
                LDAPSearchResults res = new LDAPSearchResults();
                res.add(e);
                results.addElement(res);
                return;
            }
            throw e;
        }
        LDAPUrl[] urls = e.getURLs();
        if (urls == null || urls.length == 0) {
            return;
        }
        LDAPUrl referralURL = null;
        LDAPConnection connection = null;
        if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
            referralURL = this.findReferralURL(this.m_referralConnection, urls);
        }
        if (referralURL != null) {
            connection = this.m_referralConnection;
        } else {
            String connectList = this.createReferralConnectList(urls);
            connection = this.prepareReferral(connectList, cons);
            referralURL = this.findReferralURL(connection, urls);
            this.referralRebind(connection, cons);
        }
        String newDN = referralURL.getDN();
        String DN2 = null;
        DN2 = newDN == null || newDN.equals("") ? dn : newDN;
        if (referralURL.getUrl().indexOf("?base") > -1) {
            scope = 0;
        }
        LDAPSearchConstraints newcons = (LDAPSearchConstraints)cons.clone();
        newcons.setHopLimit(cons.getHopLimit() - 1);
        this.performReferrals(connection, (LDAPConstraints)newcons, ops, DN2, scope, filter, types, attrsOnly, mods, entry, attr, results);
    }

    private LDAPConnection prepareReferral(String connectList, LDAPConstraints cons) throws LDAPException {
        LDAPConnection connection = new LDAPConnection(this.getSocketFactory());
        connection.setConnSetupDelay(this.getConnSetupDelay());
        connection.setOption(8, new Boolean(true));
        connection.setOption(9, cons.getRebindProc());
        connection.setOption(13, cons.getBindProc());
        connection.setOption(17, new Integer(this.m_protocolVersion));
        connection.setOption(10, new Integer(cons.getHopLimit() - 1));
        try {
            connection.connect(connectList, 389);
        }
        catch (LDAPException e) {
            throw new LDAPException("Referral connect failed: " + e.getMessage(), e.getLDAPResultCode());
        }
        return connection;
    }

    static void printDebug(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public LDAPEntry read(String DN2) throws LDAPException {
        return this.read(DN2, null, this.m_defaultConstraints);
    }

    public LDAPEntry read(String DN2, LDAPSearchConstraints cons) throws LDAPException {
        return this.read(DN2, null, cons);
    }

    public LDAPEntry read(String DN2, String[] attrs) throws LDAPException {
        return this.read(DN2, attrs, this.m_defaultConstraints);
    }

    public LDAPEntry read(String DN2, String[] attrs, LDAPSearchConstraints cons) throws LDAPException {
        LDAPSearchResults results = this.search(DN2, 0, "(|(objectclass=*)(objectclass=ldapsubentry))", attrs, false, cons);
        if (results == null) {
            return null;
        }
        LDAPEntry entry = results.next();
        while (results.hasMoreElements()) {
            results.nextElement();
        }
        return entry;
    }

    public static LDAPEntry read(LDAPUrl toGet) throws LDAPException {
        String host = toGet.getHost();
        int port = toGet.getPort();
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] attributes = toGet.getAttributeArray();
        String DN2 = toGet.getDN();
        LDAPConnection connection = new LDAPConnection();
        if (toGet.isSecure()) {
            LDAPSocketFactory factory = LDAPUrl.getSocketFactory();
            if (factory == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            connection.setSocketFactory(factory);
        }
        connection.connect(host, port);
        LDAPEntry returnValue = connection.read(DN2, attributes);
        connection.disconnect();
        return returnValue;
    }

    public void reconnect() throws LDAPException {
        this.disconnect();
        this.connect();
        if (this.m_saslBinder != null) {
            this.m_saslBinder.bind(this, true);
            this.m_authMethod = "sasl";
        } else {
            this.internalBind(this.m_protocolVersion, true, this.m_defaultConstraints);
        }
    }

    private void referralRebind(LDAPConnection ldc, LDAPConstraints cons) throws LDAPException {
        try {
            if (cons.getRebindProc() == null && cons.getBindProc() == null) {
                ldc.authenticate(this.m_protocolVersion, null, null);
            } else if (cons.getBindProc() == null) {
                LDAPRebindAuth auth = cons.getRebindProc().getRebindAuthentication(ldc.getHost(), ldc.getPort());
                ldc.authenticate(this.m_protocolVersion, auth.getDN(), auth.getPassword());
            } else {
                cons.getBindProc().bind(ldc);
            }
        }
        catch (LDAPException e) {
            throw new LDAPException("Referral bind failed: " + e.getMessage(), e.getLDAPResultCode());
        }
    }

    synchronized void releaseResponseListener(LDAPResponseListener l) {
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        l.reset();
        this.m_responseListeners.addElement(l);
    }

    synchronized void releaseSearchListener(LDAPSearchListener l) {
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        l.reset();
        this.m_searchListeners.addElement(l);
    }

    public void rename(String dn, String newRDN, String newParentDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(dn, newRDN, newParentDN, deleteOldRDN, this.m_defaultConstraints);
    }

    public void rename(String DN2, String newRDN, String newParentDN, boolean deleteOldRDN, LDAPConstraints cons) throws LDAPException {
        this.internalBind(cons);
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            try {
                JDAPModifyRDNRequest request = null;
                request = newParentDN != null ? new JDAPModifyRDNRequest(DN2, newRDN, deleteOldRDN, newParentDN) : new JDAPModifyRDNRequest(DN2, newRDN, deleteOldRDN);
                this.sendRequest(request, myListener, cons);
                LDAPResponse response = myListener.getResponse();
                this.checkMsg(response);
            }
            catch (LDAPReferralException e) {
                this.performReferrals(e, cons, 12, DN2, 0, newRDN, null, deleteOldRDN, null, null, null, null);
            }
            Object var8_10 = null;
            this.releaseResponseListener(myListener);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.releaseResponseListener(myListener);
            throw throwable;
        }
    }

    public void rename(String DN2, String newRDN, String newParentDN, boolean deleteOldRDN, LDAPSearchConstraints cons) throws LDAPException {
        this.rename(DN2, newRDN, newParentDN, deleteOldRDN, (LDAPConstraints)cons);
    }

    public void rename(String DN2, String newRDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(DN2, newRDN, null, deleteOldRDN);
    }

    public void rename(String DN2, String newRDN, boolean deleteOldRDN, LDAPConstraints cons) throws LDAPException {
        this.rename(DN2, newRDN, null, deleteOldRDN, cons);
    }

    public LDAPResponseListener rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseListener listener) throws LDAPException {
        return this.rename(dn, newRdn, deleteOldRdn, listener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPModifyRDNRequest(dn, newRdn, deleteOldRdn), listener, cons);
        return listener;
    }

    public void rename(String DN2, String newRDN, boolean deleteOldRDN, LDAPSearchConstraints cons) throws LDAPException {
        this.rename(DN2, newRDN, deleteOldRDN, (LDAPConstraints)cons);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly) throws LDAPException {
        return this.search(base, scope, filter, attrs, attrsOnly, this.m_defaultConstraints);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly, LDAPSearchConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        LDAPSearchResults returnValue = new LDAPSearchResults(this, cons, base, scope, filter, attrs, attrsOnly);
        Vector cacheValue = null;
        Long key = null;
        boolean isKeyValid = true;
        try {
            if (this.m_cache != null && (cacheValue = (Vector)this.m_cache.getEntry(key = this.m_cache.createKey(this.getHost(), this.getPort(), base, filter, scope, attrs, this.m_boundDN, cons))) != null) {
                return new LDAPSearchResults(cacheValue, this, cons, base, scope, filter, attrs, attrsOnly);
            }
        }
        catch (LDAPException e) {
            isKeyValid = false;
            LDAPConnection.printDebug("Exception: " + e);
        }
        this.internalBind(cons);
        LDAPSearchListener myListener = this.getSearchListener(cons);
        int deref = cons.getDereference();
        JDAPSearchRequest request = null;
        try {
            request = new JDAPSearchRequest(base, scope, deref, cons.getMaxResults(), cons.getServerTimeLimit(), attrsOnly, filter, attrs);
        }
        catch (IllegalArgumentException e) {
            throw new LDAPException(e.getMessage(), 89);
        }
        if (this.m_cache != null && isKeyValid) {
            myListener.setKey(key);
        }
        try {
            this.sendRequest(request, myListener, cons);
        }
        catch (LDAPException e) {
            this.releaseSearchListener(myListener);
            throw e;
        }
        boolean isPersistentSearch = false;
        LDAPControl[] controls = (LDAPControl[])LDAPConnection.getOption(12, cons);
        int i = 0;
        while (controls != null && i < controls.length) {
            if (controls[i] instanceof LDAPPersistSearchControl) {
                isPersistentSearch = true;
                break;
            }
            ++i;
        }
        if (isPersistentSearch) {
            returnValue.associatePersistentSearch(myListener);
        } else {
            if (cons.getBatchSize() == 0) {
                try {
                    LDAPResponse response = myListener.completeSearchOperation();
                    Enumeration results = myListener.getAllMessages().elements();
                    this.checkSearchMsg(returnValue, response, cons, base, scope, filter, attrs, attrsOnly);
                    while (results.hasMoreElements()) {
                        LDAPMessage msg = (LDAPMessage)results.nextElement();
                        this.checkSearchMsg(returnValue, msg, cons, base, scope, filter, attrs, attrsOnly);
                    }
                }
                finally {
                    Object var18_25 = null;
                    this.releaseSearchListener(myListener);
                }
            }
            LDAPMessage firstResult = myListener.nextMessage();
            if (firstResult instanceof LDAPResponse) {
                try {
                    this.checkSearchMsg(returnValue, firstResult, cons, base, scope, filter, attrs, attrsOnly);
                }
                finally {
                    Object var19_21 = null;
                    this.releaseSearchListener(myListener);
                }
            }
            try {
                this.checkSearchMsg(returnValue, firstResult, cons, base, scope, filter, attrs, attrsOnly);
            }
            catch (LDAPException ex) {
                this.releaseSearchListener(myListener);
                throw ex;
            }
            returnValue.associate(myListener);
        }
        return returnValue;
    }

    public LDAPSearchListener search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchListener listener) throws LDAPException {
        return this.search(base, scope, filter, attrs, typesOnly, listener, this.m_defaultConstraints);
    }

    public LDAPSearchListener search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchListener listener, LDAPSearchConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.internalBind(cons);
        if (listener == null) {
            listener = new LDAPSearchListener(true, cons);
        }
        JDAPSearchRequest request = null;
        try {
            request = new JDAPSearchRequest(base, scope, cons.getDereference(), cons.getMaxResults(), cons.getServerTimeLimit(), typesOnly, filter, attrs);
        }
        catch (IllegalArgumentException e) {
            throw new LDAPException(e.getMessage(), 89);
        }
        this.sendRequest(request, listener, cons);
        return listener;
    }

    public static LDAPSearchResults search(LDAPUrl toGet) throws LDAPException {
        return LDAPConnection.search(toGet, null);
    }

    public static LDAPSearchResults search(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        String host = toGet.getHost();
        int port = toGet.getPort();
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] attributes = toGet.getAttributeArray();
        String DN2 = toGet.getDN();
        String filter = toGet.getFilter();
        if (filter == null) {
            filter = defaultFilter;
        }
        int scope = toGet.getScope();
        LDAPConnection connection = new LDAPConnection();
        if (toGet.isSecure()) {
            LDAPSocketFactory factory = LDAPUrl.getSocketFactory();
            if (factory == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            connection.setSocketFactory(factory);
        }
        connection.connect(host, port);
        LDAPSearchResults results = cons != null ? connection.search(DN2, scope, filter, attributes, false, cons) : connection.search(DN2, scope, filter, attributes, false);
        results.closeOnCompletion(connection);
        return results;
    }

    void sendRequest(JDAPProtocolOp oper, LDAPMessageQueue myListener, LDAPConstraints cons) throws LDAPException {
        boolean requestSent = false;
        int i = 0;
        while (!requestSent && i < 3) {
            try {
                this.m_thread.sendRequest(this, oper, myListener, cons);
                requestSent = true;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalArgumentException e) {
                throw new LDAPException(e.getMessage(), 89);
            }
            ++i;
        }
        if (!this.isConnected()) {
            throw new LDAPException("The connection is not available", 80);
        }
        if (!requestSent) {
            throw new LDAPException("Failed to send request", 80);
        }
    }

    public void setCache(LDAPCache cache) {
        if (this.m_cache != null) {
            this.m_cache.removeReference();
        }
        if (cache != null) {
            cache.addReference();
        }
        this.m_cache = cache;
        if (this.m_thread != null) {
            this.m_thread.setCache(cache);
        }
    }

    public void setConnSetupDelay(int delay) {
        this.m_connSetupDelay = delay;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnSetupDelay(delay);
        }
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value can not be negative");
        }
        this.m_connectTimeout = timeout;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        }
    }

    public void setConstraints(LDAPConstraints cons) {
        this.m_defaultConstraints.setHopLimit(cons.getHopLimit());
        this.m_defaultConstraints.setReferrals(cons.getReferrals());
        this.m_defaultConstraints.setTimeLimit(cons.getTimeLimit());
        this.m_defaultConstraints.setBindProc(cons.getBindProc());
        this.m_defaultConstraints.setRebindProc(cons.getRebindProc());
        LDAPControl[] tClientControls = cons.getClientControls();
        LDAPControl[] oClientControls = null;
        if (tClientControls != null && tClientControls.length > 0) {
            oClientControls = new LDAPControl[tClientControls.length];
            int i = 0;
            while (i < tClientControls.length) {
                oClientControls[i] = (LDAPControl)tClientControls[i].clone();
                ++i;
            }
        }
        this.m_defaultConstraints.setClientControls(oClientControls);
        LDAPControl[] tServerControls = cons.getServerControls();
        LDAPControl[] oServerControls = null;
        if (tServerControls != null && tServerControls.length > 0) {
            oServerControls = new LDAPControl[tServerControls.length];
            int i = 0;
            while (i < tServerControls.length) {
                oServerControls[i] = (LDAPControl)tServerControls[i].clone();
                ++i;
            }
        }
        this.m_defaultConstraints.setServerControls(oServerControls);
    }

    public void setInputStream(InputStream is) {
        if (this.m_thread != null) {
            this.m_thread.setInputStream(is);
        }
    }

    public void setOption(int option, Object value) throws LDAPException {
        if (option == 17) {
            this.setProtocolVersion((Integer)value);
            return;
        }
        LDAPConnection.setOption(option, value, this.m_defaultConstraints);
    }

    private static void setOption(int option, Object value, LDAPSearchConstraints cons) throws LDAPException {
        try {
            switch (option) {
                case 2: {
                    cons.setDereference((Integer)value);
                    return;
                }
                case 3: {
                    cons.setMaxResults((Integer)value);
                    return;
                }
                case 4: {
                    cons.setTimeLimit((Integer)value);
                    return;
                }
                case 5: {
                    cons.setServerTimeLimit((Integer)value);
                    return;
                }
                case 8: {
                    cons.setReferrals((Boolean)value);
                    return;
                }
                case 13: {
                    cons.setBindProc((LDAPBind)value);
                    return;
                }
                case 9: {
                    cons.setRebindProc((LDAPRebind)value);
                    return;
                }
                case 10: {
                    cons.setHopLimit((Integer)value);
                    return;
                }
                case 20: {
                    cons.setBatchSize((Integer)value);
                    return;
                }
                case 11: {
                    if (value == null) {
                        cons.setClientControls((LDAPControl[])null);
                    } else if (value instanceof LDAPControl) {
                        cons.setClientControls((LDAPControl)value);
                    } else if (value instanceof LDAPControl[]) {
                        cons.setClientControls((LDAPControl[])value);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 12: {
                    if (value == null) {
                        cons.setServerControls((LDAPControl[])null);
                    } else if (value instanceof LDAPControl) {
                        cons.setServerControls((LDAPControl)value);
                    } else if (value instanceof LDAPControl[]) {
                        cons.setServerControls((LDAPControl[])value);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 30: {
                    cons.setMaxBacklog((Integer)value);
                    return;
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException classCastException) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    public void setOutputStream(OutputStream os) {
        if (this.m_thread != null) {
            this.m_thread.setOutputStream(os);
        }
    }

    public void setProperty(String name, Object val) throws LDAPException {
        if (name.equalsIgnoreCase(SCHEMA_BUG_PROPERTY)) {
            this.m_properties.put(SCHEMA_BUG_PROPERTY, val);
        } else if (name.equalsIgnoreCase(SASL_PACKAGE_PROPERTY)) {
            this.m_properties.put(SASL_PACKAGE_PROPERTY, val);
        } else if (name.equalsIgnoreCase("debug")) {
            debug = ((String)val).equalsIgnoreCase("true");
        } else if (name.equalsIgnoreCase(TRACE_PROPERTY)) {
            Object traceOutput = null;
            if (val == null) {
                this.m_properties.remove(TRACE_PROPERTY);
            } else {
                if (this.m_thread != null) {
                    traceOutput = this.createTraceOutput(val);
                }
                this.m_properties.put(TRACE_PROPERTY, val);
            }
            if (this.m_thread != null) {
                this.m_thread.setTraceOutput(traceOutput);
            }
        } else if (name.equalsIgnoreCase("breakConnection")) {
            this.m_connMgr.breakConnection();
        } else {
            throw new LDAPException("Unknown property: " + name);
        }
    }

    private void setProtocolVersion(int version) {
        this.m_protocolVersion = version;
    }

    void setResponseControls(LDAPConnThread current, LDAPResponseControl con) {
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Vector<LDAPResponseControl> v = (Vector<LDAPResponseControl>)this.m_responseControlTable.get(current);
            if (v != null && v.size() > 0) {
                int i = v.size() - 1;
                while (i >= 0) {
                    LDAPResponseControl response = (LDAPResponseControl)v.elementAt(i);
                    if (response.getConnection().equals(this) && (con == null || con.getMsgID() != response.getMsgID())) {
                        v.removeElement(response);
                    }
                    --i;
                }
            } else if (con != null) {
                v = new Vector<LDAPResponseControl>();
            }
            if (con != null) {
                v.addElement(con);
                this.m_responseControlTable.put(current, v);
            }
            Enumeration e = this.m_attachedList.elements();
            while (e.hasMoreElements()) {
                LDAPConnThread aThread = (LDAPConnThread)e.nextElement();
                if (aThread.isRunning()) continue;
                this.m_responseControlTable.remove(aThread);
                this.m_attachedList.removeElement(aThread);
            }
        }
        if (this.m_attachedList.indexOf(current) < 0) {
            this.m_attachedList.addElement(current);
        }
    }

    public void setSearchConstraints(LDAPSearchConstraints cons) {
        this.m_defaultConstraints = (LDAPSearchConstraints)cons.clone();
    }

    public void setSocketFactory(LDAPSocketFactory factory) {
        this.m_factory = factory;
    }

    public String toString() {
        int cloneCnt = this.m_thread == null ? 0 : this.m_thread.getClientCount();
        StringBuffer sb = new StringBuffer("LDAPConnection {");
        sb.append(this.m_factory == null ? "ldap" : "ldaps");
        sb.append("://");
        sb.append(this.getHost());
        sb.append(":");
        sb.append(this.getPort());
        if (cloneCnt > 1) {
            sb.append(" (");
            sb.append(cloneCnt);
            sb.append(")");
        }
        sb.append(" ldapVersion:");
        sb.append(this.m_protocolVersion);
        sb.append(" bindDN:\"");
        if (this.getAuthenticationDN() != null) {
            sb.append(this.getAuthenticationDN());
        }
        sb.append("\"}");
        return sb.toString();
    }
}

