/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;

public class LDAPConstraints
implements Cloneable,
Serializable {
    static final long serialVersionUID = 6506767263918312029L;
    private int m_hop_limit;
    private LDAPBind m_bind_proc;
    private LDAPRebind m_rebind_proc;
    private boolean referrals;
    private int m_time_limit;
    private LDAPControl[] m_clientControls;
    private LDAPControl[] m_serverControls;

    public LDAPConstraints() {
        this.m_time_limit = 0;
        this.referrals = false;
        this.m_bind_proc = null;
        this.m_rebind_proc = null;
        this.m_hop_limit = 5;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public LDAPConstraints(int msLimit, boolean doReferrals, LDAPBind bind_proc, int hop_limit) {
        this.m_time_limit = msLimit;
        this.referrals = doReferrals;
        this.m_bind_proc = bind_proc;
        this.m_rebind_proc = null;
        this.m_hop_limit = hop_limit;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public LDAPConstraints(int msLimit, boolean doReferrals, LDAPRebind rebind_proc, int hop_limit) {
        this.m_time_limit = msLimit;
        this.referrals = doReferrals;
        this.m_bind_proc = null;
        this.m_rebind_proc = rebind_proc;
        this.m_hop_limit = hop_limit;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public Object clone() {
        int i;
        LDAPConstraints o = new LDAPConstraints();
        o.m_time_limit = this.m_time_limit;
        o.referrals = this.referrals;
        o.m_bind_proc = this.m_bind_proc;
        o.m_rebind_proc = this.m_rebind_proc;
        o.m_hop_limit = this.m_hop_limit;
        if (this.m_clientControls != null && this.m_clientControls.length > 0) {
            o.m_clientControls = new LDAPControl[this.m_clientControls.length];
            i = 0;
            while (i < this.m_clientControls.length) {
                o.m_clientControls[i] = (LDAPControl)this.m_clientControls[i].clone();
                ++i;
            }
        }
        if (this.m_serverControls != null && this.m_serverControls.length > 0) {
            o.m_serverControls = new LDAPControl[this.m_serverControls.length];
            i = 0;
            while (i < this.m_serverControls.length) {
                o.m_serverControls[i] = (LDAPControl)this.m_serverControls[i].clone();
                ++i;
            }
        }
        return o;
    }

    public LDAPBind getBindProc() {
        return this.m_bind_proc;
    }

    public LDAPControl[] getClientControls() {
        return this.m_clientControls;
    }

    public int getHopLimit() {
        return this.m_hop_limit;
    }

    public LDAPRebind getRebindProc() {
        return this.m_rebind_proc;
    }

    public boolean getReferrals() {
        return this.referrals;
    }

    public LDAPControl[] getServerControls() {
        return this.m_serverControls;
    }

    public int getTimeLimit() {
        return this.m_time_limit;
    }

    public void setBindProc(LDAPBind bind_proc) {
        this.m_bind_proc = bind_proc;
        if (bind_proc != null) {
            this.m_rebind_proc = null;
        }
    }

    public void setClientControls(LDAPControl control) {
        this.m_clientControls = new LDAPControl[1];
        this.m_clientControls[0] = control;
    }

    public void setClientControls(LDAPControl[] controls) {
        this.m_clientControls = controls;
    }

    public void setHopLimit(int hop_limit) {
        this.m_hop_limit = hop_limit;
    }

    public void setRebindProc(LDAPRebind rebind_proc) {
        this.m_rebind_proc = rebind_proc;
        if (rebind_proc != null) {
            this.m_bind_proc = null;
        }
    }

    public void setReferrals(boolean doReferrals) {
        this.referrals = doReferrals;
    }

    public void setServerControls(LDAPControl control) {
        this.m_serverControls = new LDAPControl[1];
        this.m_serverControls[0] = control;
    }

    public void setServerControls(LDAPControl[] controls) {
        this.m_serverControls = controls;
    }

    public void setTimeLimit(int msLimit) {
        this.m_time_limit = msLimit;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("LDAPConstraints {");
        sb.append("time limit " + this.getTimeLimit() + ", ");
        sb.append("referrals " + this.getReferrals() + ", ");
        sb.append("hop limit " + this.getHopLimit() + ", ");
        sb.append("bind_proc " + this.getBindProc() + ", ");
        sb.append("rebind_proc " + this.getRebindProc());
        LDAPControl[] controls = this.getClientControls();
        if (controls != null) {
            sb.append(", client controls ");
            i = 0;
            while (i < controls.length) {
                sb.append(controls[i].toString());
                if (i < controls.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
        }
        if ((controls = this.getServerControls()) != null) {
            sb.append(", server controls ");
            i = 0;
            while (i < controls.length) {
                sb.append(controls[i].toString());
                if (i < controls.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

