/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;

public class LDAPEntry
implements Serializable {
    static final long serialVersionUID = -5563306228920012807L;
    private String dn = null;
    private LDAPAttributeSet attrSet = null;

    public LDAPEntry() {
        this.dn = null;
        this.attrSet = new LDAPAttributeSet();
    }

    public LDAPEntry(String distinguishedName) {
        this.dn = distinguishedName;
        this.attrSet = new LDAPAttributeSet();
    }

    public LDAPEntry(String distinguishedName, LDAPAttributeSet attrs) {
        this.dn = distinguishedName;
        this.attrSet = attrs;
    }

    public LDAPAttribute getAttribute(String attrName) {
        return this.attrSet.getAttribute(attrName);
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        return this.attrSet.getAttribute(attrName, lang);
    }

    public LDAPAttributeSet getAttributeSet() {
        return this.attrSet;
    }

    public LDAPAttributeSet getAttributeSet(String subtype) {
        return this.attrSet.getSubset(subtype);
    }

    public String getDN() {
        return this.dn;
    }

    void setDN(String name) {
        this.dn = name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LDAPEntry: ");
        if (this.dn != null) {
            sb.append(this.dn);
            sb.append("; ");
        }
        if (this.attrSet != null) {
            sb.append(this.attrSet.toString());
        }
        return sb.toString();
    }
}

