/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPExtendedRequest
implements JDAPProtocolOp {
    protected String m_oid = null;
    protected byte[] m_value = null;

    public JDAPExtendedRequest(String oid, byte[] value) {
        this.m_oid = oid;
        this.m_value = value;
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BERTag(128, new BEROctetString(this.m_oid), true));
        if (this.m_value != null) {
            seq.addElement(new BERTag(129, new BEROctetString(this.m_value, 0, this.m_value.length), true));
        }
        BERTag element = new BERTag(119, seq, true);
        return element;
    }

    public String getParamString() {
        String s = "";
        if (this.m_value != null) {
            try {
                s = new String(this.m_value, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        return "{OID='" + this.m_oid + "', value='" + s + "'}";
    }

    public int getType() {
        return 23;
    }

    public String toString() {
        return "ExtendedRequest " + this.getParamString();
    }
}

