/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPBaseDNRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPModifyRDNRequest
extends JDAPBaseDNRequest
implements JDAPProtocolOp {
    protected String m_old_dn = null;
    protected String m_new_rdn = null;
    protected boolean m_delete_old_dn;
    protected String m_new_superior;

    public JDAPModifyRDNRequest(String old_dn, String new_rdn, boolean delete_old_dn) {
        this.m_old_dn = old_dn;
        this.m_new_rdn = new_rdn;
        this.m_delete_old_dn = delete_old_dn;
        this.m_new_superior = null;
    }

    public JDAPModifyRDNRequest(String old_dn, String new_rdn, boolean delete_old_dn, String new_superior) {
        this.m_old_dn = old_dn;
        this.m_new_rdn = new_rdn;
        this.m_delete_old_dn = delete_old_dn;
        this.m_new_superior = new_superior;
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_old_dn));
        seq.addElement(new BEROctetString(this.m_new_rdn));
        seq.addElement(new BERBoolean(this.m_delete_old_dn));
        if (this.m_new_superior != null) {
            seq.addElement(new BERTag(128, new BEROctetString(this.m_new_superior), true));
        }
        BERTag element = new BERTag(108, seq, true);
        return element;
    }

    public String getBaseDN() {
        return this.m_old_dn;
    }

    public int getType() {
        return 12;
    }

    public void setBaseDN(String basedn) {
        this.m_old_dn = basedn;
    }

    public String toString() {
        return "ModifyRDNRequest {entry=" + this.m_old_dn + ", newrdn=" + this.m_new_rdn + ", deleteoldrdn=" + this.m_delete_old_dn + "}";
    }
}

