/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.cli.util;

import com.sun.apoc.cli.PolicyGroupTool;
import com.sun.apoc.cli.util.CLIException;
import com.sun.apoc.spi.profiles.Applicability;
import java.util.ArrayList;

public class CmdLineArguments {
    private String mAuthType = null;
    private String mBaseEntry;
    private boolean mBootstrapArgumentSet = false;
    private String mBootstrapFile;
    private String mEntity;
    private String mHost;
    private ArrayList mOperands = new ArrayList();
    private String mProfileName;
    private Applicability mApplicability = Applicability.USER;
    private String mPort;
    private int mPriority = 0;
    private String mPriorityStr;
    private String mSubcommand;
    private String mType;
    private String mUserName;
    private String mUrl;
    private static final String DEFAULT_BOOTSTRAP_FILENAME = "/pgtool.properties";
    public static final String ADD = "add";
    public static final String CREATE = "create";
    public static final String DELETE = "delete";
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    public static final String LIST = "list";
    public static final String LOGIN = "login";
    public static final String MODIFY = "modify";
    public static final String REMOVE = "remove";
    public static final String RENAME = "rename";
    private static final String SCOPE_USER = "USER";
    private static final String SCOPE_HOST = "HOST";
    private static final String AUTHTYPE_ANONYMOUS = "LDAP_USER_ANONYMOUS";
    private static final String AUTHTYPE_GSSAPI = "GSSAPI";

    public String getAuthType() {
        return this.mAuthType;
    }

    public String getBaseEntry() {
        return this.mBaseEntry;
    }

    public String getBootstrapFile() {
        return this.mBootstrapFile;
    }

    public String getEntity() {
        return this.mEntity;
    }

    public String getHostName() {
        return this.mHost;
    }

    public ArrayList getOperands() {
        return this.mOperands;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public Applicability getApplicability() {
        return this.mApplicability;
    }

    public String getPort() {
        return this.mPort;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public String getPriorityString() {
        return this.mPriorityStr;
    }

    public String getSubcommand() {
        return this.mSubcommand;
    }

    public String getType() {
        return this.mType;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getUrl() {
        return this.mUrl;
    }

    private void setAuthType(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase(AUTHTYPE_GSSAPI)) {
                this.mAuthType = AUTHTYPE_GSSAPI;
            } else if (string.equalsIgnoreCase(AUTHTYPE_ANONYMOUS)) {
                this.mAuthType = "Anonymous";
            }
        }
    }

    private void setApplicability(String string) throws CLIException {
        if (string != null) {
            if (string.equalsIgnoreCase(SCOPE_USER)) {
                this.mApplicability = Applicability.USER;
            } else if (string.equalsIgnoreCase(SCOPE_HOST)) {
                this.mApplicability = Applicability.HOST;
            } else {
                throw new CLIException("pgtool: invalid argument: " + string, CLIException.INVALID_ARGS);
            }
        }
    }

    private void setPriority(String string) throws CLIException {
        if (string != null) {
            try {
                this.mPriority = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CLIException("pgtool: invalid priority: " + string, CLIException.INVALID_ARGS);
            }
            if (this.mPriority <= 0) {
                throw new CLIException("pgtool: invalid priority: " + string, CLIException.INVALID_ARGS);
            }
            this.mPriorityStr = string;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processArguments(String[] stringArray) throws CLIException {
        int n = 0;
        if (stringArray.length < 1) {
            throw new CLIException("pgtool: insufficient arguments", CLIException.INVALID_ARGS);
        }
        if (stringArray[n].equals("-?") || stringArray[n].equals("--help")) {
            PolicyGroupTool.printHelp();
            return;
        }
        if (stringArray[n].equals("-V") || stringArray[n].equals("--version")) {
            PolicyGroupTool.printVersion();
            return;
        }
        this.mSubcommand = stringArray[n++];
        while (n < stringArray.length) {
            block83: {
                block84: {
                    block82: {
                        if (stringArray[n].length() == 0 || stringArray[n].charAt(0) == '-') break block82;
                        this.mOperands.add(stringArray[n]);
                        break block83;
                    }
                    if (!this.mOperands.isEmpty() || stringArray[n].length() <= 1) break block84;
                    int n2 = 1;
                    if (stringArray[n].length() > 2 && stringArray[n].charAt(n2) == '-') {
                        n2 = 2;
                    }
                    switch (stringArray[n].charAt(n2)) {
                        case 'a': {
                            if (stringArray[n].startsWith("--authentication=")) {
                                this.setAuthType(this.extractOptionArg(stringArray[n], "--authentication="));
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.setAuthType(stringArray[n]);
                            }
                            this.mBootstrapArgumentSet = true;
                            if (this.mAuthType == null) {
                                throw new CLIException("pgtool: argument required for option: -a/--authentication", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'b': {
                            if (stringArray[n].startsWith("--base=")) {
                                this.mBaseEntry = this.extractOptionArg(stringArray[n], "--base=");
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mBaseEntry = stringArray[n];
                            }
                            this.mBootstrapArgumentSet = true;
                            if (this.mBaseEntry == null) {
                                throw new CLIException("pgtool: argument required for option: -b/--base", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'e': {
                            if (stringArray[n].startsWith("--entity=")) {
                                this.mEntity = this.extractOptionArg(stringArray[n], "--entity=");
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mEntity = stringArray[n];
                            }
                            if (this.mEntity == null) {
                                throw new CLIException("pgtool: argument required for option: -e/--entity", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'f': {
                            if (stringArray[n].startsWith("--file=")) {
                                this.mBootstrapFile = this.extractOptionArg(stringArray[n], "--file=");
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mBootstrapFile = stringArray[n];
                            }
                            if (this.mBootstrapFile == null) {
                                throw new CLIException("pgtool: argument required for option: -f/--file", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'h': {
                            if (stringArray[n].startsWith("--hostname=")) {
                                this.mHost = this.extractOptionArg(stringArray[n], "--hostname=");
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mHost = stringArray[n];
                            }
                            this.mBootstrapArgumentSet = true;
                            if (this.mHost == null) {
                                throw new CLIException("pgtool: argument required for option: -h/--hostname", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'i': {
                            if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mPriorityStr = stringArray[n];
                            }
                            if (this.mPriorityStr == null) throw new CLIException("pgtool: argument required for option: -i/--priority", CLIException.INVALID_ARGS);
                            this.setPriority(this.mPriorityStr);
                            break block83;
                        }
                        case 'l': {
                            if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mUrl = stringArray[n];
                                this.mBootstrapArgumentSet = true;
                            }
                            if (this.mUrl == null) {
                                throw new CLIException("pgtool: argument required for option: -l/--url", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'm': {
                            if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mProfileName = stringArray[n];
                            }
                            if (this.mProfileName == null) {
                                throw new CLIException("pgtool: argument required for option: -m/--name", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'n': {
                            if (stringArray[n].startsWith("--name=")) {
                                this.mProfileName = this.extractOptionArg(stringArray[n], "--name=");
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mProfileName = stringArray[n];
                            }
                            if (this.mProfileName == null) {
                                throw new CLIException("pgtool: argument required for option: -m/--name", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'p': {
                            boolean bl = false;
                            if (stringArray[n].startsWith("--port=")) {
                                this.mPort = this.extractOptionArg(stringArray[n], "--port=");
                                bl = true;
                            } else if (stringArray[n].equals("--port")) {
                                bl = true;
                                if (stringArray[++n].length() != 0) {
                                    this.mPort = stringArray[n];
                                }
                            } else if (stringArray[n].equals("-p")) {
                                bl = true;
                                if (stringArray[++n].length() != 0) {
                                    this.mPort = stringArray[n];
                                }
                            }
                            if (bl) {
                                this.mBootstrapArgumentSet = true;
                                if (this.mPort == null) {
                                    throw new CLIException("pgtool: argument required for option: -p/--port", CLIException.INVALID_ARGS);
                                }
                            } else {
                                if (stringArray[n].startsWith("--priority=")) {
                                    this.mPriorityStr = this.extractOptionArg(stringArray[n], "--priority=");
                                } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                    this.mPriorityStr = stringArray[n];
                                }
                                if (this.mPriorityStr == null) throw new CLIException("pgtool: argument required for option: -i/--priority", CLIException.INVALID_ARGS);
                                this.setPriority(this.mPriorityStr);
                            }
                            break block83;
                        }
                        case 's': {
                            String string = null;
                            if (stringArray[n].startsWith("--scope=")) {
                                string = this.extractOptionArg(stringArray[n], "--scope=");
                                this.setApplicability(string);
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                string = stringArray[n];
                                this.setApplicability(string);
                            }
                            if (string == null) {
                                throw new CLIException("pgtool: argument required for option: -s/--scope", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 't': {
                            if (stringArray[n].startsWith("--type=")) {
                                this.mType = this.extractOptionArg(stringArray[n], "--type=");
                            } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                this.mType = stringArray[n];
                            }
                            this.mBootstrapArgumentSet = true;
                            if (this.mType == null) {
                                throw new CLIException("pgtool: argument required for option: -t/--type", CLIException.INVALID_ARGS);
                            }
                            break block83;
                        }
                        case 'u': {
                            boolean bl = false;
                            if (stringArray[n].startsWith("--url=")) {
                                bl = true;
                                this.mUrl = this.extractOptionArg(stringArray[n], "--url=");
                            } else if (stringArray[n].equals("--url")) {
                                bl = true;
                                if (stringArray[++n].length() != 0) {
                                    this.mUrl = stringArray[n];
                                }
                            }
                            if (bl) {
                                this.mBootstrapArgumentSet = true;
                                if (this.mUrl == null) {
                                    throw new CLIException("pgtool: argument required for option: -l/--url", CLIException.INVALID_ARGS);
                                }
                            } else {
                                if (stringArray[n].startsWith("--username=")) {
                                    this.mUserName = this.extractOptionArg(stringArray[n], "--username=");
                                } else if (++n < stringArray.length && stringArray[n].length() != 0) {
                                    this.mUserName = stringArray[n];
                                }
                                if (this.mUserName == null) {
                                    throw new CLIException("pgtool: argument required for option: -u/--username", CLIException.INVALID_ARGS);
                                }
                            }
                            break block83;
                        }
                        default: {
                            throw new CLIException("pgtool: illegal option " + stringArray[n], CLIException.INVALID_ARGS);
                        }
                    }
                }
                if (stringArray[n].length() != 0) {
                    this.mOperands.add(stringArray[n]);
                }
            }
            ++n;
        }
        this.checkRequiredArgumentsSet();
    }

    private void checkRequiredArgumentsSet() throws CLIException {
        String[] stringArray;
        if (this.mBootstrapArgumentSet) {
            if (this.mBootstrapFile != null) {
                throw new CLIException("pgtool: cannot specify bootstrap file and bootstrap options", CLIException.INVALID_ARGS);
            }
            if (this.mUrl == null && this.mBaseEntry == null) {
                throw new CLIException("pgtool: incomplete bootstrapping options", CLIException.INVALID_ARGS);
            }
        } else if (this.mBootstrapFile == null) {
            stringArray = new StringBuffer();
            stringArray.append(System.getProperty("user.home"));
            stringArray.append(DEFAULT_BOOTSTRAP_FILENAME);
            this.mBootstrapFile = stringArray.toString();
        }
        if (this.mSubcommand.equals(EXPORT)) {
            this.checkNameSet();
            stringArray = new String[]{"priority"};
            String[] stringArray2 = new String[]{this.mPriorityStr};
            this.checkOptionsNotSet(stringArray, stringArray2);
            this.checkForRequiredOperands(1);
        } else if (this.mSubcommand.equals(IMPORT)) {
            this.checkForRequiredOperands(1);
        } else if (this.mSubcommand.equals(DELETE)) {
            this.checkNameSet();
            stringArray = new String[]{"priority"};
            String[] stringArray3 = new String[]{this.mPriorityStr};
            this.checkOptionsNotSet(stringArray, stringArray3);
            this.checkForRequiredOperands(0);
        } else if (this.mSubcommand.equals(CREATE)) {
            this.checkForRequiredOperands(0);
        } else if (this.mSubcommand.equals(LIST)) {
            this.checkForRequiredOperands(0);
        } else if (this.mSubcommand.equals(RENAME) || this.mSubcommand.equals(MODIFY) || this.mSubcommand.equals(ADD) || this.mSubcommand.equals(REMOVE)) {
            stringArray = new String[]{"name", "priority"};
            String[] stringArray4 = new String[]{this.mProfileName, this.mPriorityStr};
            this.checkOptionsNotSet(stringArray, stringArray4);
            this.checkForRequiredOperands(2);
        }
    }

    void checkNameSet() throws CLIException {
        if (this.mProfileName == null) {
            throw new CLIException("pgtool: invalid options: name option mandatory for " + this.mSubcommand + " command.", CLIException.INVALID_ARGS);
        }
    }

    void checkOptionsNotSet(String[] stringArray, String[] stringArray2) throws CLIException {
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] == null) continue;
            throw new CLIException("pgtool: invalid options: cannot specify " + stringArray[i] + " option for " + this.mSubcommand + " command.", CLIException.INVALID_ARGS);
        }
    }

    private void checkForRequiredOperands(int n) throws CLIException {
        if (this.mOperands.size() != n) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("pgtool: invalid operand(s) for the ");
            stringBuffer.append(this.mSubcommand + " command");
            if (!this.mOperands.isEmpty()) {
                stringBuffer.append(": ");
                for (int i = 0; i < this.mOperands.size(); ++i) {
                    String string = (String)this.mOperands.get(i);
                    if (string == null) continue;
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
            throw new CLIException(stringBuffer.toString(), CLIException.INVALID_ARGS);
        }
    }

    private String extractOptionArg(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return null;
        }
        return string.substring(n + string2.length());
    }
}

