/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.datastore.ldap;

import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.EntityType;
import com.sun.apoc.policy.common.NodeKey;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicyGroupUse;
import com.sun.apoc.policy.common.PolicyId;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.organization.Organization;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.pmgr.LdapClientContext;
import com.sun.apoc.policy.util.BootstrapData;
import com.sun.apoc.policy.util.LdapMetaConfiguration;
import com.sun.apoc.policy.util.MetaConfiguration;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

public class LdapDataStore
extends DataStore {
    public StringBuffer mServiceEntryDNBuf = null;
    public StringBuffer mRootServiceEntryDNBuf = new StringBuffer(200);
    public static final String SERVICES = "services";
    public static final String SERVICE_APOC = "ApocService";
    public static final String SERVICE_ORG_CONFIG = "OrganizationConfig";
    public static final String SERVICE_VERSION = "1.0";
    public static final String SERVICE_DEFAULT = "default";
    public static final String SERVICE_REGISTRY = "ApocRegistry";
    public static final int NUMBER_OF_SERVICE_MAPPING_ELEMENTS = 6;
    private static ServiceMapping[] SERVICE_MAPPING_ELEMENTS = new ServiceMapping[6];
    private static EntryMapping CONTAINER_MAPPING;
    private static EntryMapping POLICYGROUP_MAPPING;
    private static EntryMapping POLICY_MAPPING;
    public static final String DN_KEY = "DN";
    private Hashtable mUserProfileAttrsTable = new Hashtable();
    private MetaConfiguration mDataStoreConfig = null;
    public static final String LDAP_OBJCLASS = "objectclass";
    public static final String ORG_UNIT_OBJCLASS = "organizationalunit";
    public static final String ORG_UNIT_NAMING_ATTR = "ou";
    public static final String CONFIG_NAMING_ATTR = "ou=";
    public static final String SUNSERVICE_OBJCLASS = "sunservice";
    public static final String SUNSERVICE_COMPONENT_OBJCLASS = "sunservicecomponent";
    public static final String SUNSERVICEID_ATTR = "sunserviceid";
    public static final String KEYVALUE_ATTR = "sunkeyvalue";
    public static final String PRIORITY_ATTR = "sunsmspriority";
    private static final String MODIFY_TIMESTAMP_ATTR = "modifytimestamp";
    public static final String USE_KEY = "applicability=";
    public static final String APOC_BLOB_KEY = "APOCBlob=";
    public static final String DISPLAY_NAME_KEY = "displayname=";
    public static final String ORG_MAP_KEY = "organizationalmapping=";
    public static final String LDAP_ATTR_MAP_KEY = "ldapattributemapping=";
    public static final String ASSIGNED_KEY = "assigned=";
    public static final String USER_POLICY_GROUP_USE_VALUE;
    public static final String HOST_POLICY_GROUP_USE_VALUE;
    public static final String GLOBAL_POLICY_GROUP_CONTAINER = "_GlobalPolicyGroups_";
    public static final String DEFAULT_USER_POLICY_GROUP_NAME = "_DefaultUserPolicyGroup_";
    public static final String DEFAULT_HOST_POLICY_GROUP_NAME = "_DefaultHostPolicyGroup_";
    StringBuffer dNBuf = new StringBuffer(200);
    DataStore.ComponentNameParser mComponentNameParser = new DataStore.ComponentNameParser();
    private static final String MODULE = "LdapDataStore";
    public static final String LDAP_WILDCARD = "*";
    private static final String USERPROFILE_KEY = "org.openoffice.UserProfile/Data/";
    private String[] mUserProfileAttrs = new String[]{"givenname", "sn", "initials", "street", "l", "st", "postalcode", "c", "o", "position", "title", "homephone", "telephonenumber", "facsimiletelephonenumber", "mail"};
    private static final String LDAP_MAPPING_SEPARATOR = ",";
    private String mBaseDN = null;
    private static final String[] TIMEONLY_ATTRS;
    private static final String[] ALL_BLOBS_ATTRS;

    public LdapDataStore(BootstrapData bootstrapData, ClientContext clientContext) throws RegistryException {
        this.readBootstrapData(bootstrapData);
        this.mDataStoreConfig = new LdapMetaConfiguration(this, (LdapClientContext)clientContext);
        this.setLdapEntrySettings();
    }

    private void setLdapEntrySettings() throws RegistryException {
        for (int i = 0; i < this.mUserProfileAttrs.length; ++i) {
            String[] stringArray = this.mDataStoreConfig.getStrings(USERPROFILE_KEY + this.mUserProfileAttrs[i], LDAP_MAPPING_SEPARATOR);
            this.mUserProfileAttrsTable.put(this.mUserProfileAttrs[i], stringArray == null ? new String[]{} : stringArray);
        }
        if (this.mUserProfileAttrsTable.isEmpty()) {
            throw new RegistryException("The user profile mapping information is unavailable.", "error.ldap.bootstrap", MODULE, 0);
        }
    }

    public String getUserProfLdapAttribute(String string) throws RegistryException {
        String[] stringArray = (String[])this.mUserProfileAttrsTable.get(string);
        if (stringArray == null || stringArray.length == 0) {
            throw new RegistryException("The attribute, " + string + ", is not part of the user profile.", "error.userprofile.attribute", MODULE, 0);
        }
        return stringArray[0];
    }

    public String getBaseDN() {
        return this.mBaseDN;
    }

    public String getRootServiceEntryDN() {
        return this.mRootServiceEntryDNBuf.toString();
    }

    public String getServiceEntryDN() {
        return this.mServiceEntryDNBuf.toString();
    }

    public MetaConfiguration getDataStoreMetaConfiguration() {
        return this.mDataStoreConfig;
    }

    private void readBootstrapData(BootstrapData bootstrapData) throws RegistryException {
        this.mBaseDN = bootstrapData.getBaseDN();
        if (this.mBaseDN == null) {
            throw new RegistryException("The bootstrapping information for the LDAP directory server is incomplete.", "error.bootstrap.incomplete", MODULE, 0);
        }
        this.mServiceEntryDNBuf = new StringBuffer(200);
        for (int i = 0; i < 6; ++i) {
            this.mServiceEntryDNBuf.append(LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].mEntryRDN);
            if (i + 1 >= 6) continue;
            this.mServiceEntryDNBuf.append(LDAP_MAPPING_SEPARATOR);
        }
        this.mRootServiceEntryDNBuf.append(this.mServiceEntryDNBuf).append(LDAP_MAPPING_SEPARATOR).append(this.mBaseDN);
    }

    public Vector getRoleMembers(EntityId entityId, String string, String string2, String[] stringArray, EntityId entityId2, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(&(");
        stringBuffer.append(LDAP_OBJCLASS);
        stringBuffer.append("=");
        stringBuffer.append(string);
        stringBuffer.append(")(");
        stringBuffer.append(string2);
        stringBuffer.append("=");
        stringBuffer.append(entityId.getLocation());
        stringBuffer.append("))");
        Vector vector = null;
        vector = this.performSearch(entityId2.getLocation(), true, stringBuffer.toString(), stringArray, true, bl, booleanReturnObject, false, clientContext);
        return vector == null ? new Vector() : vector;
    }

    public Vector getListOfChildren(EntityId entityId, String string, String string2, boolean bl, String[] stringArray, boolean bl2, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (string != null) {
            stringBuffer.append(string).append(LDAP_MAPPING_SEPARATOR);
        }
        stringBuffer.append(entityId.getLocation());
        Vector vector = this.performSearch(stringBuffer.toString(), bl, string2, stringArray, true, bl2, booleanReturnObject, false, clientContext);
        return vector;
    }

    public PolicySetId[] getPolicyGroups(PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        if (policyGroupUse == null || policyGroupUse == PolicyGroupUse.UNKNOWN) {
            return new PolicySetId[0];
        }
        return this.getContainedPolicyGroups(null, policyGroupUse, clientContext);
    }

    private PolicySetId[] getContainedPolicyGroups(EntityId entityId, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        int n;
        Vector vector;
        PolicySetId[] policySetIdArray;
        int n2;
        block16: {
            n2 = 0;
            if (entityId != null && entityId.getEntityType() == EntityType.ROLE) {
                return new PolicySetId[n2];
            }
            String string = null;
            policySetIdArray = null;
            StringBuffer stringBuffer = new StringBuffer(200);
            if (entityId == null) {
                stringBuffer.append(CONFIG_NAMING_ATTR).append(GLOBAL_POLICY_GROUP_CONTAINER).append(LDAP_MAPPING_SEPARATOR).append(this.getRootServiceEntryDN());
            } else {
                stringBuffer.append(this.getServiceEntryDN());
                stringBuffer.append(LDAP_MAPPING_SEPARATOR).append(entityId.getLocation());
            }
            string = stringBuffer.toString();
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append("(");
            stringBuffer.append(CONFIG_NAMING_ATTR);
            if (entityId == null) {
                stringBuffer.append(LDAP_WILDCARD);
            } else {
                switch (policyGroupUse.getIntValue()) {
                    case 2: {
                        stringBuffer.append(DEFAULT_HOST_POLICY_GROUP_NAME);
                        break;
                    }
                    case 1: {
                        stringBuffer.append(DEFAULT_USER_POLICY_GROUP_NAME);
                    }
                }
            }
            stringBuffer.append(")");
            String[] stringArray = new String[]{KEYVALUE_ATTR, PRIORITY_ATTR};
            vector = null;
            try {
                vector = this.getEntriesAttributes(string, false, stringBuffer.toString(), stringArray, true, clientContext);
            }
            catch (RegistryException registryException) {
                if (registryException.getErrorCode() != 32) break block16;
                return new PolicySetId[0];
            }
        }
        if (vector.isEmpty()) {
            return new PolicySetId[n2];
        }
        PolicyGroupIdImpl policyGroupIdImpl = null;
        Vector vector2 = null;
        int n3 = vector.size();
        int n4 = 0;
        TreeSet<PolicyGroupIdImpl> treeSet = new TreeSet<PolicyGroupIdImpl>(new PolicyGroupPrioritySorter());
        for (int i = 0; i < n3; ++i) {
            vector2 = (Vector)vector.get(i);
            n = vector2.size();
            if (n <= 0) continue;
            try {
                policyGroupIdImpl = this.getPolicyGroupIdImpl((String)vector2.get(n - 1), vector2, entityId, clientContext);
                if (policyGroupIdImpl.getPolicyGroupUse() != policyGroupUse) continue;
                policyGroupIdImpl.setPolicyGroupUse(policyGroupUse);
                policyGroupIdImpl.setContainerId(entityId);
                treeSet.add(policyGroupIdImpl);
                ++n4;
                continue;
            }
            catch (RegistryException registryException) {
                // empty catch block
            }
        }
        Iterator iterator = treeSet.iterator();
        policySetIdArray = new PolicySetId[n4];
        n = 0;
        while (iterator.hasNext()) {
            policySetIdArray[n++] = (PolicySetId)iterator.next();
        }
        return policySetIdArray;
    }

    private PolicyGroupIdImpl getPolicyGroupIdImpl(String string, Vector vector, EntityId entityId, ClientContext clientContext) throws RegistryException {
        String[] stringArray;
        if (string == null) {
            throw new RegistryException("Cannot construct PolicyGroupIdImpl.", "error.occurred", MODULE, 0);
        }
        PolicyGroupIdImpl policyGroupIdImpl = null;
        String string2 = null;
        Object var7_7 = null;
        String string3 = null;
        if (vector == null || vector.isEmpty()) {
            stringArray = new String[]{KEYVALUE_ATTR, PRIORITY_ATTR};
            try {
                vector = this.getAttributeValueList(string, stringArray, false, clientContext);
            }
            catch (LDAPException lDAPException) {
                throw new RegistryException("Cannot construct PolicyGroupIdImpl as unable to access policy group in datastore.", "error.ldap.read", MODULE, 0);
            }
            if (vector.isEmpty()) {
                throw new RegistryException("Cannot construct PolicyGroupIdImpl.", "error.occurred", MODULE, 0);
            }
        } else {
            vector.remove(vector.size() - 1);
        }
        string3 = (String)vector.lastElement();
        stringArray = LdapDataStore.getValuesForKey(vector, DISPLAY_NAME_KEY);
        if (stringArray.length != 0) {
            string2 = stringArray[0];
        }
        policyGroupIdImpl = new PolicyGroupIdImpl(string2, entityId, string3);
        if (string != null) {
            policyGroupIdImpl.setDataStoreEntry(string);
            String[] stringArray2 = LDAPDN.explodeDN((String)string, (boolean)false);
            String string4 = stringArray2[0];
            int n = string4.indexOf("=");
            if (n != -1 && ++n < stringArray2[0].length()) {
                policyGroupIdImpl.setName(string4.substring(n));
            }
        }
        stringArray = LdapDataStore.getValuesForKey(vector, USE_KEY);
        for (int i = 0; i < stringArray.length; ++i) {
            policyGroupIdImpl.setPolicyGroupUse(PolicyGroupUse.getPolicyGroupUse(stringArray[i]));
        }
        return policyGroupIdImpl;
    }

    private LDAPEntry readAttributes(String string, String[] stringArray, LdapClientContext ldapClientContext) throws LDAPException {
        LDAPConnection lDAPConnection = ldapClientContext.getConnection();
        LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
        return lDAPEntry;
    }

    public String readEntryDN(String string, ClientContext clientContext) throws RegistryException {
        String string2 = null;
        try {
            LDAPConnection lDAPConnection = ((LdapClientContext)clientContext).getConnection();
            LDAPEntry lDAPEntry = lDAPConnection.read(string);
            if (lDAPEntry != null) {
                string2 = lDAPEntry.getDN();
            }
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                throw new RegistryException("LDAP entry does not exist for this EntityId.", "error.occurred", MODULE, 0);
            }
            throw new RegistryException("An LDAP read error occurred: " + (Object)((Object)lDAPException), "error.ldap.read", MODULE, lDAPException.getLDAPResultCode());
        }
        return string2;
    }

    public Hashtable getAttributeValueTable(String string, boolean bl, String[] stringArray, ClientContext clientContext) throws LDAPException {
        LDAPEntry lDAPEntry = null;
        lDAPEntry = this.readAttributes(string, stringArray, (LdapClientContext)clientContext);
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        if (lDAPEntry != null) {
            if (bl) {
                Vector<String> vector = new Vector<String>();
                vector.add(lDAPEntry.getDN());
                hashtable.put(DN_KEY, vector);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], LdapDataStore.getAllValues(lDAPEntry, stringArray[i]));
            }
        }
        return hashtable;
    }

    public Vector getAttributeValueList(String string, String[] stringArray, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws LDAPException {
        return this.getAttributeValueList(string, stringArray, bl, false, clientContext, booleanReturnObject);
    }

    public Vector getAttributeValueList(String string, String[] stringArray, boolean bl, boolean bl2, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws LDAPException {
        Vector<String> vector = new Vector<String>();
        LDAPEntry lDAPEntry = null;
        lDAPEntry = this.readAttributes(string, stringArray, (LdapClientContext)clientContext);
        if (lDAPEntry != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[i]);
                if (lDAPAttribute == null) continue;
                if (bl) {
                    booleanReturnObject.setReturnValue(true);
                    return vector;
                }
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    vector.add((String)enumeration.nextElement());
                }
            }
            if (bl2) {
                vector.add(lDAPEntry.getDN());
            }
        }
        return vector;
    }

    public Vector getAttributeValueList(String string, String[] stringArray, ClientContext clientContext) throws LDAPException {
        return this.getAttributeValueList(string, stringArray, false, clientContext, new Organization.BooleanReturnObject(false));
    }

    public Vector getAttributeValueList(String string, String[] stringArray, boolean bl, ClientContext clientContext) throws LDAPException {
        return this.getAttributeValueList(string, stringArray, false, bl, clientContext, new Organization.BooleanReturnObject(false));
    }

    public Vector performSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, boolean bl3, Organization.BooleanReturnObject booleanReturnObject, boolean bl4, ClientContext clientContext) throws RegistryException {
        return this.performSearch(string, bl, string2, stringArray, bl2, bl3, booleanReturnObject, bl4, ((LdapClientContext)clientContext).getConnection());
    }

    public Vector performSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, boolean bl3, Organization.BooleanReturnObject booleanReturnObject, boolean bl4, LDAPConnection lDAPConnection) throws RegistryException {
        Vector vector;
        block8: {
            vector = new Vector();
            LDAPSearchResults lDAPSearchResults = null;
            try {
                lDAPSearchResults = this.doSearch(string, bl, string2, stringArray, bl4, lDAPConnection);
                if (bl3) {
                    if (lDAPSearchResults.hasMoreElements()) {
                        booleanReturnObject.setReturnValue(true);
                    }
                    lDAPConnection.abandon(lDAPSearchResults);
                    return vector;
                }
                while (lDAPSearchResults.hasMoreElements()) {
                    Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (bl2) {
                        Vector<String> vector2 = new Vector<String>();
                        vector2.add(lDAPEntry.getDN());
                        hashtable.put(DN_KEY, vector2);
                    }
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            hashtable.put(stringArray[i], LdapDataStore.getAllValues(lDAPEntry, stringArray[i]));
                        }
                    }
                    vector.add(hashtable);
                }
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 4 || n == 11) break block8;
                throw new RegistryException("An LDAP read error occurred during the search: " + (Object)((Object)lDAPException), "error.ldap.search", MODULE, n);
            }
        }
        return vector;
    }

    public Vector getEntriesAttributes(String string, boolean bl, String string2, String[] stringArray, boolean bl2, ClientContext clientContext) throws RegistryException {
        Vector vector;
        block6: {
            vector = new Vector();
            try {
                LDAPSearchResults lDAPSearchResults = this.doSearch(string, bl, string2, stringArray, false, (LdapClientContext)clientContext);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    Vector<String> vector2 = new Vector<String>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Vector vector3 = LdapDataStore.getAllValues(lDAPEntry, stringArray[i]);
                        if (vector3 == null || vector3.isEmpty()) continue;
                        for (int j = 0; j < vector3.size(); ++j) {
                            vector2.add((String)vector3.get(j));
                        }
                    }
                    if (bl2) {
                        vector2.add(lDAPEntry.getDN());
                    }
                    vector.add(vector2);
                }
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 4 || n == 11) break block6;
                throw new RegistryException("An LDAP read error occurred: " + (Object)((Object)lDAPException), "error.ldap.read", MODULE, n);
            }
        }
        return vector;
    }

    private LDAPSearchResults doSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, LdapClientContext ldapClientContext) throws LDAPException {
        return this.doSearch(string, bl, string2, stringArray, bl2, ldapClientContext.getConnection());
    }

    private LDAPSearchResults doSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, LDAPConnection lDAPConnection) throws LDAPException {
        int n = 1;
        if (bl) {
            n = 2;
        }
        if (string == null) {
            string = this.mBaseDN;
        }
        return lDAPConnection.search(string, n, string2, stringArray, bl2);
    }

    public PolicySetId createPolicyGroup(EntityId entityId, String string, PolicyGroupUse policyGroupUse, int n, ClientContext clientContext) throws RegistryException {
        block6: {
            block5: {
                if (entityId == null) break block5;
                if (string != null) break block6;
                switch (policyGroupUse.getIntValue()) {
                    case 1: {
                        string = DEFAULT_USER_POLICY_GROUP_NAME;
                        break block6;
                    }
                    case 2: {
                        string = DEFAULT_HOST_POLICY_GROUP_NAME;
                        break block6;
                    }
                    default: {
                        throw new RegistryException("A valid scope must be specified for an entity policy group.", "error.occurred", MODULE, 0);
                    }
                }
            }
            if (string == null) {
                throw new RegistryException("A display name  must be specified for a global policy group.", "error.occurred", MODULE, 0);
            }
        }
        PolicyGroupIdImpl policyGroupIdImpl = this.createPolicyGroupIdImpl(string, entityId, n);
        policyGroupIdImpl.setPolicyGroupUse(policyGroupUse);
        this.createPolicyGroup(policyGroupIdImpl, clientContext);
        return policyGroupIdImpl;
    }

    public void createPolicyGroup(PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        PolicySetId policySetId = this.findPolicyGroup(policyGroupIdImpl.getDisplayName(), policyGroupIdImpl.getContainerId(), policyGroupIdImpl.getPolicyGroupUse(), clientContext);
        if (policySetId != null) {
            throw new RegistryException("A policy group with this name already exists.", "error.policygroup.name.exists", MODULE, 0);
        }
        if (policyGroupIdImpl.getContainerId() == null) {
            if (policyGroupIdImpl.getPriority() == 0) {
                int n = 1;
                Vector vector = this.getPolicyGroupPriorities(null, policyGroupIdImpl.getPolicyGroupUse(), clientContext);
                if (vector != null && !vector.isEmpty()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Integer n2 = (Integer)vector.get(i);
                        if (n2 < n) continue;
                        n = n2 + 1;
                    }
                }
                policyGroupIdImpl.setPriority(n);
            } else {
                this.checkForPriorityConflict(policyGroupIdImpl, clientContext);
            }
        } else if (policyGroupIdImpl.getContainerId().getEntityType() == EntityType.ROLE) {
            throw new RegistryException("Entity policy groups cannot be created for roles.", "error.occurred", MODULE, 0);
        }
        try {
            this.createPolicyGroupEntry(policyGroupIdImpl, ((LdapClientContext)clientContext).getConnection());
        }
        catch (LDAPException lDAPException) {
            throw new RegistryException("An LDAP error occured while creating the policy group, " + policyGroupIdImpl.getDisplayName() + ": " + (Object)((Object)lDAPException), "error.ldap.policygroup.creation", MODULE, 0);
        }
    }

    private void createPolicyGroupEntry(PolicyGroupIdImpl policyGroupIdImpl, LDAPConnection lDAPConnection) throws LDAPException {
        Object object;
        String[] stringArray;
        String string;
        if (policyGroupIdImpl.getName() == null) {
            string = policyGroupIdImpl.getDataStoreEntry();
            stringArray = null;
            String string2 = null;
            object = new Random();
            int n = 0;
            do {
                if ((n = ((Random)object).nextInt()) < 0) {
                    n = -n;
                }
                stringArray = String.valueOf(((Random)object).nextInt());
            } while (this.entryExists(string2 = CONFIG_NAMING_ATTR + (String)stringArray + LDAP_MAPPING_SEPARATOR + string, lDAPConnection));
            policyGroupIdImpl.setName((String)stringArray);
            policyGroupIdImpl.setDataStoreEntry(string2);
        }
        string = new LDAPAttributeSet();
        stringArray = new String[]{DISPLAY_NAME_KEY + policyGroupIdImpl.getDisplayName(), USE_KEY + policyGroupIdImpl.getPolicyGroupUse().getStringValue()};
        try {
            string.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.POLICYGROUP_MAPPING.mObjectClass));
            string.add(new LDAPAttribute(PRIORITY_ATTR, Integer.toString(policyGroupIdImpl.getPriority())));
            string.add(new LDAPAttribute(KEYVALUE_ATTR, stringArray));
            string.add(LdapDataStore.POLICYGROUP_MAPPING.mServiceIdAttr);
            this.addEntry(policyGroupIdImpl.getDataStoreEntry(), (LDAPAttributeSet)string, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                block10: {
                    object = policyGroupIdImpl.getContainerId();
                    String string3 = null;
                    string3 = object == null ? this.mBaseDN : ((EntityId)object).getLocation();
                    String string4 = this.ensureServiceEntryExistsForEntry(string3, lDAPConnection);
                    if (object == null) {
                        String string5 = "ou=_GlobalPolicyGroups_," + string4;
                        try {
                            lDAPConnection.read(string5);
                        }
                        catch (LDAPException lDAPException2) {
                            if (lDAPException2.getLDAPResultCode() == 32) {
                                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                                lDAPAttributeSet.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.CONTAINER_MAPPING.mObjectClass));
                                lDAPAttributeSet.add(LdapDataStore.CONTAINER_MAPPING.mServiceIdAttr);
                                this.addEntry(string5, lDAPAttributeSet, lDAPConnection);
                                break block10;
                            }
                            throw lDAPException2;
                        }
                    }
                }
                this.addEntry(policyGroupIdImpl.getDataStoreEntry(), (LDAPAttributeSet)string, lDAPConnection);
            }
            throw lDAPException;
        }
    }

    public void renamePolicyGroup(PolicyGroupIdImpl policyGroupIdImpl, String string, ClientContext clientContext) throws RegistryException {
        if (policyGroupIdImpl == null || string == null || string.length() < 1) {
            throw new RegistryException("Cannot rename policy group as parameters are invalid.", "error.occurred", MODULE, 0);
        }
        PolicySetId policySetId = this.findPolicyGroup(policyGroupIdImpl.getDisplayName(), policyGroupIdImpl.getContainerId(), policyGroupIdImpl.getPolicyGroupUse(), clientContext);
        if (policySetId == null) {
            throw new RegistryException("The policy group does not exist.", "error.policygroup.not.exists", MODULE, 0);
        }
        policySetId = this.findPolicyGroup(string, policyGroupIdImpl.getContainerId(), policyGroupIdImpl.getPolicyGroupUse(), clientContext);
        if (policySetId != null) {
            throw new RegistryException("A policy group with this name already exists.", "error.policygroup.name.exists", MODULE, 0);
        }
        String[] stringArray = new String[]{DISPLAY_NAME_KEY + policyGroupIdImpl.getDisplayName()};
        this.removeMultiValuedAttributeValues(policyGroupIdImpl.getDataStoreEntry(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, clientContext);
        stringArray[0] = DISPLAY_NAME_KEY + string;
        this.addValuesToMultiValuedAttribute(policyGroupIdImpl.getDataStoreEntry(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, clientContext);
    }

    public void deletePolicyGroups(PolicySetId[] policySetIdArray, ClientContext clientContext) throws RegistryException {
        if (policySetIdArray == null || policySetIdArray.length == 0) {
            return;
        }
        for (int i = 0; i < policySetIdArray.length; ++i) {
            try {
                this.deleteEntry(((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry(), (LdapClientContext)clientContext);
                continue;
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 32) {
                    throw new RegistryException("Cannot delete policy group because it does not exist: " + policySetIdArray[i].getDisplayName() + ": " + (Object)((Object)lDAPException), "error.policygroup.not.exists", MODULE, 0);
                }
                if (n == 66) {
                    try {
                        LDAPSearchResults lDAPSearchResults = this.doSearch(((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry(), false, "objectclass=sunservicecomponent", null, false, (LdapClientContext)clientContext);
                        while (lDAPSearchResults.hasMoreElements()) {
                            LDAPEntry lDAPEntry = lDAPSearchResults.next();
                            this.deleteEntry(lDAPEntry.getDN(), (LdapClientContext)clientContext);
                        }
                        this.deleteEntry(((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry(), (LdapClientContext)clientContext);
                        continue;
                    }
                    catch (LDAPException lDAPException2) {
                        throw new RegistryException("An LDAP error occurred during the deletion of a policy group, " + policySetIdArray[i].getDisplayName() + ": " + (Object)((Object)lDAPException2), "error.ldap.policygroup.deletion", MODULE, 0);
                    }
                }
                throw new RegistryException("An LDAP error occurred during the deletion of a policy group, " + policySetIdArray[i].getDisplayName() + ": " + (Object)((Object)lDAPException), "error.ldap.policygroup.deletion", MODULE, 0);
            }
        }
        this.getConfigDataManager().flushNodeCache();
    }

    private void deleteEntry(String string, LdapClientContext ldapClientContext) throws LDAPException {
        ldapClientContext.getConnection().delete(string);
    }

    private void createComponentEntry(PolicyGroupIdImpl policyGroupIdImpl, String string, LDAPConnection lDAPConnection) throws RegistryException {
        block4: {
            try {
                this.createPolicyGroupEntry(policyGroupIdImpl, lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 68) break block4;
                throw new RegistryException("An LDAP error occured while creating the policy group, " + policyGroupIdImpl.getDisplayName() + ": " + (Object)((Object)lDAPException), "error.ldap.policygroup.creation", MODULE, 0);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        try {
            stringBuffer.append(CONFIG_NAMING_ATTR).append(string).append(LDAP_MAPPING_SEPARATOR).append(policyGroupIdImpl.getDataStoreEntry());
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.POLICY_MAPPING.mObjectClass));
            lDAPAttributeSet.add(LdapDataStore.POLICY_MAPPING.mServiceIdAttr);
            this.addEntry(stringBuffer.toString(), lDAPAttributeSet, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            throw new RegistryException("An LDAP error occurred when creating the component entry " + stringBuffer.toString() + ": " + (Object)((Object)lDAPException), "error.ldap.write", MODULE, 0);
        }
    }

    private void addEntry(String string, LDAPAttributeSet lDAPAttributeSet, LDAPConnection lDAPConnection) throws LDAPException {
        int n;
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        String string2 = stringArray[0].substring(0, n = stringArray[0].indexOf(61));
        if (lDAPAttributeSet.getAttribute(string2) == null) {
            lDAPAttributeSet.add(new LDAPAttribute(string2, stringArray[0].substring(n + 1)));
        }
        LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    private void writeAttributes(EntityId entityId, String string, Change[] changeArray, boolean bl, LdapClientContext ldapClientContext) throws RegistryException {
        LDAPConnection lDAPConnection = ldapClientContext.getConnection();
        this.writeAttributes(entityId.getLocation(), string, changeArray, bl, lDAPConnection);
    }

    private void writeAttributes(String string, String string2, Change[] changeArray, boolean bl, LDAPConnection lDAPConnection) throws RegistryException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        try {
            if (!this.containsContainer(string, string2, lDAPConnection)) {
                lDAPModificationSet.add(0, new LDAPAttribute(LDAP_OBJCLASS, string2));
            }
            for (int i = 0; i < changeArray.length; ++i) {
                LDAPAttribute lDAPAttribute = bl ? new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues) : new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues[0]);
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            lDAPConnection.modify(string, lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            throw new RegistryException("A LDAP write error occurred when updating the entity " + string + ": " + (Object)((Object)lDAPException), "error.ldap.write", MODULE, lDAPException.getLDAPResultCode());
        }
    }

    private void deleteAttributeValues(String string, String string2, Change[] changeArray, boolean bl, LDAPConnection lDAPConnection) throws RegistryException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        try {
            for (int i = 0; i < changeArray.length; ++i) {
                LDAPAttribute lDAPAttribute = bl ? new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues) : new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues[0]);
                lDAPModificationSet.add(1, lDAPAttribute);
            }
            lDAPConnection.modify(string, lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    public boolean entryExists(String string, ClientContext clientContext) {
        return this.entryExists(string, ((LdapClientContext)clientContext).getConnection());
    }

    private boolean entryExists(String string, LDAPConnection lDAPConnection) {
        try {
            lDAPConnection.read(string);
            return true;
        }
        catch (LDAPException lDAPException) {
            return false;
        }
    }

    private boolean containsContainer(String string, String string2, LDAPConnection lDAPConnection) throws LDAPException {
        LDAPAttribute lDAPAttribute;
        String[] stringArray = new String[]{LDAP_OBJCLASS};
        LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(stringArray[0])) != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                if (!string2.equalsIgnoreCase((String)enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public void readPolicy(PolicyId policyId, boolean bl, ClientContext clientContext) throws RegistryException {
        Object object;
        String[] stringArray = bl ? new String[]{MODIFY_TIMESTAMP_ATTR} : new String[]{MODIFY_TIMESTAMP_ATTR, KEYVALUE_ATTR};
        StringBuffer stringBuffer = new StringBuffer(200);
        try {
            object = (PolicyGroupIdImpl)policyId.getPolicySetId();
            stringBuffer.append(CONFIG_NAMING_ATTR).append(this.mComponentNameParser.getStoredFormat(policyId.getComponentName())).append(LDAP_MAPPING_SEPARATOR).append(((PolicyGroupIdImpl)policyId.getPolicySetId()).getDataStoreEntry());
        }
        catch (NullPointerException nullPointerException) {
            throw new RegistryException("Cannot read policy data because the policy name is invalid.", "error.policy.invalid", MODULE, 0);
        }
        object = null;
        try {
            object = this.getAttributeValueList(stringBuffer.toString(), stringArray, clientContext);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        if (object != null) {
            if (bl) {
                if (((Vector)object).size() == 1) {
                    policyId.setTimeStamp((String)((Vector)object).get(0));
                }
            } else if (((Vector)object).size() > 1) {
                policyId.setTimeStamp((String)((Vector)object).get(0));
                String[] stringArray2 = LdapDataStore.getValuesForKey((Vector)object, APOC_BLOB_KEY);
                policyId.setData(stringArray2[0]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeComponent(NodeKey nodeKey, String string, ClientContext clientContext) throws RegistryException {
        if (nodeKey == null || nodeKey.mComponentName == null) {
            throw new RegistryException("The name of the policy is invalid", "error.policy.invalid", MODULE, 0);
        }
        String string2 = this.mComponentNameParser.getStoredFormat(nodeKey.mComponentName);
        LDAPConnection lDAPConnection = ((LdapClientContext)clientContext).getConnection();
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(CONFIG_NAMING_ATTR).append(string2);
        stringBuffer.append(LDAP_MAPPING_SEPARATOR);
        stringBuffer.append(nodeKey.mGroupLayer.getDataStoreEntry());
        String string3 = stringBuffer.toString();
        if (string == null || string.length() == 0) {
            try {
                lDAPConnection.delete(string3);
                return;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) return;
                throw new RegistryException("An LDAP error occurred when deleting " + string3 + ": " + (Object)((Object)lDAPException), "error.ldap.policygroup.deletion", MODULE, 0);
            }
        }
        Change[] changeArray = new Change[]{new Change(KEYVALUE_ATTR, APOC_BLOB_KEY + string)};
        try {
            this.writeAttributes(string3, SUNSERVICE_COMPONENT_OBJCLASS, changeArray, false, lDAPConnection);
            return;
        }
        catch (RegistryException registryException) {
            if (registryException.getErrorCode() != 32) throw registryException;
            this.createComponentEntry(nodeKey.mGroupLayer, string2, lDAPConnection);
            this.writeAttributes(string3, SUNSERVICE_COMPONENT_OBJCLASS, changeArray, false, lDAPConnection);
            return;
        }
    }

    public void removeMultiValuedAttributeValues(String string, String string2, String[] stringArray, String string3, ClientContext clientContext) throws RegistryException {
        if (string2 == null || stringArray == null) {
            throw new RegistryException("Invalid parameters for modification.", "error.occurred", MODULE, 0);
        }
        Change[] changeArray = new Change[]{new Change(string2, stringArray)};
        LDAPConnection lDAPConnection = ((LdapClientContext)clientContext).getConnection();
        this.deleteAttributeValues(string, string3, changeArray, true, lDAPConnection);
    }

    public void fillAttributes(EntityId entityId, String[] stringArray, String[] stringArray2, String string, ClientContext clientContext) throws RegistryException {
        if (entityId == null) {
            throw new RegistryException("Invalid parameters for modification.", "error.occurred", MODULE, 0);
        }
        this.fillAttributes(entityId.getLocation(), stringArray, stringArray2, string, clientContext);
    }

    public void fillAttributes(String string, String[] stringArray, String[] stringArray2, String string2, ClientContext clientContext) throws RegistryException {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            throw new RegistryException("Invalid parameters for modification.", "error.occurred", MODULE, 0);
        }
        int n = stringArray.length;
        Change[] changeArray = new Change[n];
        for (int i = 0; i < n; ++i) {
            changeArray[i] = new Change(stringArray[i], stringArray2[i]);
        }
        LDAPConnection lDAPConnection = ((LdapClientContext)clientContext).getConnection();
        this.writeAttributes(string, string2, changeArray, false, lDAPConnection);
    }

    public void addValuesToMultiValuedAttribute(String string, String string2, String[] stringArray, String string3, ClientContext clientContext) throws RegistryException {
        Object object;
        if (string2 == null || stringArray == null) {
            throw new RegistryException("Invalid parameters for modification.", "error.occurred", MODULE, 0);
        }
        Vector vector = new Vector();
        LDAPConnection lDAPConnection = null;
        HashSet<String> hashSet = new HashSet<String>();
        LDAPEntry lDAPEntry = null;
        try {
            lDAPConnection = ((LdapClientContext)clientContext).getConnection();
            lDAPEntry = lDAPConnection.read(string);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                try {
                    object = this.getDNExcludingServiceEntry(string);
                    this.ensureServiceEntryExistsForEntry((String)object, lDAPConnection);
                    lDAPEntry = lDAPConnection.read(string);
                }
                catch (LDAPException lDAPException2) {
                    throw new RegistryException("An LDAP read error occurred while adding values: " + (Object)((Object)lDAPException2), "error.ldap.read", MODULE, lDAPException2.getLDAPResultCode());
                }
            }
            throw new RegistryException("An LDAP read error occurred while adding values: " + (Object)((Object)lDAPException), "error.ldap.read", MODULE, lDAPException.getLDAPResultCode());
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string2);
        if (lDAPAttribute != null) {
            object = lDAPAttribute.getStringValues();
            while (object.hasMoreElements()) {
                hashSet.add((String)object.nextElement());
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        Change[] changeArray = new Change[]{new Change()};
        changeArray[0].mName = string2;
        int n = hashSet.size();
        changeArray[0].mValues = new String[n];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            changeArray[0].mValues[n2++] = (String)iterator.next();
        }
        this.writeAttributes(string, string3, changeArray, true, lDAPConnection);
    }

    public String[] getComponentList(PolicySetId[] policySetIdArray, ClientContext clientContext) throws RegistryException {
        HashSet<String> hashSet = new HashSet<String>();
        LDAPConnection lDAPConnection = ((LdapClientContext)clientContext).getConnection();
        LDAPSearchResults lDAPSearchResults = null;
        String string = null;
        String string2 = "ou=*";
        String[] stringArray = new String[]{ORG_UNIT_NAMING_ATTR};
        for (int i = 0; i < policySetIdArray.length; ++i) {
            try {
                string = ((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry();
                lDAPSearchResults = this.doSearch(string, false, string2, stringArray, false, lDAPConnection);
                while (lDAPSearchResults.hasMoreElements()) {
                    String string3 = LdapDataStore.getFirstValue(lDAPSearchResults.next(), stringArray[0]);
                    if (string3 == null) continue;
                    hashSet.add(this.mComponentNameParser.getOutputFormat(string3));
                }
                continue;
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
        return hashSet.toArray(new String[0]);
    }

    String buildComponent(Hashtable hashtable, String[] stringArray) {
        return (String)hashtable.get(stringArray[0]);
    }

    private static String buildComponentNameFilter(String[] stringArray, DataStore.ComponentNameParser componentNameParser) {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (stringArray.length > 1) {
            stringBuffer.append("|");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("(").append(CONFIG_NAMING_ATTR);
                stringBuffer.append(componentNameParser.getStoredFormat(stringArray[i]));
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append(CONFIG_NAMING_ATTR);
            if (stringArray.length == 0) {
                stringBuffer.append(LDAP_WILDCARD);
            } else {
                stringBuffer.append(componentNameParser.getStoredFormat(stringArray[0]));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String getFirstValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    private static Vector getAllValues(LDAPEntry lDAPEntry, String string) {
        Vector<String> vector = new Vector<String>();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute == null) {
            return vector;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            vector.add((String)enumeration.nextElement());
        }
        return vector;
    }

    public PolicyId[] getPolicyIds(PolicySetId policySetId, String[] stringArray, boolean bl, ClientContext clientContext) throws RegistryException {
        if (policySetId == null || stringArray == null || stringArray.length == 0 || clientContext == null) {
            throw new RegistryException("Invalid parameters.", "error.occurred", MODULE, 0);
        }
        PolicyId[] policyIdArray = new PolicyId[stringArray.length];
        String string = ((PolicyGroupIdImpl)policySetId).getDataStoreEntry();
        Hashtable<String, PolicyId> hashtable = new Hashtable<String, PolicyId>(stringArray.length);
        try {
            LDAPSearchResults lDAPSearchResults = this.doSearch(string, false, LdapDataStore.buildComponentNameFilter(stringArray, this.mComponentNameParser), bl ? TIMEONLY_ATTRS : ALL_BLOBS_ATTRS, false, (LdapClientContext)clientContext);
            while (lDAPSearchResults.hasMoreElements()) {
                String string2;
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string3 = LdapDataStore.getFirstValue(lDAPEntry, ORG_UNIT_NAMING_ATTR);
                if (string3 == null) continue;
                string3 = this.mComponentNameParser.getOutputFormat(string3);
                PolicyId policyId = new PolicyId(string3, policySetId);
                policyId.setTimeStamp(LdapDataStore.getFirstValue(lDAPEntry, MODIFY_TIMESTAMP_ATTR));
                if (!bl && (string2 = LdapDataStore.getFirstValue(lDAPEntry, KEYVALUE_ATTR)) != null && string2.startsWith(APOC_BLOB_KEY)) {
                    policyId.setData(string2.substring(APOC_BLOB_KEY.length()));
                }
                hashtable.put(string3, policyId);
            }
        }
        catch (LDAPException lDAPException) {
            throw new RegistryException("An LDAP read error has occurred: " + (Object)((Object)lDAPException), "error.ldap.read", MODULE, lDAPException.getLDAPResultCode());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            policyIdArray[i] = (PolicyId)hashtable.get(stringArray[i]);
        }
        return policyIdArray;
    }

    public String[] getPolicies(PolicySetId policySetId, String[] stringArray, ClientContext clientContext) throws RegistryException {
        String[] stringArray2;
        if (policySetId == null || stringArray == null || stringArray.length == 0 || clientContext == null) {
            throw new RegistryException("Invalid parameters.", "error.occurred", MODULE, 0);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = LdapDataStore.buildComponentNameFilter(stringArray, this.mComponentNameParser);
        String[] stringArray3 = new String[2];
        PolicyGroupIdImpl policyGroupIdImpl = (PolicyGroupIdImpl)policySetId;
        stringArray3[0] = ORG_UNIT_NAMING_ATTR;
        stringArray3[1] = KEYVALUE_ATTR;
        try {
            stringArray2 = this.doSearch(policyGroupIdImpl.getDataStoreEntry(), false, string, stringArray3, false, (LdapClientContext)clientContext);
            String string2 = null;
            String string3 = null;
            while (stringArray2.hasMoreElements()) {
                LDAPEntry lDAPEntry = stringArray2.next();
                string2 = LdapDataStore.getFirstValue(lDAPEntry, ORG_UNIT_NAMING_ATTR);
                string3 = LdapDataStore.getFirstValue(lDAPEntry, KEYVALUE_ATTR);
                if (string2 == null || string3 == null || !string3.startsWith(APOC_BLOB_KEY)) continue;
                hashtable.put(this.mComponentNameParser.getOutputFormat(string2), string3.substring(APOC_BLOB_KEY.length()).trim());
            }
        }
        catch (LDAPException lDAPException) {
            throw new RegistryException("An LDAP read error has occurred: " + (Object)((Object)lDAPException), "error.ldap.read", MODULE, lDAPException.getLDAPResultCode());
        }
        stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = (String)hashtable.get(stringArray[i]);
        }
        return stringArray2;
    }

    public void storePolicy(PolicySetId policySetId, String string, String string2, ClientContext clientContext) throws RegistryException {
        if (policySetId == null || string == null || string2 == null) {
            throw new RegistryException("Cannot create the policy data entry because the parameters are invalid.", "error.occurred", MODULE, 0);
        }
        String string3 = this.mComponentNameParser.getStoredFormat(string);
        this.createComponentEntry((PolicyGroupIdImpl)policySetId, string3, ((LdapClientContext)clientContext).getConnection());
        String string4 = CONFIG_NAMING_ATTR + string3 + LDAP_MAPPING_SEPARATOR + ((PolicyGroupIdImpl)policySetId).getDataStoreEntry();
        Change[] changeArray = new Change[]{new Change(KEYVALUE_ATTR, APOC_BLOB_KEY + string2)};
        this.writeAttributes(string4, SUNSERVICE_COMPONENT_OBJCLASS, changeArray, false, ((LdapClientContext)clientContext).getConnection());
    }

    public static String getValueForKey(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        String string3 = null;
        if (string.startsWith(string2) && (n = string.indexOf("=")) > 0) {
            string3 = string.substring(++n);
        }
        return string3;
    }

    public static String[] getValuesForKey(Vector vector, String string) {
        int n;
        if (vector == null || vector.size() == 0) {
            return new String[0];
        }
        Vector<String> vector2 = new Vector<String>();
        String string2 = null;
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.get(n);
            if ((string2 = LdapDataStore.getValueForKey(string2, string)) == null) continue;
            vector2.add(string2);
        }
        n = vector2.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector2.get(i);
        }
        return stringArray;
    }

    private String getDNExcludingServiceEntry(String string) {
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        int n = stringArray.length;
        String[] stringArray2 = new String[n - 6];
        int n2 = 0;
        for (int i = 6; i < n; ++i) {
            stringArray2[n2++] = stringArray[i];
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(stringArray2[0]);
        for (int i = 1; i < stringArray2.length; ++i) {
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(stringArray2[i]);
        }
        return stringBuffer.toString();
    }

    public String ensureServiceEntryExistsForEntry(String string, LDAPConnection lDAPConnection) throws LDAPException {
        boolean bl;
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = new StringBuffer(200);
            bl = false;
            stringBuffer.append(this.mServiceEntryDNBuf);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(string);
            try {
                lDAPConnection.read(stringBuffer.toString());
                bl = true;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block6;
                throw lDAPException;
            }
        }
        if (bl) {
            return stringBuffer.toString();
        }
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(string);
        for (int i = 5; i >= 0; --i) {
            stringBuffer.insert(0, LDAP_MAPPING_SEPARATOR);
            stringBuffer.insert(0, LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].mEntryRDN);
            try {
                this.addEntry(stringBuffer.toString(), LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].mAttrSet, lDAPConnection);
                continue;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 68) continue;
                throw lDAPException;
            }
        }
        return stringBuffer.toString();
    }

    public PolicyGroupIdImpl createPolicyGroupIdImpl(String string, EntityId entityId, int n) throws RegistryException {
        PolicyGroupIdImpl policyGroupIdImpl = null;
        StringBuffer stringBuffer = new StringBuffer();
        PolicyGroupIdImpl policyGroupIdImpl2 = policyGroupIdImpl = n > 0 ? new PolicyGroupIdImpl(string, entityId, n) : new PolicyGroupIdImpl(string, entityId);
        if (entityId == null) {
            policyGroupIdImpl.setName(null);
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(GLOBAL_POLICY_GROUP_CONTAINER);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(this.mServiceEntryDNBuf);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(this.mBaseDN);
        } else {
            policyGroupIdImpl.setName(string);
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(string);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(this.mServiceEntryDNBuf);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(entityId.getLocation());
        }
        policyGroupIdImpl.setDataStoreEntry(stringBuffer.toString());
        return policyGroupIdImpl;
    }

    public boolean isEntityWritable(EntityId entityId, ClientContext clientContext) throws RegistryException {
        PolicyGroupIdImpl policyGroupIdImpl = this.createPolicyGroupIdImpl("__TestGroupDoNotUse__", entityId, -1);
        try {
            this.createPolicyGroupEntry(policyGroupIdImpl, ((LdapClientContext)clientContext).getConnection());
            ((LdapClientContext)clientContext).getConnection().delete(policyGroupIdImpl.getDataStoreEntry());
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 50) {
                throw new RegistryException("An LDAP error has occurred when testing for access rights on " + entityId == null ? "the root" : entityId.getDisplayName() + ": " + (Object)((Object)lDAPException), "error.ldap.write", MODULE, 0);
            }
            return false;
        }
        return true;
    }

    public PolicySetId getPolicyGroupId(String string, ClientContext clientContext) throws RegistryException {
        if (string == null) {
            throw new RegistryException("Cannot find policy group because parameter is invalid.", "error.occurred", MODULE, 0);
        }
        return PolicyGroupIdImpl.getPolicyGroupIdImpl(string);
    }

    public PolicySetId getPolicyGroupId(EntityId entityId, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        if (entityId == null || policyGroupUse == null || policyGroupUse == PolicyGroupUse.UNKNOWN) {
            throw new RegistryException("Cannot find policy group because parameters are invalid.", "error.occurred", MODULE, 0);
        }
        String string = null;
        switch (policyGroupUse.getIntValue()) {
            case 1: {
                string = DEFAULT_USER_POLICY_GROUP_NAME;
                break;
            }
            case 2: {
                string = DEFAULT_HOST_POLICY_GROUP_NAME;
            }
        }
        PolicyGroupIdImpl policyGroupIdImpl = this.createPolicyGroupIdImpl(string, entityId, -1);
        policyGroupIdImpl.setPolicyGroupUse(policyGroupUse);
        return policyGroupIdImpl;
    }

    public PolicySetId getPolicyGroupId(String string, EntityId entityId, PolicyGroupUse policyGroupUse, int n, ClientContext clientContext) throws RegistryException {
        PolicyGroupIdImpl policyGroupIdImpl = this.createPolicyGroupIdImpl(string, entityId, n);
        policyGroupIdImpl.setPolicyGroupUse(policyGroupUse);
        return policyGroupIdImpl;
    }

    private boolean checkPolicyGroupPriorities(PolicySetId[] policySetIdArray, boolean bl) throws RegistryException {
        int n;
        int n2;
        if (policySetIdArray == null) {
            throw new RegistryException("The policy group priority list is null.", "error.priorities.invalid", MODULE, 0);
        }
        boolean bl2 = false;
        int n3 = 0;
        Vector<PolicySetId> vector = new Vector<PolicySetId>(policySetIdArray.length);
        for (n2 = 0; n2 < policySetIdArray.length; ++n2) {
            n = policySetIdArray[n2].getPriority();
            if (n == 0) {
                if (!bl) {
                    throw new RegistryException("The policy group priorities are undefined.", "error.priorities.invalid", MODULE, 0);
                }
                bl2 = true;
                continue;
            }
            if (n > n3) {
                vector.setSize(n + 1);
                vector.set(n, policySetIdArray[n2]);
                n3 = n;
                continue;
            }
            if (vector.get(n) != null) {
                if (!bl) {
                    throw new RegistryException("The policy group priorities assigned are incorrect.", "error.priorities.incorrect", MODULE, 0);
                }
                bl2 = true;
                policySetIdArray[n2].setPriority(0);
                continue;
            }
            vector.set(n, policySetIdArray[n2]);
        }
        if (!bl2) {
            return false;
        }
        n2 = 0;
        for (n = 0; n < policySetIdArray.length; ++n) {
            while (n < policySetIdArray.length && policySetIdArray[n].getPriority() != 0) {
                ++n;
            }
            if (n == policySetIdArray.length) break;
            while (n2 < vector.size() && vector.get(n2) != null) {
                ++n2;
            }
            policySetIdArray[n].setPriority(n2);
            ++n2;
        }
        return true;
    }

    public PolicySetId[] getPolicyGroupsAssignedToEntity(EntityId entityId, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        if (entityId == null) {
            throw new RegistryException("Invalid entity parameter for method that finds policy groups assigned to an entity.", "error.occurred", MODULE, 0);
        }
        EntityId[] entityIdArray = new EntityId[]{entityId};
        TreeSet treeSet = this.getAssignedPolicyGroupTreeForEntities(entityIdArray, policyGroupUse, clientContext);
        PolicySetId[] policySetIdArray = new PolicySetId[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            policySetIdArray[n++] = (PolicySetId)iterator.next();
        }
        return policySetIdArray;
    }

    public PolicySetId[] getAllPolicyGroupsForEntity(EntityId entityId, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        if (entityId == null) {
            throw new RegistryException("Invalid entity parameter for method that finds policy groups.", "error.occurred", MODULE, 0);
        }
        EntityId[] entityIdArray = new EntityId[]{entityId};
        Object var5_5 = null;
        TreeSet treeSet = this.getAssignedPolicyGroupTreeForEntities(entityIdArray, PolicyGroupUse.ALL, clientContext);
        PolicySetId[] policySetIdArray = this.getContainedPolicyGroups(entityId, policyGroupUse, clientContext);
        int n = policySetIdArray.length;
        PolicySetId[] policySetIdArray2 = new PolicySetId[treeSet.size() + n];
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            policySetIdArray2[n2++] = (PolicySetId)iterator.next();
        }
        for (int i = 0; i < n; ++i) {
            policySetIdArray2[n2++] = policySetIdArray[i];
        }
        return policySetIdArray2;
    }

    public TreeSet getAssignedPolicyGroupTreeForEntities(EntityId[] entityIdArray, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        Vector vector = new Vector();
        TreeSet<PolicyGroupIdImpl> treeSet = new TreeSet<PolicyGroupIdImpl>(new PolicyGroupPrioritySorter());
        String[] stringArray = new String[]{KEYVALUE_ATTR};
        StringBuffer stringBuffer = new StringBuffer(200);
        for (int i = 0; i < entityIdArray.length; ++i) {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.getServiceEntryDN()).append(LDAP_MAPPING_SEPARATOR).append(entityIdArray[i].getLocation());
            try {
                vector = this.getAttributeValueList(stringBuffer.toString(), stringArray, clientContext);
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            String[] stringArray2 = LdapDataStore.getValuesForKey(vector, ASSIGNED_KEY);
            int n = stringArray2.length;
            PolicyGroupIdImpl policyGroupIdImpl = null;
            String string = null;
            for (int j = 0; j < n; ++j) {
                string = stringArray2[j];
                if (string == null) continue;
                try {
                    policyGroupIdImpl = this.getPolicyGroupIdImpl(string, null, null, clientContext);
                    if (policyGroupUse == PolicyGroupUse.ALL) {
                        treeSet.add(policyGroupIdImpl);
                        continue;
                    }
                    if (policyGroupIdImpl.getPolicyGroupUse() != policyGroupUse) continue;
                    treeSet.add(policyGroupIdImpl);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            vector.clear();
        }
        return treeSet;
    }

    public void assignPolicyGroupsToEntity(EntityId entityId, PolicySetId[] policySetIdArray, ClientContext clientContext) throws RegistryException {
        if (entityId == null || policySetIdArray == null || policySetIdArray.length == 0) {
            return;
        }
        int n = policySetIdArray.length;
        String string = KEYVALUE_ATTR;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2 = ((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry();
            if (!this.entryExists(string2, clientContext)) {
                throw new RegistryException("Cannot assign policy group to entity because policy group does not exist.", "error.policygroup.not.exists", MODULE, 0);
            }
            stringArray[i] = ASSIGNED_KEY + string2.toLowerCase();
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getServiceEntryDN());
        stringBuffer.append(LDAP_MAPPING_SEPARATOR);
        stringBuffer.append(entityId.getLocation());
        this.addValuesToMultiValuedAttribute(stringBuffer.toString(), string, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, clientContext);
        this.getConfigDataManager().flushNodeCache();
    }

    public void unassignPolicyGroupsFromEntity(EntityId entityId, PolicySetId[] policySetIdArray, ClientContext clientContext) throws RegistryException {
        if (entityId == null || policySetIdArray == null || policySetIdArray.length == 0) {
            return;
        }
        int n = policySetIdArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = ((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry();
            stringArray[i] = ASSIGNED_KEY + string;
            stringArray[i] = stringArray[i].toLowerCase();
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getServiceEntryDN()).append(LDAP_MAPPING_SEPARATOR).append(entityId.getLocation());
        this.removeMultiValuedAttributeValues(stringBuffer.toString(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, clientContext);
        this.getConfigDataManager().flushNodeCache();
    }

    public Vector getListOfEntitiesForPolicyGroup(PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        Vector vector = null;
        StringBuffer stringBuffer = new StringBuffer(200);
        try {
            stringBuffer.append("(&(").append(LDAP_OBJCLASS).append("=").append(SUNSERVICE_COMPONENT_OBJCLASS).append(")(").append(KEYVALUE_ATTR).append("=").append(ASSIGNED_KEY).append(policyGroupIdImpl.getDataStoreEntry()).append("))");
            vector = this.performSearch(this.getBaseDN(), true, stringBuffer.toString().toLowerCase(), null, true, false, null, false, clientContext);
        }
        catch (RegistryException registryException) {
            LdapDataStore.checkIfSizeLimitExceeded(registryException);
        }
        return vector == null ? new Vector() : vector;
    }

    public Vector getPolicyGroupPriorities(EntityId entityId, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        Vector<Integer> vector = new Vector<Integer>();
        if (policyGroupUse == PolicyGroupUse.UNKNOWN) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        if (entityId == null) {
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(GLOBAL_POLICY_GROUP_CONTAINER);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(this.mRootServiceEntryDNBuf);
        } else {
            stringBuffer.append(this.mServiceEntryDNBuf);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(entityId.getLocation());
        }
        StringBuffer stringBuffer2 = new StringBuffer(200);
        stringBuffer2.append("(&(");
        stringBuffer2.append("sunkeyvalue=");
        stringBuffer2.append(USE_KEY + policyGroupUse.getStringValue());
        stringBuffer2.append(")");
        stringBuffer2.append("(");
        stringBuffer2.append("sunsmspriority=*");
        stringBuffer2.append(")");
        stringBuffer2.append(")");
        String[] stringArray = new String[]{PRIORITY_ATTR};
        Vector vector2 = null;
        try {
            vector2 = this.performSearch(stringBuffer.toString(), false, stringBuffer2.toString(), stringArray, false, false, null, false, clientContext);
        }
        catch (RegistryException registryException) {
            return vector;
        }
        if (vector2 == null || vector2.isEmpty()) {
            return vector;
        }
        String string = null;
        for (int i = 0; i < vector2.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector2.get(i);
            Vector vector3 = (Vector)hashtable.get(PRIORITY_ATTR);
            if (vector3 == null || vector3.isEmpty()) continue;
            string = (String)vector3.get(0);
            try {
                Integer n = new Integer(string);
                vector.add(n);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return vector;
    }

    public void setPolicyGroupPriorities(PolicySetId[] policySetIdArray, boolean bl, ClientContext clientContext) throws RegistryException {
        if (policySetIdArray == null || policySetIdArray.length == 0) {
            return;
        }
        int n = policySetIdArray.length;
        if (bl) {
            this.checkPolicyGroupPriorities(policySetIdArray, false);
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        stringArray[0] = PRIORITY_ATTR;
        for (int i = 0; i < n; ++i) {
            stringArray2[0] = Integer.toString(policySetIdArray[i].getPriority());
            this.fillAttributes(((PolicyGroupIdImpl)policySetIdArray[i]).getDataStoreEntry(), stringArray, stringArray2, SUNSERVICE_COMPONENT_OBJCLASS, clientContext);
        }
    }

    public void checkForPriorityConflict(PolicySetId policySetId, ClientContext clientContext) throws RegistryException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (policySetId.getContainerId() != null) {
            return;
        }
        stringBuffer.append(CONFIG_NAMING_ATTR);
        stringBuffer.append(GLOBAL_POLICY_GROUP_CONTAINER);
        stringBuffer.append(LDAP_MAPPING_SEPARATOR);
        stringBuffer.append(this.mRootServiceEntryDNBuf);
        StringBuffer stringBuffer2 = new StringBuffer(200);
        stringBuffer2.append("(&(");
        stringBuffer2.append("sunkeyvalue=");
        stringBuffer2.append(USE_KEY);
        stringBuffer2.append(policySetId.getPolicyGroupUse().getStringValue());
        stringBuffer2.append(")(");
        stringBuffer2.append("sunsmspriority=");
        stringBuffer2.append(policySetId.getPriority());
        stringBuffer2.append("))");
        String[] stringArray = new String[]{PRIORITY_ATTR};
        Vector vector = null;
        try {
            vector = this.performSearch(stringBuffer.toString(), false, stringBuffer2.toString(), stringArray, false, false, null, false, clientContext);
        }
        catch (RegistryException registryException) {
            return;
        }
        if (vector != null && !vector.isEmpty()) {
            throw new RegistryException("A policy group with this priority already exists.", "error.policygroup.priority.exists", MODULE, 0);
        }
    }

    public PolicySetId findPolicyGroup(String string, EntityId entityId, PolicyGroupUse policyGroupUse, ClientContext clientContext) throws RegistryException {
        if (policyGroupUse == PolicyGroupUse.UNKNOWN) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        if (entityId == null) {
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(GLOBAL_POLICY_GROUP_CONTAINER);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(this.mRootServiceEntryDNBuf);
        } else {
            stringBuffer.append(this.mServiceEntryDNBuf);
            stringBuffer.append(LDAP_MAPPING_SEPARATOR);
            stringBuffer.append(entityId.getLocation());
            string = policyGroupUse == PolicyGroupUse.USER ? DEFAULT_USER_POLICY_GROUP_NAME : DEFAULT_HOST_POLICY_GROUP_NAME;
        }
        StringBuffer stringBuffer2 = new StringBuffer(200);
        stringBuffer2.append("(&(");
        stringBuffer2.append("sunkeyvalue=");
        stringBuffer2.append(DISPLAY_NAME_KEY + string);
        stringBuffer2.append(")(");
        stringBuffer2.append("sunkeyvalue=");
        stringBuffer2.append(USE_KEY + policyGroupUse.getStringValue());
        stringBuffer2.append("))");
        String[] stringArray = new String[]{PRIORITY_ATTR};
        Vector vector = null;
        try {
            vector = this.performSearch(stringBuffer.toString(), false, stringBuffer2.toString(), stringArray, true, false, null, false, clientContext);
        }
        catch (RegistryException registryException) {
            return null;
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        Hashtable hashtable = (Hashtable)vector.get(0);
        Vector vector2 = (Vector)hashtable.get(DN_KEY);
        String string2 = null;
        String string3 = null;
        if (vector2 != null && !vector2.isEmpty()) {
            string2 = (String)vector2.get(0);
        }
        if ((vector2 = (Vector)hashtable.get(PRIORITY_ATTR)) != null && !vector2.isEmpty()) {
            string3 = (String)vector2.get(0);
        }
        if (string2 == null || string3 == null) {
            return null;
        }
        PolicyGroupIdImpl policyGroupIdImpl = new PolicyGroupIdImpl(string, entityId, string3);
        policyGroupIdImpl.setDataStoreEntry(string2);
        String[] stringArray2 = LDAPDN.explodeDN((String)string2, (boolean)false);
        String string4 = stringArray2[0];
        int n = string4.indexOf("=");
        if (n != -1 && ++n < stringArray2[0].length()) {
            policyGroupIdImpl.setName(string4.substring(n));
        }
        policyGroupIdImpl.setPolicyGroupUse(policyGroupUse);
        return policyGroupIdImpl;
    }

    public Vector getListedRolesForEntity(EntityId entityId, String string, ClientContext clientContext) throws RegistryException {
        Vector vector = null;
        String[] stringArray = new String[]{string};
        try {
            vector = this.getAttributeValueList(entityId.getLocation(), stringArray, false, clientContext, null);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return vector == null ? new Vector() : vector;
    }

    public static void checkIfSizeLimitExceeded(RegistryException registryException) throws RegistryException {
        if (registryException.getErrorCode() == 4) {
            throw new RegistryException("Search failed because the number of resulting entries was larger than the limit set by the LDAP server." + registryException.getLocalizedMessage(), "error.ldap.results.size", MODULE, 0);
        }
    }

    static {
        USER_POLICY_GROUP_USE_VALUE = USE_KEY + PolicyGroupUse.USER;
        HOST_POLICY_GROUP_USE_VALUE = USE_KEY + PolicyGroupUse.HOST;
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[0] = new ServiceMapping(SUNSERVICE_COMPONENT_OBJCLASS, SERVICE_REGISTRY, "ou=ApocRegistry");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[1] = new ServiceMapping(SUNSERVICE_COMPONENT_OBJCLASS, "ou=default");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[2] = new ServiceMapping(ORG_UNIT_OBJCLASS, "ou=OrganizationConfig");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[3] = new ServiceMapping(SUNSERVICE_OBJCLASS, "ou=1.0");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[4] = new ServiceMapping(SUNSERVICE_OBJCLASS, "ou=ApocService");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[5] = new ServiceMapping(ORG_UNIT_OBJCLASS, "ou=services");
        CONTAINER_MAPPING = new EntryMapping(SUNSERVICE_COMPONENT_OBJCLASS, "ApocPolicyGroupContainer");
        POLICYGROUP_MAPPING = new EntryMapping(SUNSERVICE_COMPONENT_OBJCLASS, "ApocPolicyGroup");
        POLICY_MAPPING = new EntryMapping(SUNSERVICE_COMPONENT_OBJCLASS, "ApocPolicy");
        TIMEONLY_ATTRS = new String[]{ORG_UNIT_NAMING_ATTR, MODIFY_TIMESTAMP_ATTR};
        ALL_BLOBS_ATTRS = new String[]{ORG_UNIT_NAMING_ATTR, MODIFY_TIMESTAMP_ATTR, KEYVALUE_ATTR};
    }

    private static class PolicyGroupPrioritySorter
    implements Comparator {
        private PolicyGroupPrioritySorter() {
        }

        public int compare(Object object, Object object2) {
            PolicyGroupIdImpl policyGroupIdImpl = (PolicyGroupIdImpl)object;
            PolicyGroupIdImpl policyGroupIdImpl2 = (PolicyGroupIdImpl)object2;
            if (policyGroupIdImpl == null) {
                return policyGroupIdImpl2 == null ? 0 : -1;
            }
            if (policyGroupIdImpl2 == null) {
                return 1;
            }
            if (policyGroupIdImpl.getPriority() != policyGroupIdImpl2.getPriority()) {
                return policyGroupIdImpl.getPriority() - policyGroupIdImpl2.getPriority();
            }
            return policyGroupIdImpl.getDataStoreEntry().compareTo(policyGroupIdImpl2.getDataStoreEntry());
        }
    }

    public static class Change {
        String mName;
        String[] mValues;

        public Change() {
        }

        public Change(String string, String[] stringArray) {
            this.mName = string;
            this.mValues = stringArray;
        }

        public Change(String string, String string2) {
            this.mName = string;
            this.mValues = new String[1];
            this.mValues[0] = string2;
        }
    }

    static class ServiceMapping {
        String mEntryRDN = null;
        LDAPAttributeSet mAttrSet = new LDAPAttributeSet();

        ServiceMapping(String string, String string2) {
            this.mAttrSet.add(new LDAPAttribute(LdapDataStore.LDAP_OBJCLASS, string));
            this.mEntryRDN = string2;
        }

        ServiceMapping(String string, String string2, String string3) {
            this.mAttrSet.add(new LDAPAttribute(LdapDataStore.LDAP_OBJCLASS, string));
            this.mAttrSet.add(new LDAPAttribute(LdapDataStore.SUNSERVICEID_ATTR, string2));
            this.mEntryRDN = string3;
        }
    }

    static class EntryMapping {
        String mObjectClass = null;
        LDAPAttribute mServiceIdAttr = null;

        EntryMapping(String string) {
            this.mObjectClass = string;
        }

        EntryMapping(String string, String string2) {
            this.mObjectClass = string;
            this.mServiceIdAttr = new LDAPAttribute(LdapDataStore.SUNSERVICEID_ATTR, string2);
        }
    }
}

