/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.organization;

import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.EntityType;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicyId;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.datastore.DataStoreType;
import com.sun.apoc.policy.organization.LdapOrganization;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.util.BootstrapData;

public abstract class Organization {
    public static final String ORG_KEY = "Organization/";
    public static final String DOMAIN_KEY = "Domain/";
    public static final String USER_KEY = "User/";
    public static final String HOST_KEY = "Host/";
    public static final String ROLE_KEY = "Role/";
    public static final boolean CHECK_ONLY = true;
    public static final boolean NOT_CHECK_ONLY = false;
    private static final String MODULE = "Organization";

    public static Organization getOrganization(BootstrapData bootstrapData, DataStore dataStore) throws RegistryException {
        LdapOrganization ldapOrganization = null;
        switch (DataStoreType.getInt(bootstrapData.getDataStoreType())) {
            case 0: {
                ldapOrganization = new LdapOrganization(dataStore);
                break;
            }
            default: {
                throw new RegistryException("The data store type specified in the bootstrapping information is not recognized", "error.unsupported.datastore", MODULE, 0);
            }
        }
        return ldapOrganization;
    }

    public abstract EntityId getEntityParent(EntityId var1, EntityType var2, ClientContext var3) throws RegistryException;

    public abstract EntityId[] getRolesEntityIsAMemberOf(EntityId var1, ClientContext var2) throws RegistryException;

    public abstract EntityId[] getEntityChildren(EntityId var1, EntityType var2, ClientContext var3) throws RegistryException;

    public abstract EntityId[] getRoleMembers(EntityId var1, EntityType var2, ClientContext var3) throws RegistryException;

    public abstract EntityId[] getAllParentsInPath(EntityId var1, ClientContext var2) throws RegistryException;

    public abstract EntityId[] getLayerPath(EntityId var1, ClientContext var2) throws RegistryException;

    public abstract boolean hasEntityChildren(EntityId var1, EntityType var2, ClientContext var3) throws RegistryException;

    public abstract boolean hasMembers(EntityId var1, EntityType var2, ClientContext var3) throws RegistryException;

    public abstract EntityId findUserEntityId(String var1, ClientContext var2) throws RegistryException;

    public abstract EntityId findHostEntityId(String var1, ClientContext var2) throws RegistryException;

    public abstract EntityId[] findEntitiesByName(EntityId var1, EntityType var2, String var3, boolean var4, ClientContext var5) throws RegistryException;

    public abstract EntityId[] findEntitiesByFilter(EntityId var1, EntityType var2, String var3, boolean var4, ClientContext var5) throws RegistryException;

    public abstract EntityId getRootEntityId(EntityType var1, ClientContext var2) throws RegistryException;

    public abstract EntityId getEntityIdFromLocation(String var1, ClientContext var2) throws RegistryException;

    public abstract PolicySetId[] getLayeredPolicySetIds(EntityId var1, ClientContext var2) throws RegistryException;

    public abstract PolicyId[][] getLayeredPolicies(EntityId var1, String[] var2, boolean var3, ClientContext var4) throws RegistryException;

    public abstract EntityId[] getEntitiesForPolicyGroup(PolicyGroupIdImpl var1, ClientContext var2) throws RegistryException;

    public abstract PolicyId getPolicyId(String var1, PolicyGroupIdImpl var2, boolean var3, ClientContext var4) throws RegistryException;

    public abstract PolicyId[] getPolicies(String var1, PolicySetId[] var2, boolean var3, ClientContext var4) throws RegistryException;

    public static class BooleanReturnObject {
        private boolean mReturnValue;

        public BooleanReturnObject(boolean bl) {
            this.mReturnValue = bl;
        }

        public void setReturnValue(boolean bl) {
            this.mReturnValue = bl;
        }

        public boolean getReturnValue() {
            return this.mReturnValue;
        }
    }
}

