/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.entities;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.entities.User;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Iterator;

public class MemberTableModel
extends CCActionTableModel
implements RequestParticipant {
    public static final String CHILD_NAME_COLUMN = "NameColumn";
    public static final String CHILD_NAME_TEXT = "NameText";
    public static final String CHILD_NAME_HREF = "NameHref";
    public static final String CHILD_PATH_COLUMN = "PathColumn";
    public static final String CHILD_PATH_TEXT = "PathText";
    public static final int RETRIEVE_ROLES = 0;
    public static final int RETRIEVE_USERS = 1;

    public void setRequestContext(RequestContext requestContext) {
        this.setActionValue(CHILD_NAME_COLUMN, "APOC.navigation.name");
        this.setActionValue(CHILD_PATH_COLUMN, "APOC.ca.path");
        this.setMaxRows(10);
    }

    public void retrieve() throws ModelControlException {
        this.clear();
        Iterator iterator = null;
        try {
            Entity entity = Toolbox2.getSelectedEntity();
            if (entity instanceof User) {
                iterator = ((User)entity).getMemberships();
                this.setTitle("APOC.roles.title");
                this.setSummary("APOC.roles.tableSummary");
                this.setEmpty("APOC.policies.set.table.empty");
            } else if (entity instanceof Role) {
                iterator = ((Role)entity).getMembers();
                this.setTitle("APOC.users.title");
                this.setSummary("APOC.users.tableSummary");
                this.setEmpty("APOC.policies.set.table.empty");
            }
            while (iterator != null && iterator.hasNext()) {
                this.appendRow();
                entity = (Entity)iterator.next();
                String string = entity.getDisplayName(Toolbox2.getLocale());
                if (entity instanceof User) {
                    string = string + " [" + ((User)entity).getUserId() + "]";
                }
                this.setValue(CHILD_NAME_TEXT, string);
                this.setValue(CHILD_NAME_HREF, entity.getId());
                this.setValue(CHILD_PATH_TEXT, Toolbox2.getParentagePath(entity, true, false, "/"));
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }
}

