/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.entities;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.spi.PolicyManager;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.ldap.entities.LdapNode;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class SearchTableModel
extends CCActionTableModel
implements RequestParticipant {
    public static final String CHILD_NAME_TEXT = "NameText";
    public static final String CHILD_NAME_HREF = "NameHref";
    public static final String CHILD_NAME_COLUMN = "NameColumn";
    public static final String CHILD_VIEW_ACTION = "ViewAction";
    public static final String CHILD_USERID_COLUMN = "UserIdColumn";
    public static final String CHILD_USERID_TEXT = "UserIdText";
    public static final String CHILD_TYPE_TEXT = "TypeText";
    public static final String CHILD_TYPE_COLUMN = "TypeColumn";
    public static final String CHILD_PATH_TEXT = "PathText";
    public static final String CHILD_PATH_COLUMN = "PathColumn";
    public static final String CHILD_FILTER_MENU = "FilterMenu";
    private int m_nSearchLimit = 200;
    private PolicyManager m_policyManager = null;
    private String m_sType = "";

    public void setRequestContext(RequestContext requestContext) {
        this.setActionValue(CHILD_NAME_COLUMN, "APOC.navigation.name");
        this.setActionValue(CHILD_TYPE_COLUMN, "APOC.navigation.type");
        this.setActionValue(CHILD_PATH_COLUMN, "APOC.search.path");
        this.setActionValue(CHILD_USERID_COLUMN, "APOC.search.userid");
    }

    public void retrieve(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7) throws ModelControlException {
        this.clear();
        this.m_sType = string3;
        if (string5.length() == 0) {
            string5 = "*";
        }
        if (!(string5 = this.stripQuotes(string5)).startsWith("*")) {
            string5 = "*" + string5;
        }
        if (!string5.endsWith("*")) {
            string5 = string5 + "*";
        }
        if (string6 != null && string6.length() > 0 && !string6.equals("defval")) {
            int n = Integer.parseInt(string6);
            this.setMaxRows(n);
        }
        try {
            PolicyManager policyManager = Toolbox2.getPolicyManager();
            if (string7 != null && string7.length() > 0) {
                policyManager = Toolbox2.createPolicyManager(string7, null, null, false);
            }
            LdapEnvironmentMgr ldapEnvironmentMgr = new LdapEnvironmentMgr(policyManager.getEnvironment());
            this.m_nSearchLimit = ldapEnvironmentMgr.getSearchResultSizeLimit();
            LinkedList linkedList = new LinkedList();
            Iterator iterator = linkedList.iterator();
            Entity entity = policyManager.getEntity(string2, string);
            if (bl) {
                entity = policyManager.getRootEntity(string4);
            }
            if (string3.equals("ORG") && entity instanceof Organization) {
                iterator = ((Organization)entity).findSubOrganizations(string5, true);
                this.addToModel(iterator, false);
            } else if (string3.equals("DOMAIN") && entity instanceof Domain) {
                iterator = ((Domain)entity).findSubDomains(string5, true);
                this.addToModel(iterator, false);
            } else if (string3.equals("HOST") && entity instanceof Domain) {
                iterator = ((Domain)entity).findHosts(string5, true);
                this.addToModel(iterator, false);
            } else if (string3.equals("ROLE") && (entity instanceof Role || entity instanceof Organization)) {
                if (entity instanceof LdapNode) {
                    iterator = ((LdapNode)entity).findRoles(string5, true);
                }
                this.addToModel(iterator, false);
            } else if (string3.equals("USERID") && entity instanceof Organization) {
                iterator = ((Organization)entity).findUsers(string5, true);
                this.addToModel(iterator, false);
                if (!string5.equals("*")) {
                    this.searchUsers(entity, string5);
                }
            }
            if (bl) {
                if (string3.equals("ALL")) {
                    entity = policyManager.getRootEntity("HOST");
                    iterator = ((Node)entity).findEntities(string5, true);
                    this.addToModel(iterator, bl);
                    entity = policyManager.getRootEntity("USER");
                    if (entity instanceof Node && this.m_nSearchLimit > this.getSize()) {
                        iterator = ((Node)entity).findEntities(string5, true);
                        this.addToModel(iterator, bl);
                        if (entity instanceof Organization && !string5.equals("*") && this.m_nSearchLimit > this.getSize()) {
                            this.searchUsers(entity, string5);
                        }
                    }
                }
            } else if (string3.equals("ALL") && entity instanceof Domain) {
                iterator = ((Domain)entity).findSubDomains(string5, true);
                this.addToModel(iterator, false);
                iterator = ((Domain)entity).findHosts(string5, true);
                this.addToModel(iterator, false);
            } else if (string3.equals("ALL") && entity instanceof Organization) {
                iterator = ((Node)entity).findEntities(string5, true);
                this.addToModel(iterator, bl);
                if (entity instanceof Organization && !string5.equals("*") && this.m_nSearchLimit > this.getSize()) {
                    this.searchUsers(entity, string5);
                }
            } else if (string3.equals("ALL") && entity instanceof Node) {
                iterator = ((Node)entity).findEntities(string5, true);
                this.addToModel(iterator, false);
            }
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }

    private void searchUsers(Entity entity, String string) throws SPIException, ModelControlException {
        LinkedList<User> linkedList = new LinkedList<User>();
        Iterator iterator = linkedList.iterator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 2) {
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            if (this.m_nSearchLimit > this.getSize()) {
                User user;
                Iterator iterator2 = ((Organization)entity).findUsers("(givenname=" + string3 + ")", true);
                Iterator iterator3 = ((Organization)entity).findUsers("(sn=" + string2 + ")", true);
                HashSet<String> hashSet = new HashSet<String>();
                while (iterator2.hasNext()) {
                    user = (User)iterator2.next();
                    hashSet.add(user.getUserId());
                }
                while (iterator3.hasNext()) {
                    user = (User)iterator3.next();
                    if (!hashSet.contains(user.getUserId())) continue;
                    linkedList.add(user);
                }
                this.addToModel(linkedList.iterator(), true);
            }
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(cn=" + string3 + " " + string2 + ")", true);
                this.addToModel(iterator, true);
            }
        } else {
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(givenname=" + string + ")", true);
                this.addToModel(iterator, true);
            }
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(sn=" + string + ")", true);
                this.addToModel(iterator, true);
            }
            if (this.m_nSearchLimit > this.getSize()) {
                iterator = ((Organization)entity).findUsers("(cn=" + string + ")", true);
                this.addToModel(iterator, true);
            }
        }
    }

    private void addToModel(Iterator iterator, boolean bl) throws SPIException, ModelControlException {
        while (iterator.hasNext() && this.m_nSearchLimit > this.getSize()) {
            String string;
            boolean bl2 = false;
            Entity entity = (Entity)iterator.next();
            String string2 = entity.getId();
            if (bl) {
                int n = this.getLocation();
                for (int i = 0; i < this.getNumRows(); ++i) {
                    this.setLocation(i);
                    string = (String)this.getValue(CHILD_VIEW_ACTION);
                    if (!string2.equals(string)) continue;
                    bl2 = true;
                    break;
                }
                this.setLocation(n);
            }
            if (bl2) continue;
            this.appendRow();
            String string3 = "-";
            String string4 = entity.getDisplayName(Toolbox2.getLocale());
            if (entity instanceof User) {
                string3 = ((User)entity).getUserId();
                if (!this.m_sType.equals("USERID")) {
                    string4 = string4 + " [" + string3 + "]";
                }
            }
            string = entity.getPolicySourceName();
            this.setValue(CHILD_NAME_TEXT, string4);
            this.setValue(CHILD_VIEW_ACTION, string2 + "|" + string);
            this.setValue(CHILD_USERID_TEXT, string3);
            this.setValue(CHILD_TYPE_TEXT, Toolbox2.getEntityTypeResource(entity));
            this.setValue(CHILD_PATH_TEXT, Toolbox2.getParentagePath(entity, true, false, "/", this.m_policyManager));
        }
    }

    private String stripQuotes(String string) {
        if ((string = string.trim()).length() >= 2) {
            if (string.substring(0, 1).equals("\"") && string.substring(string.length() - 1).equals("\"")) {
                string = string.substring(1, string.length() - 1);
            } else if (string.substring(0, 1).equals("'") && string.substring(string.length() - 1).equals("'")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }
}

