/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi;

import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.EntityTreeProvider;
import com.sun.apoc.spi.environment.EnvironmentMgr;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class PolicyManager {
    private EnvironmentMgr mEnvironment = null;
    private PolicySource[] mSources = null;
    private Map mSourcesByName = new HashMap();

    public PolicyManager(Hashtable hashtable) throws SPIException {
        this.mEnvironment = new EnvironmentMgr(hashtable);
        this.mEnvironment.checkEnvironment();
        String[] stringArray = this.mEnvironment.getSources();
        this.mSources = new PolicySource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.mSources[i] = new PolicySource(stringArray[i], this.mEnvironment);
            this.mSourcesByName.put(stringArray[i], this.mSources[i]);
        }
    }

    public EntityTreeProvider getEntityProvider(String string) {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        return policySource != null ? policySource.getEntityProvider() : null;
    }

    public AssignmentProvider getAssignmentProvider(String string) {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        return policySource != null ? policySource.getAssignmentProvider() : null;
    }

    public ProfileProvider getProfileProvider(String string) {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        return policySource != null ? policySource.getProfileProvider() : null;
    }

    public Entity getRootEntity(String string) throws SPIException {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        return policySource != null ? policySource.getRoot() : null;
    }

    public Entity getEntity(String string, String string2) throws SPIException {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        return policySource != null ? policySource.getEntity(string2) : null;
    }

    public Entity getEntity(String string) throws SPIException {
        Entity entity = null;
        for (int i = 0; i < this.mSources.length && entity == null; ++i) {
            entity = this.getEntity(this.mSources[i].getName(), string);
        }
        return entity;
    }

    public Profile getProfile(String string, String string2) throws SPIException {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        ProfileProvider profileProvider = policySource.getProfileProvider();
        Profile profile = null;
        if (profileProvider != null) {
            try {
                profile = profileProvider.getProfile(string2);
                if (profile != null && !profile.getApplicability().getStringValue().equals(policySource.getName())) {
                    profile = null;
                }
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        return profile;
    }

    public Profile getProfile(String string) throws SPIException {
        Profile profile = null;
        for (int i = 0; i < this.mSources.length && profile == null; ++i) {
            profile = this.getProfile(this.mSources[i].getName(), string);
        }
        return profile;
    }

    public Iterator getAllProfiles() throws SPIException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        for (int i = 0; i < this.mSources.length; ++i) {
            ProfileProvider profileProvider = this.mSources[i].getProfileProvider();
            Iterator iterator = profileProvider.getAllProfiles();
            while (iterator.hasNext()) {
                Profile profile = (Profile)iterator.next();
                arrayList.add(profile);
            }
        }
        return arrayList.iterator();
    }

    public ProfileRepository getProfileRepository(String string, String string2) throws SPIException {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        ProfileProvider profileProvider = policySource.getProfileProvider();
        return profileProvider != null ? profileProvider.getProfileRepository(string2) : null;
    }

    public ProfileRepository getDefaultProfileRepository(String string) throws SPIException {
        PolicySource policySource = (PolicySource)this.mSourcesByName.get(string);
        ProfileProvider profileProvider = policySource.getProfileProvider();
        return profileProvider != null ? profileProvider.getDefaultProfileRepository() : null;
    }

    public Hashtable getEnvironment() throws SPIException {
        return this.mEnvironment.getEnvironment();
    }

    public String[] getSources() throws SPIException {
        return this.mEnvironment.getSources();
    }

    public void close() throws SPIException {
        for (int i = 0; i < this.mSources.length; ++i) {
            this.mSources[i].close();
        }
    }
}

