/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi;

import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.Provider;
import com.sun.apoc.spi.ProviderLoadingException;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.EntityTreeProvider;
import com.sun.apoc.spi.environment.EnvironmentMgr;
import com.sun.apoc.spi.file.FileProviderFactory;
import com.sun.apoc.spi.ldap.LdapProviderFactory;
import com.sun.apoc.spi.profiles.ProfileProvider;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class PolicySource {
    private String mName = null;
    private EnvironmentMgr mEnvironment = null;
    private EntityTreeProvider mEntities = null;
    private ProfileProvider mProfiles = null;
    private AssignmentProvider mAssignments = null;
    private Set mFailedURLs;
    static /* synthetic */ Class class$com$sun$apoc$spi$entities$EntityTreeProvider;
    static /* synthetic */ Class class$com$sun$apoc$spi$profiles$ProfileProvider;
    static /* synthetic */ Class class$com$sun$apoc$spi$AssignmentProvider;
    static /* synthetic */ Class class$com$sun$apoc$spi$PolicySource;

    public PolicySource(String string, EnvironmentMgr environmentMgr) throws SPIException {
        this.mName = string;
        this.mEnvironment = environmentMgr;
        this.mFailedURLs = new HashSet();
        this.mEntities = (EntityTreeProvider)this.getProvider(class$com$sun$apoc$spi$entities$EntityTreeProvider == null ? (class$com$sun$apoc$spi$entities$EntityTreeProvider = PolicySource.class$("com.sun.apoc.spi.entities.EntityTreeProvider")) : class$com$sun$apoc$spi$entities$EntityTreeProvider);
        this.mProfiles = (ProfileProvider)this.getProvider(class$com$sun$apoc$spi$profiles$ProfileProvider == null ? (class$com$sun$apoc$spi$profiles$ProfileProvider = PolicySource.class$("com.sun.apoc.spi.profiles.ProfileProvider")) : class$com$sun$apoc$spi$profiles$ProfileProvider);
        this.mAssignments = (AssignmentProvider)this.getProvider(class$com$sun$apoc$spi$AssignmentProvider == null ? (class$com$sun$apoc$spi$AssignmentProvider = PolicySource.class$("com.sun.apoc.spi.AssignmentProvider")) : class$com$sun$apoc$spi$AssignmentProvider);
    }

    public Hashtable getEnvironment() {
        return this.mEnvironment.getEnvironment();
    }

    public Entity getRoot() throws SPIException {
        return this.mEntities.getRootEntity();
    }

    public Entity getEntity(String string) throws SPIException {
        return this.mEntities.getEntity(string);
    }

    public EntityTreeProvider getEntityProvider() {
        return this.mEntities;
    }

    public AssignmentProvider getAssignmentProvider() {
        return this.mAssignments;
    }

    public ProfileProvider getProfileProvider() {
        return this.mProfiles;
    }

    public String getName() {
        return this.mName;
    }

    public void close() throws SPIException {
        HashSet<Provider> hashSet = new HashSet<Provider>();
        if (this.mEntities != null) {
            hashSet.add(this.mEntities);
        }
        if (this.mAssignments != null) {
            hashSet.add(this.mAssignments);
        }
        if (this.mProfiles != null) {
            hashSet.add(this.mProfiles);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((Provider)iterator.next()).close();
        }
    }

    public synchronized boolean isFailedURL(String string) {
        return this.mFailedURLs.contains(string);
    }

    public synchronized void addFailedURL(String string) {
        if (!this.isFailedURL(string)) {
            this.mFailedURLs.add(string);
        }
    }

    public synchronized Object getConnectionHandler(String string) {
        return this.mEnvironment.getConnectionHandler(string);
    }

    public synchronized void setConnectionHandler(String string, Object object) {
        this.mEnvironment.setConnectionHandler(string, object);
    }

    private Provider getProvider(Class clazz) throws SPIException {
        Provider provider = null;
        String string = this.mEnvironment.getProviderClass(this.mName, clazz);
        if (string != null) {
            return this.loadProvider(string);
        }
        String[] stringArray = this.mEnvironment.getProviderURLs(this.mName, clazz);
        for (int i = 0; provider == null && i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (this.isFailedURL(string2)) continue;
            try {
                String string3 = string2.substring(0, string2.indexOf(":"));
                if (EnvironmentMgr.isLdapProtocol(string3)) {
                    provider = LdapProviderFactory.get(string2, clazz, this);
                    if (provider == null) continue;
                    provider.open();
                    continue;
                }
                if (!EnvironmentMgr.isFileProtocol(string3) || (provider = FileProviderFactory.get(string2, clazz, this)) == null) continue;
                provider.open();
                continue;
            }
            catch (SPIException sPIException) {
                if (i == stringArray.length - 1) {
                    throw sPIException;
                }
                this.addFailedURL(string2);
            }
        }
        return provider;
    }

    private Provider loadProvider(String string) throws SPIException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            Class[] classArray = new Class[]{class$com$sun$apoc$spi$PolicySource == null ? (class$com$sun$apoc$spi$PolicySource = PolicySource.class$("com.sun.apoc.spi.PolicySource")) : class$com$sun$apoc$spi$PolicySource};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            return (Provider)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ProviderLoadingException(string, exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

