/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.cfgtree;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.ElementCopyException;
import com.sun.apoc.spi.cfgtree.MandatoryElementException;
import com.sun.apoc.spi.cfgtree.PolicyTreeImpl;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNode;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNodeImpl;
import com.sun.apoc.spi.cfgtree.property.Property;
import com.sun.apoc.spi.policies.Policy;

public abstract class ConfigElementImpl {
    protected boolean mIsAddedAtTopLayer = false;
    protected boolean mIsDynamic = false;
    protected boolean mIsMandatory = false;
    protected String mName;
    protected int mOperationType = -1;
    protected Policy mOriginOfMandatory;
    protected String mPackage;
    protected PolicyNodeImpl mParent;
    protected String mPath;
    protected PolicyTreeImpl mPolicyTree;
    private static final String MODULE = "ConfigElementImpl";

    public void checkIfMandatory() throws SPIException {
        if (this.mIsMandatory) {
            String string = "ProtectedElement";
            if (this instanceof PolicyNode) {
                string = "PolicyNode";
            } else if (this instanceof Property) {
                string = "Property";
            }
            throw new MandatoryElementException(string, this.getName());
        }
    }

    public void copySettings(ConfigElementImpl configElementImpl) throws SPIException {
        configElementImpl.mIsAddedAtTopLayer = this.mIsAddedAtTopLayer;
        configElementImpl.mIsDynamic = this.mIsDynamic;
        configElementImpl.mIsMandatory = this.mIsMandatory;
        configElementImpl.mName = this.mName;
        configElementImpl.mOperationType = this.mOperationType;
        configElementImpl.mPackage = this.mPackage;
        configElementImpl.mPolicyTree = this.mPolicyTree;
        configElementImpl.mParent = this.mParent;
        configElementImpl.mPath = this.mPath;
        configElementImpl.mOriginOfMandatory = this.mOriginOfMandatory;
    }

    public String getAbsolutePath() {
        return this.mPath;
    }

    public String getName() {
        return this.mName;
    }

    public int getOperationType() {
        return this.mOperationType;
    }

    public Policy getOriginOfMandatory() {
        return this.mOriginOfMandatory;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public PolicyNode getParent() {
        return this.mParent;
    }

    public PolicyTreeImpl getPolicyTree() {
        return this.mPolicyTree;
    }

    public abstract boolean hasBeenModified();

    public boolean isAddedAtTopLayer() {
        return this.mIsAddedAtTopLayer;
    }

    public boolean isMandatory() {
        return this.mIsMandatory;
    }

    public void setAddedAtTopLayer() {
        this.mIsAddedAtTopLayer = true;
    }

    public void setDynamic() {
        this.mIsDynamic = true;
    }

    public void setMandatoryFlag() {
        this.mIsMandatory = true;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public void setOperationType(int n) {
        this.mOperationType = n;
    }

    public void setOriginOfMandatory(Policy policy) {
        this.mOriginOfMandatory = policy;
    }

    public void setPackage(String string) {
        this.mPackage = string;
    }

    public void setParent(PolicyNodeImpl policyNodeImpl) {
        this.mParent = policyNodeImpl;
    }

    public void setPath(String string) {
        this.mPath = string;
    }

    public void setPolicyTree(PolicyTreeImpl policyTreeImpl) {
        this.mPolicyTree = policyTreeImpl;
    }

    public ConfigElementImpl shallowCopy() throws SPIException {
        ConfigElementImpl configElementImpl = null;
        try {
            configElementImpl = (ConfigElementImpl)this.getClass().newInstance();
        }
        catch (Exception exception) {
            String string = "ProtectedElement";
            if (this instanceof PolicyNode) {
                string = "PolicyNode";
            } else if (this instanceof Property) {
                string = "Property";
            }
            throw new ElementCopyException(string, this.getName(), (Throwable)exception);
        }
        this.copySettings(configElementImpl);
        return configElementImpl;
    }
}

