/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.cfgtree;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.DataType;
import com.sun.apoc.spi.cfgtree.InvalidDataTypeException;
import com.sun.apoc.spi.cfgtree.property.InvalidPropertyException;
import com.sun.apoc.spi.cfgtree.property.PropertyImpl;
import com.sun.apoc.spi.policies.Policy;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class NodeValueImpl {
    private StringBuffer mValueBuf;
    public String[] mValueArray;
    private DataType mDataType = DataType.UNKNOWN;
    private String mLocaleName;
    private Policy mOriginLayer;
    private boolean mNilAttribute = false;
    private boolean mIsContentsSet = false;
    private boolean mIsModifiedAtTopLayer = false;
    private PropertyImpl mPropertyImpl;
    private static final String MODULE = "NodeValueImpl";

    public String getContents() {
        if (!this.mIsContentsSet) {
            if (this.mValueBuf != null) {
                this.setOriginalContents(this.mValueBuf.toString());
            }
            this.mIsContentsSet = true;
        }
        if (this.mValueArray == null || this.mValueArray.length < 1) {
            return null;
        }
        String string = this.mValueArray[0];
        if (this.getSeparator() == null) {
            return string;
        }
        for (int i = 1; i < this.mValueArray.length; ++i) {
            string = string + this.getSeparator() + this.mValueArray[i];
        }
        return string;
    }

    public String[] getValueArray() {
        if (!this.mIsContentsSet) {
            if (this.mValueBuf != null) {
                this.setOriginalContents(this.mValueBuf.toString());
            }
            this.mIsContentsSet = true;
        }
        if (this.mValueArray == null) {
            return new String[0];
        }
        return this.mValueArray;
    }

    public void setNewContents(String string) throws SPIException {
        this.mPropertyImpl.checkIfReadOnly();
        String string2 = this.getContents();
        String[] stringArray = null;
        if (string2 != null && !string2.equals(string) && this.mValueArray != null) {
            stringArray = new String[this.mValueArray.length];
            for (int i = 0; i < this.mValueArray.length; ++i) {
                stringArray[i] = new String(this.mValueArray[i]);
            }
        }
        this.setOriginalContents(string);
        try {
            this.checkContentsAgainstDataType(this.mDataType);
        }
        catch (SPIException sPIException) {
            this.mValueArray = stringArray;
            throw sPIException;
        }
        this.mNilAttribute = false;
        this.mIsModifiedAtTopLayer = true;
        this.mOriginLayer = this.mPropertyImpl.getPolicyTree().getPolicy();
        this.mPropertyImpl.setNodeValue(this, this.mPropertyImpl.getRequiredLocale());
        if (!this.mPropertyImpl.isAddedAtTopLayer()) {
            this.mPropertyImpl.setOperationType(0);
        }
    }

    public void setValueToNil() throws SPIException {
        this.mPropertyImpl.checkIfReadOnly();
        if (!this.mPropertyImpl.isNillable()) {
            throw new InvalidPropertyException("error.spi.policytree.property.nonil", this.mPropertyImpl.getName());
        }
        if (!this.mIsContentsSet) {
            this.getContents();
        }
        this.mValueArray = null;
        this.mNilAttribute = true;
        this.mIsModifiedAtTopLayer = true;
        this.mOriginLayer = this.mPropertyImpl.getPolicyTree().getPolicy();
        this.mPropertyImpl.setNodeValue(this, this.mPropertyImpl.getRequiredLocale());
        if (!this.mPropertyImpl.isAddedAtTopLayer()) {
            this.mPropertyImpl.setOperationType(0);
        }
    }

    public Policy getOrigin() {
        return this.mOriginLayer;
    }

    public boolean hasNilAttribute() {
        return this.mNilAttribute;
    }

    public DataType getDataType() {
        return this.mDataType;
    }

    public void printToStream(String string, PrintStream printStream) {
        printStream.print(string + "<" + "value");
        if (this.mLocaleName != null) {
            printStream.print(" xml:lang=\"");
            printStream.print(this.mLocaleName + "\"");
        }
        if (this.getSeparator() != null && !this.getSeparator().equals(" ")) {
            printStream.print(" oor:separator=\"");
            printStream.print(this.getSeparator() + "\"");
        }
        this.printXMLValues(printStream);
    }

    private void printXMLString(PrintStream printStream, String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printStream.print(string);
            return;
        }
        block7: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 38: {
                    printStream.print("&amp;");
                    continue block7;
                }
                case 60: {
                    printStream.print("&lt;");
                    continue block7;
                }
                case 62: {
                    printStream.print("&gt;");
                    continue block7;
                }
                default: {
                    printStream.write(by);
                }
            }
        }
    }

    private void printXMLValues(PrintStream printStream) {
        if (!this.mIsContentsSet) {
            if (this.mValueBuf != null) {
                this.setOriginalContents(this.mValueBuf.toString());
            } else {
                this.mIsContentsSet = true;
            }
        }
        if (this.mValueArray != null) {
            printStream.print(">");
            int n = this.mValueArray.length;
            if (n > 0) {
                this.printXMLString(printStream, this.mValueArray[0]);
            }
            if (this.getSeparator() != null && n > 1) {
                for (int i = 1; i < this.mValueArray.length; ++i) {
                    this.printXMLString(printStream, this.getSeparator());
                    this.printXMLString(printStream, this.mValueArray[i]);
                }
            }
            printStream.print("</value>\n");
        } else if (this.mNilAttribute) {
            printStream.print(" xsi:nil=\"true\"/>\n");
        } else {
            printStream.print("/>\n");
        }
    }

    public NodeValueImpl copyNodeValueImpl() {
        NodeValueImpl nodeValueImpl = new NodeValueImpl();
        if (!this.mIsContentsSet) {
            this.getContents();
        }
        nodeValueImpl.mIsContentsSet = true;
        if (this.mValueArray != null) {
            String[] stringArray = new String[this.mValueArray.length];
            for (int i = 0; i < this.mValueArray.length; ++i) {
                stringArray[i] = new String(this.mValueArray[i]);
            }
            nodeValueImpl.mValueArray = stringArray;
        }
        nodeValueImpl.mDataType = this.mDataType;
        nodeValueImpl.mLocaleName = this.mLocaleName;
        nodeValueImpl.mNilAttribute = this.mNilAttribute;
        nodeValueImpl.mPropertyImpl = this.mPropertyImpl;
        nodeValueImpl.mOriginLayer = this.mOriginLayer;
        nodeValueImpl.mIsModifiedAtTopLayer = this.mIsModifiedAtTopLayer;
        return nodeValueImpl;
    }

    public void checkContentsAgainstDataType(DataType dataType) throws SPIException {
        block21: {
            int n;
            block22: {
                block20: {
                    if (this.mValueArray == null || this.mValueArray.length < 1) {
                        return;
                    }
                    n = dataType.getIntValue();
                    if (n == -1) {
                        return;
                    }
                    if (n != 2 && n != 3 && n != 4) break block20;
                    long l = 0L;
                    switch (n) {
                        case 2: {
                            for (int i = 0; i < this.mValueArray.length; ++i) {
                                try {
                                    l = Short.parseShort(this.mValueArray[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new InvalidDataTypeException(dataType.getStringValue(), numberFormatException);
                                }
                            }
                            break;
                        }
                        case 3: {
                            for (int i = 0; i < this.mValueArray.length; ++i) {
                                try {
                                    l = Integer.parseInt(this.mValueArray[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new InvalidDataTypeException(dataType.getStringValue(), numberFormatException);
                                }
                            }
                            break;
                        }
                        case 4: {
                            for (int i = 0; i < this.mValueArray.length; ++i) {
                                try {
                                    l = Long.parseLong(this.mValueArray[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new InvalidDataTypeException(dataType.getStringValue(), numberFormatException);
                                }
                            }
                            break;
                        }
                    }
                    break block21;
                }
                if (n != 5) break block22;
                for (int i = 0; i < this.mValueArray.length; ++i) {
                    try {
                        double d = Double.parseDouble(this.mValueArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDataTypeException(dataType.getStringValue(), numberFormatException);
                    }
                }
                break block21;
            }
            if (n != 1) break block21;
            for (int i = 0; i < this.mValueArray.length; ++i) {
                String string;
                if (!(this.mValueArray[i].length() == 1 ? !this.mValueArray[i].equals("1") && !this.mValueArray[i].equals("0") : !(string = this.mValueArray[i].toLowerCase()).equals("true") && !string.equals("false"))) continue;
                throw new InvalidDataTypeException(dataType.getStringValue());
            }
        }
    }

    public void setNilAttribute(boolean bl) {
        this.mNilAttribute = bl;
    }

    public void setPropertyImpl(PropertyImpl propertyImpl) {
        this.mPropertyImpl = propertyImpl;
    }

    public void setModifiedAtTopLayer() {
        this.mIsModifiedAtTopLayer = true;
    }

    public boolean isModifiedAtTopLayer() {
        return this.mIsModifiedAtTopLayer;
    }

    public void setDataType(DataType dataType) {
        this.mDataType = dataType;
    }

    public void setLocaleName(String string) {
        this.mLocaleName = string;
    }

    public String getLocaleName() {
        return this.mLocaleName;
    }

    public String getSeparator() {
        return this.mPropertyImpl.getSeparator();
    }

    public void setOriginalContents(String string) {
        String string2 = string;
        if (this.getSeparator() == null) {
            this.mValueArray = new String[1];
            this.mValueArray[0] = string2;
        } else if (this.getSeparator() == " ") {
            this.mValueArray = string2.split(this.getSeparator());
        } else {
            int n = 0;
            int n2 = 0;
            Vector<String> vector = new Vector<String>();
            while (n <= string2.length()) {
                n2 = string2.indexOf(this.getSeparator());
                if (n2 < 0) {
                    vector.add(string2);
                    break;
                }
                String string3 = string2.substring(n, n2);
                string3.trim();
                vector.add(string3);
                string2 = string2.substring(n2 + 1, string2.length());
            }
            if (vector != null && !vector.isEmpty()) {
                int n3 = vector.size();
                this.mValueArray = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    this.mValueArray[i] = new String((String)vector.get(i));
                }
            }
        }
        this.mIsContentsSet = true;
        this.mNilAttribute = false;
    }

    public void appendContents(String string) {
        if (this.mValueBuf == null) {
            this.mValueBuf = new StringBuffer(200);
        }
        this.mValueBuf.append(string);
    }

    public void setOrigin(Policy policy) {
        this.mOriginLayer = policy;
    }
}

