/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.cfgtree.property;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.ConfigElementImpl;
import com.sun.apoc.spi.cfgtree.DataType;
import com.sun.apoc.spi.cfgtree.InvalidDataTypeException;
import com.sun.apoc.spi.cfgtree.NodeKey;
import com.sun.apoc.spi.cfgtree.NodeValueImpl;
import com.sun.apoc.spi.cfgtree.OperationType;
import com.sun.apoc.spi.cfgtree.ProtectedElementImpl;
import com.sun.apoc.spi.cfgtree.XMLStreamable;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNodeImpl;
import com.sun.apoc.spi.cfgtree.property.InvalidPropertyException;
import com.sun.apoc.spi.cfgtree.property.MergedProperty;
import com.sun.apoc.spi.cfgtree.property.Property;
import com.sun.apoc.spi.policies.Policy;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class PropertyImpl
extends ProtectedElementImpl
implements Property,
MergedProperty,
XMLStreamable {
    public DataType mDataType = DataType.UNKNOWN;
    public boolean mLocalized = false;
    public boolean mNillable = true;
    public String mRequiredLocale = "default";
    public String mSeparator = " ";
    protected Policy mOriginLayer;
    protected String mNameOfElementWhereProtectionSet;
    protected Policy mOriginOfProtection;
    public Hashtable mValues;

    public Hashtable copyNodeValueImplTable(Hashtable hashtable, PropertyImpl propertyImpl) throws SPIException {
        Hashtable<String, NodeValueImpl> hashtable2 = new Hashtable<String, NodeValueImpl>();
        Enumeration enumeration = hashtable.keys();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                NodeValueImpl nodeValueImpl = (NodeValueImpl)hashtable.get(string);
                if (nodeValueImpl == null) continue;
                NodeValueImpl nodeValueImpl2 = nodeValueImpl.copyNodeValueImpl();
                nodeValueImpl2.setPropertyImpl(propertyImpl);
                hashtable2.put(string, nodeValueImpl2);
            }
        }
        return hashtable2;
    }

    public NodeValueImpl createDefaultNodeValueImpl() {
        NodeValueImpl nodeValueImpl = new NodeValueImpl();
        nodeValueImpl.setPropertyImpl(this);
        nodeValueImpl.setNilAttribute(true);
        nodeValueImpl.setDataType(this.mDataType);
        return nodeValueImpl;
    }

    public void expand(String string, boolean bl) throws SPIException {
        this.mPath = string;
        if (this.isProtected()) {
            if (this.getParent() == null || !this.getParent().isProtected()) {
                this.setFinalized(true, this.getAbsolutePath(), this.getOriginOfProtection());
            }
            if (bl) {
                this.setReadOnly();
            }
        }
    }

    public String getAttributes(int n) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("oor:name").append("=\"").append(this.getName()).append("\"");
        String string = OperationType.getString(this.getOperationType());
        if (string != null && string.equals("replace")) {
            stringBuffer.append(" ").append("oor:op").append("=\"").append(string).append("\"");
        }
        switch (n) {
            case 0: 
            case 1: {
                if (this.isProtected() && (this.getParent() == null || !this.getParent().isProtected())) {
                    stringBuffer.append(" ").append("oor:finalized").append("=\"true\"");
                }
                if (this.isLocalized()) {
                    stringBuffer.append(" ").append("oor:localized").append("=\"true\"");
                }
                if (!this.mNillable) {
                    stringBuffer.append(" ").append("oor:nillable").append("=\"false\"");
                }
                if (this.mDataType == DataType.UNKNOWN) break;
                stringBuffer.append(" ").append("oor:type").append("=\"").append(this.mDataType.getStringValue()).append("\"");
                break;
            }
            case 2: {
                if (this.isReadOnly()) {
                    stringBuffer.append(" ").append("oor:readonly").append("=\"true\"");
                } else if (this.isProtected()) {
                    stringBuffer.append(" ").append("oor:finalized").append("=\"true\"");
                }
                if (this.isLocalized()) {
                    stringBuffer.append(" ").append("oor:localized").append("=\"true\"");
                }
                if (!this.isNillable()) {
                    stringBuffer.append(" ").append("oor:nillable").append("=\"false\"");
                }
                if (this.mDataType == DataType.UNKNOWN) break;
                stringBuffer.append(" ").append("oor:type").append("=\"").append(this.mDataType.getStringValue()).append("\"");
            }
        }
        return stringBuffer.toString();
    }

    public DataType getDataType() {
        return this.mDataType;
    }

    public String getNameOfElementWhereProtectionSet() {
        return this.mNameOfElementWhereProtectionSet;
    }

    public NodeValueImpl getNodeValue() {
        NodeValueImpl nodeValueImpl = null;
        if (this.mValues != null) {
            Enumeration enumeration;
            nodeValueImpl = this.mLocalized ? (NodeValueImpl)this.mValues.get(this.mRequiredLocale) : (NodeValueImpl)this.mValues.get("default");
            if (nodeValueImpl == null && this.mLocalized && (nodeValueImpl = (NodeValueImpl)this.mValues.get("default")) != null) {
                nodeValueImpl = nodeValueImpl.copyNodeValueImpl();
            }
            if (nodeValueImpl == null && this.mLocalized && (nodeValueImpl = (NodeValueImpl)this.mValues.get("en-US")) != null) {
                nodeValueImpl = nodeValueImpl.copyNodeValueImpl();
            }
            if (nodeValueImpl == null && this.mLocalized && (enumeration = this.mValues.keys()) != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string == null) continue;
                    nodeValueImpl = (NodeValueImpl)this.mValues.get(string);
                    if (nodeValueImpl == null) break;
                    nodeValueImpl = nodeValueImpl.copyNodeValueImpl();
                    break;
                }
            }
        }
        if (nodeValueImpl == null) {
            nodeValueImpl = this.createDefaultNodeValueImpl();
        }
        return nodeValueImpl;
    }

    public NodeValueImpl getNodeValue(String string) {
        if (this.mValues == null) {
            return null;
        }
        return (NodeValueImpl)this.mValues.get(string);
    }

    public Policy getOrigin() {
        return this.mOriginLayer;
    }

    public Policy getOriginOfProtection() {
        return this.mOriginOfProtection;
    }

    public Policy getOriginOfValue() {
        return this.getNodeValue().getOrigin();
    }

    public String getRequiredLocale() {
        return this.mLocalized ? this.mRequiredLocale : null;
    }

    public String getSeparator() {
        return this.mSeparator;
    }

    public String getValue() throws SPIException {
        String string = this.getNodeValue().getContents();
        return string;
    }

    public Hashtable getValues() {
        return this.mValues;
    }

    public String getStringValue() throws SPIException {
        if (this.mDataType != DataType.STRING) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        return this.getNodeValue().getContents();
    }

    public String getHexBinary() throws SPIException {
        if (this.mDataType != DataType.HEXBIN) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        return this.getNodeValue().getContents();
    }

    public int getInt() throws SPIException {
        if (this.mDataType != DataType.INT) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String string = this.getNodeValue().getContents();
        if (string == null) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
        }
        return n;
    }

    public double getDouble() throws SPIException {
        if (this.mDataType != DataType.DOUBLE) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String string = this.getNodeValue().getContents();
        if (string == null) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
        }
        return d;
    }

    public short getShort() throws SPIException {
        if (this.mDataType != DataType.SHORT) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String string = this.getNodeValue().getContents();
        if (string == null) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        short s = 0;
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
        }
        return s;
    }

    public long getLong() throws SPIException {
        if (this.mDataType != DataType.LONG) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String string = this.getNodeValue().getContents();
        if (string == null) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
        }
        return l;
    }

    public boolean getBoolean() throws SPIException {
        if (this.mDataType != DataType.BOOLEAN) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String string = this.getNodeValue().getContents();
        if (string == null) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        boolean bl = false;
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (!string.equalsIgnoreCase("false")) {
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        return bl;
    }

    public String[] getHexBinaryList() throws SPIException {
        if (this.mDataType != DataType.STRING_LIST) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        return this.getNodeValue().getValueArray();
    }

    public int[] getIntList() throws SPIException {
        if (this.mDataType != DataType.INT_LIST) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String[] stringArray = this.getNodeValue().getValueArray();
        if (stringArray.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
            }
        }
        return nArray;
    }

    public double[] getDoubleList() throws SPIException {
        if (this.mDataType != DataType.DOUBLE_LIST) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String[] stringArray = this.getNodeValue().getValueArray();
        if (stringArray.length == 0) {
            return new double[0];
        }
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                dArray[i] = Double.parseDouble(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
            }
        }
        return dArray;
    }

    public short[] getShortList() throws SPIException {
        if (this.mDataType != DataType.SHORT_LIST) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String[] stringArray = this.getNodeValue().getValueArray();
        if (stringArray.length == 0) {
            return new short[0];
        }
        short[] sArray = new short[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                sArray[i] = Short.parseShort(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
            }
        }
        return sArray;
    }

    public long[] getLongList() throws SPIException {
        if (this.mDataType != DataType.LONG_LIST) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String[] stringArray = this.getNodeValue().getValueArray();
        if (stringArray.length == 0) {
            return new long[0];
        }
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                lArray[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPropertyException("error.spi.policytree.property.value.invalid", numberFormatException);
            }
        }
        return lArray;
    }

    public boolean[] getBooleanList() throws SPIException {
        if (this.mDataType != DataType.BOOLEAN_LIST) {
            throw new InvalidDataTypeException(this.mDataType.getStringValue());
        }
        String[] stringArray = this.getNodeValue().getValueArray();
        if (stringArray.length == 0) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("true")) {
                blArray[i] = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("false")) {
                blArray[i] = false;
                continue;
            }
            throw new InvalidPropertyException("error.spi.policytree.property.value.invalid");
        }
        return blArray;
    }

    public boolean isLocalized() {
        return this.mLocalized;
    }

    public boolean isNil() {
        return this.getNodeValue().hasNilAttribute();
    }

    public boolean isNillable() {
        return this.mNillable;
    }

    public void printTag(String string, PrintStream printStream, boolean bl, int n) {
        printStream.print(string + (bl ? "<" : "</"));
        printStream.print("prop");
        if (bl) {
            printStream.print(" " + this.getAttributes(n));
        }
        printStream.print(">\n");
    }

    public void printToStream(String string, PrintStream printStream, int n) {
        this.printTag(string, printStream, true, n);
        this.printValue(string + '\t', printStream, n);
        this.printTag(string, printStream, false, n);
    }

    public void printValue(String string, PrintStream printStream, int n) {
        if (this.mValues != null) {
            NodeValueImpl nodeValueImpl = null;
            Enumeration enumeration = this.mValues.elements();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    nodeValueImpl = (NodeValueImpl)enumeration.nextElement();
                    if (nodeValueImpl == null) continue;
                    if (n == 1) {
                        if (!this.isAddedAtTopLayer() && !nodeValueImpl.isModifiedAtTopLayer()) continue;
                        nodeValueImpl.printToStream(string, printStream);
                        continue;
                    }
                    nodeValueImpl.printToStream(string, printStream);
                }
            }
        }
    }

    public void processReadOperation(PolicyNodeImpl policyNodeImpl, NodeKey nodeKey, String string, boolean bl) throws SPIException {
        if (this.mName == null) {
            throw new InvalidPropertyException();
        }
        switch (this.mOperationType) {
            case 1: {
                this.readReplaceProperty(policyNodeImpl, nodeKey, string, bl);
                break;
            }
            case -1: 
            case 0: {
                this.readModifyProperty(policyNodeImpl, nodeKey, string, bl);
            }
        }
    }

    public abstract void put(String var1, DataType var2) throws SPIException;

    public abstract void putString(String var1) throws SPIException;

    public abstract void putHexBinary(String var1) throws SPIException;

    public abstract void putInt(int var1) throws SPIException;

    public abstract void putDouble(double var1) throws SPIException;

    public abstract void putShort(short var1) throws SPIException;

    public abstract void putLong(long var1) throws SPIException;

    public abstract void putBoolean(boolean var1) throws SPIException;

    public abstract void putStringList(String[] var1) throws SPIException;

    public abstract void putHexBinaryList(String[] var1) throws SPIException;

    public abstract void putIntList(int[] var1) throws SPIException;

    public abstract void putDoubleList(double[] var1) throws SPIException;

    public abstract void putShortList(short[] var1) throws SPIException;

    public abstract void putLongList(long[] var1) throws SPIException;

    public abstract void putBooleanList(boolean[] var1) throws SPIException;

    public abstract void readModifyProperty(PolicyNodeImpl var1, NodeKey var2, String var3, boolean var4) throws SPIException;

    public abstract void readReplaceProperty(PolicyNodeImpl var1, NodeKey var2, String var3, boolean var4) throws SPIException;

    public void setDataType(DataType dataType) {
        this.mDataType = dataType;
    }

    public void setFinalized(boolean bl, String string, Policy policy) {
        super.setFinalized(bl);
        this.mNameOfElementWhereProtectionSet = string;
        this.mOriginOfProtection = policy;
    }

    public void setLocalized() {
        this.mLocalized = true;
    }

    public abstract void setNil() throws SPIException;

    public void setNillable(boolean bl) {
        this.mNillable = bl;
    }

    public void setNodeValue(NodeValueImpl nodeValueImpl, String string) throws SPIException {
        this.checkIfReadOnly();
        nodeValueImpl.setPropertyImpl(this);
        if (this.mValues == null) {
            this.mValues = new Hashtable();
        }
        if (!this.mLocalized || string == null || string.equals("default")) {
            this.mValues.put("default", nodeValueImpl);
        } else {
            this.mValues.put(string, nodeValueImpl);
        }
    }

    public void setOrigin(Policy policy) {
        Enumeration enumeration;
        this.mOriginLayer = policy;
        if (this.mValues != null && (enumeration = this.mValues.elements()) != null) {
            while (enumeration.hasMoreElements()) {
                ((NodeValueImpl)enumeration.nextElement()).setOrigin(policy);
            }
        }
    }

    public void setParsedValue(NodeValueImpl nodeValueImpl, String string) {
        if (this.mValues == null) {
            this.mValues = new Hashtable();
        }
        nodeValueImpl.setPropertyImpl(this);
        if (string == null || string.equals("default")) {
            this.mValues.put("default", nodeValueImpl);
        } else {
            this.mValues.put(string, nodeValueImpl);
        }
    }

    public void setRequiredLocale(String string) {
        if (string != null || !string.equals("default")) {
            this.mRequiredLocale = string;
        }
    }

    public abstract void setSeparator(String var1);

    public void setSettingsForAddedProperty(String string, Policy policy, boolean bl) {
        this.setPath(string);
        if (policy != null) {
            this.setOrigin(policy);
        }
        if (!bl) {
            this.setAddedAtTopLayer();
        }
    }

    public ConfigElementImpl shallowCopy() throws SPIException {
        ConfigElementImpl configElementImpl = super.shallowCopy();
        if (this.mValues != null && !this.mValues.isEmpty()) {
            ((PropertyImpl)configElementImpl).mValues = this.copyNodeValueImplTable(this.mValues, (PropertyImpl)configElementImpl);
        }
        ((PropertyImpl)configElementImpl).mSeparator = this.mSeparator;
        ((PropertyImpl)configElementImpl).mNameOfElementWhereProtectionSet = this.mNameOfElementWhereProtectionSet;
        ((PropertyImpl)configElementImpl).mOriginOfProtection = this.mOriginOfProtection;
        ((PropertyImpl)configElementImpl).mOriginLayer = this.mOriginLayer;
        ((PropertyImpl)configElementImpl).mRequiredLocale = this.mRequiredLocale;
        ((PropertyImpl)configElementImpl).mDataType = this.mDataType;
        return configElementImpl;
    }
}

