/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.environment;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.environment.PasswordCodec;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class EnvironmentMgr {
    public static final String SERVER_KEY = "Server";
    public static final String PORT_KEY = "Port";
    public static final String BASE_DN_KEY = "BaseDn";
    public static final String TYPE_KEY = "DataStoreType";
    public static final String LDAP_TYPE = "LDAP";
    protected Hashtable mEnvironment;
    protected static HashSet sLdapProtocols = new HashSet();
    protected static HashSet sFileProtocols = new HashSet();
    private Hashtable mConnections = new Hashtable();
    private static final String[] DEFAULT_SOURCES;
    static /* synthetic */ Class class$com$sun$apoc$spi$entities$EntityTreeProvider;
    static /* synthetic */ Class class$com$sun$apoc$spi$AssignmentProvider;
    static /* synthetic */ Class class$com$sun$apoc$spi$profiles$ProfileProvider;

    public EnvironmentMgr(Hashtable hashtable) {
        this.mEnvironment = hashtable;
        this.translateOldParameters();
    }

    public void translateOldParameters() {
        if (this.getOrganizationURLs().length == 0 && this.getDomainURLs().length == 0 && this.getProfileURLs().length == 0 && this.getAssignmentURLs().length == 0) {
            String string = (String)this.mEnvironment.get(TYPE_KEY);
            if (string == null || string.length() == 0) {
                string = LDAP_TYPE;
            }
            if (string.equals(LDAP_TYPE)) {
                boolean bl;
                String string2 = (String)this.mEnvironment.get(SERVER_KEY);
                boolean bl2 = string2 == null || string2.length() == 0;
                String string3 = (String)this.mEnvironment.get(BASE_DN_KEY);
                boolean bl3 = bl = string3 == null || string3.length() == 0;
                if (!bl2 && !bl) {
                    boolean bl4;
                    StringBuffer stringBuffer = new StringBuffer("ldap");
                    stringBuffer.append("://").append(string2);
                    String string4 = (String)this.mEnvironment.get(PORT_KEY);
                    boolean bl5 = bl4 = string4 == null || string4.length() == 0;
                    if (!bl4) {
                        stringBuffer.append(":").append(string4);
                    }
                    stringBuffer.append("/").append(string3);
                    this.mEnvironment.put("PROVIDER_URL", stringBuffer.toString());
                }
            }
        }
    }

    public void checkEnvironment() throws SPIException {
    }

    public Hashtable getEnvironment() {
        return this.mEnvironment;
    }

    public String getStringParam(String string) {
        return (String)this.mEnvironment.get(string);
    }

    protected String getParam(String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = this.getStringParam(string + string2);
        }
        if (string3 == null) {
            string3 = this.getStringParam(string2);
        }
        return string3;
    }

    protected String getParam(String string, String string2, String string3) {
        String string4 = null;
        if (string != null && string2 != null) {
            string4 = this.getStringParam(string + string2 + string3);
        }
        if (string4 == null) {
            string4 = this.getStringParam(string2 + string3);
        }
        if (string4 == null) {
            string4 = this.getStringParam(string3);
        }
        return string4;
    }

    protected String[] getURLList(String string) {
        String[] stringArray = new String[]{};
        if (string != null) {
            stringArray = string.split("\\s");
        }
        return stringArray;
    }

    protected int getIntParamFromString(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    protected char[] getPasswordParam(String string, String string2) {
        String string3;
        Object var3_3 = null;
        char[] cArray = null;
        var3_3 = this.mEnvironment.get(string + string2);
        if (var3_3 == null) {
            var3_3 = this.mEnvironment.get(string2);
        }
        if (var3_3 != null) {
            if (var3_3 instanceof String) {
                cArray = ((String)var3_3).toCharArray();
            } else {
                try {
                    cArray = var3_3;
                }
                catch (ClassCastException classCastException) {
                    cArray = null;
                }
            }
        }
        if ((string3 = this.getStringParam(string + string2 + "_ENCODING")) == null) {
            string3 = this.getStringParam(string2 + "_ENCODING");
        }
        if (string3 != null && string3.equals("scramble")) {
            cArray = PasswordCodec.decode(cArray);
        }
        return cArray;
    }

    public static String getUserFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getUserInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getProtocolFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getScheme();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getHostFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static int getPortFromURL(String string) {
        int n = -1;
        try {
            URI uRI = new URI(string);
            n = uRI.getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static String getPathFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public String[] getOrganizationURLs() {
        String string = this.getParam("USER_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getDomainURLs() {
        String string = this.getParam("HOST_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getProfileURLs() {
        String string = this.getParam("PROFILE_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getAssignmentURLs() {
        String string = this.getParam("ASSIGNMENT_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getProviderURLs(String string, String string2) {
        String string3 = this.getParam(string, string2, "PROVIDER_URL");
        return this.getURLList(string3);
    }

    public String getProviderClass(String string, String string2) {
        return this.getParam(string, string2, "PROVIDER_CLASS");
    }

    public String[] getProviderURLs(String string, Class clazz) {
        String string2 = null;
        if (clazz == (class$com$sun$apoc$spi$entities$EntityTreeProvider == null ? (class$com$sun$apoc$spi$entities$EntityTreeProvider = EnvironmentMgr.class$("com.sun.apoc.spi.entities.EntityTreeProvider")) : class$com$sun$apoc$spi$entities$EntityTreeProvider)) {
            string2 = "";
        } else if (clazz == (class$com$sun$apoc$spi$AssignmentProvider == null ? (class$com$sun$apoc$spi$AssignmentProvider = EnvironmentMgr.class$("com.sun.apoc.spi.AssignmentProvider")) : class$com$sun$apoc$spi$AssignmentProvider)) {
            string2 = "ASSIGNMENT_";
        } else if (clazz == (class$com$sun$apoc$spi$profiles$ProfileProvider == null ? (class$com$sun$apoc$spi$profiles$ProfileProvider = EnvironmentMgr.class$("com.sun.apoc.spi.profiles.ProfileProvider")) : class$com$sun$apoc$spi$profiles$ProfileProvider)) {
            string2 = "PROFILE_";
        }
        string = string + "_";
        return this.getProviderURLs(string, string2);
    }

    public String getProviderClass(String string, Class clazz) {
        String string2 = null;
        if (clazz == (class$com$sun$apoc$spi$entities$EntityTreeProvider == null ? (class$com$sun$apoc$spi$entities$EntityTreeProvider = EnvironmentMgr.class$("com.sun.apoc.spi.entities.EntityTreeProvider")) : class$com$sun$apoc$spi$entities$EntityTreeProvider)) {
            string2 = "";
        } else if (clazz == (class$com$sun$apoc$spi$AssignmentProvider == null ? (class$com$sun$apoc$spi$AssignmentProvider = EnvironmentMgr.class$("com.sun.apoc.spi.AssignmentProvider")) : class$com$sun$apoc$spi$AssignmentProvider)) {
            string2 = "ASSIGNMENT_";
        } else if (clazz == (class$com$sun$apoc$spi$profiles$ProfileProvider == null ? (class$com$sun$apoc$spi$profiles$ProfileProvider = EnvironmentMgr.class$("com.sun.apoc.spi.profiles.ProfileProvider")) : class$com$sun$apoc$spi$profiles$ProfileProvider)) {
            string2 = "PROFILE_";
        }
        string = string + "_";
        return this.getProviderClass(string, string2);
    }

    public String[] getSources() {
        return EnvironmentMgr.getSources(this.mEnvironment);
    }

    public static String[] getSources(Hashtable hashtable) {
        String string = (String)hashtable.get("Sources");
        if (string == null) {
            return DEFAULT_SOURCES;
        }
        return string.split(",");
    }

    public char[] getOrganizationCredentials() {
        return this.getPasswordParam("USER_", "SECURITY_CREDENTIALS");
    }

    public char[] getDomainCredentials() {
        return this.getPasswordParam("HOST_", "SECURITY_CREDENTIALS");
    }

    public char[] getProfileCredentials() {
        return this.getPasswordParam("PROFILE_", "SECURITY_CREDENTIALS");
    }

    public char[] getAssignmentCredentials() {
        return this.getPasswordParam("ASSIGNMENT_", "SECURITY_CREDENTIALS");
    }

    public String getOrganizationClass() {
        return this.getParam("USER_", "PROVIDER_CLASS");
    }

    public String getDomainClass() {
        return this.getParam("HOST_", "PROVIDER_CLASS");
    }

    public String getProfileClass() {
        return this.getParam("PROFILE_", "PROVIDER_CLASS");
    }

    public String getAssignmentClass() {
        return this.getParam("ASSIGNMENT_", "PROVIDER_CLASS");
    }

    public String getOrganizationUser(String string) {
        String string2 = null;
        string2 = EnvironmentMgr.getUserFromURL(string);
        if (string2 == null) {
            string2 = this.getParam("USER_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public String getDomainUser(String string) {
        String string2 = null;
        if (string != null) {
            string2 = EnvironmentMgr.getUserFromURL(string);
        }
        if (string2 == null) {
            string2 = this.getParam("HOST_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public String getProfileUser(String string) {
        String string2 = null;
        if (string != null) {
            string2 = EnvironmentMgr.getUserFromURL(string);
        }
        if (string2 == null) {
            string2 = this.getParam("PROFILE_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public String getAssignmentUser(String string) {
        String string2 = null;
        if (string != null) {
            string2 = EnvironmentMgr.getUserFromURL(string);
        }
        if (string2 == null) {
            string2 = this.getParam("ASSIGNMENT_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public static boolean isLdapProtocol(String string) {
        return sLdapProtocols.contains(string);
    }

    public static boolean isFileProtocol(String string) {
        return sFileProtocols.contains(string);
    }

    public static String getSupportedProtocolsString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Iterator iterator = sLdapProtocols.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next()).append(",");
        }
        Iterator iterator2 = sFileProtocols.iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append((String)iterator2.next()).append(",");
        }
        if (stringBuffer.lastIndexOf(",") == stringBuffer.length() - 1) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public synchronized Object getConnectionHandler(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.mConnections.get(string);
        }
        return var2_2;
    }

    public synchronized void setConnectionHandler(String string, Object object) {
        if (string != null) {
            if (object == null) {
                this.mConnections.remove(string);
            } else {
                this.mConnections.put(string, object);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sLdapProtocols.add("ldap");
        sLdapProtocols.add("ldaps");
        sFileProtocols.add("file");
        sFileProtocols.add("http");
        sFileProtocols.add("https");
        DEFAULT_SOURCES = new String[]{"HOST", "USER"};
    }
}

