/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.DomainTreeProvider;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.file.entities.FileDomain;
import com.sun.apoc.spi.file.entities.FileEntityProvider;
import com.sun.apoc.spi.file.entities.FileHost;
import com.sun.apoc.spi.file.entities.FileNode;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;

public class FileDomainProvider
extends FileEntityProvider
implements DomainTreeProvider {
    private static final String DEFAULT_DOMAIN_CONTAINER = "entities.txt";

    public FileDomainProvider(PolicySource policySource, String string) throws SPIException {
        super(policySource, string, DEFAULT_DOMAIN_CONTAINER);
    }

    public Domain getRootDomain() throws SPIException {
        if (!this.mDataIsLoaded) {
            this.loadData();
        }
        return (Domain)this.mRootNode;
    }

    protected void loadData() throws SPIException {
        if (this.mDataIsLoaded) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mLocation.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("h:")) {
                    this.createEntities(true, string);
                    continue;
                }
                if (!string.startsWith("d:")) continue;
                this.createEntities(false, string);
            }
            bufferedReader.close();
            if (this.mRootNode == null) {
                this.mRootNode = new FileDomain("", "fakeDomainRoot", null, this.mPolicySource);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", iOException);
        }
        this.mDataIsLoaded = true;
    }

    private void createEntities(boolean bl, String string) throws SPIException {
        if (string.indexOf(47) != -1) {
            String[] stringArray = string.split("/");
            StringBuffer stringBuffer = new StringBuffer(stringArray[1]).append("Dom");
            if (this.mRootNode == null) {
                this.mRootNode = new FileDomain(stringArray[1], stringBuffer.toString(), null, this.mPolicySource);
            } else if (!this.mRootNode.getId().contentEquals(stringBuffer)) {
                return;
            }
            if (stringArray.length > 2) {
                FileDomain fileDomain;
                int n;
                FileNode fileNode = (FileNode)this.mRootNode;
                for (n = 2; n < stringArray.length - 1; ++n) {
                    Iterator iterator = fileNode.getChildren();
                    stringBuffer.append("_");
                    stringBuffer.append(stringArray[n]);
                    if (!this.contains(iterator, stringBuffer.toString())) {
                        fileDomain = new FileDomain(stringArray[n], stringBuffer.toString(), fileNode, this.mPolicySource);
                        fileNode.addChildNode(fileDomain);
                        fileNode = fileDomain;
                        continue;
                    }
                    fileNode = (FileNode)this.internalGetEntity(stringBuffer.toString());
                }
                stringBuffer.append("_");
                stringBuffer.append(stringArray[n]);
                if (bl) {
                    FileHost fileHost = new FileHost(stringArray[n], stringBuffer.toString(), fileNode, this.mPolicySource);
                    fileNode.addChildLeaf(fileHost);
                } else {
                    fileDomain = new FileDomain(stringArray[n], stringBuffer.toString(), fileNode, this.mPolicySource);
                    fileNode.addChildNode(fileDomain);
                }
            }
        }
    }

    private boolean contains(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!entity.getId().equals(string)) continue;
            return true;
        }
        return false;
    }
}

