/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.authentication;

import com.netscape.sasl.SaslClient;
import com.netscape.sasl.SaslException;
import com.sun.apoc.spi.ldap.authentication.LdapSaslGSSAPICallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.auth.callback.CallbackHandler;

public class SaslMechanism
implements SaslClient {
    public static final String sMech = "GSSAPI";
    private static short sSequenceMax = (short)3;
    private short mSequence = 0;
    private CallbackHandler mHandler;
    private LdapSaslGSSAPICallback[] mCallbacks = new LdapSaslGSSAPICallback[1];

    public SaslMechanism(String string, CallbackHandler callbackHandler) throws IllegalArgumentException {
        if (callbackHandler == null) {
            throw new IllegalArgumentException();
        }
        this.mCallbacks[0] = new LdapSaslGSSAPICallback(string);
        this.mHandler = callbackHandler;
    }

    public String getMechanismName() {
        return sMech;
    }

    public InputStream getInputStream(InputStream inputStream) throws IOException {
        return inputStream;
    }

    public OutputStream getOutputStream(OutputStream outputStream) throws IOException {
        return outputStream;
    }

    public byte[] createInitialResponse() throws SaslException {
        try {
            this.mHandler.handle(this.mCallbacks);
            this.mSequence = (short)(this.mSequence + 1);
            return this.mCallbacks[0].getResponse();
        }
        catch (Exception exception) {
            throw new SaslException();
        }
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        try {
            if (this.isComplete()) {
                return null;
            }
            this.mCallbacks[0].setChallenge(byArray);
            this.mHandler.handle(this.mCallbacks);
            this.mSequence = (short)(this.mSequence + 1);
            return this.mCallbacks[0].getResponse();
        }
        catch (Exception exception) {
            throw new SaslException();
        }
    }

    public boolean isComplete() {
        return this.mSequence >= sSequenceMax;
    }
}

