/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.datastore;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.IllegalWriteException;
import com.sun.apoc.spi.PolicySource;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.NoSuchEntityException;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.entities.LdapDomain;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapNode;
import com.sun.apoc.spi.ldap.entities.LdapOrganization;
import com.sun.apoc.spi.ldap.entities.LdapRole;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.ldap.policies.LdapPolicy;
import com.sun.apoc.spi.ldap.profiles.LdapProfile;
import com.sun.apoc.spi.ldap.profiles.LdapProfileComparator;
import com.sun.apoc.spi.ldap.profiles.LdapProfileRepository;
import com.sun.apoc.spi.ldap.util.Timestamp;
import com.sun.apoc.spi.policies.NoSuchPolicyException;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.policies.PolicyInfo;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.InvalidPriorityException;
import com.sun.apoc.spi.profiles.InvalidProfileException;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileImpl;
import com.sun.apoc.spi.profiles.ProfileRepository;
import com.sun.apoc.spi.profiles.ProfileRepositoryImpl;
import com.sun.apoc.spi.util.BooleanReturnValue;
import com.sun.apoc.spi.util.MetaConfiguration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

public class LdapDataStore {
    public static final int BUFFER_LENGTH = 200;
    public static final boolean RECURSIVE_SEARCH = true;
    public static final boolean NON_RECURSIVE_SEARCH = false;
    private float versionNb = 1.0f;
    private boolean isVersion1 = true;
    private LdapOrganization mRootOrganization;
    private LdapDomain mRootDomain;
    public StringBuffer mServiceEntryDNBuf = null;
    public StringBuffer mRootServiceEntryDNBuf = new StringBuffer(200);
    static final String VERSION_KEY = "ApocVersion";
    public static final String SERVICES = "services";
    public static final String SERVICE_APOC = "ApocService";
    public static final String SERVICE_ORG_CONFIG = "OrganizationConfig";
    public static final String SERVICE_VERSION = "1.0";
    public static final String SERVICE_DEFAULT = "default";
    public static final String SERVICE_REGISTRY = "ApocRegistry";
    public static final int NUMBER_OF_SERVICE_MAPPING_ELEMENTS = 6;
    public static ServiceMapping[] SERVICE_MAPPING_ELEMENTS = new ServiceMapping[6];
    private static EntryMapping CONTAINER_MAPPING;
    private static EntryMapping PROFILE_MAPPING;
    private static EntryMapping POLICY_MAPPING;
    public static final String DN_KEY = "DN";
    public static final String LDAP_OBJCLASS = "objectclass";
    public static final String ORG_UNIT_OBJCLASS = "organizationalunit";
    public static final String ORG_UNIT_NAMING_ATTR = "ou";
    public static final String CONFIG_NAMING_ATTR = "ou=";
    private static final String SUNSERVICE_OBJCLASS = "sunservice";
    public static final String SUNSERVICE_COMPONENT_OBJCLASS = "sunservicecomponent";
    private static final String SUNSERVICEID_ATTR = "sunserviceid";
    private static final String SUNSERVICEID_PROFILE = "ApocPolicyGroup";
    private static final String SUNSERVICEID_POLICY = "ApocPolicy";
    public static final String KEYVALUE_ATTR = "sunkeyvalue";
    private static final String PRIORITY_ATTR = "sunsmspriority";
    public static final String MODIFY_TIMESTAMP_ATTR = "modifytimestamp";
    private static final String MODIFY_AUTHOR_ATTR = "modifiersname";
    private static final String APPLICABILITY_KEY = "applicability=";
    private static final String APOC_BLOB_KEY = "APOCBlob=";
    private static final String DISPLAY_NAME_KEY = "displayname=";
    public static final String ORG_MAP_KEY = "organizationalmapping=";
    public static final String LDAP_ATTR_MAP_KEY = "ldapattributemapping=";
    private static final String ASSIGNED_KEY = "assigned=";
    private static final String COMMENT_KEY = "comment=";
    private static final String USER_PROFILE_USE_VALUE;
    private static final String HOST_PROFILE_USE_VALUE;
    PolicyIdParser mPolicyIdParser = new PolicyIdParser();
    public static final String LDAP_WILDCARD = "*";
    private String mBaseDN = null;
    private String mRootDN = null;
    private static final String[] TIMEONLY_POLICY_ATTRS;
    private static final String[] ALL_POLICY_ATTRS;
    private static final String[] ALL_PROFILE_ATTRS;

    public LdapDataStore(String string, LdapClientContext ldapClientContext) throws SPIException {
        this.readBootstrapData(string);
    }

    public void setVersion(MetaConfiguration metaConfiguration) {
        String string = metaConfiguration.getString(VERSION_KEY);
        if (string != null) {
            try {
                this.versionNb = Float.parseFloat(string);
                this.isVersion1 = this.versionNb < 2.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean isVersion1() {
        return this.isVersion1;
    }

    public String getBaseDN() {
        return this.mBaseDN;
    }

    public String getRootServiceEntryDN() {
        return this.mRootServiceEntryDNBuf.toString();
    }

    public String getServiceEntryDN() {
        return this.mServiceEntryDNBuf.toString();
    }

    private void readBootstrapData(String string) {
        this.mBaseDN = string;
        this.mServiceEntryDNBuf = new StringBuffer(200);
        for (int i = 0; i < 6; ++i) {
            this.mServiceEntryDNBuf.append(LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].mEntryRDN);
            if (i + 1 >= 6) continue;
            this.mServiceEntryDNBuf.append(",");
        }
        this.mRootServiceEntryDNBuf.append(this.mServiceEntryDNBuf).append(",").append(this.mBaseDN);
    }

    public Vector getRoleMembers(LdapRole ldapRole, String string, String string2, String[] stringArray, boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(&(");
        stringBuffer.append(LDAP_OBJCLASS);
        stringBuffer.append("=");
        stringBuffer.append(string);
        stringBuffer.append(")(");
        stringBuffer.append(string2);
        stringBuffer.append("=");
        stringBuffer.append(ldapRole.getLocation());
        stringBuffer.append("))");
        Vector vector = null;
        vector = this.performSearch(((LdapNode)ldapRole.getParentOrgOrDomain()).getLocation(), true, stringBuffer.toString(), stringArray, true, bl, booleanReturnValue, false, ldapRole.getContext());
        return vector == null ? new Vector() : vector;
    }

    public Vector getListOfChildren(LdapNode ldapNode, String string, String string2, boolean bl, String[] stringArray, boolean bl2, LdapClientContext ldapClientContext, BooleanReturnValue booleanReturnValue) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (string != null) {
            stringBuffer.append(string).append(",");
        }
        stringBuffer.append(ldapNode.getLocation());
        Vector vector = this.performSearch(stringBuffer.toString(), bl, string2, stringArray, true, bl2, booleanReturnValue, false, ldapClientContext);
        return vector;
    }

    private LDAPEntry readAttributes(String string, String[] stringArray, LdapClientContext ldapClientContext) throws LDAPException {
        LDAPConnection lDAPConnection = ldapClientContext.getConnection();
        LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
        return lDAPEntry;
    }

    public Hashtable readAllAttributes(String string, LdapClientContext ldapClientContext) throws LDAPException {
        String[] stringArray = new String[]{LDAP_WILDCARD, MODIFY_TIMESTAMP_ATTR};
        LDAPEntry lDAPEntry = ldapClientContext.getConnection().read(string, stringArray);
        Enumeration enumeration = lDAPEntry.getAttributeSet().getAttributes();
        Hashtable hashtable = new Hashtable();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            Enumeration enumeration2 = lDAPAttribute.getByteValues();
            if (!enumeration2.hasMoreElements()) continue;
            hashtable.put(lDAPAttribute.getName(), enumeration2.nextElement());
        }
        return hashtable;
    }

    public String readEntryDN(String string, LdapClientContext ldapClientContext) throws SPIException {
        String string2 = null;
        String[] stringArray = new String[]{LDAP_OBJCLASS};
        try {
            LDAPConnection lDAPConnection = ldapClientContext.getConnection();
            LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
            if (lDAPEntry != null) {
                string2 = lDAPEntry.getDN();
            }
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                throw new NoSuchEntityException(string);
            }
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        return string2;
    }

    public Hashtable getAttributeValueTable(String string, boolean bl, String[] stringArray, LdapClientContext ldapClientContext) throws LDAPException {
        LDAPEntry lDAPEntry = null;
        lDAPEntry = this.readAttributes(string, stringArray, ldapClientContext);
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        if (lDAPEntry != null) {
            if (bl) {
                Vector<String> vector = new Vector<String>();
                vector.add(lDAPEntry.getDN());
                hashtable.put(DN_KEY, vector);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], LdapDataStore.getAllValues(lDAPEntry, stringArray[i]));
            }
        }
        return hashtable;
    }

    public Vector getAttributeValueList(String string, String[] stringArray, boolean bl, boolean bl2, LdapClientContext ldapClientContext, BooleanReturnValue booleanReturnValue) throws LDAPException {
        Vector<String> vector = new Vector<String>();
        LDAPEntry lDAPEntry = null;
        lDAPEntry = this.readAttributes(string, stringArray, ldapClientContext);
        if (lDAPEntry != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[i]);
                if (lDAPAttribute == null) continue;
                if (bl) {
                    booleanReturnValue.setReturnValue(true);
                    return vector;
                }
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    vector.add((String)enumeration.nextElement());
                }
            }
            if (bl2) {
                vector.add(lDAPEntry.getDN());
            }
        }
        return vector;
    }

    public Vector getAttributeValueList(String string, String[] stringArray, LdapClientContext ldapClientContext) throws LDAPException {
        return this.getAttributeValueList(string, stringArray, false, false, ldapClientContext, new BooleanReturnValue(false));
    }

    public Vector performSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, boolean bl3, BooleanReturnValue booleanReturnValue, boolean bl4, LdapClientContext ldapClientContext) throws IllegalReadException {
        return this.performSearch(string, bl, string2, stringArray, bl2, bl3, booleanReturnValue, bl4, ldapClientContext.getConnection());
    }

    public Vector performSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, boolean bl3, BooleanReturnValue booleanReturnValue, boolean bl4, LDAPConnection lDAPConnection) throws IllegalReadException {
        Vector vector;
        block9: {
            vector = new Vector();
            LDAPSearchResults lDAPSearchResults = null;
            try {
                lDAPSearchResults = this.doSearch(string, bl, string2, stringArray, bl4, lDAPConnection);
                if (bl3) {
                    if (lDAPSearchResults.hasMoreElements()) {
                        booleanReturnValue.setReturnValue(true);
                    }
                    lDAPConnection.abandon(lDAPSearchResults);
                    return vector;
                }
                while (lDAPSearchResults.hasMoreElements()) {
                    Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    if (bl2) {
                        Vector<String> vector2 = new Vector<String>();
                        vector2.add(lDAPEntry.getDN());
                        hashtable.put(DN_KEY, vector2);
                    }
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            hashtable.put(stringArray[i], LdapDataStore.getAllValues(lDAPEntry, stringArray[i]));
                        }
                    }
                    vector.add(hashtable);
                }
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 11) {
                    throw new IllegalReadException("error.spi.access.illegal.read.ldap.size", lDAPException);
                }
                if (n == 4) break block9;
                throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
            }
        }
        return vector;
    }

    public Vector getEntriesAttributes(String string, boolean bl, String string2, String[] stringArray, boolean bl2, LdapClientContext ldapClientContext) throws SPIException {
        Vector vector = new Vector();
        try {
            LDAPSearchResults lDAPSearchResults = this.doSearch(string, bl, string2, stringArray, false, ldapClientContext);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                Vector<String> vector2 = new Vector<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    Vector vector3 = LdapDataStore.getAllValues(lDAPEntry, stringArray[i]);
                    if (vector3 == null || vector3.isEmpty()) continue;
                    for (int j = 0; j < vector3.size(); ++j) {
                        vector2.add((String)vector3.get(j));
                    }
                }
                if (bl2) {
                    vector2.add(lDAPEntry.getDN());
                }
                vector.add(vector2);
            }
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            if (n == 4 || n == 11) {
                throw new IllegalReadException("error.spi.access.illegal.read.ldap.size", lDAPException);
            }
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        return vector;
    }

    private LDAPSearchResults doSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, LdapClientContext ldapClientContext) throws LDAPException {
        return this.doSearch(string, bl, string2, stringArray, bl2, ldapClientContext.getConnection());
    }

    private LDAPSearchResults doSearch(String string, boolean bl, String string2, String[] stringArray, boolean bl2, LDAPConnection lDAPConnection) throws LDAPException {
        int n = 1;
        if (bl) {
            n = 2;
        }
        if (string == null) {
            string = this.mBaseDN;
        }
        return lDAPConnection.search(string, n, string2, stringArray, bl2);
    }

    private void deleteEntry(String string, LdapClientContext ldapClientContext) throws LDAPException {
        ldapClientContext.getConnection().delete(string);
    }

    private void renameEntry(String string, String string2, LdapClientContext ldapClientContext) throws LDAPException {
        ldapClientContext.getConnection().rename(string, string2, true);
    }

    private void addEntry(String string, LDAPAttributeSet lDAPAttributeSet, LDAPConnection lDAPConnection) throws LDAPException {
        int n;
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        String string2 = stringArray[0].substring(0, n = stringArray[0].indexOf(61));
        if (lDAPAttributeSet.getAttribute(string2) == null) {
            lDAPAttributeSet.add(new LDAPAttribute(string2, stringArray[0].substring(n + 1)));
        }
        LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
        lDAPConnection.add(lDAPEntry);
    }

    private void writeAttributes(String string, String string2, Change[] changeArray, boolean bl, LDAPConnection lDAPConnection) throws SPIException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        try {
            if (!this.containsContainer(string, string2, lDAPConnection)) {
                lDAPModificationSet.add(0, new LDAPAttribute(LDAP_OBJCLASS, string2));
            }
            for (int i = 0; i < changeArray.length; ++i) {
                LDAPAttribute lDAPAttribute = bl ? new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues) : new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues[0]);
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            lDAPConnection.modify(string, lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
        }
    }

    private void deleteAttributeValues(String string, String string2, Change[] changeArray, boolean bl, LDAPConnection lDAPConnection) throws SPIException {
        block3: {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            try {
                for (int i = 0; i < changeArray.length; ++i) {
                    LDAPAttribute lDAPAttribute = bl ? new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues) : new LDAPAttribute(changeArray[i].mName, changeArray[i].mValues[0]);
                    lDAPModificationSet.add(1, lDAPAttribute);
                }
                lDAPConnection.modify(string, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 16 || n == 32) break block3;
                throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
            }
        }
    }

    public boolean entryExists(String string, LdapClientContext ldapClientContext) throws LDAPException {
        return this.entryExists(string, ldapClientContext.getConnection());
    }

    private boolean entryExists(String string, LDAPConnection lDAPConnection) throws LDAPException {
        try {
            lDAPConnection.read(string);
            return true;
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            if (n != 16 && n != 32) {
                throw lDAPException;
            }
            return false;
        }
    }

    private boolean containsContainer(String string, String string2, LDAPConnection lDAPConnection) throws LDAPException {
        LDAPAttribute lDAPAttribute;
        String[] stringArray = new String[]{LDAP_OBJCLASS};
        LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(stringArray[0])) != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                if (!string2.equalsIgnoreCase((String)enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public void removeMultiValuedAttributeValues(String string, String string2, String[] stringArray, String string3, LdapClientContext ldapClientContext) throws SPIException {
        if (string2 == null || stringArray == null) {
            throw new IllegalArgumentException();
        }
        Change[] changeArray = new Change[]{new Change(string2, stringArray)};
        LDAPConnection lDAPConnection = ldapClientContext.getConnection();
        this.deleteAttributeValues(string, string3, changeArray, true, lDAPConnection);
    }

    public void fillAttributes(String string, String[] stringArray, String[] stringArray2, String string2, LdapClientContext ldapClientContext) throws SPIException {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        int n = stringArray.length;
        Change[] changeArray = new Change[n];
        for (int i = 0; i < n; ++i) {
            changeArray[i] = new Change(stringArray[i], stringArray2[i]);
        }
        LDAPConnection lDAPConnection = ldapClientContext.getConnection();
        this.writeAttributes(string, string2, changeArray, false, lDAPConnection);
    }

    public void addValuesToMultiValuedAttribute(String string, String string2, String[] stringArray, String string3, LdapClientContext ldapClientContext) throws SPIException {
        Object object;
        if (string2 == null || stringArray == null) {
            throw new IllegalArgumentException();
        }
        Vector vector = new Vector();
        LDAPConnection lDAPConnection = null;
        HashSet<String> hashSet = new HashSet<String>();
        LDAPEntry lDAPEntry = null;
        try {
            lDAPConnection = ldapClientContext.getConnection();
            lDAPEntry = lDAPConnection.read(string);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                try {
                    object = this.getDNExcludingServiceEntry(string);
                    this.ensureServiceEntryExistsForEntry((String)object, lDAPConnection);
                    lDAPEntry = lDAPConnection.read(string);
                }
                catch (LDAPException lDAPException2) {
                    throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException2);
                }
            }
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string2);
        if (lDAPAttribute != null) {
            object = lDAPAttribute.getStringValues();
            while (object.hasMoreElements()) {
                hashSet.add((String)object.nextElement());
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        Change[] changeArray = new Change[]{new Change()};
        changeArray[0].mName = string2;
        int n = hashSet.size();
        changeArray[0].mValues = new String[n];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            changeArray[0].mValues[n2++] = (String)iterator.next();
        }
        this.writeAttributes(string, string3, changeArray, true, lDAPConnection);
    }

    String buildComponent(Hashtable hashtable, String[] stringArray) {
        return (String)hashtable.get(stringArray[0]);
    }

    private static String buildComponentNameFilter(String[] stringArray, PolicyIdParser policyIdParser) {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (stringArray.length > 1) {
            stringBuffer.append("|");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("(").append(CONFIG_NAMING_ATTR);
                stringBuffer.append(policyIdParser.getStoredFormat(stringArray[i]));
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append(CONFIG_NAMING_ATTR);
            if (stringArray.length == 0) {
                stringBuffer.append(LDAP_WILDCARD);
            } else {
                stringBuffer.append(policyIdParser.getStoredFormat(stringArray[0]));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String getFirstValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    private static Vector getAllValues(LDAPEntry lDAPEntry, String string) {
        Vector<String> vector = new Vector<String>();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute == null) {
            return vector;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            vector.add((String)enumeration.nextElement());
        }
        return vector;
    }

    public static String getValueForKey(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        String string3 = null;
        if (string.startsWith(string2) && (n = string.indexOf("=")) > 0) {
            string3 = string.substring(++n);
        }
        return string3;
    }

    public static String[] getValuesForKey(Vector vector, String string) {
        int n;
        if (vector == null || vector.size() == 0) {
            return new String[0];
        }
        Vector<String> vector2 = new Vector<String>();
        String string2 = null;
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.get(n);
            if ((string2 = LdapDataStore.getValueForKey(string2, string)) == null) continue;
            vector2.add(string2);
        }
        n = vector2.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector2.get(i);
        }
        return stringArray;
    }

    private String getDNExcludingServiceEntry(String string) {
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        int n = stringArray.length;
        String[] stringArray2 = new String[n - 6];
        int n2 = 0;
        for (int i = 6; i < n; ++i) {
            stringArray2[n2++] = stringArray[i];
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(stringArray2[0]);
        for (int i = 1; i < stringArray2.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray2[i]);
        }
        return stringBuffer.toString();
    }

    public String ensureServiceEntryExistsForEntry(String string, LDAPConnection lDAPConnection) throws LDAPException {
        boolean bl;
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = new StringBuffer(200);
            bl = false;
            stringBuffer.append(this.mServiceEntryDNBuf);
            stringBuffer.append(",");
            stringBuffer.append(string);
            try {
                lDAPConnection.read(stringBuffer.toString());
                bl = true;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block6;
                throw lDAPException;
            }
        }
        if (bl) {
            return stringBuffer.toString();
        }
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(string);
        for (int i = 5; i >= 0; --i) {
            stringBuffer.insert(0, ",");
            stringBuffer.insert(0, LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].mEntryRDN);
            try {
                this.addEntry(stringBuffer.toString(), LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].mAttrSet, lDAPConnection);
                continue;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 68) continue;
                throw lDAPException;
            }
        }
        return stringBuffer.toString();
    }

    public Vector getListedRolesForEntity(LdapEntity ldapEntity, String string, LdapClientContext ldapClientContext) throws SPIException {
        Vector vector;
        block2: {
            vector = null;
            String[] stringArray = new String[]{string};
            try {
                vector = this.getAttributeValueList(ldapEntity.getLocation(), stringArray, ldapClientContext);
            }
            catch (LDAPException lDAPException) {
                int n = lDAPException.getLDAPResultCode();
                if (n == 94 || n == 16 || n == 32) break block2;
                throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
            }
        }
        return vector == null ? new Vector() : vector;
    }

    public Organization createRootOrganization(LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext, LdapClientContext ldapClientContext2) throws SPIException {
        if (this.mRootDN == null) {
            this.mRootDN = this.readEntryDN(this.getBaseDN(), ldapClientContext);
        }
        this.mRootOrganization = new LdapOrganization(this.mRootDN, -1, this, ldapEntityMapping, ldapClientContext2);
        return this.mRootOrganization;
    }

    public Organization getRootOrganization() {
        return this.mRootOrganization;
    }

    public Domain createRootDomain(LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext, LdapClientContext ldapClientContext2) throws SPIException {
        if (this.mRootDN == null) {
            this.mRootDN = this.readEntryDN(this.getBaseDN(), ldapClientContext);
        }
        this.mRootDomain = new LdapDomain("1__" + this.mRootDN, -1, this, ldapEntityMapping, ldapClientContext2);
        return this.mRootDomain;
    }

    public Domain getRootDomain() {
        return this.mRootDomain;
    }

    public static int getLdapErrorCode(SPIException sPIException) {
        int n = 0;
        Throwable throwable = sPIException.getCause();
        if (throwable != null && throwable instanceof LDAPException) {
            n = ((LDAPException)throwable).getLDAPResultCode();
        }
        return n;
    }

    public Profile createProfile(ProfileRepositoryImpl profileRepositoryImpl, String string, Applicability applicability, int n) throws SPIException {
        String string2 = null;
        try {
            LDAPConnection lDAPConnection = ((LdapEntity)profileRepositoryImpl.getEntity()).getContext().getConnection();
            string2 = this.createProfileEntry(profileRepositoryImpl, string, applicability, n, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
        }
        return new LdapProfile(string2, profileRepositoryImpl, string, applicability, n);
    }

    private String createProfileEntry(ProfileRepository profileRepository, String string, Applicability applicability, int n, LDAPConnection lDAPConnection) throws LDAPException {
        String string2 = null;
        String string3 = null;
        Random random = new Random();
        int n2 = 0;
        do {
            if ((n2 = random.nextInt()) < 0) {
                n2 = -n2;
            }
            string2 = String.valueOf(random.nextInt());
        } while (this.entryExists(string3 = CONFIG_NAMING_ATTR + string2 + "," + ((LdapProfileRepository)profileRepository).getLocation(), lDAPConnection));
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        String[] stringArray = new String[]{DISPLAY_NAME_KEY + string, APPLICABILITY_KEY + applicability.getStringValue()};
        try {
            lDAPAttributeSet.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.PROFILE_MAPPING.mObjectClass));
            lDAPAttributeSet.add(new LDAPAttribute(PRIORITY_ATTR, Integer.toString(n)));
            lDAPAttributeSet.add(new LDAPAttribute(KEYVALUE_ATTR, stringArray));
            lDAPAttributeSet.add(LdapDataStore.PROFILE_MAPPING.mServiceIdAttr);
            this.addEntry(string3, lDAPAttributeSet, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                try {
                    block10: {
                        LdapEntity ldapEntity = (LdapEntity)profileRepository.getEntity();
                        String string4 = this.ensureServiceEntryExistsForEntry(ldapEntity.getLocation(), lDAPConnection);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(CONFIG_NAMING_ATTR);
                        stringBuffer.append("_GlobalPolicyGroups_");
                        stringBuffer.append(",");
                        stringBuffer.append(string4);
                        String string5 = stringBuffer.toString();
                        try {
                            lDAPConnection.read(string5);
                        }
                        catch (LDAPException lDAPException2) {
                            if (lDAPException2.getLDAPResultCode() == 32) {
                                LDAPAttributeSet lDAPAttributeSet2 = new LDAPAttributeSet();
                                lDAPAttributeSet2.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.CONTAINER_MAPPING.mObjectClass));
                                lDAPAttributeSet2.add(LdapDataStore.CONTAINER_MAPPING.mServiceIdAttr);
                                this.addEntry(string5, lDAPAttributeSet2, lDAPConnection);
                                break block10;
                            }
                            throw lDAPException2;
                        }
                    }
                    this.addEntry(string3, lDAPAttributeSet, lDAPConnection);
                }
                catch (SPIException sPIException) {
                    throw lDAPException;
                }
            }
            throw lDAPException;
        }
        return string3;
    }

    public Profile findProfile(LdapProfileRepository ldapProfileRepository, String string) throws SPIException {
        Profile profile = null;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(&(");
        stringBuffer.append(KEYVALUE_ATTR);
        stringBuffer.append("=");
        stringBuffer.append(DISPLAY_NAME_KEY);
        stringBuffer.append(string);
        stringBuffer.append("))");
        Vector vector = null;
        try {
            vector = this.performSearch(ldapProfileRepository.getLocation(), true, stringBuffer.toString(), ALL_PROFILE_ATTRS, true, false, null, false, ((LdapEntity)ldapProfileRepository.getEntity()).getContext());
        }
        catch (SPIException sPIException) {
            int n = LdapDataStore.getLdapErrorCode(sPIException);
            if (n == 94 || n == 16 || n == 32) {
                vector = null;
            }
            throw sPIException;
        }
        if (vector == null || vector.isEmpty()) {
            Profile profile2;
            if (this.isVersion1 && (profile2 = ldapProfileRepository.getProfile(ldapProfileRepository.getLocalProfileId())) != null && profile2.getDisplayName().equals(string)) {
                profile = profile2;
            }
        } else {
            profile = this.getProfileObject(ldapProfileRepository, (Hashtable)vector.get(0));
        }
        return profile;
    }

    private Profile getProfileObject(ProfileRepository profileRepository, Hashtable hashtable) throws SPIException {
        Object object;
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object object3 = null;
        Applicability applicability = Applicability.UNKNOWN;
        int n = 0;
        Vector vector = (Vector)hashtable.get(DN_KEY);
        if (vector != null && !vector.isEmpty()) {
            string = (String)vector.get(0);
        }
        if ((vector = (Vector)hashtable.get(PRIORITY_ATTR)) != null && !vector.isEmpty()) {
            string3 = (String)vector.get(0);
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        vector = (Vector)hashtable.get(MODIFY_TIMESTAMP_ATTR);
        if (vector != null && !vector.isEmpty()) {
            string4 = (String)vector.get(0);
        }
        if ((vector = (Vector)hashtable.get(MODIFY_AUTHOR_ATTR)) != null && !vector.isEmpty()) {
            string5 = (String)vector.get(0);
        }
        if ((vector = (Vector)hashtable.get(KEYVALUE_ATTR)) != null && !vector.isEmpty()) {
            object2 = LdapDataStore.getValuesForKey(vector, DISPLAY_NAME_KEY);
            if (((String[])object2).length != 0) {
                string2 = object2[0];
            }
            if (((String[])(object2 = LdapDataStore.getValuesForKey(vector = (Vector)hashtable.get(KEYVALUE_ATTR), APPLICABILITY_KEY))).length != 0) {
                applicability = Applicability.getApplicability(object2[0]);
            }
            if (((Object)(object2 = LdapDataStore.getValuesForKey(vector, COMMENT_KEY))).length != 0) {
                object3 = object2[0];
            }
        }
        if (string == null || string2 == null || string4 == null || applicability.equals(Applicability.UNKNOWN)) {
            return null;
        }
        if (n <= 0) {
            if (this.isVersion1) {
                if (!LdapProfile.isLocalProfileDN(string)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        object2 = (ProfileRepositoryImpl)profileRepository;
        if (applicability.equals(Applicability.HOST)) {
            object = (ProfileRepositoryImpl)this.mRootDomain.getProfileRepository();
            if (((ProfileRepositoryImpl)object2).getId().equals(((ProfileRepositoryImpl)object).getId())) {
                object2 = object;
            }
        }
        object = new LdapProfile(string, (ProfileRepositoryImpl)object2, string2, applicability, n);
        ((LdapProfile)object).setLastModified(string4);
        Entity entity = null;
        if (this.mRootOrganization != null) {
            entity = this.mRootOrganization.getEntity(string5);
        }
        if (entity == null && this.mRootDomain != null) {
            entity = this.mRootDomain.getEntity(string5);
        }
        ((ProfileImpl)object).setAuthor(entity);
        ((ProfileImpl)object).setExistingComment((String)object3);
        return object;
    }

    private Policy getPolicyObject(String string, ProfileImpl profileImpl, Hashtable hashtable) throws SPIException {
        Object object;
        if (profileImpl == null || hashtable == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Vector vector = (Vector)hashtable.get(DN_KEY);
        if (vector != null && !vector.isEmpty()) {
            string2 = (String)vector.get(0);
        }
        if (string == null && (vector = (Vector)hashtable.get(ORG_UNIT_NAMING_ATTR)) != null && !vector.isEmpty()) {
            string = (String)vector.get(0);
            if (string == null) {
                return null;
            }
            string = this.mPolicyIdParser.getOutputFormat(string);
        }
        if ((vector = (Vector)hashtable.get(MODIFY_TIMESTAMP_ATTR)) != null && !vector.isEmpty()) {
            string4 = (String)vector.get(0);
        }
        if ((vector = (Vector)hashtable.get(KEYVALUE_ATTR)) != null && !vector.isEmpty() && ((String[])(object = LdapDataStore.getValuesForKey(vector, APOC_BLOB_KEY))).length != 0) {
            string3 = object[0];
        }
        if (string2 == null || string3 == null || string4 == null) {
            return null;
        }
        object = new LdapPolicy(string, string3, Timestamp.getMillis(string4), string2, profileImpl);
        return object;
    }

    private PolicyInfo getPolicyInfoObject(ProfileImpl profileImpl, Hashtable hashtable) throws SPIException {
        if (profileImpl == null || hashtable == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        Vector vector = (Vector)hashtable.get(ORG_UNIT_NAMING_ATTR);
        if (vector != null && !vector.isEmpty()) {
            string = (String)vector.get(0);
            if (string == null) {
                return null;
            }
            string = this.mPolicyIdParser.getOutputFormat(string);
        }
        if ((vector = (Vector)hashtable.get(MODIFY_TIMESTAMP_ATTR)) != null && !vector.isEmpty()) {
            string2 = (String)vector.get(0);
        }
        if (string2 == null) {
            return null;
        }
        PolicyInfo policyInfo = new PolicyInfo(string, profileImpl.getId(), Timestamp.getMillis(string2));
        return policyInfo;
    }

    public void checkForPriorityConflict(ProfileRepository profileRepository, Applicability applicability, int n) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        StringBuffer stringBuffer2 = new StringBuffer(200);
        stringBuffer2.append("(&");
        this.addApplicabilityFilter(stringBuffer2, applicability);
        stringBuffer2.append("(");
        stringBuffer2.append(PRIORITY_ATTR);
        stringBuffer2.append("=");
        stringBuffer2.append(n);
        stringBuffer2.append("))");
        String[] stringArray = new String[]{PRIORITY_ATTR};
        Vector vector = null;
        try {
            vector = this.performSearch(((LdapProfileRepository)profileRepository).getLocation(), true, stringBuffer2.toString(), stringArray, false, false, null, false, ((LdapEntity)profileRepository.getEntity()).getContext());
        }
        catch (SPIException sPIException) {
            int n2 = LdapDataStore.getLdapErrorCode(sPIException);
            if (n2 == 94 || n2 == 16 || n2 == 32) {
                return;
            }
            throw sPIException;
        }
        if (vector != null && !vector.isEmpty()) {
            throw new InvalidPriorityException("error.spi.profile.priority.used", n);
        }
    }

    public Iterator getProfilePriorities(ProfileRepositoryImpl profileRepositoryImpl, Applicability applicability) throws SPIException {
        Vector<Integer> vector = new Vector<Integer>();
        if (applicability.equals(Applicability.UNKNOWN)) {
            return vector.iterator();
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(&");
        this.addApplicabilityFilter(stringBuffer, applicability);
        stringBuffer.append("(");
        stringBuffer.append(PRIORITY_ATTR);
        stringBuffer.append("=*");
        stringBuffer.append(")");
        stringBuffer.append(")");
        String[] stringArray = new String[]{PRIORITY_ATTR};
        Vector vector2 = null;
        try {
            vector2 = this.performSearch(((LdapProfileRepository)profileRepositoryImpl).getLocation(), false, stringBuffer.toString(), stringArray, false, false, null, false, ((LdapEntity)profileRepositoryImpl.getEntity()).getContext());
        }
        catch (SPIException sPIException) {
            int n = LdapDataStore.getLdapErrorCode(sPIException);
            if (n == 94 || n == 16 || n == 32) {
                return vector.iterator();
            }
            throw sPIException;
        }
        if (vector2 == null || vector2.isEmpty()) {
            return vector.iterator();
        }
        String string = null;
        for (int i = 0; i < vector2.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector2.get(i);
            Vector vector3 = (Vector)hashtable.get(PRIORITY_ATTR);
            if (vector3 == null || vector3.isEmpty()) continue;
            string = (String)vector3.get(0);
            try {
                Integer n = new Integer(string);
                vector.add(n);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return vector.iterator();
    }

    public void destroyProfile(ProfileRepositoryImpl profileRepositoryImpl, ProfileImpl profileImpl) throws SPIException {
        LdapClientContext ldapClientContext = ((LdapEntity)profileRepositoryImpl.getEntity()).getContext();
        String string = ((LdapProfile)profileImpl).getLocation();
        try {
            this.deleteEntry(string, ldapClientContext);
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            if (n == 32) {
                throw new InvalidProfileException("error.spi.profile.invalid.noexist", profileImpl.getId(), (Throwable)lDAPException);
            }
            if (n == 66) {
                try {
                    LDAPSearchResults lDAPSearchResults = this.doSearch(string, false, "objectclass=sunservicecomponent", null, false, ldapClientContext);
                    while (lDAPSearchResults.hasMoreElements()) {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        this.deleteEntry(lDAPEntry.getDN(), ldapClientContext);
                    }
                    this.deleteEntry(string, ldapClientContext);
                }
                catch (LDAPException lDAPException2) {
                    throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException2);
                }
            }
            throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
        }
    }

    public boolean hasWriteAccess(ProfileRepositoryImpl profileRepositoryImpl, Entity entity) throws SPIException {
        LdapClientContext ldapClientContext = ((LdapEntity)entity).getContext();
        try {
            String string = this.createProfileEntry(profileRepositoryImpl, "__TestGroupDoNotUse__", Applicability.USER, 0, ldapClientContext.getConnection());
            ldapClientContext.getConnection().delete(string);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 50) {
                throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
            }
            return false;
        }
        return true;
    }

    public Profile getProfile(ProfileRepositoryImpl profileRepositoryImpl, String string) throws SPIException {
        if (string == null) {
            return null;
        }
        Hashtable hashtable = null;
        try {
            hashtable = this.getAttributeValueTable(string, true, ALL_PROFILE_ATTRS, ((LdapEntity)profileRepositoryImpl.getEntity()).getContext());
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                return null;
            }
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        return this.getProfileObject(profileRepositoryImpl, hashtable);
    }

    private String getEntityIdFromProfileId(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        if (stringArray == null || stringArray.length < 8) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 7;
        if (stringArray[n].equalsIgnoreCase("ou=services")) {
            ++n;
        }
        stringBuffer.append(stringArray[n]);
        for (int i = n + 1; i < stringArray.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public Profile getProfile(String string) throws SPIException {
        if (string == null) {
            return null;
        }
        String string2 = this.getEntityIdFromProfileId(string);
        Entity entity = null;
        if (this.mRootOrganization != null) {
            entity = this.mRootOrganization.getEntity(string2);
        }
        if (entity == null && this.mRootDomain != null) {
            entity = this.mRootDomain.getEntity(string2);
        }
        if (entity == null) {
            return null;
        }
        return this.getProfile((ProfileRepositoryImpl)entity.getProfileRepository(), string);
    }

    public TreeSet getProfiles(LdapProfileRepository ldapProfileRepository, Applicability applicability) throws SPIException {
        Profile profile;
        Vector vector;
        block8: {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("(&(");
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(LDAP_WILDCARD);
            stringBuffer.append(")");
            stringBuffer.append("(");
            stringBuffer.append(SUNSERVICEID_ATTR);
            stringBuffer.append("=");
            stringBuffer.append(SUNSERVICEID_PROFILE);
            stringBuffer.append("))");
            vector = null;
            try {
                vector = this.performSearch(ldapProfileRepository.getLocation(), true, stringBuffer.toString(), ALL_PROFILE_ATTRS, true, false, null, false, ((LdapEntity)ldapProfileRepository.getEntity()).getContext());
            }
            catch (SPIException sPIException) {
                if (LdapDataStore.getLdapErrorCode(sPIException) == 32) break block8;
                throw sPIException;
            }
        }
        TreeSet<Profile> treeSet = new TreeSet<Profile>(new LdapProfileComparator());
        if (vector != null) {
            profile = null;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                profile = (ProfileImpl)this.getProfileObject(ldapProfileRepository, (Hashtable)vector.get(i));
                if (profile == null) continue;
                boolean bl = false;
                Applicability applicability2 = ((ProfileImpl)profile).getApplicability();
                if (applicability2.equals(Applicability.ALL)) {
                    bl = true;
                } else if ((applicability2.equals(Applicability.HOST) || applicability2.equals(Applicability.USER)) && (applicability.equals(Applicability.ALL) || applicability.equals(applicability2))) {
                    bl = true;
                }
                if (!bl) continue;
                treeSet.add(profile);
            }
        }
        if (this.isVersion1 && (profile = ldapProfileRepository.getProfile(ldapProfileRepository.getLocalProfileId())) != null) {
            treeSet.add(profile);
        }
        return treeSet;
    }

    public Iterator getAllProfiles(PolicySource policySource, LdapEntity ldapEntity, Applicability applicability) throws SPIException {
        Vector vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(&(");
        stringBuffer.append(LDAP_OBJCLASS);
        stringBuffer.append("=");
        stringBuffer.append(SUNSERVICE_COMPONENT_OBJCLASS);
        stringBuffer.append(")");
        stringBuffer.append("(");
        stringBuffer.append(CONFIG_NAMING_ATTR);
        stringBuffer.append(LDAP_WILDCARD);
        stringBuffer.append(")");
        stringBuffer.append("(");
        stringBuffer.append(SUNSERVICEID_ATTR);
        stringBuffer.append("=");
        stringBuffer.append(SUNSERVICEID_PROFILE);
        stringBuffer.append("))");
        Vector vector2 = null;
        try {
            vector2 = this.performSearch(ldapEntity.getLocation(), true, stringBuffer.toString(), ALL_PROFILE_ATTRS, true, false, null, false, ldapEntity.getContext());
        }
        catch (SPIException sPIException) {
            if (LdapDataStore.getLdapErrorCode(sPIException) == 32) {
                return vector.iterator();
            }
            throw sPIException;
        }
        if (vector2 == null || vector2.isEmpty()) {
            return vector.iterator();
        }
        Hashtable<String, LdapProfileRepository> hashtable = new Hashtable<String, LdapProfileRepository>();
        TreeSet<ProfileImpl> treeSet = new TreeSet<ProfileImpl>(new LdapProfileComparator());
        ProfileImpl profileImpl = null;
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Hashtable hashtable2 = (Hashtable)vector2.get(i);
            String string2 = null;
            Vector vector3 = (Vector)hashtable2.get(DN_KEY);
            if (vector3 != null && !vector3.isEmpty()) {
                string2 = (String)vector3.get(0);
            }
            if (string2 == null || policySource.getEntity(string = this.getEntityIdFromProfileId(string2)) == null) continue;
            LdapProfileRepository ldapProfileRepository = (LdapProfileRepository)hashtable.get(string);
            if (ldapProfileRepository == null) {
                ldapProfileRepository = new LdapProfileRepository(string, policySource);
                hashtable.put(string, ldapProfileRepository);
            }
            if ((profileImpl = (ProfileImpl)this.getProfileObject(ldapProfileRepository, hashtable2)) == null || !applicability.equals(Applicability.ALL) && !applicability.equals(profileImpl.getApplicability())) continue;
            treeSet.add(profileImpl);
        }
        return treeSet.iterator();
    }

    public Iterator getAssignedProfiles(Entity entity) throws SPIException {
        LdapProfileRepository ldapProfileRepository;
        Profile profile;
        String string;
        int n;
        Vector<Profile> vector;
        Vector vector2;
        LdapEntity ldapEntity;
        block9: {
            ldapEntity = (LdapEntity)entity;
            vector2 = new Vector();
            vector = new Vector<Profile>();
            String[] stringArray = new String[]{KEYVALUE_ATTR};
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(this.getServiceEntryDN()).append(",").append(ldapEntity.getLocation());
            try {
                vector2 = this.getAttributeValueList(stringBuffer.toString(), stringArray, ldapEntity.getContext());
            }
            catch (LDAPException lDAPException) {
                n = lDAPException.getLDAPResultCode();
                if (n == 94 || n == 16 || n == 32) break block9;
                throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
            }
        }
        if (vector2 == null || vector2.isEmpty()) {
            return vector.iterator();
        }
        String[] stringArray = LdapDataStore.getValuesForKey(vector2, ASSIGNED_KEY);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string == null) continue;
            profile = null;
            try {
                profile = this.getProfile(string);
                if (profile == null) continue;
                vector.add(profile);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isVersion1 && (profile = (ldapProfileRepository = (LdapProfileRepository)ldapEntity.getProfileRepository()).getProfile(string = ldapProfileRepository.getLocalProfileId())) != null) {
            boolean bl = false;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Profile profile2 = (Profile)iterator.next();
                if (!profile2.equals(profile)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                vector.add(profile);
            }
        }
        return vector.iterator();
    }

    public void assignProfile(Profile profile, Entity entity) throws SPIException {
        if (profile == null) {
            return;
        }
        String string = KEYVALUE_ATTR;
        try {
            boolean bl = this.entryExists(((LdapProfile)profile).getLocation(), ((LdapEntity)entity).getContext());
            if (!bl) {
                throw new InvalidProfileException("error.spi.profile.invalid.noexist", profile.getId());
            }
        }
        catch (LDAPException lDAPException) {
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        String[] stringArray = new String[]{ASSIGNED_KEY + ((LdapProfile)profile).getLocation().toLowerCase()};
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getServiceEntryDN());
        stringBuffer.append(",");
        stringBuffer.append(((LdapEntity)entity).getLocation());
        this.addValuesToMultiValuedAttribute(stringBuffer.toString(), string, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)entity).getContext());
    }

    public void unassignProfile(Profile profile, Entity entity) throws SPIException {
        if (profile == null) {
            return;
        }
        String[] stringArray = new String[]{ASSIGNED_KEY + ((LdapProfile)profile).getLocation()};
        stringArray[0] = stringArray[0].toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getServiceEntryDN()).append(",").append(((LdapEntity)entity).getLocation());
        this.removeMultiValuedAttributeValues(stringBuffer.toString(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)entity).getContext());
    }

    public void setProfilePriority(ProfileImpl profileImpl, int n) throws SPIException {
        if (n <= 0) {
            throw new InvalidPriorityException("error.spi.profile.priority.invalid", n);
        }
        this.checkForPriorityConflict(profileImpl.getProfileRepository(), profileImpl.getApplicability(), n);
        String[] stringArray = new String[]{PRIORITY_ATTR};
        String[] stringArray2 = new String[]{Integer.toString(n)};
        this.fillAttributes(((LdapProfile)profileImpl).getLocation(), stringArray, stringArray2, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
    }

    public void setProfileDisplayName(ProfileImpl profileImpl, String string) throws SPIException {
        String[] stringArray = new String[]{DISPLAY_NAME_KEY + profileImpl.getDisplayName()};
        this.removeMultiValuedAttributeValues(((LdapProfile)profileImpl).getLocation(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
        stringArray[0] = DISPLAY_NAME_KEY + string;
        this.addValuesToMultiValuedAttribute(((LdapProfile)profileImpl).getLocation(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
    }

    public void setProfileComment(ProfileImpl profileImpl, String string) throws SPIException {
        String[] stringArray = new String[1];
        if (profileImpl.getComment() != null) {
            stringArray[0] = COMMENT_KEY + profileImpl.getComment();
            this.removeMultiValuedAttributeValues(((LdapProfile)profileImpl).getLocation(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
        }
        if (string != null) {
            stringArray[0] = COMMENT_KEY + string;
            this.addValuesToMultiValuedAttribute(((LdapProfile)profileImpl).getLocation(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
        }
    }

    public void setProfileApplicability(ProfileImpl profileImpl, Applicability applicability) throws SPIException {
        String[] stringArray = new String[]{APPLICABILITY_KEY + profileImpl.getApplicability()};
        this.removeMultiValuedAttributeValues(((LdapProfile)profileImpl).getLocation(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
        stringArray[0] = APPLICABILITY_KEY + applicability;
        this.addValuesToMultiValuedAttribute(((LdapProfile)profileImpl).getLocation(), KEYVALUE_ATTR, stringArray, SUNSERVICE_COMPONENT_OBJCLASS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
    }

    public Iterator getAssignedEntities(Profile profile) throws SPIException {
        Object object;
        Object object2;
        int n;
        Vector vector = this.getListOfEntitiesForProfile(profile);
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                try {
                    object2 = (Hashtable)vector.get(n);
                    object = (Vector)((Hashtable)object2).get(DN_KEY);
                    if (object == null || ((Vector)object).isEmpty()) continue;
                    String string = (String)((Vector)object).get(0);
                    Entity entity = null;
                    LdapNode ldapNode = null;
                    ldapNode = profile.getApplicability().equals(Applicability.HOST) ? this.mRootDomain : this.mRootOrganization;
                    if (ldapNode == null || (entity = ldapNode.getEntityFromDN(string, LdapEntityType.UNKNOWN, true, null)) == null) continue;
                    vector2.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.isVersion1 && ((LdapProfile)profile).isLocal()) {
            Entity entity = profile.getProfileRepository().getEntity();
            n = 0;
            object2 = vector2.iterator();
            while (object2.hasNext()) {
                object = (Entity)object2.next();
                if (!object.equals(entity)) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                vector2.add(entity);
            }
        }
        return vector2.iterator();
    }

    public Vector getListOfEntitiesForProfile(Profile profile) throws SPIException {
        Vector vector;
        block2: {
            vector = null;
            StringBuffer stringBuffer = new StringBuffer(200);
            try {
                stringBuffer.append("(&(");
                stringBuffer.append(LDAP_OBJCLASS);
                stringBuffer.append("=");
                stringBuffer.append(SUNSERVICE_COMPONENT_OBJCLASS);
                stringBuffer.append(")(");
                stringBuffer.append(KEYVALUE_ATTR);
                stringBuffer.append("=");
                stringBuffer.append(ASSIGNED_KEY);
                stringBuffer.append(((LdapProfile)profile).getLocation());
                stringBuffer.append("))");
                vector = this.performSearch(this.getBaseDN(), true, stringBuffer.toString().toLowerCase(), null, true, false, null, false, ((LdapEntity)profile.getProfileRepository().getEntity()).getContext());
            }
            catch (SPIException sPIException) {
                int n = LdapDataStore.getLdapErrorCode(sPIException);
                if (n == 94 || n == 16 || n == 32) break block2;
                throw sPIException;
            }
        }
        return vector == null ? new Vector() : vector;
    }

    public Policy getPolicy(ProfileImpl profileImpl, String string) throws SPIException {
        Hashtable hashtable;
        block3: {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(this.mPolicyIdParser.getStoredFormat(string));
            stringBuffer.append(",");
            stringBuffer.append(((LdapProfile)profileImpl).getLocation());
            hashtable = null;
            try {
                hashtable = this.getAttributeValueTable(stringBuffer.toString(), true, ALL_POLICY_ATTRS, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block3;
                throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
            }
        }
        Policy policy = null;
        if (hashtable != null && !hashtable.isEmpty()) {
            policy = this.getPolicyObject(string, profileImpl, hashtable);
        }
        return policy;
    }

    private static String buildPolicyIdFilter(Iterator iterator, PolicyIdParser policyIdParser) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (iterator.hasNext()) {
                stringBuffer.append("|");
                stringBuffer.append("(").append(CONFIG_NAMING_ATTR);
                stringBuffer.append(policyIdParser.getStoredFormat(string));
                stringBuffer.append(")");
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    stringBuffer.append("(").append(CONFIG_NAMING_ATTR);
                    stringBuffer.append(policyIdParser.getStoredFormat(string));
                    stringBuffer.append(")");
                }
            } else {
                stringBuffer.append(CONFIG_NAMING_ATTR);
                stringBuffer.append(policyIdParser.getStoredFormat(string));
            }
        } else {
            stringBuffer.append(CONFIG_NAMING_ATTR);
            stringBuffer.append(LDAP_WILDCARD);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void destroyPolicy(Policy policy) throws SPIException {
        try {
            LdapPolicy ldapPolicy = (LdapPolicy)policy;
            LdapClientContext ldapClientContext = ((LdapEntity)ldapPolicy.getProfile().getProfileRepository().getEntity()).getContext();
            this.deleteEntry(ldapPolicy.getLocation(), ldapClientContext);
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            if (n == 32) {
                throw new NoSuchPolicyException(policy.getId());
            }
            throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
        }
    }

    private String createPolicyEntry(ProfileImpl profileImpl, String string, LDAPConnection lDAPConnection) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        try {
            stringBuffer.append(CONFIG_NAMING_ATTR).append(string).append(",").append(((LdapProfile)profileImpl).getLocation());
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.POLICY_MAPPING.mObjectClass));
            lDAPAttributeSet.add(LdapDataStore.POLICY_MAPPING.mServiceIdAttr);
            this.addEntry(stringBuffer.toString(), lDAPAttributeSet, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
        }
        return stringBuffer.toString();
    }

    public boolean hasPolicies(ProfileImpl profileImpl) throws SPIException {
        String string = LdapDataStore.buildPolicyIdFilter(new Vector().iterator(), this.mPolicyIdParser);
        Vector vector = this.getListOfPoliciesForProfile(profileImpl, string, true);
        return vector != null && !vector.isEmpty();
    }

    public Vector getPolicies(ProfileImpl profileImpl) throws SPIException {
        String string = LdapDataStore.buildPolicyIdFilter(new Vector().iterator(), this.mPolicyIdParser);
        return this.getPolicies(profileImpl, string);
    }

    public Vector getPolicies(ProfileImpl profileImpl, Iterator iterator) throws SPIException {
        String string = LdapDataStore.buildPolicyIdFilter(iterator, this.mPolicyIdParser);
        return this.getPolicies(profileImpl, string);
    }

    public Vector getPolicyInfos(ProfileImpl profileImpl, Iterator iterator) throws SPIException {
        String string = LdapDataStore.buildPolicyIdFilter(iterator, this.mPolicyIdParser);
        return this.getPolicyInfos(profileImpl, string);
    }

    private Vector getPolicies(ProfileImpl profileImpl, String string) throws SPIException {
        Vector vector = this.getListOfPoliciesForProfile(profileImpl, string, false);
        if (vector == null || vector.isEmpty()) {
            return new Vector();
        }
        Vector<Policy> vector2 = new Vector<Policy>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Policy policy = this.getPolicyObject(null, profileImpl, (Hashtable)vector.get(i));
            if (policy == null) continue;
            vector2.add(policy);
        }
        return vector2;
    }

    private Vector getPolicyInfos(ProfileImpl profileImpl, String string) throws SPIException {
        Vector vector = this.getListOfPoliciesForProfile(profileImpl, string, true);
        if (vector == null || vector.isEmpty()) {
            return new Vector();
        }
        Vector<PolicyInfo> vector2 = new Vector<PolicyInfo>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PolicyInfo policyInfo = this.getPolicyInfoObject(profileImpl, (Hashtable)vector.get(i));
            if (policyInfo == null) continue;
            vector2.add(policyInfo);
        }
        return vector2;
    }

    public Vector getListOfPoliciesForProfile(ProfileImpl profileImpl, String string, boolean bl) throws SPIException {
        if (profileImpl == null) {
            throw new IllegalArgumentException();
        }
        Vector vector = null;
        String[] stringArray = bl ? TIMEONLY_POLICY_ATTRS : ALL_POLICY_ATTRS;
        try {
            vector = this.performSearch(((LdapProfile)profileImpl).getLocation(), false, string, stringArray, true, false, new BooleanReturnValue(false), false, ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext());
        }
        catch (SPIException sPIException) {
            if (LdapDataStore.getLdapErrorCode(sPIException) == 32) {
                return new Vector();
            }
            throw sPIException;
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storePolicy(ProfileImpl profileImpl, Policy policy) throws SPIException {
        LDAPConnection lDAPConnection = ((LdapEntity)profileImpl.getProfileRepository().getEntity()).getContext().getConnection();
        String string = policy.getId();
        String string2 = this.mPolicyIdParser.getStoredFormat(string);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(CONFIG_NAMING_ATTR).append(string2).append(",").append(((LdapProfile)profileImpl).getLocation());
        String string3 = stringBuffer.toString();
        if (policy.getData() == null || policy.getData().length() == 0) {
            try {
                lDAPConnection.delete(string3);
                return;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) return;
                throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
            }
        }
        Change[] changeArray = new Change[]{new Change(KEYVALUE_ATTR, APOC_BLOB_KEY + policy.getData())};
        try {
            this.writeAttributes(string3, SUNSERVICE_COMPONENT_OBJCLASS, changeArray, false, lDAPConnection);
            return;
        }
        catch (SPIException sPIException) {
            if (LdapDataStore.getLdapErrorCode(sPIException) != 32) throw sPIException;
            this.createPolicyEntry(profileImpl, string2, lDAPConnection);
            this.writeAttributes(string3, SUNSERVICE_COMPONENT_OBJCLASS, changeArray, false, lDAPConnection);
            return;
        }
    }

    private void createPolicyEntry(LdapPolicy ldapPolicy, LDAPConnection lDAPConnection) throws SPIException {
        Profile profile = this.findProfile((LdapProfileRepository)ldapPolicy.getProfile().getProfileRepository(), ldapPolicy.getProfile().getDisplayName());
        if (profile == null) {
            try {
                this.createProfileEntry(ldapPolicy.getProfile().getProfileRepository(), ldapPolicy.getProfile().getDisplayName(), ldapPolicy.getProfile().getApplicability(), ldapPolicy.getProfile().getPriority(), lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
            }
        }
        try {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute(LDAP_OBJCLASS, LdapDataStore.POLICY_MAPPING.mObjectClass));
            lDAPAttributeSet.add(LdapDataStore.POLICY_MAPPING.mServiceIdAttr);
            this.addEntry(ldapPolicy.getLocation(), lDAPAttributeSet, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.ldap", lDAPException);
        }
    }

    private void addApplicabilityFilter(StringBuffer stringBuffer, Applicability applicability) {
        stringBuffer.append("(|(");
        stringBuffer.append(KEYVALUE_ATTR);
        stringBuffer.append("=");
        stringBuffer.append(APPLICABILITY_KEY);
        stringBuffer.append("ALL");
        stringBuffer.append(")");
        if (applicability.equals(Applicability.ALL)) {
            stringBuffer.append("(");
            stringBuffer.append(KEYVALUE_ATTR);
            stringBuffer.append("=");
            stringBuffer.append(APPLICABILITY_KEY);
            stringBuffer.append("USER");
            stringBuffer.append(")(");
            stringBuffer.append(KEYVALUE_ATTR);
            stringBuffer.append("=");
            stringBuffer.append(APPLICABILITY_KEY);
            stringBuffer.append("HOST");
            stringBuffer.append(")");
        } else {
            stringBuffer.append("(");
            stringBuffer.append(KEYVALUE_ATTR);
            stringBuffer.append("=");
            stringBuffer.append(APPLICABILITY_KEY);
            stringBuffer.append(applicability.getStringValue());
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
    }

    public ArrayList getModificationDetails(LdapProfile ldapProfile) throws SPIException {
        return this.getModificationDetails(ldapProfile.getLocation(), ((LdapEntity)ldapProfile.getProfileRepository().getEntity()).getContext());
    }

    public ArrayList getModificationDetails(LdapPolicy ldapPolicy) throws SPIException {
        return this.getModificationDetails(ldapPolicy.getLocation(), ((LdapEntity)ldapPolicy.getProfile().getProfileRepository().getEntity()).getContext());
    }

    public ArrayList getModificationDetails(String string, LdapClientContext ldapClientContext) throws SPIException {
        Entity entity;
        String string2;
        Vector vector = null;
        String[] stringArray = new String[]{MODIFY_TIMESTAMP_ATTR, MODIFY_AUTHOR_ATTR};
        try {
            vector = this.getAttributeValueList(string, stringArray, ldapClientContext);
        }
        catch (LDAPException lDAPException) {
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        if (vector == null || vector.size() == 0) {
            throw new IllegalReadException("error.spi.access.illegal.read.ldap");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(vector.get(0));
        if (vector.size() > 1 && (string2 = (String)vector.get(1)) != null && this.mRootOrganization != null && (entity = this.mRootOrganization.getEntity(string2)) != null) {
            arrayList.add(entity);
        }
        return arrayList;
    }

    public String getProfileComment(Profile profile) throws SPIException {
        String[] stringArray;
        Vector vector = null;
        String[] stringArray2 = new String[]{KEYVALUE_ATTR};
        try {
            vector = this.getAttributeValueList(((LdapProfile)profile).getLocation(), stringArray2, ((LdapEntity)profile.getProfileRepository().getEntity()).getContext());
        }
        catch (LDAPException lDAPException) {
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        String string = null;
        if (!(vector == null && vector.isEmpty() || (stringArray = LdapDataStore.getValuesForKey(vector, COMMENT_KEY)).length == 0)) {
            string = stringArray[0];
        }
        return string;
    }

    static {
        USER_PROFILE_USE_VALUE = APPLICABILITY_KEY + Applicability.USER;
        HOST_PROFILE_USE_VALUE = APPLICABILITY_KEY + Applicability.HOST;
        int n = 0;
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[n++] = new ServiceMapping(SUNSERVICE_COMPONENT_OBJCLASS, SERVICE_REGISTRY, "ou=ApocRegistry");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[n++] = new ServiceMapping(SUNSERVICE_COMPONENT_OBJCLASS, "ou=default");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[n++] = new ServiceMapping(ORG_UNIT_OBJCLASS, "ou=OrganizationConfig");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[n++] = new ServiceMapping(SUNSERVICE_OBJCLASS, "ou=1.0");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[n++] = new ServiceMapping(SUNSERVICE_OBJCLASS, "ou=ApocService");
        LdapDataStore.SERVICE_MAPPING_ELEMENTS[n++] = new ServiceMapping(ORG_UNIT_OBJCLASS, "ou=services");
        CONTAINER_MAPPING = new EntryMapping(SUNSERVICE_COMPONENT_OBJCLASS, "ApocPolicyGroupContainer");
        PROFILE_MAPPING = new EntryMapping(SUNSERVICE_COMPONENT_OBJCLASS, SUNSERVICEID_PROFILE);
        POLICY_MAPPING = new EntryMapping(SUNSERVICE_COMPONENT_OBJCLASS, SUNSERVICEID_POLICY);
        TIMEONLY_POLICY_ATTRS = new String[]{ORG_UNIT_NAMING_ATTR, MODIFY_TIMESTAMP_ATTR};
        ALL_POLICY_ATTRS = new String[]{ORG_UNIT_NAMING_ATTR, MODIFY_TIMESTAMP_ATTR, KEYVALUE_ATTR};
        ALL_PROFILE_ATTRS = new String[]{ORG_UNIT_NAMING_ATTR, PRIORITY_ATTR, MODIFY_TIMESTAMP_ATTR, MODIFY_AUTHOR_ATTR, KEYVALUE_ATTR};
    }

    public class PolicyIdParser {
        Hashtable policyIds = new Hashtable();
        StringBuffer compBuf = new StringBuffer(200);
        char ESCAPE_CHAR = (char)47;

        public String getStoredFormat(String string) {
            if (string == null) {
                return null;
            }
            String string2 = (String)this.policyIds.get(string);
            if (string2 != null) {
                return string2;
            }
            this.compBuf.delete(0, this.compBuf.length());
            String string3 = string.toLowerCase();
            char[] cArray = string.toCharArray();
            char[] cArray2 = string3.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == this.ESCAPE_CHAR || cArray[i] != cArray2[i]) {
                    this.compBuf.append(this.ESCAPE_CHAR);
                }
                this.compBuf.append(cArray[i]);
            }
            string2 = this.compBuf.toString();
            this.policyIds.put(string, string2);
            return string2;
        }

        public String getOutputFormat(String string) {
            if (string == null) {
                return null;
            }
            this.compBuf.delete(0, this.compBuf.length());
            char[] cArray = string.toCharArray();
            String string2 = string.toUpperCase();
            char[] cArray2 = string2.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == this.ESCAPE_CHAR) {
                    this.compBuf.append(cArray2[++i]);
                    continue;
                }
                this.compBuf.append(cArray[i]);
            }
            String string3 = this.compBuf.toString();
            this.policyIds.put(string3, string);
            return string3;
        }
    }

    public static class Change {
        String mName;
        String[] mValues;

        public Change() {
        }

        public Change(String string, String[] stringArray) {
            this.mName = string;
            this.mValues = stringArray;
        }

        public Change(String string, String string2) {
            this.mName = string;
            this.mValues = new String[1];
            this.mValues[0] = string2;
        }
    }

    public static class ServiceMapping {
        String mEntryRDN = null;
        LDAPAttributeSet mAttrSet = new LDAPAttributeSet();

        ServiceMapping(String string, String string2) {
            this.mAttrSet.add(new LDAPAttribute(LdapDataStore.LDAP_OBJCLASS, string));
            this.mEntryRDN = string2;
        }

        ServiceMapping(String string, String string2, String string3) {
            this.mAttrSet.add(new LDAPAttribute(LdapDataStore.LDAP_OBJCLASS, string));
            this.mAttrSet.add(new LDAPAttribute(LdapDataStore.SUNSERVICEID_ATTR, string2));
            this.mEntryRDN = string3;
        }

        public String getRDN() {
            return this.mEntryRDN;
        }
    }

    static class EntryMapping {
        String mObjectClass = null;
        LDAPAttribute mServiceIdAttr = null;

        EntryMapping(String string) {
            this.mObjectClass = string;
        }

        EntryMapping(String string, String string2) {
            this.mObjectClass = string;
            this.mServiceIdAttr = new LDAPAttribute(LdapDataStore.SUNSERVICEID_ATTR, string2);
        }
    }
}

