/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.AbstractEntity;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapDomain;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapHost;
import com.sun.apoc.spi.ldap.entities.LdapOrganization;
import com.sun.apoc.spi.ldap.entities.LdapRole;
import com.sun.apoc.spi.ldap.entities.LdapUser;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;

public abstract class LdapEntity
extends AbstractEntity {
    public static final String DOMAIN_TREE_INDICATOR = "1__";
    public static final boolean CHECK_ONLY = true;
    public static final boolean NOT_CHECK_ONLY = false;
    public static final boolean DN_REQUIRED = true;
    public static final boolean DN_NOT_REQUIRED = false;
    public static final String LDAP_SEPARATOR = ",";
    public static final char DN_SEPARATOR = '=';
    LdapDataStore mDataStore;
    LdapClientContext mContext;
    LdapEntityMapping mEntityMapping;
    String mLocation;
    int mParentIndex;
    boolean mIsDomainTree;
    protected String mDisplayName;

    protected LdapEntity(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        this.mId = string;
        this.mDataStore = ldapDataStore;
        this.mContext = ldapClientContext;
        this.mEntityMapping = ldapEntityMapping;
        this.mParentIndex = n;
        this.mLocation = string;
    }

    public LdapDataStore getDataStore() {
        return this.mDataStore;
    }

    public LdapClientContext getContext() {
        return this.mContext;
    }

    public void setContext(LdapClientContext ldapClientContext) {
        this.mContext = ldapClientContext;
    }

    public abstract boolean equals(Object var1);

    public String getLocation() {
        return this.mLocation;
    }

    public String getDisplayName(Locale locale) {
        if (this.mDisplayName == null) {
            try {
                if (this.equals(this.mPolicySource.getRoot())) {
                    this.mDisplayName = this.mLocation;
                }
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
            if (this.mDisplayName == null) {
                this.mDisplayName = this.getDisplayNameFromLocation();
            }
        }
        return this.mDisplayName;
    }

    public Iterator getAncestorNames(Locale locale) {
        String string = this.mEntityMapping.mUserMapping.getContainerEntry();
        String string2 = this.mEntityMapping.mHostMapping.getContainerEntry();
        String[] stringArray = null;
        String string3 = null;
        try {
            string3 = this.mPolicySource.getRoot().getId();
            stringArray = LDAPDN.explodeDN((String)string3, (boolean)false);
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        String[] stringArray2 = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (stringArray2 != null) {
            int n = stringArray2.length - 1;
            if (stringArray != null) {
                n = stringArray2.length - stringArray.length - 1;
                if (stringArray2.length > stringArray.length) {
                    linkedList.add(LDAPDN.unEscapeRDN((String)string3));
                }
            }
            for (int i = n; i > 0; --i) {
                int n2;
                String string4 = stringArray2[i];
                if (string4.equals(string) || string4.equals(string2) || (n2 = string4.indexOf(61)) < 0) continue;
                linkedList.add(LDAPDN.unEscapeRDN((String)string4.substring(n2 + 1)));
            }
        }
        return linkedList.iterator();
    }

    public abstract Entity getParent();

    private String getDisplayNameFromLocation() {
        String string = null;
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)true);
        if (stringArray != null && stringArray.length > 0) {
            string = LDAPDN.unEscapeRDN((String)stringArray[0]);
        }
        return string;
    }

    public boolean isDomainTree() {
        return this.mIsDomainTree;
    }

    protected void setIsDomainTree() {
        this.mIsDomainTree = true;
    }

    private Hashtable fillAttributeValues(String string) {
        String[] stringArray = new String[2 + this.mEntityMapping.mUserMapping.getDisplayAttributes().length];
        stringArray[0] = "objectclass";
        stringArray[1] = this.mEntityMapping.mUserMapping.getUniqueAttribute();
        int n = 2;
        for (int i = 0; i < this.mEntityMapping.mUserMapping.getDisplayAttributes().length; ++i) {
            stringArray[n++] = this.mEntityMapping.mUserMapping.getDisplayAttributes()[i];
        }
        try {
            return this.getDataStore().getAttributeValueTable(string, true, stringArray, this.getContext());
        }
        catch (LDAPException lDAPException) {
            return null;
        }
    }

    public Entity getEntityFromDN(String string, LdapEntityType ldapEntityType, boolean bl, Hashtable hashtable) {
        int n;
        CharSequence charSequence;
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        int n2 = 0;
        String string2 = string;
        if (bl) {
            stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
            if (stringArray == null) {
                return null;
            }
            n2 = 6;
            if (n2 >= stringArray.length) {
                return null;
            }
            charSequence = new StringBuffer(stringArray[n2]);
            for (n = n2 + 1; n < stringArray.length; ++n) {
                ((StringBuffer)charSequence).append(LDAP_SEPARATOR).append(stringArray[n]);
            }
            string2 = ((StringBuffer)charSequence).toString();
        }
        if (this.isDomainTree()) {
            if (((LdapEntity)((Object)this.getDataStore().getRootDomain())).getLocation().equalsIgnoreCase(string2)) {
                return this.getDataStore().getRootDomain();
            }
        } else if (((LdapEntity)((Object)this.getDataStore().getRootOrganization())).getLocation().equalsIgnoreCase(string2)) {
            return this.getDataStore().getRootOrganization();
        }
        if (ldapEntityType == LdapEntityType.UNKNOWN) {
            if (stringArray == null) {
                stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
            }
            if (hashtable == null && (hashtable = this.fillAttributeValues(string2)) == null) {
                return null;
            }
            ldapEntityType = this.detectEntityType(stringArray[n2], hashtable);
            if (ldapEntityType == LdapEntityType.UNKNOWN) {
                return null;
            }
            if (!this.isCompatible(ldapEntityType)) {
                return null;
            }
        }
        charSequence = null;
        n = 1;
        int n3 = ldapEntityType.getIntValue();
        switch (n3) {
            case 6: {
                charSequence = this.mEntityMapping.mUserMapping.getContainerEntry();
                break;
            }
            case 7: {
                charSequence = this.mEntityMapping.mHostMapping.getContainerEntry();
                break;
            }
            case 5: {
                charSequence = this.mEntityMapping.mRoleMapping.getContainerEntry();
                n = -1;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (charSequence != null && ((String)charSequence).length() == 0) {
            charSequence = null;
        }
        if (n == -1) {
            if (stringArray == null) {
                stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
            }
            if ((n = LdapEntity.findContainer(stringArray, n2, (String)charSequence)) == -1) {
                return null;
            }
            n -= n2;
        }
        LdapEntity ldapEntity = null;
        Object var12_12 = null;
        switch (n3) {
            case 3: {
                ldapEntity = new LdapOrganization(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                break;
            }
            case 4: {
                ldapEntity = new LdapDomain(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                break;
            }
            case 5: {
                ldapEntity = new LdapRole(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                if (!this.isDomainTree()) break;
                ((LdapRole)ldapEntity).setIsDomainTree();
                break;
            }
            case 6: {
                ldapEntity = new LdapUser(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                if (hashtable == null && (hashtable = this.fillAttributeValues(string2)) == null) {
                    return null;
                }
                ((LdapUser)ldapEntity).setDisplayName(hashtable, this.mEntityMapping.mUserMapping.getDisplayAttributes(), this.mEntityMapping.mUserMapping.getDisplayFormat());
                break;
            }
            case 7: {
                ldapEntity = new LdapHost(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
            }
        }
        if (ldapEntity != null) {
            ((AbstractEntity)ldapEntity).setPolicySource(this.mPolicySource);
        }
        return ldapEntity;
    }

    private boolean isCompatible(LdapEntityType ldapEntityType) {
        if (this.mPolicySource.getName().equals("USER")) {
            return !ldapEntityType.equals(LdapEntityType.DOMAIN) && !ldapEntityType.equals(LdapEntityType.HOST);
        }
        if (this.mPolicySource.getName().equals("HOST")) {
            return ldapEntityType.equals(LdapEntityType.DOMAIN) || ldapEntityType.equals(LdapEntityType.HOST);
        }
        return true;
    }

    public LdapEntityType detectEntityType(String string, Hashtable hashtable) {
        String[] stringArray;
        LdapEntityType ldapEntityType = LdapEntityType.UNKNOWN;
        Vector vector = (Vector)hashtable.get("objectclass");
        if (vector == null || vector.isEmpty()) {
            return ldapEntityType;
        }
        Enumeration enumeration = vector.elements();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        int n = arrayList.size();
        block1: for (int i = 0; i < n && ldapEntityType == LdapEntityType.UNKNOWN; ++i) {
            int n2;
            String string2 = (String)arrayList.get(i);
            if (string2.equalsIgnoreCase(this.mEntityMapping.mUserMapping.getObjectClass())) {
                ldapEntityType = LdapEntityType.USERID;
                break;
            }
            if (string2.equalsIgnoreCase(this.mEntityMapping.mHostMapping.getObjectClass())) {
                ldapEntityType = LdapEntityType.HOST;
                break;
            }
            stringArray = this.mEntityMapping.mOrganizationMapping.getObjectClasses();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string2.equalsIgnoreCase(stringArray[j])) continue;
                ldapEntityType = LdapEntityType.ORG;
                break;
            }
            if (ldapEntityType == LdapEntityType.UNKNOWN) {
                String[] stringArray2 = this.mEntityMapping.mRoleMapping.getObjectClasses();
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (!string2.equalsIgnoreCase(stringArray2[n2])) continue;
                    ldapEntityType = LdapEntityType.ROLE;
                    break;
                }
            }
            if (ldapEntityType != LdapEntityType.UNKNOWN) continue;
            String[] stringArray3 = this.mEntityMapping.mDomainMapping.getObjectClasses();
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                if (!string2.equalsIgnoreCase(stringArray3[n2])) continue;
                ldapEntityType = LdapEntityType.DOMAIN;
                continue block1;
            }
        }
        if (ldapEntityType == LdapEntityType.USERID) {
            for (int i = 0; i < n; ++i) {
                stringArray = (String[])arrayList.get(i);
                if (!stringArray.equalsIgnoreCase(this.mEntityMapping.mHostMapping.getObjectClass())) continue;
                ldapEntityType = LdapEntityType.HOST;
                break;
            }
        }
        return ldapEntityType;
    }

    private static int findContainer(String[] stringArray, int n, String string) {
        String string2 = stringArray[n].substring(0, stringArray[n].indexOf("="));
        for (int i = n + 1; i < stringArray.length; ++i) {
            if (string != null) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return i;
            }
            if (stringArray[i].startsWith(string2)) continue;
            return i - 1;
        }
        return -1;
    }

    public abstract Iterator getLayeredProfiles() throws SPIException;
}

